/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.DiffProperty;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.view.uistruct.FormDependency;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.view.UIExprManager;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class WebBuilderDiffProcessor {
    public static final WebBuilderDiffProcessor instance = new WebBuilderDiffProcessor();

    public List<UICommand> processDiff(DefaultContext context, List<Diff> diffs, List<UICommand> uiCommands) throws Throwable {
        for (Diff diff : diffs) {
            MetaForm metaForm = diff.getMetaForm();
            String fieldKey = diff.getKey();
            if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.dataSource)) {
                return uiCommands;
            }
            if (diff.isGridColumnDrag()) {
                return uiCommands;
            }
            if (StringUtils.isNotBlank((CharSequence)diff.caption)) {
                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.grid)) {
                    this.addUICommandReloadDependency(context, metaForm, uiCommands);
                }
                return uiCommands;
            }
            if (diff.isDelete) {
                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.grid) || Objects.equals(diff.getMetaObjectType(), MetaObjectType.gridField)) {
                    this.addUICommandReloadDependency(context, metaForm, uiCommands);
                }
                return uiCommands;
            }
            for (DiffProperty diffProperty : diff.properties) {
                MetaBlock ownerMetaBlock;
                MetaPanel ownerMetaPanel;
                MetaComponent component;
                MetaComponent metaComponent1;
                MetaComponent metaComponent;
                Property property = diffProperty.property;
                if (Objects.equals(diffProperty.property, Property.CheckRule) || Objects.equals(diffProperty.property, Property.RowTableKey)) continue;
                if (property == Property.enable || property == Property.visible) {
                    if (!Objects.equals(diff.getMetaObjectType(), MetaObjectType.operation)) continue;
                    continue;
                }
                if (Objects.equals(property, Property.valueChanged) || Objects.equals(property, Property.defaultFomulaValue) || Objects.equals(property, Property.defaultValue)) {
                    this.addUICommandReloadDependency(context, metaForm, uiCommands);
                }
                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.gridField)) {
                    if (Objects.equals(diffProperty.property, Property.key)) continue;
                    String gridKey = IOMetaObject.gridMap.get(fieldKey);
                    metaComponent1 = metaComponent = metaForm.componentByKey(gridKey);
                    if (Objects.equals(metaComponent = this.decideAllUIComponents(metaComponent, diff), metaComponent1)) continue;
                    metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
                    continue;
                }
                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.listViewField)) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)property.name, (CharSequence)Property.key.name)) continue;
                    String listViewKey = IOMetaObject.listViewMap.get(fieldKey);
                    metaComponent1 = metaComponent = metaForm.componentByKey(listViewKey);
                    if (Objects.equals(metaComponent = this.decideAllUIComponents(metaComponent, diff), metaComponent1)) continue;
                    metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
                    continue;
                }
                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.field) || Objects.equals(diff.getMetaObjectType(), MetaObjectType.panel) || Objects.equals(diff.getMetaObjectType(), MetaObjectType.grid)) {
                    MetaComponent tempComponent;
                    IDLookup idLookup;
                    if (Objects.equals(property, Property.key) || Objects.equals(property, Property.caption)) continue;
                    if (Objects.equals(property, Property.buddyCaption) || Objects.equals(property, Property.buddyX) || Objects.equals(property, Property.buddyY)) {
                        MetaComponent metaComp;
                        String buddyKey;
                        idLookup = IDLookup.getIDLookup(metaForm);
                        MetaComponent metaComponent2 = (MetaComponent)idLookup.getMetaObjectColumnByKey(buddyKey = (metaComp = (MetaComponent)idLookup.getMetaObjectColumnByKey(fieldKey)).getBuddyKey());
                        MetaComponent tempComponent2 = metaComponent2;
                        if (tempComponent2 == (metaComponent2 = this.decideAllUIComponents(metaComponent2, diff))) continue;
                        metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
                        continue;
                    }
                    idLookup = IDLookup.getIDLookup(metaForm);
                    metaComponent = (MetaComponent)idLookup.getMetaObjectColumnByKey(fieldKey);
                    if (Objects.isNull(metaComponent)) {
                        metaComponent = idLookup.getNoFieldComponent(fieldKey);
                    }
                    if ((tempComponent = metaComponent) == (metaComponent = this.decideAllUIComponents(metaComponent, diff))) continue;
                    metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
                    continue;
                }
                if (!Objects.equals(diff.getMetaObjectType(), MetaObjectType.operation) || (component = (ownerMetaPanel = (MetaPanel)(ownerMetaBlock = (MetaBlock)metaForm.getMetaBody().get(0)).getRoot()).getComponent(0)).getControlType() == 223) continue;
                uiCommands.add(UICommand.reloadFormKey(diff.formKey));
            }
        }
        return uiCommands;
    }

    private void addUICommandReloadDependency(DefaultContext context, MetaForm metaForm, List<UICommand> uiCommands) throws Throwable {
        MidVE ve = context.getVE();
        UIExprManager manager = new UIExprManager(metaForm, (VE)ve);
        FormDependency dependency = manager.build();
        uiCommands.add(UICommand.reloadDependency(dependency.toJSON()));
    }

    private MetaComponent decideAllUIComponents(MetaComponent metaComponent, Diff diff) throws Throwable {
        if (Objects.isNull(metaComponent)) {
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
            metaComponent = (MetaComponent)IDLookup.getIDLookup(metaForm).getMetaObjectColumnByKey(diff.getKey());
        }
        return metaComponent;
    }
}

