/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.bpm.util.BpmOperToJsonUtil;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class WebBpmDesignCmd
extends DesignerServiceCmd {
    public static final String CMD = "WebBpmDesign";
    private String operType = "NewWork";
    private String projectKey;
    private String formKey;
    private String formCaption;
    private String filePath;
    public static final String CONST_ONE = "NewWork";
    public static final String CONST_TWO = "SelectWork";
    public static final String CONST_FOUR = "NewBpmVersion";
    public static final String CONST_THREE = "DeployBpm";
    public static final String CONST_TRUE = "true";
    public static final String CONST_FALSE = "false";
    public static final String CONST_RESULT = "result";
    private static final BpmOperToJsonUtil bpmOperUtil = new BpmOperToJsonUtil();

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) {
        this.filePath = FilePathHelper.toBackFilePath((String)arguments.get((Object)"filePath"));
        this.projectKey = (String)arguments.get((Object)"projectKey");
        this.formKey = (String)arguments.get((Object)"newFormKey");
        this.formCaption = (String)arguments.get((Object)"formCaption");
        this.operType = (String)arguments.get((Object)"operType");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        JSONObject result = new JSONObject();
        if (CONST_ONE.equalsIgnoreCase(this.operType)) {
            Map<String, String> res = bpmOperUtil.createXml(this.projectKey, this.formKey, this.formCaption, "0");
            if (CONST_TRUE.equals(res.get(CONST_RESULT))) {
                this.saveBpmXml(result, res, 1);
            } else {
                result.put("code", (Object)1);
                result.put("msg", (Object)res.get("msg"));
            }
        } else {
            if (CONST_TWO.equalsIgnoreCase(this.operType)) {
                JSONObject jsonFileContent = WebBpmDesignCmd.getJsonFileContent(this.filePath);
                result.put("jsonFileContent", (Object)jsonFileContent);
                result.put("caption", (Object)jsonFileContent.getJSONObject("props").getJSONObject("props").getJSONObject("Caption").getString("value"));
                result.put("version", (Object)("V" + jsonFileContent.getJSONObject("props").getJSONObject("props").getJSONObject("Version").getString("value")));
                return JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect});
            }
            if (CONST_THREE.equalsIgnoreCase(this.operType)) {
                ArrayList<UICommand> result1;
                block16: {
                    result1 = new ArrayList<UICommand>();
                    FileOutputStream fileOutputStream = null;
                    XMLWriter writer = null;
                    try {
                        try {
                            File workFlowFile = new File(this.filePath);
                            String parentPath = workFlowFile.getParent();
                            String bpmFilePath = String.valueOf(parentPath.substring(0, parentPath.length() - 4)) + File.separator + "BPM.xml";
                            SAXReader reader = new SAXReader();
                            Document document = reader.read(new File(bpmFilePath));
                            Element root = document.getRootElement();
                            if (root.element("DeployInfoCollection") == null) {
                                root.addElement("DeployInfoCollection");
                            }
                            if (root.element("DeployInfoCollection").elements("DeployInfo") != null) {
                                List deployInfoList = root.element("DeployInfoCollection").elements("DeployInfo");
                                for (Element ele : deployInfoList) {
                                    if (!this.formKey.equals(ele.attributeValue("Key"))) continue;
                                    root.element("DeployInfoCollection").remove(ele);
                                }
                            }
                            root.element("DeployInfoCollection").addElement("DeployInfo").addAttribute("InitDate", DateUtil.getDateFormatText(null, (String)"yyyy-MM-dd HH:mm:ss")).addAttribute("Key", this.formKey);
                            OutputFormat format = this.getOutputFormat();
                            fileOutputStream = new FileOutputStream(bpmFilePath);
                            writer = new XMLWriter(fileOutputStream, format);
                            writer.write(document);
                        }
                        catch (Exception e) {
                            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
                            this.closeFileStream(fileOutputStream, writer);
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        this.closeFileStream(fileOutputStream, writer);
                        throw throwable;
                    }
                    this.closeFileStream(fileOutputStream, writer);
                }
                result1.add(UICommand.showTip("\u5de5\u4f5c\u6d41:" + this.formKey + "\u90e8\u7f72\u6210\u529f"));
                return UICommand.toJson(result1);
            }
            if (CONST_FOUR.equalsIgnoreCase(this.operType)) {
                XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(this.filePath);
                String version = xmlTreeWithPath.xmlTree.getRoot().getAttributes().get("Version");
                version = StringUtils.isEmpty((CharSequence)version) ? "1" : version;
                IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
                HashMap profileMap = globalInstance.getMetaBPM().getProfileMap();
                String[] vs = this.formKey.split("_V");
                if (vs.length > 0) {
                    this.formKey = vs[0];
                }
                ProcessDefinitionProfile processDefinitionProfile = (ProcessDefinitionProfile)profileMap.get(String.valueOf(this.formKey) + "_V" + version);
                this.projectKey = processDefinitionProfile.getProject().getKey();
                Map<String, String> res = bpmOperUtil.createXml(this.projectKey, this.formKey, processDefinitionProfile.getCaption(), version);
                this.saveBpmXml(result, res, Integer.valueOf(res.get("version")));
            }
        }
        return result;
    }

    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private OutputFormat getOutputFormat() {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(4);
        format.setExpandEmptyElements(false);
        format.setPadText(false);
        return format;
    }

    private void saveBpmXml(JSONObject result, Map<String, String> res, Integer version) throws Throwable {
        this.filePath = res.get("filePath");
        this.formCaption = res.get("caption");
        result.put("code", (Object)0);
        result.put("msg", (Object)"\u65b0\u589e\u6587\u4ef6\u6210\u529f");
        result.put("filePath", (Object)this.filePath);
        ArrayList<UICommand> uiCommands = new ArrayList<UICommand>();
        uiCommands.add(UICommand.reloadFileTree(this.filePath));
        uiCommands.add(UICommand.reloadMenuTree());
        result.put("uICommands", (Object)UICommand.toJson(uiCommands));
        result.put("caption", (Object)(String.valueOf(this.formCaption) + "V" + version));
        result.put("version", (Object)("V" + version));
        result.put("formKey", (Object)("V" + this.formKey + "_V" + version));
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        ProcessDefinitionProfile formProfile = new ProcessDefinitionProfile();
        HashMap profileMap = globalInstance.getMetaBPM().getProfileMap();
        MetaProject metaProject = globalInstance.getMetaProject(this.projectKey);
        formProfile.setKey(this.formKey);
        formProfile.setCaption(this.formCaption);
        formProfile.setVersion(version.intValue());
        formProfile.setResource(String.valueOf(this.projectKey) + File.separator + "BPM/" + this.formKey + ".xml");
        formProfile.setProject((IMetaProject)metaProject);
        formProfile.setSourceType("Directory");
        profileMap.put(String.valueOf(this.formKey) + "_V" + version, formProfile);
    }

    public static JSONObject getJsonFileContent(String filePath) throws Throwable {
        return bpmOperUtil.convertXmlToJson(filePath);
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new WebBpmDesignCmd();
    }
}

