/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.DiffProperty;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class UIFormDiffProcessor {
    public static final UIFormDiffProcessor instance = new UIFormDiffProcessor();
    public static String Error = null;

    public List<UICommand> processDiff(List<Diff> diffs, List<UICommand> uiCommands, boolean genPropertyDiffSuccess, String xmlError, int anInt) throws Throwable {
        String paramsformKey;
        Error = xmlError;
        if (!genPropertyDiffSuccess || Diff.hasGridColumnDrag(diffs)) {
            if (diffs.get(0).getMetaObjectType() == MetaObjectType.ToolBar) {
                uiCommands.add(UICommand.refreshMenuTree(diffs.get((int)0).formKey));
                uiCommands.add(UICommand.reloadFormKey(diffs.get((int)0).formKey));
                uiCommands.add(new UICommand("GetType", "ToolBar"));
                uiCommands.add(UICommand.locate(diffs.get(0).getKey()));
            } else if (StringUtils.isBlank((CharSequence)xmlError)) {
                String formKey = diffs.get((int)0).formKey;
                uiCommands.add(UICommand.refreshMenuTree(formKey));
                uiCommands.add(UICommand.reloadFormKey(formKey));
                if (diffs.get((int)0).isEmbed != null && diffs.get((int)0).isEmbed.booleanValue()) {
                    uiCommands.add(new UICommand("GetType", diffs.get(0).getMetaObjectType()));
                    uiCommands.add(UICommand.locate(String.valueOf(diffs.get(0).getKey()) + "Embed"));
                } else if (StringUtils.isNotBlank((CharSequence)diffs.get(0).getKey())) {
                    if (diffs.get((int)0).parentKey != null) {
                        uiCommands.add(UICommand.locate(diffs.get((int)0).parentKey));
                    }
                    uiCommands.add(UICommand.locate(diffs.get(0).getKey()));
                }
            } else {
                uiCommands.add(UICommand.showError(xmlError));
            }
            if (Diff.hasGridColumnDrag(diffs)) {
                uiCommands.add(UICommand.reloadXmlSource(diffs.get(0).getFilePath()));
            }
        } else {
            uiCommands = this.processDiff(diffs, uiCommands, anInt);
        }
        if (!(paramsformKey = diffs.get(0).getParamsformKey()).equals(diffs.get((int)0).formKey)) {
            String pathByFormKey = LoadFileTree.getPathByFormKey(paramsformKey);
            uiCommands.add(UICommand.reloadFormKey(paramsformKey));
            uiCommands.add(UICommand.reloadXmlSource(pathByFormKey));
        }
        return uiCommands;
    }

    public List<UICommand> processDiff(List<Diff> diffs, List<UICommand> uiCommands, int anInt) throws Throwable {
        for (Diff diff : diffs) {
            String formKey = diff.formKey;
            if (diff.caption != null || diff.isButtonQuote != null && diff.isButtonQuote.booleanValue()) {
                if (diff.getMetaObjectType() != MetaObjectType.DataObject) {
                    uiCommands.add(UICommand.refreshMenuTree(formKey));
                    uiCommands.add(UICommand.reloadFormKey(formKey));
                }
                if (diff.getMetaObjectType() == MetaObjectType.field || diff.getMetaObjectType() == MetaObjectType.grid || diff.getMetaObjectType() == MetaObjectType.panel || diff.getMetaObjectType() == MetaObjectType.listView) {
                    uiCommands.add(new UICommand("GetType", diff.getMetaObjectType()));
                    uiCommands.add(UICommand.locate(diff.getKey()));
                } else if (diff.getMetaObjectType() == MetaObjectType.gridField || diff.getMetaObjectType() == MetaObjectType.GridFieldMultiRowTable) {
                    uiCommands.add(new UICommand("GetType", "columnheader"));
                    if (diff.sideKey.equals(diff.parentKey)) {
                        uiCommands.add(UICommand.locate(diff.parentKey));
                    } else {
                        uiCommands.add(UICommand.locate(diff.getKey()));
                    }
                } else if (diff.getMetaObjectType() == MetaObjectType.operation) {
                    uiCommands.add(UICommand.locate(diff.getKey()));
                } else if (diff.getMetaObjectType() == MetaObjectType.TableView) {
                    uiCommands.add(UICommand.locate(diff.getKey()));
                } else if (diff.getMetaObjectType() == MetaObjectType.ListViewColumn) {
                    uiCommands.add(UICommand.locate(diff.getKey()));
                } else if (diff.getMetaObjectType() == MetaObjectType.operationCollection) {
                    uiCommands.add(UICommand.locate("HeadOperationCollection" + anInt));
                } else if (diff.getMetaObjectType() == MetaObjectType.GridFieldRow) {
                    uiCommands.add(UICommand.locate(diff.parentKey));
                    uiCommands.add(UICommand.locate(diff.getKey()));
                } else if (diff.getMetaObjectType() == MetaObjectType.subDetail) {
                    if (!diff.isButtonQuote.booleanValue()) {
                        if ("Grid".equalsIgnoreCase(XmlDiffProcessor.subDetailBind)) {
                            uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                            uiCommands.add(UICommand.locate("SubGrid" + anInt));
                        } else if ("GridLayoutPanel".equalsIgnoreCase(XmlDiffProcessor.subDetailBind)) {
                            uiCommands.add(UICommand.locate("tempGridLayoutPanel" + anInt));
                        }
                    } else if (diff.getMetaObjectType() == MetaObjectType.DataObject) {
                        String path = diff.getFilePath();
                        uiCommands.add(UICommand.reloadXmlSource(path));
                    } else {
                        uiCommands.add(UICommand.locate("tempGridLayoutPanel" + anInt));
                    }
                } else if (diff.getMetaObjectType() == MetaObjectType.EmbedPanel) {
                    uiCommands.add(new UICommand("GetType", "Panel"));
                    uiCommands.add(UICommand.locate(diff.getKey()));
                }
            } else if (diff.isDelete) {
                uiCommands.add(UICommand.refreshMenuTree(formKey));
                uiCommands.add(UICommand.reloadFormKey(formKey));
                if (diff.getMetaObjectType() == MetaObjectType.field) {
                    uiCommands.add(UICommand.locate(diff.parentKey));
                } else if (diff.getMetaObjectType() == MetaObjectType.gridField) {
                    uiCommands.add(UICommand.locate(diff.parentKey));
                } else if (diff.getMetaObjectType() != MetaObjectType.operation && diff.getMetaObjectType() != MetaObjectType.operationCollection) {
                    if (diff.getMetaObjectType() == MetaObjectType.toolbar || diff.getMetaObjectType() == MetaObjectType.Embed) {
                        uiCommands.add(UICommand.locate(formKey));
                    } else if (diff.getMetaObjectType() == MetaObjectType.GridFieldRow) {
                        uiCommands.add(UICommand.locate(diff.getKey()));
                    } else if (diff.getMetaObjectType() == MetaObjectType.ListViewColumn) {
                        uiCommands.add(UICommand.locate(formKey));
                    } else {
                        uiCommands.add(UICommand.locate(diff.parentKey));
                    }
                }
            } else if (MetaObjectType.DataOperationToobar == diff.getMetaObjectType()) {
                uiCommands.add(UICommand.refreshMenuTree(formKey));
                uiCommands.add(UICommand.reloadFormKey(diff.formKey));
            } else if (MetaObjectType.ExtraLayout == diff.getMetaObjectType()) {
                uiCommands.add(UICommand.reloadFormKey(formKey));
                uiCommands.add(UICommand.locate(diff.getKey()));
            } else {
                MetaForm metaForm = diff.getMetaForm();
                for (DiffProperty diffProperty : diff.properties) {
                    Property property = diffProperty.property;
                    if (property == Property.defaultValue || property == Property.ShowZero || property == Property.StripTrailingZeros || property == Property.maxLength || property == Property.Scale || property == Property.CheckRule || property == Property.required || property == Property.Second || property == Property.defaultFomulaValue || property == Property.columnKey) {
                        if (diff.getMetaObjectType() == MetaObjectType.gridField) {
                            uiCommands.add(UICommand.reloadFormKey(formKey));
                            if (property == Property.CheckRule || property == Property.required || property == Property.Item || property == Property.itemKey) {
                                uiCommands.add(UICommand.reloadFormKey(formKey));
                            }
                            uiCommands.add(UICommand.locate(diff.getKey()));
                            continue;
                        }
                        if (diff.getMetaObjectType() == MetaObjectType.listViewField) {
                            uiCommands.add(UICommand.reloadFormKey(formKey));
                            continue;
                        }
                        if (diff.getMetaObjectType() == MetaObjectType.field) {
                            if (property == Property.defaultValue || property == Property.defaultFomulaValue) {
                                uiCommands.add(UICommand.reloadFormKey(formKey));
                                uiCommands.add(UICommand.locate(diff.getKey()));
                                continue;
                            }
                            if (property == Property.StripTrailingZeros || property == Property.ShowZero || property == Property.required) {
                                uiCommands.add(UICommand.reloadFormKey(formKey));
                                uiCommands.add(UICommand.locate(diff.getKey()));
                                continue;
                            }
                            uiCommands.add(UICommand.reloadFormKey(formKey));
                            uiCommands.add(UICommand.locate(diff.getKey()));
                            continue;
                        }
                        if (diff.getMetaObjectType() != MetaObjectType.comboBoxType) continue;
                        uiCommands.add(UICommand.reloadFormKey(formKey));
                        continue;
                    }
                    if (diff.getMetaObjectType() == MetaObjectType.DictViewColumn) {
                        uiCommands.add(UICommand.reloadFormKey(formKey));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if (diff.getMetaObjectType() == MetaObjectType.dataSource) {
                        if (Error != null && Error.length() > 0) {
                            uiCommands.add(UICommand.showError(Error));
                            continue;
                        }
                        uiCommands.add(UICommand.reloadFormKey(formKey));
                        continue;
                    }
                    if (diff.getMetaObjectType() == MetaObjectType.TabItem) continue;
                    if (property == Property.key || property == Property.caption) {
                        uiCommands.add(UICommand.refreshMenuTree(formKey));
                        uiCommands.add(UICommand.reloadFormKey(formKey));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if (property == Property.buddyCaption) {
                        uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                        continue;
                    }
                    if (property == Property.enable || property == Property.visible) {
                        uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                        continue;
                    }
                    if (property == Property.DataObjectCheckRule) {
                        if ("new".equalsIgnoreCase(diff.properties.get((int)0).newValue)) continue;
                        uiCommands.add(UICommand.showError(diff.properties.get((int)0).newValue));
                        continue;
                    }
                    if (property == Property.Layout || property == Property.Separate || property == Property.Orientation || diff.getMetaObjectType() == MetaObjectType.AddRowPanel) {
                        uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if (property == Property.x || property == Property.y || property == Property.buddyX || property == Property.buddyY) {
                        String fieldKey = diff.getKey();
                        uiCommands.add(UICommand.reloadFormKey(formKey));
                        uiCommands.add(UICommand.locate(fieldKey));
                        continue;
                    }
                    if (property == Property.Second || property == Property.Stretch || property == Property.ImageCut) {
                        if (diff.getMetaObjectType() == MetaObjectType.gridField) {
                            uiCommands.add(UICommand.reloadFormKey(diff.getDictType()));
                            continue;
                        }
                        uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if (property == Property.OnlyShow) {
                        uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if (property == Property.XSpan) {
                        uiCommands.add(UICommand.reloadFormKey(formKey));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if (property == Property.YSpan) {
                        uiCommands.add(UICommand.reloadFormKey(formKey));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if ("BasicAttribute".equals(diff.getMetaObjectType().name) && "Type".equals(diff.getReserveOne())) {
                        uiCommands.add(UICommand.reloadFormKey("BasicAttribute"));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if (property == Property.CellGroupType) {
                        uiCommands.add(UICommand.reloadFormKey(formKey));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if (property == Property.FormulaCaption) {
                        uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if (property == Property.DataOperationToobar) {
                        if (Objects.isNull(metaForm.getDataSource())) break;
                        uiCommands.add(UICommand.reloadFormKey(formKey));
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    if (property == Property.GroupKey) {
                        uiCommands.add(UICommand.locate(diff.getKey()));
                        continue;
                    }
                    uiCommands.add(UICommand.reloadFormKey(formKey));
                    uiCommands.add(UICommand.locate(diff.getKey()));
                }
                if (diff.getMetaObjectType() == MetaObjectType.buttonReplace) {
                    uiCommands.add(UICommand.reloadFormKey(formKey));
                    uiCommands.add(new UICommand("GetType", "Panel"));
                    uiCommands.add(UICommand.locate(diff.getKey()));
                } else if (diff.getMetaObjectType() == MetaObjectType.AddRowPanel) {
                    uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                    uiCommands.add(UICommand.locate(diff.parentKey));
                } else if (diff.getMetaObjectType() == MetaObjectType.DeleteRowPanel) {
                    uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                    uiCommands.add(UICommand.locate(diff.parentKey));
                } else if (diff.getMetaObjectType() == MetaObjectType.AddTableViewRow) {
                    uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                    uiCommands.add(UICommand.locate(diff.getKey() != null && !diff.getKey().isEmpty() ? diff.getKey() : diff.parentKey));
                } else if (diff.getMetaObjectType() == MetaObjectType.fieldCondition) {
                    uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                } else if (diff.getMetaObjectType() == MetaObjectType.comboboxSourceSetting) {
                    uiCommands.add(UICommand.reloadFormKey(formKey));
                    uiCommands.add(UICommand.locate(diff.getKey()));
                } else if (diff.getMetaObjectType() == MetaObjectType.AddRowLayout) {
                    uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                    uiCommands.add(UICommand.locate(diff.parentKey));
                } else if (diff.getMetaObjectType() == MetaObjectType.DeleteRowLayout) {
                    uiCommands.add(UICommand.reloadFormKey(diff.formKey));
                    uiCommands.add(UICommand.locate(diff.parentKey));
                }
            }
            if (diff.getMetaObjectType() == MetaObjectType.TabItem) {
                if (diff.insertItemAfter) {
                    uiCommands.add(UICommand.refreshMenuTree(formKey));
                    uiCommands.add(UICommand.reloadFormKey(formKey));
                    uiCommands.add(UICommand.locate(String.valueOf(diff.parentKey) + "@" + diff.getKey()));
                }
                if (!diff.isDelete) {
                    uiCommands.add(UICommand.reloadFormKey(formKey));
                    uiCommands.add(UICommand.locate(String.valueOf(diff.parentKey) + "@" + diff.getKey()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)diff.getFilePath())) {
                uiCommands.add(UICommand.reloadXmlSource(diff.getFilePath()));
            }
            if (StringUtils.isNotBlank((CharSequence)diff.getDataObjectfilePath())) {
                uiCommands.add(UICommand.reloadXmlSource(diff.getDataObjectfilePath()));
            }
            if (!StringUtils.isNotBlank((CharSequence)diff.getOtherDataObjectFilePath())) continue;
            uiCommands.add(UICommand.reloadXmlSource(diff.getOtherDataObjectFilePath()));
        }
        if (diffs.get((int)0).isMultyDelete) {
            uiCommands = uiCommands.stream().distinct().collect(Collectors.toList());
        }
        return uiCommands;
    }
}

