/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;

public class SetSourceDataObjectCmd
extends DesignerServiceCmd {
    public static final String CMD = "SetSourceDataObject";
    private String subKey;
    private String sourceDataObjectValue;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.subKey = TypeConvertor.toString((Object)arguments.get((Object)"subKey"));
        this.sourceDataObjectValue = TypeConvertor.toString((Object)arguments.get((Object)"sourceDataObjectValue"));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        for (MetaFormProfile metaFormProfile : MetaFactory.getGlobalInstance().getMetaFormList()) {
            if (!this.subKey.equalsIgnoreCase(metaFormProfile.getExtend())) continue;
            ArrayList<UICommand> result = new ArrayList<UICommand>();
            result.add(UICommand.showTip("\u6b64\u8868\u5355\u542b\u6709\u9a6c\u7532,\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c"));
            return UICommand.toJson(result);
        }
        String filePath = LoadFileTree.getPathByFormKey(this.subKey);
        FileOutputStream fileOutputStream = null;
        XMLWriter writer = null;
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(filePath);
            this.deleteChildAttributeValue(document.getRootElement());
            Element deleteNode = (Element)document.selectSingleNode("/Form/DataSource");
            if (deleteNode != null) {
                document.getRootElement().remove(deleteNode);
            }
            Document document1 = DocumentHelper.createDocument();
            Element dataSource = document1.addElement("DataSource");
            dataSource.addAttribute("RefObjectKey", this.sourceDataObjectValue);
            document.getRootElement().elements().add(0, dataSource);
            Node node = document.selectSingleNode("//Var[@Key='SystemInfoTableKey']");
            if (node != null) {
                Element element = (Element)node;
                MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(this.sourceDataObjectValue);
                for (MetaTable metaTable : metaDataObject.getTableCollection()) {
                    int tableMode;
                    if (metaTable.getKey().endsWith("_NODB") || (tableMode = metaTable.getTableMode().intValue()) != 0) continue;
                    element.setAttributeValue("Value", metaTable.getKey());
                    break;
                }
            }
            OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
            String newFilePath = FilePathHelper.toBackFilePath(String.valueOf(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(((MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(this.subKey)).getProject().getKey())) + File.separator + new File(filePath).getName() + "." + System.currentTimeMillis());
            fileOutputStream = new FileOutputStream(newFilePath);
            writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            XmlFileProcessor.stackput(filePath, newFilePath);
            DesignReloadMetaObject.reloadMetaFormRollbackError(null, this.subKey);
            String s = LoadFileTree.loadFilePathByDataObjectFieldKey(this.sourceDataObjectValue);
            DataObjectHelper.reload(null, this.sourceDataObjectValue, s, null);
            ArrayList<UICommand> result = new ArrayList<UICommand>();
            result.add(UICommand.reloadXmlSource(filePath));
            result.add(UICommand.reloadFormKey(this.subKey));
            result.add(UICommand.showTip("\u64cd\u4f5c\u6210\u529f,\u5982\u82e5\u64a4\u9500,\u8bf7\u5173\u95ed\u6b64\u754c\u9762,\u70b9\u51fb\u8bbe\u8ba1\u754c\u9762\u7684\u64a4\u9500"));
            JSONArray jSONArray = UICommand.toJson(result);
            this.closeFileStream(fileOutputStream, writer);
            return jSONArray;
        }
        catch (MetaException e) {
            try {
                LogSvr.getInstance().error("\n", (Throwable)e);
                throw new RuntimeException("warning: " + e.getMessage());
                catch (Exception e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.closeFileStream(fileOutputStream, writer);
                throw throwable;
            }
        }
    }

    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteChildAttributeValue(Element element) {
        Attribute tableKey;
        Attribute columnKey = element.attribute("ColumnKey");
        if (columnKey != null) {
            element.remove(columnKey);
        }
        if ((tableKey = element.attribute("TableKey")) != null) {
            element.remove(tableKey);
        }
        List elements = element.elements();
        if (element != null) {
            for (Element element2 : elements) {
                this.deleteChildAttributeValue(element2);
            }
        }
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new SetSourceDataObjectCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

