/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SearchFilePathCmd
extends DesignerServiceCmd {
    public static final String CMD = "SearchFilePath";
    private String search;
    private int maxCount;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.search = (String)arguments.get((Object)"search");
        this.maxCount = TypeConvertor.toInteger((Object)arguments.get((Object)"maxCount"));
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        if (StringUtils.isBlank((CharSequence)this.search)) {
            return Collections.emptyList();
        }
        List<String[]> result = LoadFileTree.searchNodes(context, this.search, this.maxCount);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        JSONArray jsonArray = new JSONArray();
        JSONArray jsonArray1 = SearchFilePathCmd.getJsonArray(result, jsonArray);
        return jsonArray1;
    }

    private static synchronized JSONArray getJsonArray(List<String[]> result, JSONArray jsonArray) {
        result.stream().filter(array -> !StringUtils.containsIgnoreCase((CharSequence)array[1], (CharSequence)(String.valueOf(File.separatorChar) + "initializeData" + File.separatorChar))).map(array -> {
            array[0] = FilePathHelper.toFrontFilePath(array[0]);
            array[1] = FilePathHelper.toFrontFilePath(array[1]);
            return array;
        }).sorted(Comparator.comparing(array -> array[0])).forEachOrdered(array -> {
            String path = array[1];
            if (StringUtils.isNotBlank((CharSequence)path) && FileUtils.getFile((String[])new String[]{FilePathHelper.toBackFilePath(path)}).isFile()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("text", (Object)array[0]);
                jsonObject.put("path", (Object)path);
                jsonArray.put((Object)jsonObject);
            }
        });
        return jsonArray;
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new SearchFilePathCmd();
    }
}

