/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.SaveFileContentCmd;
import com.bokesoft.yes.design.cmd.SaveFilesByFormKeyCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.RebuildTableUtil;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.util.FileUtil;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class SaveFilesCmd
extends DesignerServiceCmd {
    public static final String CMD = "SaveFilesCmd";

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        Map<String, Stack<String>> filePathToTmpFileMap = XmlFileProcessor.filePathToTmpFileMap;
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        for (Map.Entry<String, Stack<String>> stringStackEntry : filePathToTmpFileMap.entrySet()) {
            boolean isNew;
            Stack<String> value = stringStackEntry.getValue();
            if (value.size() == 0) continue;
            String tmpFilePath = value.peek();
            String filePath = stringStackEntry.getKey();
            Object[] actions = new Object[]{"SaveFileContent: ", tmpFilePath};
            Performance.endActive((int)Performance.startAction((Object[])actions), (Object[])actions);
            String tmpContent = FileUtil.File2String((String)tmpFilePath, (String)"UTF-8");
            String tmpSecondLine = DesignIOMetaUtil.getSecondLine(tmpContent);
            String objectType = DesignIOMetaUtil.getSubString(tmpSecondLine, "<([A-Za-z_]\\w*)\\s");
            String key = DesignIOMetaUtil.getSubString(tmpSecondLine, "Key=\"([A-Za-z_]\\w*)\"");
            MetaFormProfile metaFormProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(key);
            String newContent = FileUtils.readFileToString((File)new File(tmpFilePath), (String)"UTF-8");
            boolean bl = isNew = !new File(filePath).exists();
            if (!isNew && tmpSecondLine.contains("Version")) {
                int version = SaveFileContentCmd.checkFileVersion(filePath, newContent);
                newContent = SaveFileContentCmd.versionAddOne(newContent, version);
            }
            FileUtils.writeStringToFile((File)new File(filePath), (String)newContent, (String)"UTF-8");
            if (metaFormProfile == null) {
                metaFormProfile = (MetaFormProfile)metaFactory.getExtFormList().get(key);
            }
            if ("Form".equalsIgnoreCase(objectType)) {
                if (metaFormProfile != null && StringUtils.isEmpty((CharSequence)metaFormProfile.getExtend())) {
                    SaveFilesByFormKeyCmd.formatXml(metaFactory, filePath, key, "Form", result);
                }
                metaFormProfile.setRunType(1);
            } else {
                "DataObject".equalsIgnoreCase(objectType);
            }
            if (!"DataObject".equalsIgnoreCase(objectType) && metaFormProfile != null && metaFactory.getMetaForm(key).getDataSource() != null) {
                DataObjects.getInstance().init(metaFactory, true);
                RebuildTableUtil.rebuildTable(context, filePath);
            }
            result.add(UICommand.reloadXmlSource(filePath));
        }
        XmlFileProcessor.filePathToTmpFileMap.clear();
        XmlFileProcessor.reFilePathToTmpFileMap.clear();
        MetaTableCache.init((IMetaFactory)MetaFactory.getGlobalInstance(), null, (Map)MetaTableCache.getMetaTables());
        return UICommand.toJson(result);
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new SaveFilesCmd();
    }
}

