/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.NewFormCmd;
import com.bokesoft.yes.design.cmd.SaveFileContentCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.CheckXSDUtils;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.MetaUtils;
import com.bokesoft.yes.design.utils.RebuildTableUtil;
import com.bokesoft.yes.design.vo.CheckXSDResult;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.erp.scope.MetaFormAllFormulScopeCache;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.Xml4jUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.tools.dic.proxy.ItemCacheManager;
import com.bokesoft.yes.util.FileUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.tools.ve.VE;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

public class SaveFilesByFormKeyCmd
extends DesignerServiceCmd {
    public static final String CMD = "SaveFilesByFormKey";
    private String uiFormKey;
    private String entryParas;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.uiFormKey = (String)arguments.get((Object)"uiFormKey");
        this.entryParas = (String)arguments.get((Object)"entryParas");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        List<String[]> filePaths = LoadFileTree.loadFilePathsByFormKey(context, this.uiFormKey, this.entryParas, null);
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        for (String[] tmp : filePaths) {
            String filePath = tmp[0];
            String tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
            if (tmpFilePath == null) continue;
            Object[] actions = new Object[]{"SaveFileContent: ", tmpFilePath};
            Performance.endActive((int)Performance.startAction((Object[])actions), (Object[])actions);
            String tmpContent = FileUtil.File2String((String)tmpFilePath, (String)"UTF-8");
            String tmpSecondLine = DesignIOMetaUtil.getSecondLine(tmpContent);
            String objectType = DesignIOMetaUtil.getSubString(tmpSecondLine, "<([A-Za-z_]\\w*)\\s");
            String key = DesignIOMetaUtil.getSubString(tmpSecondLine, "Key=\"([A-Za-z_]\\w*)\"");
            String newTmpFilePath = null;
            if ("Form".equals(objectType)) {
                String newContent;
                String itemKey;
                MetaForm metaForm = metaFactory.getMetaForm(key);
                if (metaForm.getFormType() == 2 && (itemKey = metaForm.getDataSource().getDataObject().getKey()) != null) {
                    new ItemCacheManager((VE)context.getVE()).getItemCache(itemKey).clear();
                }
                if (StringUtils.isBlank((CharSequence)metaForm.getProject().getKey()) || filePath.indexOf(metaForm.getProject().getKey()) == -1) {
                    this.setProjectKeyAndCaption(metaForm);
                }
                String formFilePath = LoadFileTree.getPathByFormKey(key);
                newTmpFilePath = XmlFileProcessor.instance.getTmpFile(formFilePath);
                XmlFileProcessor.recycleToTmpFormAndFileMap.remove("Entry@Entry" + key);
                SaveFileContentCmd.reloadDataObjects(result, metaFactory, filePath);
                SaveFilesByFormKeyCmd.removeScopeCache(metaForm, metaFactory, result);
                if (StringUtils.isEmpty((CharSequence)metaForm.getExtend())) {
                    newContent = FileUtils.readFileToString((File)new File(newTmpFilePath), (String)"UTF-8");
                    FileUtils.writeStringToFile((File)new File(filePath), (String)newContent, (String)"UTF-8");
                    SaveFilesByFormKeyCmd.formatXml(metaFactory, newTmpFilePath, key, "Form", result);
                } else {
                    newContent = FileUtils.readFileToString((File)new File(newTmpFilePath), (String)"UTF-8");
                    FileUtils.writeStringToFile((File)new File(filePath), (String)newContent, (String)"UTF-8");
                }
                Set<MetaFormProfile> allMetaFormProfilesByDataObjectKey = DataObjectHelper.getAllMetaFormProfilesByDataObjectKey(key);
                for (MetaFormProfile metaFormProfile : allMetaFormProfilesByDataObjectKey) {
                    metaFormProfile.setRunType(1);
                }
            } else if (MetaObjectType.DataObject.name.equals(objectType)) {
                String dataObjectFilePath = LoadFileTree.loadFilePathByDataObjectFieldKey(key);
                newTmpFilePath = XmlFileProcessor.instance.getTmpFile(dataObjectFilePath);
                if (StringUtils.isNotEmpty((CharSequence)metaFactory.getDataObject(key).getExtend())) {
                    SaveFileContentCmd.reloadDataObjects(result, metaFactory, filePath);
                    SaveFilesByFormKeyCmd.removeScopeCache(null, metaFactory, result);
                    Set<MetaFormProfile> allMetaFormProfilesByDataObjectKey = DataObjectHelper.getAllMetaFormProfilesByDataObjectKey(key);
                    for (MetaFormProfile metaFormProfile : allMetaFormProfilesByDataObjectKey) {
                        metaFormProfile.setRunType(1);
                    }
                } else {
                    MetaDataObject metaDataObject = NewFormCmd.loadMetaDataObject(key);
                    MetaUtils.saveMetaDataObject(metaFactory, metaDataObject, filePath, key, CMD, "", key, result, context);
                }
            }
            if (newTmpFilePath != null) {
                boolean isNew;
                String newContent = FileUtils.readFileToString((File)new File(newTmpFilePath), (String)"UTF-8");
                boolean bl = isNew = !new File(filePath).exists();
                if (!isNew && tmpSecondLine.contains("Version")) {
                    int version = SaveFileContentCmd.checkFileVersion(filePath, newContent);
                    newContent = SaveFileContentCmd.versionAddOne(newContent, version);
                }
                FileUtils.writeStringToFile((File)new File(filePath), (String)newContent, (String)"UTF-8");
                if (!"DataObject".equalsIgnoreCase(objectType) && metaFactory.getMetaForm(key).getDataSource() != null) {
                    RebuildTableUtil.rebuildTable(context, filePath);
                }
            }
            XmlFileProcessor.instance.clearTmpFile(filePath);
            result.add(UICommand.reloadXmlSource(filePath));
        }
        result.add(UICommand.showTip("\u4fdd\u5b58\u6210\u529f"));
        MetaTableCache.init((IMetaFactory)MetaFactory.getGlobalInstance(), null, (Map)MetaTableCache.getMetaTables());
        return UICommand.toJson(result);
    }

    public static void removeScopeCache(MetaForm metaForm, IMetaFactory metaFactory, List<UICommand> result) throws Throwable {
        ArrayList<MetaFormProfile> metaFormProfiles = new ArrayList<MetaFormProfile>();
        String refObjectKey = null;
        if (metaForm != null && metaForm.getDataSource() != null) {
            refObjectKey = metaForm.getDataSource().getRefObjectKey();
        }
        DesignReloadMetaObject.loadEmbedOwnerAndVest(metaFactory, metaFormProfiles, refObjectKey);
        for (MetaFormProfile formProfile : metaFormProfiles) {
            MetaFormAllFormulScopeCache.instance.clear(formProfile.getKey());
            result.add(UICommand.removeScopeCache(formProfile.getKey()));
        }
    }

    private void setProjectKeyAndCaption(MetaForm metaForm) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        String projectKey = StringUtils.isNotEmpty((CharSequence)metaForm.getExtend()) ? metaForm.getProject().getKey() : NewFormCmd.projectKey;
        if (StringUtils.isBlank((CharSequence)projectKey)) {
            return;
        }
        MetaProject metaProject = metaFactory.getMetaProject(projectKey);
        metaForm.setProject((IMetaProject)metaProject);
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new SaveFilesByFormKeyCmd();
    }

    public static void formatXml(IMetaFactory metaFactory, String filePath, String key, String tagName, List<UICommand> result) throws Throwable {
        MetaForm metaForm1 = NewFormCmd.loadMetaForm(key);
        MetaFormSave metaFormSave = new MetaFormSave((AbstractMetaObject)metaForm1);
        Document document = metaFormSave.getDocument();
        XmlTree oldXmlTree = Xml4jUtil.parseTree((String)filePath);
        CheckXSDUtils.resortAttrPosition(oldXmlTree.getRoot(), filePath);
        XmlCreator creator = new XmlCreator(document, oldXmlTree);
        String xml = creator.createXml();
        String newContent = xml.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
        CheckXSDResult checkXSDResult = CheckXSDUtils.checkXSD(metaFactory, tagName, key, key, newContent, "", null, null);
        if (!checkXSDResult.isPass() && checkXSDResult.getMsg() != null && checkXSDResult.getMsg().isEmpty()) {
            result.add(UICommand.showTip(checkXSDResult.getMsg()));
        }
        FileUtils.writeStringToFile((File)new File(filePath), (String)newContent, (String)"UTF-8");
    }

    public static void reloadDataObject(IMetaFactory metaFactory, String key, List<UICommand> result, String filePath) throws Throwable {
        SaveFileContentCmd.reloadDataObjects(result, metaFactory, filePath);
        Set<MetaFormProfile> allMetaFormProfilesByDataObjectKey = DataObjectHelper.getAllMetaFormProfilesByDataObjectKey(key);
        for (MetaFormProfile metaFormProfile : allMetaFormProfilesByDataObjectKey) {
            metaFormProfile.setRunType(1);
        }
    }
}

