/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.WebBpmDesignCmd;
import com.bokesoft.yes.design.cmd.WebDataMapDesign;
import com.bokesoft.yes.design.cmd.WebDataMigration;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

public class ReductionSnapshotXmlCmd
extends DesignerServiceCmd {
    public static final String CMD = "ReductionSnapshotXml";
    private String uiFormKey;
    private String type;
    private String filePath;
    private String temFilePath;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.uiFormKey = (String)arguments.get((Object)"uiFormKey");
        this.type = (String)arguments.get((Object)"type");
        this.filePath = (String)arguments.get((Object)"filePath");
        this.temFilePath = (String)arguments.get((Object)"temFilePath");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        result.add(UICommand.reloadXmlSourceByTemp(this.filePath, this.temFilePath));
        if ("Form".equalsIgnoreCase(this.type)) {
            DesignReloadMetaObject.reloadMetaFormRollbackError(null, this.uiFormKey, null, this.temFilePath);
            result.add(UICommand.reloadFormKey(this.uiFormKey));
            result.add(UICommand.refreshMenuTree(this.uiFormKey));
        } else if ("DataObject".equalsIgnoreCase(this.type)) {
            DataObjectHelper.reload(null, this.uiFormKey, this.filePath, null, this.temFilePath);
        } else if ("DataMigration".equalsIgnoreCase(this.type)) {
            IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
            ReloadForm.reloadDataMigrationKey(iMetaFactory, this.uiFormKey, this.temFilePath);
            JSONObject jsonFileContent = WebDataMigration.getJsonFileContent(this.filePath);
            result.add(UICommand.uadataWebJson(JSONObject.toJSONString((Object)jsonFileContent, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect})));
        } else if ("DataMap".equalsIgnoreCase(this.type)) {
            String projectKey = LoadFileTree.getProjectKeyByFilePath(this.filePath);
            ReloadForm.reloadCustom(projectKey, this.uiFormKey);
            JSONObject jsonFileContent = WebDataMapDesign.getJsonFileContent(this.filePath);
            result.add(UICommand.uadataWebJson(JSONObject.toJSONString((Object)jsonFileContent, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect})));
        } else if ("BPM".equalsIgnoreCase(this.type)) {
            String version;
            String newContent = FileUtils.readFileToString((File)new File(this.temFilePath), (String)"UTF-8");
            String newSecondLine = DesignIOMetaUtil.getSecondLine(newContent);
            try {
                version = DesignIOMetaUtil.getSubString(newSecondLine, "Version=\"([A-Za-z_]\\w*)\"");
            }
            catch (Exception e) {
                version = "1";
            }
            IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
            iMetaFactory.updateProcessDefination(this.uiFormKey, Integer.parseInt(version));
            iMetaFactory.updateProcessDefinationByDeployKey(this.uiFormKey);
            JSONObject jsonFileContent = WebBpmDesignCmd.getJsonFileContent(this.filePath);
            result.add(UICommand.uadataWebJson(jsonFileContent));
        }
        return UICommand.toJson(result);
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new ReductionSnapshotXmlCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

