/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;

public class PasteComponentCmd
extends DesignerServiceCmd {
    public static final String CMD = "PasteComponent";
    private String srcFormKey;
    private String srcCompKey;
    private String formKey;
    private String parentKey;
    private String x;
    private String y;
    private String sideKey;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.srcFormKey = (String)arguments.get((Object)"srcFormKey");
        this.srcCompKey = (String)arguments.get((Object)"srcCompKey");
        this.formKey = (String)arguments.get((Object)"formKey");
        this.parentKey = (String)arguments.get((Object)"parentKey");
        this.x = (String)arguments.get((Object)"x");
        this.y = (String)arguments.get((Object)"y");
        this.sideKey = (String)arguments.get((Object)"sideKey");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        if (StringUtils.startsWith((CharSequence)this.srcCompKey, (CharSequence)"Column:")) {
            return this.copyGridComp();
        }
        return this.copyHeadComp();
    }

    private JSONArray copyHeadComp() throws Throwable {
        MetaForm srcMetaForm = MetaFactory.getGlobalInstance().getMetaForm(this.srcFormKey);
        MetaComponent srcComp = srcMetaForm.componentByKey(this.srcCompKey);
        if (Objects.isNull(srcComp)) {
            return null;
        }
        String srcFormPath = LoadFileTree.getPathByFormKey(this.srcFormKey);
        XmlTreeWithPath srcXmlTreeWithPath = XmlTreeWithPath.parseFilePath(srcFormPath, false);
        TagNode tagNode = srcXmlTreeWithPath.xmlTree.getTagNode(String.valueOf(srcComp.getTagName()) + "@" + this.srcCompKey);
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
        int keySuffix = this.getKeySuffix(metaForm, this.srcCompKey);
        String fieldKey = String.valueOf(srcComp.getKey()) + keySuffix;
        tagNode.setAttribute("Key", fieldKey);
        tagNode.setAttribute("Caption", String.valueOf(srcComp.getCaption()) + keySuffix);
        tagNode.setAttribute("X", this.x);
        tagNode.setAttribute("Y", this.y);
        if (!StringUtils.equals((CharSequence)this.formKey, (CharSequence)this.srcFormKey)) {
            tagNode.deleteChildByTagName("DataBinding");
        }
        MetaComponent parentComp = metaForm.componentByKey(this.parentKey);
        String formPath = LoadFileTree.getPathByFormKey(this.formKey);
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(formPath, false);
        TagNode parentNode = xmlTreeWithPath.xmlTree.getTagNode(String.valueOf(parentComp.getTagName()) + "@" + this.parentKey);
        TagNode rowDefNode = parentNode.findFirstTagNodeByTagName("RowDefCollection");
        List<AbstractNode> childNodeList = parentNode.getChildren();
        childNodeList.add(childNodeList.indexOf(rowDefNode) - 1, tagNode);
        String fileContent = xmlTreeWithPath.xmlTree.getRoot().toXml(0, false);
        fileContent = RegExUtils.replaceAll((String)fileContent, (String)"[\r\n]+(\\s*[\r\n]+)*", (String)"\r\n");
        XmlFileProcessor.instance.saveTempFile(formPath, fileContent, metaForm.getProjectKey());
        DesignReloadMetaObject.reloadMetaFormRollbackError(this.formKey);
        ArrayList<UICommand> resultList = new ArrayList<UICommand>();
        resultList.add(UICommand.refreshMenuTree(this.formKey));
        resultList.add(UICommand.reloadFormKey(this.formKey));
        resultList.add(UICommand.locate(fieldKey));
        resultList.add(UICommand.reloadXmlSource(formPath));
        return UICommand.toJson(resultList);
    }

    private JSONArray copyGridComp() throws Throwable {
        String srcFormPath = LoadFileTree.getPathByFormKey(this.srcFormKey);
        XmlTreeWithPath srcXmlTreeWithPath = XmlTreeWithPath.parseFilePath(srcFormPath, false);
        this.srcCompKey = StringUtils.substringAfter((String)this.srcCompKey, (String)"Column:");
        TagNode srcHeadNode = srcXmlTreeWithPath.xmlTree.getTagNode("GridColumn@" + this.srcCompKey);
        TagNode srcCellNode = srcXmlTreeWithPath.xmlTree.getTagNode("GridCell@" + this.srcCompKey);
        String srcCompCaption = srcHeadNode.getAttributes().get("Caption");
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
        int keySuffix = this.getKeySuffix(metaForm, this.srcCompKey);
        String fieldKey = String.valueOf(this.srcCompKey) + keySuffix;
        srcHeadNode.setAttribute("Key", fieldKey);
        srcHeadNode.setAttribute("Caption", String.valueOf(srcCompCaption) + keySuffix);
        srcCellNode.setAttribute("Key", fieldKey);
        srcCellNode.setAttribute("Caption", String.valueOf(srcCompCaption) + keySuffix);
        if (!StringUtils.equals((CharSequence)this.formKey, (CharSequence)this.srcFormKey)) {
            srcCellNode.deleteChildByTagName("DataBinding");
        }
        MetaComponent parentComp = metaForm.componentByKey(this.parentKey);
        String formPath = LoadFileTree.getPathByFormKey(this.formKey);
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(formPath, false);
        TagNode parentNode = xmlTreeWithPath.xmlTree.getTagNode(String.valueOf(parentComp.getTagName()) + "@" + this.parentKey);
        this.sideKey = StringUtils.substringAfter((String)this.sideKey, (String)"Column:");
        TagNode columnsNode = parentNode.findFirstTagNodeByTagName("GridColumnCollection");
        TagNode sideColumnNode = xmlTreeWithPath.xmlTree.getTagNode("GridColumn@" + this.sideKey);
        List<AbstractNode> childrenNode = columnsNode.getChildren();
        childrenNode.add(childrenNode.indexOf(sideColumnNode) + 1, srcHeadNode);
        TagNode cellsNode = parentNode.findFirstTagNodeByTagName("GridRow");
        TagNode sideCellNode = xmlTreeWithPath.xmlTree.getTagNode("GridCell@" + this.sideKey);
        List<AbstractNode> childCellNodeList = cellsNode.getChildren();
        childCellNodeList.add(childCellNodeList.indexOf(sideCellNode) + 1, srcCellNode);
        String fileContent = xmlTreeWithPath.xmlTree.getRoot().toXml(0, false);
        fileContent = RegExUtils.replaceAll((String)fileContent, (String)"[\r\n]+(\\s*[\r\n]+)*", (String)"\r\n");
        XmlFileProcessor.instance.saveTempFile(formPath, fileContent, metaForm.getProjectKey());
        DesignReloadMetaObject.reloadMetaFormRollbackError(this.formKey);
        ArrayList<UICommand> resultList = new ArrayList<UICommand>();
        resultList.add(UICommand.refreshMenuTree(this.formKey));
        resultList.add(UICommand.reloadFormKey(this.formKey));
        resultList.add(UICommand.locate(fieldKey));
        resultList.add(UICommand.reloadXmlSource(formPath));
        return UICommand.toJson(resultList);
    }

    private int getKeySuffix(MetaForm metaForm, String compKey) {
        List allComponents = metaForm.getAllComponents();
        ArrayList<MetaComponent> allDetailComps = new ArrayList<MetaComponent>();
        int j = 0;
        while (j < metaForm.getAllDetailComponents().size()) {
            MetaComponent component = (MetaComponent)metaForm.getAllDetailComponents().get(j);
            this.recursiveAddCompToList(component, allDetailComps);
            ++j;
        }
        allComponents.addAll(allDetailComps);
        Set keys = allComponents.stream().map(MetaComponent::getKey).collect(Collectors.toSet());
        int i = 0;
        String tmpKey = String.valueOf(compKey) + i;
        while (keys.contains(tmpKey)) {
            tmpKey = String.valueOf(compKey) + ++i;
        }
        return i;
    }

    private void recursiveAddCompToList(MetaComponent component, List<MetaComponent> allDetailComps) {
        if (!allDetailComps.contains(component)) {
            allDetailComps.add(component);
        }
        if (component.getComponentCount() > 0) {
            int i = 0;
            while (i < component.getComponentCount()) {
                MetaComponent subComp = component.getComponent(i);
                this.recursiveAddCompToList(subComp, allDetailComps);
                ++i;
            }
        }
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new PasteComponentCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

