/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.WebDesignerDataTableUtil;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MetaFormDiffProcessor {
    public static final MetaFormDiffProcessor instance = new MetaFormDiffProcessor();

    public String processDiff(DefaultContext context, List<Diff> diffs, boolean genPropertyDiffSuccess, DocumentRecordDirty formDocument, Map<String, String> tmpFiles) throws Throwable {
        String tmp = this.processDiffReloadForm(context, tmpFiles);
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        for (Diff diff : diffs) {
            diff.setMetaForm(metaFactory.getMetaForm(diff.getMetaForm().getKey()));
            if (!genPropertyDiffSuccess) continue;
            this.synchronizedDocumentDataSource(formDocument);
        }
        return tmp.toString();
    }

    public String processDiffReloadForm(DefaultContext context, Map<String, String> tmpFiles) throws Throwable {
        StringBuilder errors = new StringBuilder(256);
        if (tmpFiles != null) {
            for (Map.Entry<String, String> entry : tmpFiles.entrySet()) {
                String tmpFilePath = entry.getKey();
                String newContent = entry.getValue();
                String secondLine = DesignIOMetaUtil.getSecondLine(newContent);
                String objectType = DesignIOMetaUtil.getSubString(secondLine, "<([A-Za-z_]\\w*)\\s");
                String key = DesignIOMetaUtil.getSubString(secondLine, "Key=\"([A-Za-z_]\\w*)\"");
                try {
                    if ("DataObject".equals(objectType)) {
                        DataObjectHelper.reload(context, key, tmpFilePath, null);
                        continue;
                    }
                    if (!"Form".equals(objectType)) continue;
                    DesignReloadMetaObject.reloadMetaFormRollbackError(context, key);
                }
                catch (MetaException e) {
                    String error = MetaFormDiffProcessor.getExceptionString((Exception)((Object)e));
                    errors.append(errors.length() > 0 ? "\n" : "").append(error);
                }
            }
        }
        return errors.length() == 0 ? "\u64cd\u4f5c\u6210\u529f" : errors.toString();
    }

    private static String getExceptionString(Exception e) {
        String result = e.getMessage();
        if (!StringUtils.isNotEmpty((CharSequence)result)) {
            result = e.getClass().toString();
        }
        return result;
    }

    public void synchronizedDocumentDataSource(DocumentRecordDirty formDocument) throws Throwable {
        MetaDataObject dataObject;
        if (Objects.isNull(formDocument)) {
            return;
        }
        String formKey = formDocument.getMetaForm().getKey();
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        formDocument.setMetaForm(metaForm);
        MetaDataSource dataSource = metaForm.getDataSource();
        if (dataSource != null && (dataObject = dataSource.getDataObject()) != null) {
            formDocument.setMetaDataObject(dataObject);
            DataTable newDataTable = null;
            MetaTableCollection tableCollection = dataObject.getTableCollection();
            for (MetaTable metaTable : tableCollection) {
                String metaTableKey = metaTable.getKey();
                formDocument.addDirtyTableFlag(metaTableKey);
                DataTable oldDataTable = formDocument.get(metaTableKey);
                newDataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
                if (oldDataTable != null) {
                    if (!this.isAddDataTable2Document(oldDataTable, newDataTable)) continue;
                    WebDesignerDataTableUtil.appendAll(oldDataTable, newDataTable);
                    formDocument.remove(metaTableKey);
                }
                formDocument.add(metaTableKey, newDataTable);
            }
        }
    }

    private boolean isAddDataTable2Document(DataTable oldDataTable, DataTable newDataTable) {
        DataTableMetaData oldMetaData = oldDataTable.getMetaData();
        DataTableMetaData newMetaData = newDataTable.getMetaData();
        int columnCount = oldMetaData.getColumnCount();
        if (columnCount != newMetaData.getColumnCount()) {
            return true;
        }
        int i = 0;
        while (i < columnCount) {
            int newDataType;
            String newColumnKey;
            ColumnInfo oldColumnInfo = oldMetaData.getColumnInfo(i);
            ColumnInfo newColumnInfo = newMetaData.getColumnInfo(i);
            String oldColumnKey = oldColumnInfo.getColumnKey();
            if (!oldColumnKey.equals(newColumnKey = newColumnInfo.getColumnKey())) {
                return true;
            }
            int oldDataType = oldColumnInfo.getDataType();
            if (oldDataType != (newDataType = newColumnInfo.getDataType())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

