/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSON;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;

public class LoadXmlAttrDataCmd
extends DesignerServiceCmd {
    public static final String CMD = "LoadXmlAttrData";
    public static final String XMLATTR_JSON_FILE = "/json/xmlAttrs.json";
    private static final Logger logger = Logger.getLogger(LoadXmlAttrDataCmd.class.getName());

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> stringHashMap) throws Throwable {
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        Map<String, String> xmlAttrsMap = LoadXmlAttrDataCmd.readXmlAttrsFromJsonFile();
        JSONObject jsonObject = this.setXmlAttrList(xmlAttrsMap);
        return jsonObject.toString();
    }

    private static Map<String, String> readXmlAttrsFromJsonFile() throws Throwable {
        InputStream inputStream = null;
        Reader reader = null;
        BufferedReader bufferedReader = null;
        Map<String, String> tempMap = new HashMap<String, String>();
        try {
            try {
                StringBuffer jsonFileContent = new StringBuffer();
                inputStream = LoadXmlAttrDataCmd.class.getResourceAsStream(XMLATTR_JSON_FILE);
                reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                bufferedReader = new BufferedReader(reader);
                String read = "";
                while ((read = bufferedReader.readLine()) != null) {
                    jsonFileContent.append(String.valueOf(read) + "\n");
                }
                tempMap = (Map)JSON.parse((String)jsonFileContent.toString().trim());
            }
            catch (Throwable e) {
                LogSvr.getInstance().error(e.getMessage(), e);
                HashMap<String, String> hashMap = tempMap;
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e2) {
                        logger.warning("close bufferedReader exception:" + ExceptionUtils.getStackTrace((Throwable)e2));
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e3) {
                        logger.warning("close reader exception:" + ExceptionUtils.getStackTrace((Throwable)e3));
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e4) {
                        logger.warning("close inputStream exception:" + ExceptionUtils.getStackTrace((Throwable)e4));
                    }
                }
                return hashMap;
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.warning("close bufferedReader exception:" + ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warning("close reader exception:" + ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.warning("close inputStream exception:" + ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return tempMap;
    }

    private JSONObject setXmlAttrList(Map<String, String> xmlAttrsMap) {
        JSONObject jsonObject = new JSONObject();
        if (xmlAttrsMap.size() < 1) {
            return jsonObject;
        }
        ArrayList<String> xmlAttrsList = new ArrayList<String>();
        ArrayList<String> xmlAttrsDtlList = new ArrayList<String>();
        for (String attrName : xmlAttrsMap.keySet()) {
            HashMap attrMap = (HashMap)JSON.parseObject((String)JSON.toJSONString((Object)xmlAttrsMap.get(attrName)), HashMap.class);
            xmlAttrsList.add(StringUtils.join((Object[])attrMap.keySet().toArray(), (String)"@~@"));
            xmlAttrsDtlList.add(StringUtils.join(attrMap.values(), (String)"@~@"));
        }
        jsonObject.append("tagNamesList", (Object)StringUtils.join((Object[])xmlAttrsMap.keySet().toArray(), (String)"@~~@"));
        jsonObject.append("xmlAttrsList", (Object)StringUtils.join(xmlAttrsList, (String)"@~~@"));
        jsonObject.append("xmlAttrsDtlList", (Object)StringUtils.join(xmlAttrsDtlList, (String)"@~~@"));
        return jsonObject;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new LoadXmlAttrDataCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

