/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.search.FileSearchQuery;
import com.bokesoft.yes.design.search.FileSearchResult;
import com.bokesoft.yes.design.search.FileTextSearchScope;
import com.bokesoft.yes.design.search.text.FileMatch;
import com.bokesoft.yes.design.search.text.FileMatchResource;
import com.bokesoft.yes.design.search.text.LineElement;
import com.bokesoft.yes.design.search.text.Match;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import java.io.File;

public class LoadFilesSearchDataCmd
extends DesignerServiceCmd {
    public static final String CMD = "LoadFilesSearchData";
    public static final String SearchFormKey = "D_FileTree";
    public static final String SearchTable = "D_SearchResultTable";
    public static final String FileType = "FileType";
    public static final String FileLineType = "FileLineType";
    private String searchText = "";
    private boolean isRegEx = false;
    private boolean isCaseSensitive = false;
    private boolean isWholeWord = false;
    private String fileTypes = "";

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.searchText = (String)arguments.get((Object)"searchText");
        this.isRegEx = TypeConvertor.toBoolean((Object)arguments.get((Object)"isRegEx"));
        this.isCaseSensitive = TypeConvertor.toBoolean((Object)arguments.get((Object)"isCaseSensitive"));
        this.isWholeWord = TypeConvertor.toBoolean((Object)arguments.get((Object)"isWholeWord"));
        this.fileTypes = (String)arguments.get((Object)"fileTypes");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        FileTextSearchScope scope = new FileTextSearchScope(new String[]{"*"});
        FileSearchQuery fQuery = new FileSearchQuery(this.searchText, this.isRegEx, this.isCaseSensitive, this.isWholeWord, this.fileTypes, scope);
        fQuery.run();
        FileSearchResult result = fQuery.getSearchResult();
        Object[] elements = result.getElements();
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        MetaForm metaForm = metaFactory.getMetaForm(SearchFormKey);
        MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
        MetaTable metaTable = dataObject.getMetaTable(SearchTable);
        DataTable table = DataTableUtil.newEmptyDataTable((MetaTable)metaTable);
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < elements.length) {
            FileMatchResource res = (FileMatchResource)elements[i];
            File file = res.getFile();
            Match[] matchs = result.getMatches(elements[i]);
            String fileType = res.getFileType();
            String name = file.getName();
            String fSolutionPath = res.getFileSolutionPath();
            table.append();
            table.setObject("Key", (Object)file.getAbsolutePath());
            table.setObject("ParentKey", null);
            table.setObject("Caption", (Object)(String.valueOf(name) + " (" + fSolutionPath + ")"));
            table.setObject("Type", (Object)FileType);
            table.setObject("Count", (Object)matchs.length);
            table.setObject(FileType, (Object)fileType);
            table.setObject("ParentPath", (Object)file.getParent());
            String key = name.substring(0, name.length() - ".xml".length());
            String focusRowChangedFormula = "showSource('" + file.getAbsolutePath() + "', '" + res.getFileSolutionPath() + "', '" + TreeNode.actionFileReflection.getOrDefault(key, key) + "', '" + file.getParent() + "')";
            table.setObject("FocusRowChangedFormula", (Object)focusRowChangedFormula);
            int j = 0;
            while (j < matchs.length) {
                FileMatch fileMatch = (FileMatch)matchs[j];
                LineElement lineElement = fileMatch.getLineElement();
                table.append();
                table.setObject("Key", (Object)("line" + j));
                table.setObject("ParentKey", (Object)file.getAbsolutePath());
                table.setObject("Caption", (Object)lineElement.getContents());
                table.setObject("Type", (Object)FileLineType);
                table.setObject("StartColumn", (Object)(fileMatch.getOffset() - lineElement.getOffset()));
                table.setObject("EndColumn", (Object)(fileMatch.getOffset() + fileMatch.getLength() - lineElement.getOffset()));
                table.setObject(FileType, (Object)fileType);
                table.setObject("ParentPath", (Object)file.getParent());
                table.setObject("FOffset", (Object)fileMatch.getOffset());
                table.setObject("FocusRowChangedFormula", (Object)focusRowChangedFormula);
                ++j;
            }
            ++i;
        }
        long end = System.currentTimeMillis();
        return table;
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new LoadFilesSearchDataCmd();
    }
}

