/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class LoadFileContentCmd
extends DesignerServiceCmd {
    public static final String CMD = "LoadFileContent";
    private String filePath;
    private String temFilePath;
    private boolean needLoad;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.filePath = FilePathHelper.toBackFilePath((String)arguments.get((Object)"filePath"));
        this.temFilePath = FilePathHelper.toBackFilePath((String)arguments.get((Object)"temFilePath"));
        this.needLoad = TypeConvertor.toBoolean((Object)(arguments.get((Object)"needLoad") == null ? Boolean.valueOf(true) : arguments.get((Object)"needLoad")));
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        File file;
        String tmpFilePath;
        String currentVersion = "";
        String content = "";
        if (StringUtils.isNotEmpty((CharSequence)this.temFilePath)) {
            tmpFilePath = this.temFilePath;
            if (this.needLoad) {
                file = new File(this.filePath);
                content = FileUtils.readFileToString((File)file, (String)"UTF-8");
                String newSecondLine = DesignIOMetaUtil.getSecondLine(content);
                try {
                    currentVersion = DesignIOMetaUtil.getSubString(newSecondLine, "Version=\"(\\d*)\"");
                }
                catch (Exception e) {
                    currentVersion = "1";
                }
            }
        } else {
            tmpFilePath = XmlFileProcessor.instance.getTmpFile(this.filePath);
        }
        if (StringUtils.isBlank((CharSequence)tmpFilePath)) {
            tmpFilePath = this.filePath;
        }
        if (this.needLoad) {
            file = new File(tmpFilePath);
            content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (StringUtils.isNotEmpty((CharSequence)currentVersion)) {
                String oldVerison;
                try {
                    oldVerison = DesignIOMetaUtil.getSubString(content, "Version=\"(\\d*)\"");
                }
                catch (Exception e) {
                    oldVerison = "1";
                }
                content = content.replace("Version=\"" + oldVerison, "Version=\"" + currentVersion);
            }
        }
        JSONObject result = new JSONObject();
        result.put("isNew", !new File(this.filePath).exists());
        result.put("isEditBeforeLoad", tmpFilePath != this.filePath);
        result.put("content", (Object)content);
        return result;
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new LoadFileContentCmd();
    }
}

