/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class GetmacroformulaCmd
extends DesignerServiceCmd {
    public static final String CMD = "Getmacroformula";
    private String formKey;
    private String content;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.formKey = (String)arguments.get((Object)"formKey");
        this.content = TypeConvertor.toString((Object)arguments.get((Object)"content"));
        if (StringUtils.isNotEmpty((CharSequence)this.content)) {
            this.content = this.content.replaceAll("@br@", " ").replaceAll("\uff1b", ";").replaceAll("\uff08", "(").replaceAll("\uff09", ")");
        }
    }

    @Override
    public Object innerDoCmd(DefaultContext context) {
        String contenttext = this.content;
        HashMap<String, Map<String, String>> macroMap = new HashMap<String, Map<String, String>>(150);
        HashMap<String, String> stringStringMap = new HashMap<String, String>();
        HashMap<String, String> optionstringStringMap = new HashMap<String, String>();
        this.extracted(context, contenttext, macroMap, stringStringMap, optionstringStringMap);
        JSONObject jsonObject = new JSONObject();
        StringBuilder ssaa = new StringBuilder();
        for (Map.Entry stringMapEntry : macroMap.entrySet()) {
            String key = (String)stringMapEntry.getKey();
            ssaa.append(key).append("\n").append(" ");
            Map value = (Map)stringMapEntry.getValue();
            for (Map.Entry stringStringEntry : value.entrySet()) {
                String key1 = (String)stringStringEntry.getKey();
                String value1 = (String)stringStringEntry.getValue();
                ssaa.append(key1).append(":").append("\n\t\t").append(value1).append("\n");
                if (!value1.contains(";")) continue;
                this.extracted(context, value1, macroMap, stringStringMap, optionstringStringMap);
            }
        }
        jsonObject.append("mm1", (Object)ssaa);
        if (!this.content.equals("")) {
            return jsonObject.toString();
        }
        return new JSONObject().toString();
    }

    private void extracted(DefaultContext context, String contenttext, Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap, Map<String, String> optionstringStringMap) {
        List<String> strings = this.getStrings(contenttext);
        this.extracted(context, strings, macroMap, stringStringMap);
        this.extractedprojiect(context, strings, macroMap, stringStringMap);
        this.extracteds(strings, macroMap, stringStringMap);
        this.optionextracted(context, strings, macroMap, optionstringStringMap);
        this.optionextractedprojiect(context, strings, macroMap, optionstringStringMap);
        this.optionextracteds(strings, macroMap, optionstringStringMap);
    }

    private void extracteds(List<String> strings, Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
        if (strings.size() > 0) {
            for (String string : strings) {
                MetaForm metaForm = null;
                try {
                    metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
                    MetaMacroCollection macroCollection = metaForm.getMacroCollection();
                    String macro = string.substring(0, string.indexOf("("));
                    if (macroCollection.get(macro) == null) continue;
                    MetaMacro metaMacro = (MetaMacro)macroCollection.get(macro);
                    String args = "";
                    String key = "";
                    String value = "";
                    args = metaMacro.getArgs();
                    key = StringUtils.isNotEmpty((CharSequence)args) ? String.valueOf(metaMacro.getKey()) + "(" + args + ")" : String.valueOf(metaMacro.getKey()) + "()";
                    value = metaMacro.getContent();
                    stringStringMap.put(key, value);
                }
                catch (Throwable throwable) {
                    LogSvr.getInstance().error(throwable.getMessage(), throwable);
                }
            }
            if (stringStringMap.size() > 0) {
                macroMap.put("@" + this.formKey + "/CommonDef.xml", stringStringMap);
            }
        }
    }

    private void optionextracteds(List<String> strings, Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
        if (strings.size() > 0) {
            for (String string : strings) {
                MetaForm metaForm = null;
                try {
                    metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
                    MetaOperationCollection operationCollection = metaForm.getOperationCollection();
                    String macro = string.substring(0, string.indexOf("("));
                    if (operationCollection.get(macro) == null || operationCollection.get(macro) == null) continue;
                    MetaOperation metaOperation = (MetaOperation)operationCollection.get(macro);
                    String value = metaOperation.getAction().getContent();
                    stringStringMap.put(macro, value);
                }
                catch (Throwable throwable) {
                    LogSvr.getInstance().error(throwable.getMessage(), throwable);
                }
            }
            if (stringStringMap.size() > 0) {
                macroMap.put("@" + this.formKey + "/CommonDef.xml", stringStringMap);
            }
        }
    }

    private void extractedprojiect(DefaultContext context, List<String> strings, Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
        if (strings.size() > 0) {
            for (String string : strings) {
                try {
                    String macro;
                    MetaMacroCollection macroCollection;
                    MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
                    IMetaFactory metaFactory = context.getVE().getMetaFactory();
                    MetaProject metaProject = (MetaProject)metaForm.getProject();
                    MetaCommonDef metaCommonDef = metaFactory.getCommonDef(metaProject.getKey());
                    if (metaCommonDef == null || (macroCollection = metaCommonDef.getMacroCollection()).get(macro = string.substring(0, string.indexOf("("))) == null) continue;
                    MetaMacro metaMacro = (MetaMacro)macroCollection.get(macro);
                    String args = "";
                    String key = "";
                    String value = "";
                    args = metaMacro.getArgs();
                    key = StringUtils.isNotEmpty((CharSequence)args) ? String.valueOf(metaMacro.getKey()) + "(" + args + ")" : String.valueOf(metaMacro.getKey()) + "()";
                    value = metaMacro.getContent();
                    stringStringMap.put(key, value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (stringStringMap.size() > 0) {
                try {
                    macroMap.put("@" + MetaFactory.getGlobalInstance().getMetaForm(this.formKey).getProject().getKey() + "/CommonDef.xml", stringStringMap);
                }
                catch (Throwable throwable) {
                    LogSvr.getInstance().error(throwable.getMessage(), throwable);
                }
            }
        }
    }

    private void optionextractedprojiect(DefaultContext context, List<String> strings, Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
        if (strings.size() > 0) {
            for (String string : strings) {
                try {
                    MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
                    IMetaFactory metaFactory = context.getVE().getMetaFactory();
                    MetaProject metaProject = (MetaProject)metaForm.getProject();
                    MetaCommonDef metaCommonDef = metaFactory.getCommonDef(metaProject.getKey());
                    MetaOperationCollection operationCollection = metaCommonDef.getOperationCollection();
                    String macro = string.substring(0, string.indexOf("("));
                    if (operationCollection.get(macro) == null || operationCollection.get(macro) == null) continue;
                    MetaOperation metaOperation = (MetaOperation)operationCollection.get(macro);
                    String value = metaOperation.getAction().getContent();
                    stringStringMap.put(macro, value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (stringStringMap.size() > 0) {
                try {
                    macroMap.put("@" + MetaFactory.getGlobalInstance().getMetaForm(this.formKey).getProject().getKey() + "/CommonDef.xml", stringStringMap);
                }
                catch (Throwable throwable) {
                    LogSvr.getInstance().error(throwable.getMessage(), throwable);
                }
            }
        }
    }

    private void extracted(DefaultContext context, List<String> strings, Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
        if (strings.size() > 0) {
            for (String string : strings) {
                try {
                    String macro;
                    MetaMacroCollection macroCollection;
                    IMetaFactory metaFactory = context.getVE().getMetaFactory();
                    MetaCommonDef metaCommonDef = metaFactory.getCommonDef("");
                    if (metaCommonDef == null || (macroCollection = metaCommonDef.getMacroCollection()).get(macro = string.substring(0, string.indexOf("("))) == null) continue;
                    MetaMacro metaMacro = (MetaMacro)macroCollection.get(macro);
                    String args = "";
                    String key = "";
                    String value = "";
                    args = metaMacro.getArgs();
                    key = StringUtils.isNotEmpty((CharSequence)args) ? String.valueOf(metaMacro.getKey()) + "(" + args + ")" : String.valueOf(metaMacro.getKey()) + "()";
                    value = metaMacro.getContent();
                    stringStringMap.put(key, value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (stringStringMap.size() > 0) {
                macroMap.put("@solution/CommonDef.xml", stringStringMap);
            }
        }
    }

    private void optionextracted(DefaultContext context, List<String> strings, Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
        if (strings.size() > 0) {
            for (String string : strings) {
                try {
                    String macro;
                    MetaOperationCollection operationCollection;
                    IMetaFactory metaFactory = context.getVE().getMetaFactory();
                    MetaCommonDef metaCommonDef = metaFactory.getCommonDef("");
                    if (metaCommonDef == null || (operationCollection = metaCommonDef.getOperationCollection()).get(macro = string.substring(0, string.indexOf("("))) == null) continue;
                    MetaOperation metaOperation = (MetaOperation)operationCollection.get(macro);
                    String value = metaOperation.getAction().getContent();
                    stringStringMap.put(macro, value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (stringStringMap.size() > 0) {
                macroMap.put("@solution/CommonDef.xml", stringStringMap);
            }
        }
    }

    private List<String> getStrings(String contenttext) {
        Stack stack = new Stack();
        String a = "";
        ArrayList<String> strings = new ArrayList<String>();
        int size = stack.size();
        int i = 0;
        while (i < size) {
            if (((Character)stack.peek()).charValue() != ';' && stack.size() != 0) {
                a = String.valueOf(a) + stack.pop();
            } else if (stack.size() != 0) {
                stack.pop();
                strings.add(a);
                a = "";
            }
            if (stack.size() == 0) {
                strings.add(a);
            }
            ++i;
        }
        return strings;
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new GetmacroformulaCmd();
    }

    public static String reverseRecursive(String s) {
        int length = s.length();
        if (length <= 1) {
            return s;
        }
        String left = s.substring(0, length / 2);
        String right = s.substring(length / 2, length);
        String afterReverse = String.valueOf(GetmacroformulaCmd.reverseRecursive(right)) + GetmacroformulaCmd.reverseRecursive(left);
        return afterReverse;
    }
}

