/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.design.vo.RecycleForm;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSubList;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.report.MetaReportList;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class DeleteXmlFileCmd
extends DesignerServiceCmd {
    public static final String CMD = "DeleteXmlFile";
    public static String objectType = "";
    private StringHashMap<Object> arguments;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.arguments = new StringHashMap();
        this.arguments.putAll(arguments);
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        RecycleForm recycleForm = this.getRecycleForm();
        if (recycleForm == null) {
            ArrayList<UICommand> result = new ArrayList<UICommand>();
            result.add(UICommand.showTip("\u63d0\u793a: \u8be5\u8868\u5355\u672a\u4fdd\u5b58\u6216\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
            return UICommand.toJson(result);
        }
        objectType = recycleForm.getType();
        if (StringUtils.equals((CharSequence)objectType, (CharSequence)"Form")) {
            MetaDataObjectList dataObjectList;
            MetaFormProfile metaForm2;
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(recycleForm.getKey());
            if (metaFormProfile == null) {
                metaFormProfile = (MetaFormProfile)metaFactory.getExtFormList().get(recycleForm.getKey());
            }
            for (MetaFormProfile metaForm2 : metaFormList) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)metaForm2.getExtend(), (CharSequence)recycleForm.getKey())) continue;
                ArrayList<UICommand> result = new ArrayList<UICommand>();
                result.add(UICommand.showTip("\u63d0\u793a:\u8be5\u8868\u5355\u5b58\u5728\u9a6c\u7532\u4e0d\u5141\u8bb8\u5220\u9664!!!"));
                return UICommand.toJson(result);
            }
            metaForm2 = MetaObjectHelper.deptClone(metaFormProfile);
            metaForm2.setProject(metaFormProfile.getProject());
            metaForm2.getForm().setProject(metaFormProfile.getProject());
            recycleForm.setForm(metaForm2);
            metaFormList.remove(recycleForm.getKey());
            metaFactory.getExtFormList().remove(recycleForm.getKey());
            if (metaFormProfile.getForm().getDataSource() != null && StringUtils.isEmpty((CharSequence)metaFormProfile.getForm().getDataSource().getRefObjectKey()) && (dataObjectList = metaFactory.getDataObjectList()) != null) {
                dataObjectList.remove(recycleForm.getKey());
            }
            boolean isDelete = this.deleteForm(metaFactory, recycleForm.getKey());
            String extend = metaFormProfile.getExtend();
            Boolean mergeToSource = metaFormProfile.getMergeToSource();
            if (StringUtils.isNotEmpty((CharSequence)extend) && Objects.equals(mergeToSource, Boolean.TRUE)) {
                DesignReloadMetaObject.reloadMetaFormRollbackError(extend);
            }
            this.recycleXmlFile(recycleForm);
            List<UICommand> result = this.buildUICommandList(recycleForm);
            if (isDelete) {
                result.add(UICommand.reloadMenuTree());
            }
            DesignReloadMetaObject.oldFormHashMap.remove(recycleForm.getKey());
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)objectType, (CharSequence)"DataObject")) {
            String xmlFileKey = recycleForm.getKey();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(xmlFileKey);
            String extend = metaDataObjectProfile.getExtend();
            MetaDataObject dataObject = metaDataObjectProfile.getDataObject();
            if (StringUtils.isNotBlank((CharSequence)dataObject.getMergeToSourceMapKey()) && StringUtils.isBlank((CharSequence)dataObject.getExtend())) {
                ArrayList<UICommand> result = new ArrayList<UICommand>();
                result.add(UICommand.showTip("\u63d0\u793a:\u8be5\u6570\u636e\u5bf9\u8c61\u5b58\u5728\u9a6c\u7532\u4e0d\u5141\u8bb8\u5220\u9664!!!"));
                return UICommand.toJson(result);
            }
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            for (MetaFormProfile metaFormProfile : metaFormList) {
                String refObjectKey;
                MetaForm metaForm = metaFormProfile.getForm();
                if (!Objects.nonNull(metaForm) || !Objects.nonNull(metaForm.getDataSource()) || StringUtils.isBlank((CharSequence)(refObjectKey = metaForm.getDataSource().getRefObjectKey())) || !StringUtils.equals((CharSequence)refObjectKey, (CharSequence)xmlFileKey)) continue;
                ArrayList<UICommand> result = new ArrayList<UICommand>();
                result.add(UICommand.showTip("warning: \u8be5\u6570\u636e\u5bf9\u8c61\u5df2\u5728\u8868\u5355\uff1a" + metaForm.getKey() + "\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!!!"));
                return UICommand.toJson(result);
            }
            dataObjectList.remove(xmlFileKey);
            if (StringUtils.isNotBlank((CharSequence)extend)) {
                String resource = LoadFileTree.getPathByDataObject(extend);
                DataObjectHelper.reload(null, extend, resource, null);
            }
            recycleForm.setForm(MetaObjectHelper.deptClone(metaDataObjectProfile));
            this.recycleXmlFile(recycleForm);
            List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)objectType, (CharSequence)"Map")) {
            String xmlFileKey = recycleForm.getKey();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            ERPMetaMap metaCustomObject = (ERPMetaMap)metaFactory.getMetaCustomObject(ERPMetaMap.class, xmlFileKey);
            List customList = metaFactory.getCustomList();
            customList.remove(metaCustomObject);
            recycleForm.setForm(MetaObjectHelper.clone(metaCustomObject));
            this.recycleXmlFile(recycleForm);
            List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)objectType, (CharSequence)"DataMigration")) {
            String xmlFileKey = recycleForm.getKey();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataMigrationList dataMigrationList = metaFactory.getDataMigrationList();
            MetaDataMigrationProfile metaDataMigrationProfile = (MetaDataMigrationProfile)dataMigrationList.get(xmlFileKey);
            MetaDataMigrationProfile metaObject = MetaObjectHelper.deptClone(metaDataMigrationProfile);
            dataMigrationList.remove(xmlFileKey);
            recycleForm.setForm(metaObject);
            this.recycleXmlFile(recycleForm);
            List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)objectType, (CharSequence)"Process")) {
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaBPM metaBPM = metaFactory.getMetaBPM();
            recycleForm.setForm(metaBPM);
            this.recycleXmlFile(recycleForm);
            metaFactory.reloadMetaBPM();
            List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)objectType, (CharSequence)"Report")) {
            MetaReportProfile metaReportProfile;
            String formKey = recycleForm.getSubKey();
            String xmlFileKey = recycleForm.getKey();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaReportList metaReportList = metaFactory.getMetaReportList();
            MetaReportSubList metaReportSubList = (MetaReportSubList)metaReportList.get(formKey);
            if (Objects.nonNull(metaReportSubList) && Objects.nonNull(metaReportProfile = (MetaReportProfile)metaReportSubList.get(xmlFileKey))) {
                metaReportSubList.remove(xmlFileKey);
                recycleForm.setForm(MetaObjectHelper.deptClone(metaReportProfile));
            }
            this.recycleXmlFile(recycleForm);
            List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)objectType, (CharSequence)"Workbook")) {
            MetaExcelTemplateProfile metaExcelTemplateProfile;
            String xmlFileKey = recycleForm.getKey();
            String projectKey = recycleForm.getProjectKey();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaExcelTemplateList metaExcelTemplateList = metaFactory.getMetaExcelTemplateList();
            MetaExcelTemplateSubList metaExcelTemplateSubList = (MetaExcelTemplateSubList)metaExcelTemplateList.get(projectKey);
            if (Objects.nonNull(metaExcelTemplateSubList) && Objects.nonNull(metaExcelTemplateProfile = (MetaExcelTemplateProfile)metaExcelTemplateSubList.get(xmlFileKey))) {
                metaExcelTemplateSubList.remove(xmlFileKey);
                recycleForm.setForm(MetaObjectHelper.deptClone(metaExcelTemplateProfile));
            }
            this.recycleXmlFile(recycleForm);
            List<UICommand> result = this.buildUICommandList(recycleForm);
            return UICommand.toJson(result);
        }
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        result.add(UICommand.showTip("\u63d0\u793a:\u6b64\u6587\u4ef6\u4e0d\u80fd\u5220\u9664!!!"));
        return UICommand.toJson(result);
    }

    private boolean deleteForm(IMetaFactory iMetaFactory, String key) throws Throwable {
        LinkedHashMap<String, String> allItems = this.getAllItems();
        AtomicBoolean isRemove = new AtomicBoolean(false);
        SAXReader reader = new SAXReader();
        OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
        for (Map.Entry<String, String> entry : allItems.entrySet()) {
            String keya = entry.getKey();
            String formKey = entry.getValue();
            if (!formKey.equals(key) && !formKey.startsWith("FormKey=" + key)) continue;
            int fistIndex = keya.indexOf("/");
            String projectKey = keya.substring(0, fistIndex);
            String entryPath = String.valueOf(iMetaFactory.getProjectResolver(projectKey).getPath("")) + "Entry.xml";
            Document document = reader.read(new File(entryPath));
            FileOutputStream fileOutputStream = new FileOutputStream(entryPath);
            XMLWriter writer = new XMLWriter(fileOutputStream, format);
            keya = keya.substring(fistIndex);
            String substring = keya.substring(1);
            int endIndex = substring.lastIndexOf("/");
            Element nodes = (Element)document.getRootElement().selectSingleNode(substring.substring(0, endIndex));
            Element node = (Element)document.getRootElement().selectSingleNode(substring);
            if (Objects.isNull(nodes)) {
                nodes = document.getRootElement();
            }
            if (nodes != null) {
                isRemove.set(nodes.remove(node));
            }
            writer.write(document);
            EntryProcessor.instance.reloadEntry(projectKey);
        }
        return isRemove.get();
    }

    public LinkedHashMap<String, String> getAllItems() throws Throwable {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        MetaEntry metaEntry = MetaFactory.getGlobalInstance().getEntryList("");
        int i = 0;
        while (i < metaEntry.size()) {
            AbstractCompositeObject abstractCompositeObject = metaEntry.get(i);
            if (abstractCompositeObject instanceof MetaEntry) {
                MetaEntry entry = (MetaEntry)abstractCompositeObject;
                this.findItems(linkedHashMap, entry, entry.getProject());
            } else {
                MetaEntryItem entryItem = (MetaEntryItem)metaEntry.get(i);
                String pEntryKeys = String.valueOf(entryItem.getProject()) + "/EntryItem[@FormKey='" + entryItem.getFormKey() + "']";
                String value = entryItem.getFormKey();
                if (StringUtils.isNotEmpty((CharSequence)entryItem.getParameters())) {
                    value = entryItem.getParameters();
                    pEntryKeys = String.valueOf(entryItem.getProject()) + "/EntryItem[@FormKey='" + entryItem.getFormKey() + "']" + "[@Key='" + entryItem.getKey() + "']";
                }
                linkedHashMap.put(pEntryKeys, value);
            }
            ++i;
        }
        return linkedHashMap;
    }

    private void findItems(LinkedHashMap<String, String> linkedHashMap, MetaEntry metaEntry, String pEntryKey) throws Throwable {
        String pEntryKeys = String.valueOf(pEntryKey) + "/Entry[@Key='" + metaEntry.getKey() + "']";
        if (metaEntry.size() != 0) {
            int j = 0;
            while (j < metaEntry.size()) {
                if (metaEntry.get(j) instanceof MetaEntry) {
                    linkedHashMap.put(pEntryKeys, metaEntry.getKey());
                    this.findItems(linkedHashMap, (MetaEntry)metaEntry.get(j), pEntryKeys);
                } else {
                    MetaEntryItem entryItem = (MetaEntryItem)metaEntry.get(j);
                    String pEntryKeys1 = String.valueOf(pEntryKeys) + "/EntryItem[@FormKey='" + entryItem.getFormKey() + "']";
                    String value = entryItem.getFormKey();
                    if (StringUtils.isNotEmpty((CharSequence)entryItem.getParameters())) {
                        pEntryKeys1 = String.valueOf(pEntryKeys) + "/EntryItem[@FormKey='" + entryItem.getFormKey() + "']" + "[@Key='" + entryItem.getKey() + "']";
                        value = entryItem.getParameters();
                    }
                    linkedHashMap.put(pEntryKeys1, value);
                }
                ++j;
            }
        }
    }

    private RecycleForm getRecycleForm() throws Throwable {
        String filePath = FilePathHelper.toBackFilePath((String)this.arguments.get((Object)"filePath"));
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        String content = FileUtils.readFileToString((File)new File(filePath), (Charset)StandardCharsets.UTF_8);
        String secondLine = DesignIOMetaUtil.getSecondLine(content);
        String key = DesignIOMetaUtil.getSubString(secondLine, " Key=\"([A-Za-z_]\\w*)\"");
        String caption = DesignIOMetaUtil.getSubString(secondLine, "Caption=\"([\u4e00-\u9fa5_a-zA-Z0-9]*)\"");
        String objectType = DesignIOMetaUtil.getSubString(secondLine, "<([A-Za-z_]\\w*)\\s");
        String tmpFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", String.valueOf(key) + ".xml").toString();
        String projectKey = LoadFileTree.getProjectKey(filePath);
        RecycleForm recycleForm = new RecycleForm();
        recycleForm.setKey(key);
        recycleForm.setCaption(caption);
        recycleForm.setType(objectType);
        recycleForm.setFilePath(filePath);
        recycleForm.setTmpFilePath(tmpFilePath);
        recycleForm.setContent(content);
        recycleForm.setProjectKey(projectKey);
        try {
            String subKey = DesignIOMetaUtil.getSubString(secondLine, "FormKey=\"([A-Za-z_]\\w*)\"");
            recycleForm.setSubKey(subKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return recycleForm;
    }

    private void recycleXmlFile(RecycleForm recycleForm) throws Throwable {
        String xmlFileKey = recycleForm.getKey();
        String xmlFilePath = recycleForm.getFilePath();
        String xmlFileContent = recycleForm.getContent();
        String tmpFilePath = recycleForm.getTmpFilePath();
        FileUtils.writeStringToFile((File)new File(tmpFilePath), (String)xmlFileContent, (String)"UTF-8");
        XmlFileProcessor.instance.clearTmpFile(xmlFilePath);
        LoadFileTree.removeFilePath(xmlFilePath, recycleForm);
        XmlFileProcessor.instance.saveTempRecycleFile(String.valueOf(objectType) + "@" + xmlFileKey, recycleForm);
        FileUtils.forceDelete((File)new File(xmlFilePath));
    }

    private List<UICommand> buildUICommandList(RecycleForm recycleForm) {
        String xmlFileKey = recycleForm.getKey();
        String xmlFilePath = recycleForm.getFilePath();
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        result.add(UICommand.reloadFileTree(xmlFilePath));
        result.add(UICommand.closeFormKey(xmlFileKey));
        result.add(UICommand.closeFilePath(xmlFilePath));
        return result;
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new DeleteXmlFileCmd();
    }
}

