/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class CopyFormCmd
extends DesignerServiceCmd {
    public static final String CMD = "CopyForm";
    public static String projectKey;
    private String formKey;
    private String formCaption;
    private String directory;
    private String Source;
    private String AssociationForm;
    private int formType;
    private String isDirectory = "1";

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> arguments) throws Throwable {
        projectKey = TypeConvertor.toString((Object)arguments.get((Object)"projectKey")).trim();
        this.formKey = TypeConvertor.toString((Object)arguments.get((Object)"newFormKey")).trim();
        this.formCaption = TypeConvertor.toString((Object)arguments.get((Object)"formCaption")).trim();
        this.directory = TypeConvertor.toString((Object)arguments.get((Object)"directory")).trim();
        this.Source = TypeConvertor.toString((Object)arguments.get((Object)"Source")).trim();
        this.AssociationForm = TypeConvertor.toString((Object)arguments.get((Object)"AssociationForm")).trim();
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        File file;
        SAXReader reader;
        Document document;
        Element root;
        String mergeToSource;
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        if (globalInstance.getMetaFormList().get(this.formKey) != null) {
            return UICommand.showError("\u8868\u5355\u540d\u91cd\u590d\u521b\u5efa\u5931\u8d25\uff01").toJson();
        }
        String orgFilePath = LoadFileTree.getPathByFormKey(this.AssociationForm);
        if (StringUtils.isBlank((CharSequence)orgFilePath)) {
            return UICommand.showError("\u5173\u8054\u8868" + this.AssociationForm + "\u4e0d\u5b58\u5728\uff01").toJson();
        }
        String tempPath = XmlFileProcessor.instance.getTmpFile(orgFilePath);
        if (StringUtils.isBlank((CharSequence)tempPath)) {
            tempPath = orgFilePath;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)(mergeToSource = (root = (document = (reader = new SAXReader()).read(file = new File(tempPath))).getRootElement()).attributeValue("MergeToSource")), (CharSequence[])new CharSequence[]{"1", "true"})) {
            return UICommand.showError("\u4e0d\u53ef\u590d\u5236\u529f\u80fd\u9a6c\u7532\uff01").toJson();
        }
        HashMap<Object, Object> changedContent = new HashMap<Object, Object>();
        String orgFormKey = root.attributeValue("Key");
        root.addAttribute("Key", this.formKey);
        root.addAttribute("Caption", this.formCaption);
        changedContent.put(orgFormKey, this.formKey);
        List dataObjectKeys = root.selectNodes("//DataSource");
        boolean isnExtend = StringUtils.isEmpty((CharSequence)root.attributeValue("Extend"));
        String extendedForm = root.attributeValue("Extend");
        String formType1 = root.attributeValue("FormType");
        this.formType = FormType.parse((String)(StringUtils.isEmpty((CharSequence)formType1) ? "Normal" : formType1));
        int n = this.formType = isnExtend ? this.formType : MetaFactory.getGlobalInstance().getMetaForm(extendedForm).getFormType();
        if (dataObjectKeys != null && dataObjectKeys.size() > 0) {
            Element dataSource = (Element)dataObjectKeys.get(0);
            String refObjectKey = dataSource.attributeValue("RefObjectKey");
            if (isnExtend && dataSource != null && StringUtils.isEmpty((CharSequence)refObjectKey) && 3 != this.formType) {
                Element dataObject = dataSource.element("DataObject");
                dataObject.addAttribute("Key", this.formKey);
                dataObject.addAttribute("Caption", this.formCaption);
                String primaryTableKey = dataObject.attributeValue("PrimaryTableKey");
                List tables = root.selectNodes("//TableCollection/Table");
                for (Element table : tables) {
                    String orgTableKey = table.attributeValue("Key");
                    String tmp = "Tmp";
                    String newTableKey = String.valueOf(orgTableKey.replace(orgFormKey, this.formKey)) + tmp;
                    String orgTableCaption = table.attributeValue("Caption");
                    table.addAttribute("Key", newTableKey);
                    table.addAttribute("Caption", orgTableCaption.replace(orgFormKey, this.formKey));
                    table.addAttribute("IndexPrefix", newTableKey);
                    String parentKey = table.attributeValue("ParentKey");
                    if (!StringUtils.isEmpty((CharSequence)parentKey)) {
                        table.addAttribute("ParentKey", (String)changedContent.get(parentKey));
                    }
                    changedContent.put(orgTableKey, newTableKey);
                }
                dataObject.addAttribute("PrimaryTableKey", (String)changedContent.get(primaryTableKey));
                List hasTableKeys = root.selectNodes("Body//*[@TableKey]");
                for (Element hasTableKey : hasTableKeys) {
                    String orgTableKeyValue = hasTableKey.attributeValue("TableKey");
                    hasTableKey.addAttribute("TableKey", (String)changedContent.getOrDefault(orgTableKeyValue, orgTableKeyValue));
                }
                List defaultFormulaValues = root.selectNodes("Body//*[@DefaultFormulaValue]");
                for (Element defaultFormulaValue : defaultFormulaValues) {
                    String oldDefaultFormulaValue = defaultFormulaValue.attributeValue("DefaultFormulaValue");
                    if (!StringUtils.isNotBlank((CharSequence)oldDefaultFormulaValue)) continue;
                    String newDefaultFormulaValue = StringUtils.replace((String)oldDefaultFormulaValue, (String)primaryTableKey, (String)changedContent.getOrDefault(primaryTableKey, primaryTableKey));
                    defaultFormulaValue.addAttribute("DefaultFormulaValue", newDefaultFormulaValue);
                }
                List embedVars = root.selectNodes("Body//Embed/Var");
                for (Element embedVar : embedVars) {
                    String orgValue = embedVar.attributeValue("Value");
                    String keyValue = embedVar.attributeValue("Key");
                    if (StringUtils.isEmpty((CharSequence)orgValue)) continue;
                    embedVar.addAttribute("Value", (String)changedContent.get(orgValue));
                }
            }
        }
        String fileName = String.valueOf(this.formKey) + ".xml";
        String fileTreePath = LoadFileTree.newFile(projectKey, this.formType, fileName, this.formKey, this.formCaption, this.directory, this.isDirectory);
        OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
        String newFilePath = FilePathHelper.toBackFilePath(String.valueOf(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(projectKey)) + File.separator + fileName + "." + System.currentTimeMillis());
        document.setName(fileTreePath);
        String resource = LoadFileTree.getResource(newFilePath, projectKey);
        FileOutputStream fileOutputStream = new FileOutputStream(newFilePath);
        XMLWriter writer = new XMLWriter(fileOutputStream, format);
        writer.write(document);
        this.closeFileStream(fileOutputStream, writer);
        XmlFileProcessor.stackput(fileTreePath, newFilePath);
        EntryProcessor.instance.newForm(projectKey, this.formType, this.formKey, this.formCaption, this.Source, true);
        MetaProject metaProject = globalInstance.getMetaProject(projectKey);
        MetaFormList metaFormList = globalInstance.getMetaFormList();
        MetaFormProfile newFormProfile = MetaObjectHelper.deptClone((MetaFormProfile)metaFormList.get(orgFormKey));
        newFormProfile.setProject((IMetaProject)metaProject);
        newFormProfile.setKey(this.formKey);
        newFormProfile.setCaption(this.formCaption);
        newFormProfile.setForm(null);
        metaFormList.add((KeyPairMetaObject)newFormProfile);
        if (!isnExtend) {
            newFormProfile.setExtend(extendedForm);
            newFormProfile.setFormType(-1);
        }
        newFormProfile.setResource(resource);
        ReloadForm.reloadFormKey(globalInstance, this.formKey, resource);
        globalInstance.getMetaForm(this.formKey);
        result.add(UICommand.reloadFileTree(fileTreePath));
        result.add(UICommand.runFormKey(this.formKey));
        result.add(UICommand.reloadMenuTree());
        return UICommand.toJson(result);
    }

    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new CopyFormCmd();
    }

    public String getCmd() {
        return CMD;
    }

    private MetaForm setKeyAndCaption(MetaForm orgMetaForm, MetaForm newMetaForm, String key, String caption) throws Exception {
        String orgKey = orgMetaForm.getKey();
        String orgCaption = orgMetaForm.getCaption();
        newMetaForm.setKey(this.formKey);
        newMetaForm.setCaption(this.formCaption);
        if (newMetaForm.getDataSource() != null && (this.formType != 3 || this.AssociationForm.isEmpty())) {
            MetaDataObject metaDataObject = newMetaForm.getDataSource().getDataObject();
            metaDataObject.setKey(metaDataObject.getKey().replace(orgKey, key));
            metaDataObject.setCaption(metaDataObject.getCaption().replace(orgCaption, caption));
            HashMap<String, String> replacedTableKeys = new HashMap<String, String>();
            MetaTableCollection metaTables = metaDataObject.getTableCollection();
            if (metaTables != null) {
                ArrayList<MetaTable> metaTableArray = new ArrayList<MetaTable>();
                for (MetaTable metaTable : metaTables) {
                    String tableNewKey;
                    String tableOrgKey = metaTable.getKey();
                    if (!tableOrgKey.equals(tableNewKey = tableOrgKey.replace(orgKey, key))) {
                        replacedTableKeys.put(tableOrgKey, tableNewKey);
                        metaTable.setKey(tableNewKey);
                    }
                    metaTable.setCaption(metaTable.getCaption().replace(orgCaption, caption));
                    metaTable.setIndexPrefix(metaTable.getIndexPrefix().replace(orgKey, key));
                    metaTableArray.add(metaTable);
                }
                metaTables.clear();
                for (MetaTable metaTable : metaTableArray) {
                    metaTables.add((KeyPairMetaObject)metaTable);
                }
                String tableName = metaDataObject.getMainTableKey();
                metaDataObject.setMainTableKey(replacedTableKeys.getOrDefault(tableName, tableName));
                for (AbstractMetaObject metaObject : newMetaForm.getAllUIComponents().values()) {
                    if (!(metaObject instanceof MetaComponent)) continue;
                    MetaComponent metaComponent = (MetaComponent)metaObject;
                    MetaDataBinding metaDataBinding = metaComponent.getDataBinding();
                    if (metaDataBinding != null && metaDataBinding.getTableKey().contains("_NODB")) {
                        metaComponent.setDataBinding(null);
                        metaDataBinding = null;
                    }
                    if (metaDataBinding != null) {
                        metaDataBinding.setTableKey(replacedTableKeys.getOrDefault(tableName, tableName));
                    }
                    if (!(metaComponent instanceof MetaGrid)) continue;
                    MetaGrid metaGrid = (MetaGrid)metaComponent;
                    for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
                        metaGridRow.setTableKey(replacedTableKeys.getOrDefault(tableName, tableName));
                    }
                }
            }
        }
        return newMetaForm;
    }

    private String saveMetaForm(MetaForm metaForm) throws Throwable {
        MetaFormSave save = new MetaFormSave((AbstractMetaObject)metaForm);
        org.w3c.dom.Document newDocument = save.getDocument();
        XmlCreator creator = new XmlCreator(newDocument, null);
        IMetaProject project = metaForm.getProject();
        MetaForm clone = MetaObjectHelper.deptClone(metaForm);
        MetaDataSource metaDataSource = new MetaDataSource();
        metaDataSource.setRefObjectKey(metaForm.getDataSource().getRefObjectKey());
        clone.setDataSource(metaDataSource);
        clone.setProject(project);
        String xml1 = creator.createXml();
        return xml1;
    }
}

