/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFacade;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFileWrapper;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.DiffProperty;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.MetaFormDiffProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.cmd.XmlDiffToPropertyDiff;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.dto.CommitDiffDto;
import com.bokesoft.yes.design.function.DesignActionUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.DocumentHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaFormHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.web.util.ExtensionUtil;
import com.bokesoft.yigo.mid.web.util.IExtensionProvider;
import com.bokesoft.yigo.struct.document.Document;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommitDiffCmd
extends DesignerServiceCmd {
    public static final String CMD = "CommitDiff";
    public static final CommitDiffCmd instance = new CommitDiffCmd();
    private String formKey;
    private String entryParas;
    private final List<Diff> diffs = new ArrayList<Diff>();
    private DocumentRecordDirty formDocument;
    private Document designerDocument;
    private String controlType;
    private String notNewTableFlagStr = "1";
    private Set<String> openFormKeys = new HashSet<String>();
    private boolean beExtendedFlag = false;
    private boolean vestFlag = false;
    private boolean specVestFlag = false;
    private Pair<List<MetaFormProfile>, MetaFormProfile> metaFormPair = Pair.of(Collections.emptyList(), null);
    private Map<String, XmlTreeWithPath> xmlTreeMap = new HashMap<String, XmlTreeWithPath>();
    private boolean withoutUICommands = false;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        String docStr;
        this.beExtendedFlag = false;
        this.vestFlag = false;
        this.specVestFlag = false;
        this.metaFormPair = Pair.of(Collections.emptyList(), null);
        this.xmlTreeMap = new HashMap<String, XmlTreeWithPath>();
        String key = (String)arguments.get((Object)"openFormKeys");
        if (StringUtils.isNotBlank((CharSequence)key)) {
            this.openFormKeys.addAll(Arrays.asList(key.split(",")));
        }
        context.setPara("openFormKeys", this.openFormKeys);
        this.formKey = (String)arguments.get((Object)"formKey");
        this.entryParas = (String)arguments.get((Object)"entryParas");
        if (arguments.containsKey((Object)"designerDocument")) {
            docStr = (String)arguments.get((Object)"designerDocument");
            this.designerDocument = DocumentHelper.parseDocumentFormJSON(docStr);
        }
        if (arguments.containsKey((Object)"formDocument")) {
            docStr = (String)arguments.get((Object)"formDocument");
            String documentFormKey = (String)arguments.get((Object)"documentFormKey");
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(documentFormKey);
            this.formDocument = new DocumentRecordDirty(metaForm, false);
            try {
                this.formDocument.fromJSON(new JSONObject(docStr));
            }
            catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            }
        }
        String diffJsonString = (String)arguments.get((Object)"diffs");
        JSONArray array = new JSONArray(diffJsonString);
        int i = 0;
        while (i < array.length()) {
            JSONObject jsonObject = array.getJSONObject(i);
            this.diffs.add(Diff.fromJson(jsonObject));
            this.controlType = jsonObject.optString("controlType");
            this.notNewTableFlagStr = jsonObject.optString("associatedTable", "1");
            ++i;
        }
        this.validateArguments(array);
        this.validateExtension(array, context);
    }

    @Override
    public synchronized Object innerDoCmd(DefaultContext context) throws Throwable {
        boolean hasPreOpt;
        String prjKey;
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile tmpProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(this.formKey);
        if (tmpProfile == null) {
            tmpProfile = (MetaFormProfile)metaFactory.getExtFormList().get(this.formKey);
        }
        if (LoadFileTree.isJarProjectKey(prjKey = tmpProfile.getProject().getKey())) {
            CommitDiffDto commitDiffDto = new CommitDiffDto();
            commitDiffDto.setResult("fail");
            commitDiffDto.setMessage("Jar\u5305\u4e2d\u7684\u8868\u5355\u65e0\u6cd5\u4fee\u6539 (" + CommitDiffCmd.class.getSimpleName() + ")");
            return commitDiffDto.toJson();
        }
        CommitDiffDto commitDiffDto = CommitDiffCmd.commitDiffWithoutUiCommand(context, this.formKey, this.entryParas, this.diffs, this.designerDocument, this.formDocument);
        ArrayList<String> formKeyList = new ArrayList<String>();
        formKeyList.add(this.formKey);
        MetaForm metaForm = metaFactory.getMetaForm(this.formKey);
        if (StringUtils.isNotBlank((CharSequence)metaForm.getExtend())) {
            formKeyList.add(metaForm.getExtend());
        } else {
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            for (MetaFormProfile metaFormProfile : metaFormList) {
                String extend = metaFormProfile.getExtend();
                if (!StringUtils.equals((CharSequence)extend, (CharSequence)this.formKey)) continue;
                formKeyList.add(metaFormProfile.getKey());
            }
        }
        String paramsFormKey = this.diffs.get(0).getParamsformKey();
        if (!StringUtils.equals((CharSequence)this.diffs.get((int)0).formKey, (CharSequence)paramsFormKey)) {
            formKeyList.add(paramsFormKey);
            String paramsFormPath = LoadFileTree.getPathByFormKey(paramsFormKey);
            commitDiffDto.getFilePathList().add(paramsFormPath);
        }
        commitDiffDto.setFormKeyList(formKeyList);
        boolean bl = hasPreOpt = StringUtils.equals((CharSequence)this.controlType, (CharSequence)"ListView") && StringUtils.equals((CharSequence)this.notNewTableFlagStr, (CharSequence)"0");
        if (!hasPreOpt) {
            return commitDiffDto.toJson();
        }
        String filePath = LoadFileTree.getPathByFormKey(this.formKey);
        if (XmlFileProcessor.filePathToTmpFileMap.containsKey(filePath)) {
            Stack<String> stack = XmlFileProcessor.filePathToTmpFileMap.get(filePath);
            String curTmpFile = stack.pop();
            stack.pop();
            stack.push(curTmpFile);
        }
        return commitDiffDto.toJson();
    }

    private static CommitDiffDto commitDiffWithoutUiCommand(DefaultContext context, String formKey, String entryParas, List<Diff> diffs, Document designerDocument, DocumentRecordDirty formDocument) throws Throwable {
        CommitDiffCmd.loadXmlTrees(diffs, entryParas, null);
        int anInt = XmlDiffProcessor.instance.processDiff(diffs, designerDocument);
        boolean genPropertyDiffSuccess = XmlDiffToPropertyDiff.instance.processDiff(diffs);
        Map<String, String> tmpFiles = XmlFileProcessor.instance.processDiff(diffs, false);
        String XmlError = MetaFormDiffProcessor.instance.processDiff(context, diffs, genPropertyDiffSuccess, formDocument, tmpFiles);
        CommitDiffDto commitDiffDto = new CommitDiffDto();
        if ("\u64cd\u4f5c\u6210\u529f".equals(XmlError)) {
            commitDiffDto.setResult("Success");
        } else {
            commitDiffDto.setResult("fail");
        }
        ArrayList<String> filePathList = new ArrayList<String>();
        for (Diff diff : diffs) {
            if (!diff.isPropertyDiff()) continue;
            String filePath = FilePathHelper.toFrontFilePath(diff.getFilePath());
            String dataObjectFilePath = FilePathHelper.toFrontFilePath(diff.getDataObjectfilePath());
            String otherDataObjectFilePath = FilePathHelper.toFrontFilePath(diff.getOtherDataObjectFilePath());
            filePathList.add(filePath);
            if (StringUtils.isNotEmpty((CharSequence)dataObjectFilePath)) {
                filePathList.add(dataObjectFilePath);
            }
            if (!StringUtils.isNotEmpty((CharSequence)otherDataObjectFilePath)) continue;
            filePathList.add(otherDataObjectFilePath);
        }
        for (String path : filePathList) {
            String tempFilePath = XmlFileProcessor.instance.getTmpFile(path);
            IndexFileWrapper file = IndexFileWrapper.newInstance((String)path, (String)tempFilePath);
            IndexFacade.reload((IndexFileWrapper)file);
        }
        commitDiffDto.setFilePathList(filePathList);
        CommitDiffCmd.processDocumentDirty(diffs, formKey, null, commitDiffDto, formDocument, context);
        commitDiffDto.setMessage(XmlError);
        return commitDiffDto;
    }

    private static void setLocateIdList(List<String> locateIdList, TagNode node) {
        TagNode parent = node.getParent();
        if (parent == null) {
            return;
        }
        if (parent.getParent() == null || parent.getTagName().equalsIgnoreCase("Block")) {
            return;
        }
        String key = parent.getAttributes().get("Key");
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            locateIdList.add(key);
        }
        CommitDiffCmd.setLocateIdList(locateIdList, parent);
    }

    private static void processDocumentDirty(List<Diff> diffs, String Key, List<UICommand> uiCommands, CommitDiffDto commitDiffDto, DocumentRecordDirty formDocument, DefaultContext context) throws Throwable {
        if (Objects.isNull(formDocument)) {
            return;
        }
        if (DesignActionUtil.getPreferencesInfo("IsShowData").equals("false")) {
            return;
        }
        String formKey = formDocument.getMetaForm().getKey();
        if (!StringUtils.equals((CharSequence)diffs.get(0).getParamsformKey(), (CharSequence)formKey)) {
            return;
        }
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile metaFormProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(Key);
        String extend = metaFormProfile.getExtend();
        if (StringUtils.isNotBlank((CharSequence)extend) && !metaFormProfile.getMergeToSource().booleanValue()) {
            return;
        }
        if (metaFormProfile.getForm().getFormType() == 3) {
            return;
        }
        RichDocumentContext richDocumentContext = CommitDiffCmd.processParentContext(context, formDocument);
        formDocument.setContext(richDocumentContext);
        try {
            formDocument.setMetaForm(metaFormProfile.getForm());
            JSONObject documentDirty = formDocument.getDirtyJSON(richDocumentContext);
            if (uiCommands != null) {
                uiCommands.add(UICommand.processDocumentDirty(formKey, documentDirty));
            }
            if (commitDiffDto != null) {
                commitDiffDto.setDocumentDirty(documentDirty);
            }
        }
        catch (Throwable e) {
            LogSvr.getInstance().error("", e);
        }
    }

    private static RichDocumentContext processParentContext(DefaultContext context, DocumentRecordDirty formDocument) throws Throwable {
        context.setFormKey(formDocument.getMetaForm().getKey());
        context.setDocument((Document)formDocument);
        RichDocumentContext parentContext = (RichDocumentContext)context.getParentContext();
        if (Objects.isNull(parentContext)) {
            parentContext = new RichDocumentContext(context);
            parentContext.setDocument((Document)formDocument);
            context.setParentContext((DefaultContext)parentContext);
        }
        return parentContext;
    }

    public static void loadXmlTrees(List<Diff> diffs, String entryParas, String type) throws Throwable {
        HashMap<String, XmlTreeWithPath> xmlTrees = new HashMap<String, XmlTreeWithPath>();
        block0: for (Diff diff : diffs) {
            MetaForm metaForm;
            MetaGrid metaGrid;
            String sideKey;
            if (StringUtils.isBlank((CharSequence)type) && Objects.nonNull(diff.getMetaObjectType())) {
                type = diff.getMetaObjectType().name;
            }
            String filePath = diff.getFilePath();
            String realFormKey = diff.formKey;
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                if (StringUtils.equals((CharSequence)realFormKey, (CharSequence)"ERP_DictEdit")) {
                    realFormKey = FilenameUtils.getBaseName((String)filePath);
                }
            } else {
                if (StringUtils.equals((CharSequence)type, (CharSequence)"DataObject")) {
                    if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.DataObject)) {
                        filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(realFormKey);
                    }
                } else {
                    filePath = LoadFileTree.getPathByFormKey(realFormKey);
                }
                if (StringUtils.isBlank((CharSequence)filePath)) {
                    realFormKey = entryParas;
                    if (StringUtils.isBlank((CharSequence)realFormKey)) {
                        String otherKey;
                        realFormKey = otherKey = entryParas;
                        diff.setContainerKey(otherKey);
                    }
                    filePath = LoadFileTree.loadFilePathByFormFieldKey(realFormKey, diff.getOrgKey(), diff.parentKey, entryParas, type);
                }
                if (StringUtils.isNotBlank((CharSequence)entryParas)) {
                    realFormKey = entryParas;
                    diff.setContainerKey(entryParas);
                }
                diff.setFilePath(filePath);
            }
            if (StringUtils.isBlank((CharSequence)realFormKey)) {
                realFormKey = diff.formKey;
            }
            if (StringUtils.equals((CharSequence)type, (CharSequence)"DataObject")) {
                diff.setMetaDataObejct(MetaFactory.getGlobalInstance().getDataObject(realFormKey));
            } else if (!StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"CommonDef")) {
                diff.setMetaForm(MetaFactory.getGlobalInstance().getMetaForm(realFormKey));
            }
            String filePathVest = "";
            String dataObjectFilePath = "";
            if (!StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"DataObject", "CommonDef"})) {
                String refObjectKey;
                filePathVest = LoadFileTree.loadFilePathByVestFormFieldKey(true, diff.getMetaForm().getExtend(), diff.getOrgKey(), diff.parentKey, entryParas);
                MetaDataSource dataSource = diff.getMetaForm().getDataSource();
                if (Objects.nonNull(dataSource) && StringUtils.isNotBlank((CharSequence)(refObjectKey = dataSource.getRefObjectKey()))) {
                    dataObjectFilePath = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
                }
            }
            XmlTreeWithPath orgTree = (XmlTreeWithPath)xmlTrees.get(filePath);
            XmlTreeWithPath defaultOrgTree = null;
            XmlTreeWithPath vestOrgTree = null;
            XmlTreeWithPath dataObjectOrgTree = null;
            XmlTreeWithPath otherDataObjectOrgTree = null;
            if (Objects.isNull(orgTree) || Objects.isNull(diff.getXmlTree())) {
                if (StringUtils.isNotBlank((CharSequence)dataObjectFilePath)) {
                    diff.setDataObjectfilePath(dataObjectFilePath);
                }
                orgTree = XmlTreeWithPath.parseFilePath(filePath);
                defaultOrgTree = XmlTreeWithPath.parseFilePathNotLoadTmp(filePath);
                vestOrgTree = XmlTreeWithPath.parseFilePath(filePathVest);
                dataObjectOrgTree = XmlTreeWithPath.parseFilePath(dataObjectFilePath);
                if (Objects.nonNull(dataObjectOrgTree)) {
                    boolean dataBindFlag;
                    List<DiffProperty> properties = diff.properties;
                    boolean bl = dataBindFlag = CollectionUtils.isNotEmpty(properties) && StringUtils.equals((CharSequence)properties.get((int)0).propertyValueByLocation, (CharSequence)"DataBinding");
                    if (StringUtils.equalsIgnoreCase((CharSequence)diff.getReserveFour(), (CharSequence)"true") || dataBindFlag) {
                        TagNode tagNode;
                        String refObjectKey = diff.getMetaForm().getDataSource().getRefObjectKey();
                        MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(refObjectKey);
                        String mergeToSourceMapKey = dataObject.getMergeToSourceMapKey();
                        if (StringUtils.isNotBlank((CharSequence)mergeToSourceMapKey)) {
                            String mergePath = LoadFileTree.loadFilePathByDataObjectFieldKey(mergeToSourceMapKey);
                            diff.setOtherDataObjectFilePath(diff.getDataObjectfilePath());
                            diff.setDataObjectfilePath(mergePath);
                            otherDataObjectOrgTree = XmlTreeWithPath.parseFilePath(mergePath);
                        }
                        if (Objects.isNull(tagNode = dataObjectOrgTree.xmlTree.getTagNode("Table@" + diff.getReserveTwo()))) {
                            XmlTreeWithPath tmp = dataObjectOrgTree;
                            dataObjectOrgTree = otherDataObjectOrgTree;
                            otherDataObjectOrgTree = tmp;
                        }
                        String extendObjectKey = dataObject.getExtend();
                        if (Objects.isNull(otherDataObjectOrgTree) && StringUtils.isNotBlank((CharSequence)extendObjectKey)) {
                            String mergePath = LoadFileTree.loadFilePathByDataObjectFieldKey(extendObjectKey);
                            diff.setOtherDataObjectFilePath(diff.getDataObjectfilePath());
                            diff.setDataObjectfilePath(mergePath);
                            otherDataObjectOrgTree = XmlTreeWithPath.parseFilePath(mergePath);
                        }
                    }
                }
                if (Objects.nonNull(orgTree)) {
                    xmlTrees.put(orgTree.orgFilePath, orgTree);
                }
                if (Objects.nonNull(defaultOrgTree)) {
                    xmlTrees.put(defaultOrgTree.orgFilePath, defaultOrgTree);
                }
                if (Objects.nonNull(vestOrgTree)) {
                    xmlTrees.put(vestOrgTree.orgFilePath, vestOrgTree);
                }
                if (Objects.nonNull(dataObjectOrgTree)) {
                    xmlTrees.put(dataObjectOrgTree.orgFilePath, dataObjectOrgTree);
                }
            }
            if (Objects.isNull(orgTree)) {
                String path = diff.getFilePath();
                orgTree = XmlTreeWithPath.parseFilePath(path);
            }
            diff.setXmlTree(orgTree);
            diff.setDefaultxmlTree(defaultOrgTree);
            diff.setVestXmlTree(vestOrgTree);
            diff.setDataObjectXmlTree(dataObjectOrgTree);
            diff.setOtherDataObjectOrgTree(otherDataObjectOrgTree);
            if (!Objects.equals(diff.getMetaObjectType(), MetaObjectType.gridField) || !StringUtils.isNotBlank((CharSequence)diff.sideKey) || orgTree.xmlTree.containKey(sideKey = "GridColumn@" + diff.sideKey) || StringUtils.contains((CharSequence)sideKey, (CharSequence)"_") || !Objects.nonNull(metaGrid = (MetaGrid)(metaForm = diff.getMetaForm()).componentByKey(diff.parentKey))) continue;
            MetaGridColumnCollection columnCollection = metaGrid.getColumnCollection();
            int idx = columnCollection.size() - 1;
            while (idx >= 0) {
                MetaGridColumn metaGridColumn = (MetaGridColumn)columnCollection.get(idx);
                String key = metaGridColumn.getKey();
                sideKey = "GridColumn@" + key;
                if (orgTree.xmlTree.containKey(sideKey)) {
                    diff.sideKey = key;
                    continue block0;
                }
                --idx;
            }
        }
        xmlTrees.clear();
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new CommitDiffCmd();
    }

    private void validateArguments(JSONArray array) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = metaFactory.getMetaForm(this.formKey);
        this.beExtendedFlag = MetaFormHelper.isBeExtended(metaForm);
        this.vestFlag = StringUtils.isNotBlank((CharSequence)metaForm.getExtend());
        this.specVestFlag = Objects.equals(metaForm.getMergeToSource(), Boolean.TRUE);
        if (!this.beExtendedFlag && !this.vestFlag) {
            return;
        }
        if (this.vestFlag && !this.specVestFlag) {
            return;
        }
        this.metaFormPair = !this.specVestFlag ? MetaFormHelper.listVestMetaFormByOriginal(metaForm) : MetaFormHelper.listVestMetaFormBySpecVest(metaForm);
        List vestMetaFormList = (List)this.metaFormPair.getLeft();
        for (MetaFormProfile vestMetaForm : vestMetaFormList) {
            String vestFilePath = LoadFileTree.getPathByFormKey(vestMetaForm.getKey());
            String tmpVestFilePath = XmlFileProcessor.instance.getTmpFile(vestFilePath);
            String realVestFilePath = StringUtils.isNotBlank((CharSequence)tmpVestFilePath) ? tmpVestFilePath : vestFilePath;
            XmlTreeWithPath vestMetaXmlTree = XmlTreeWithPath.parseFilePath(realVestFilePath);
            this.xmlTreeMap.put(vestMetaForm.getKey(), vestMetaXmlTree);
        }
        MetaFormProfile funMetaForm = (MetaFormProfile)this.metaFormPair.getRight();
        if (Objects.nonNull(funMetaForm)) {
            String funFilePath = LoadFileTree.getPathByFormKey(funMetaForm.getKey());
            String tmpFunFilePath = XmlFileProcessor.instance.getTmpFile(funFilePath);
            String realFunFilePath = StringUtils.isNotBlank((CharSequence)tmpFunFilePath) ? tmpFunFilePath : funFilePath;
            XmlTreeWithPath funMetaXmlTree = XmlTreeWithPath.parseFilePath(realFunFilePath);
            this.xmlTreeMap.put(funMetaForm.getKey(), funMetaXmlTree);
        }
        int i = 0;
        while (i < array.length()) {
            JSONObject jsonObject = array.getJSONObject(i);
            String compKey = jsonObject.optString("key");
            if (!StringUtils.isBlank((CharSequence)compKey)) {
                boolean isDelete;
                String metaObjectType = jsonObject.optString("metaObjectType");
                boolean isButtonQuote = jsonObject.optBoolean("ISButtonQuote", false);
                String caption = jsonObject.optString("caption", "");
                if (StringUtils.isNotBlank((CharSequence)caption) && !isButtonQuote) {
                    this.validateArgumentsByAdd(compKey, metaObjectType);
                }
                if (isDelete = jsonObject.optBoolean("isDelete", false)) {
                    this.validateArgumentsByDelete(compKey, metaObjectType);
                }
            }
            ++i;
        }
    }

    private void validateArgumentsByAdd(String compKey, String metaObjectType) throws IllegalAccessException {
        Field[] fs;
        boolean existFlag;
        MetaFormProfile funMetaForm = (MetaFormProfile)this.metaFormPair.getRight();
        if (Objects.isNull(funMetaForm)) {
            return;
        }
        String typeName = this.specVestFlag ? "\u539f\u5355" : "\u9a6c\u7532";
        XmlTreeWithPath xmlTreeWithPath = this.xmlTreeMap.get(funMetaForm.getKey());
        if (StringUtils.equals((CharSequence)metaObjectType, (CharSequence)"GridField")) {
            existFlag = xmlTreeWithPath.xmlTree.containKey("GridColumn@" + compKey);
            if (existFlag) {
                throw new RuntimeException("warning: " + typeName + "[key=" + funMetaForm.getKey() + "]\u5df2\u5b58\u5728\u76f8\u540c\u7ec4\u4ef6Key\uff01");
            }
            existFlag = xmlTreeWithPath.xmlTree.containKey("GridCell@" + compKey);
            if (existFlag) {
                throw new RuntimeException("warning: " + typeName + "[key=" + funMetaForm.getKey() + "]\u5df2\u5b58\u5728\u76f8\u540c\u7ec4\u4ef6Key\uff01");
            }
        }
        if (existFlag = xmlTreeWithPath.xmlTree.containKey(String.valueOf(metaObjectType) + "@" + compKey)) {
            throw new RuntimeException("warning: " + typeName + "[key=" + funMetaForm.getKey() + "]\u5df2\u5b58\u5728\u76f8\u540c\u7ec4\u4ef6Key\uff01");
        }
        Field[] fieldArray = fs = ControlType.class.getFields();
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            int modifiers = f.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && StringUtils.startsWithIgnoreCase((CharSequence)f.getName(), (CharSequence)"STR_") && (existFlag = xmlTreeWithPath.xmlTree.containKey(f.get(null) + "@" + compKey))) {
                throw new RuntimeException("warning: " + typeName + "[key=" + funMetaForm.getKey() + "]\u5df2\u5b58\u5728\u76f8\u540c\u7ec4\u4ef6Key\uff01");
            }
            ++n2;
        }
    }

    private void validateArgumentsByDelete(String compKey, String metaObjectType) throws IllegalAccessException {
        ArrayList<MetaFormProfile> vestMetaForm = new ArrayList<MetaFormProfile>((Collection)this.metaFormPair.getLeft());
        if (this.beExtendedFlag && Objects.nonNull(this.metaFormPair.getRight())) {
            vestMetaForm.add((MetaFormProfile)this.metaFormPair.getRight());
        }
        for (MetaFormProfile metaForm : vestMetaForm) {
            Field[] fs;
            boolean existFlag;
            XmlTreeWithPath xmlTreeWithPath = this.xmlTreeMap.get(metaForm.getKey());
            if (StringUtils.equals((CharSequence)metaObjectType, (CharSequence)"GridField")) {
                existFlag = xmlTreeWithPath.xmlTree.containKey("GridColumn@" + compKey);
                if (existFlag) {
                    throw new RuntimeException("warning: \u9a6c\u7532[key=" + metaForm.getKey() + "]\u5df2\u4f7f\u7528\u8be5\u7ec4\u4ef6\uff01");
                }
                existFlag = xmlTreeWithPath.xmlTree.containKey("GridCell@" + compKey);
                if (existFlag) {
                    throw new RuntimeException("warning: \u9a6c\u7532[key=" + metaForm.getKey() + "]\u5df2\u4f7f\u7528\u8be5\u7ec4\u4ef6\uff01");
                }
            }
            if (existFlag = xmlTreeWithPath.xmlTree.containKey(String.valueOf(metaObjectType) + "@" + compKey)) {
                throw new RuntimeException("warning: \u9a6c\u7532[key=" + metaForm.getKey() + "]\u5df2\u4f7f\u7528\u8be5\u7ec4\u4ef6\uff01");
            }
            Field[] fieldArray = fs = ControlType.class.getFields();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                int modifiers = f.getModifiers();
                if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && StringUtils.startsWithIgnoreCase((CharSequence)f.getName(), (CharSequence)"STR_") && (existFlag = xmlTreeWithPath.xmlTree.containKey(f.get(null) + "@" + compKey))) {
                    throw new RuntimeException("warning: \u9a6c\u7532[key=" + metaForm.getKey() + "]\u5df2\u4f7f\u7528\u8be5\u7ec4\u4ef6\uff01");
                }
                ++n2;
            }
        }
    }

    private void validateExtension(JSONArray array, DefaultContext context) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = metaFactory.getMetaForm(this.formKey);
        IExtensionProvider provider = ExtensionUtil.newDefaultProvider();
        MetaForm extensionForm = provider.getExtMetaForm(context, metaForm);
        if (extensionForm == null) {
            return;
        }
        int i = 0;
        while (i < array.length()) {
            JSONObject jsonObject = array.getJSONObject(i);
            String compKey = jsonObject.optString("key");
            if (!StringUtils.isBlank((CharSequence)compKey)) {
                String metaObjectType = jsonObject.optString("metaObjectType");
                boolean isDelete = jsonObject.optBoolean("isDelete", false);
                if (isDelete) {
                    Field[] fs;
                    String vestFilePath = LoadFileTree.getPathByFormKey(extensionForm.getKey());
                    String tmpVestFilePath = XmlFileProcessor.instance.getTmpFile(vestFilePath);
                    String realVestFilePath = StringUtils.isNotBlank((CharSequence)tmpVestFilePath) ? tmpVestFilePath : vestFilePath;
                    XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(realVestFilePath);
                    boolean existFlag = xmlTreeWithPath.xmlTree.containKey(String.valueOf(metaObjectType) + "@" + compKey);
                    if (existFlag) {
                        throw new RuntimeException("warning: \u79fb\u52a8\u6269\u5c55\u8868\u5355[key=" + extensionForm.getKey() + "]\u4e2d\u5df2\u4f7f\u7528\u8be5\u7ec4\u4ef6\uff0c\u8bf7\u5148\u79fb\u9664\uff01");
                    }
                    Field[] fieldArray = fs = ControlType.class.getFields();
                    int n = fs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field f = fieldArray[n2];
                        int modifiers = f.getModifiers();
                        if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && StringUtils.startsWithIgnoreCase((CharSequence)f.getName(), (CharSequence)"STR_") && (existFlag = xmlTreeWithPath.xmlTree.containKey(f.get(null) + "@" + compKey))) {
                            throw new RuntimeException("warning: \u79fb\u52a8\u6269\u5c55\u8868\u5355[key=" + extensionForm.getKey() + "]\u4e2d\u5df2\u4f7f\u7528\u8be5\u7ec4\u4ef6\uff0c\u8bf7\u5148\u79fb\u9664\uff01");
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
    }
}

