/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CheckKeyAndFileNameCmd
extends DesignerServiceCmd {
    public static final String CMD = "CheckKeyAndFileName";
    public static final CheckKeyAndFileNameCmd instance = new CheckKeyAndFileNameCmd();
    private String filePath;
    private String content;

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> arguments) throws Throwable {
        this.filePath = FilePathHelper.toBackFilePath((String)arguments.get((Object)"filePath"));
        this.content = (String)arguments.get((Object)"content");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        Pair<String, String> pair = this.getFormKeyAndFileName();
        if (StringUtils.equals((CharSequence)((CharSequence)pair.getLeft()), (CharSequence)((CharSequence)pair.getRight()))) {
            return UICommand.toJson(Collections.emptyList());
        }
        List<UICommand> resultList = Collections.singletonList(UICommand.showError("\u8868\u5355\u6807\u8bc6\u4e0e\u6587\u4ef6\u540d\u5fc5\u987b\u4e00\u81f4"));
        return UICommand.toJson(resultList);
    }

    private Pair<String, String> getFormKeyAndFileName() {
        String secondLine = DesignIOMetaUtil.getSecondLine(this.content);
        String formKey = CheckKeyAndFileNameCmd.getSubString(secondLine, "Key=\"([A-Za-z_]\\w*)\"");
        if (StringUtils.isBlank((CharSequence)formKey)) {
            return Pair.of((Object)"", (Object)"");
        }
        String tagName = DesignIOMetaUtil.getSubString(secondLine, "<([A-Za-z_]\\w*)");
        if (StringUtils.equals((CharSequence)tagName, (CharSequence)"Entry")) {
            return Pair.of((Object)"", (Object)"");
        }
        File file = new File(this.filePath);
        String fileName = file.getName().split(".xml")[0];
        return Pair.of((Object)formKey, (Object)fileName);
    }

    public static String getSubString(String s, String pattern) {
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new CheckKeyAndFileNameCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

