/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DeleteXmlFileCmd;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.cmd.MetaFormDiffProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.function.DesignActionUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;

public class CancelXmlFileCmd
extends DesignerServiceCmd {
    public static final String CMD = "CancelXmlFile";
    private String filePath;
    private String content;
    private String projectKey;
    private DocumentRecordDirty formDocument;
    private String uiFormKey;
    private String documentFormKey;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.filePath = FilePathHelper.toBackFilePath((String)arguments.get((Object)"filePath"));
        this.content = (String)arguments.get((Object)"content");
        this.projectKey = LoadFileTree.getProjectKey(this.filePath);
        if (arguments.containsKey((Object)"formDocument")) {
            String docStr = (String)arguments.get((Object)"formDocument");
            this.documentFormKey = (String)arguments.get((Object)"documentFormKey");
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.documentFormKey);
            this.formDocument = new DocumentRecordDirty(metaForm, false);
            this.uiFormKey = (String)arguments.get((Object)"uiFormKey");
            try {
                this.formDocument.fromJSON(new JSONObject(docStr));
            }
            catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        String secondLine = DesignIOMetaUtil.getSecondLine(this.content);
        String key = "";
        String objectType = "";
        if (!this.isGeneralConfiguration(secondLine)) {
            objectType = DesignIOMetaUtil.getSubString(secondLine, "<([A-Za-z_]\\w*)\\s");
            key = DesignIOMetaUtil.getSubString(secondLine, "Key=\"([A-Za-z_]\\w*)\"");
        } else {
            objectType = "CommonDef";
        }
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        boolean isNew = !new File(this.filePath).exists();
        boolean reloadMenuTree = false;
        if (isNew) {
            MetaFormProfile metaFormProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(key);
            metaFactory.getMetaFormList().remove(key);
            MetaForm form = metaFormProfile.getForm();
            if (StringUtils.isEmpty((CharSequence)form.getDataSource().getRefObjectKey())) {
                metaFactory.getDataObjectList().remove(key);
            }
            IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
            reloadMenuTree = this.deleteEntryNode(iMetaFactory, key);
            XmlFileProcessor.recycleToTmpFormAndFileMap.remove("Entry@Entry" + key);
        }
        if ("Process".equals(objectType)) {
            XmlFileProcessor.instance.clearTmpFile(this.filePath);
            XmlFileProcessor.dealWithObject(result, "BPM", this.filePath, key, this.filePath);
        } else if ("Map".equals(objectType)) {
            XmlFileProcessor.instance.clearTmpFile(this.filePath);
            XmlFileProcessor.dealWithObject(result, "DataMap", this.filePath, key, this.filePath);
        } else if ("DataMigration".equals(objectType)) {
            XmlFileProcessor.instance.clearTmpFile(this.filePath);
            XmlFileProcessor.dealWithObject(result, "DataMigration", this.filePath, key, this.filePath);
        } else if ("CommonDef".equals(objectType)) {
            result.add(UICommand.reloadXmlSource(this.filePath));
        } else {
            String nowActiveFormPath = null;
            List<MetaFormProfile> reloadMetaFormProfiles = null;
            if (objectType.equals("Form")) {
                if (!isNew) {
                    String pathByFormKey;
                    String s;
                    String refObjectKey;
                    MetaForm metaForm1;
                    String tmpRefObjectKey1;
                    String path = LoadFileTree.getPathByFormKey(key);
                    XmlTreeWithPath parse1 = XmlTreeWithPath.parseFilePathNotLoadTmp(path);
                    XmlTreeWithPath tmpParse1 = XmlTreeWithPath.parseFilePath(path);
                    String refObjectKey1 = parse1.xmlTree.getRoot().getOrCreateChildByTagName("DataSource").getAttributes().get("RefObjectKey");
                    if (Objects.equals(refObjectKey1, tmpRefObjectKey1 = tmpParse1.xmlTree.getRoot().getOrCreateChildByTagName("DataSource").getAttributes().get("RefObjectKey"))) {
                        if (StringUtils.isNotEmpty((CharSequence)refObjectKey1)) {
                            metaForm1 = metaFactory.getMetaForm(key);
                            refObjectKey = metaForm1.getDataSource().getRefObjectKey();
                            if (StringUtils.isEmpty((CharSequence)refObjectKey)) {
                                metaForm1.getDataSource().setRefObjectKey(refObjectKey1);
                                refObjectKey = refObjectKey1;
                            }
                            s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
                            pathByFormKey = LoadFileTree.getPathByFormKey(key);
                            XmlFileProcessor.instance.clearTmpFile(s);
                            XmlFileProcessor.instance.clearTmpFile(pathByFormKey);
                            DataObjectHelper.reload(null, refObjectKey, s, this.filePath);
                            result.add(UICommand.reloadXmlSource(s));
                        }
                        reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(null, key, this.filePath, null);
                    } else if (StringUtils.isNotEmpty((CharSequence)refObjectKey1)) {
                        metaForm1 = metaFactory.getMetaForm(key);
                        refObjectKey = metaForm1.getDataSource().getRefObjectKey();
                        if (StringUtils.isEmpty((CharSequence)refObjectKey)) {
                            refObjectKey = refObjectKey1;
                        }
                        s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
                        pathByFormKey = LoadFileTree.getPathByFormKey(key);
                        XmlFileProcessor.instance.clearTmpFile(s);
                        XmlFileProcessor.instance.clearTmpFile(pathByFormKey);
                        reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(null, key, this.filePath, null);
                        result.add(UICommand.reloadXmlSource(s));
                    } else {
                        MetaFormProfile metaFormProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(key);
                        reloadMetaFormProfiles = new ArrayList<MetaFormProfile>();
                        reloadMetaFormProfiles.add(metaFormProfile);
                        MetaForm metaForm = metaFactory.getMetaForm(key);
                        String refObjectKey2 = metaForm.getDataSource().getRefObjectKey();
                        String resource1 = LoadFileTree.getResource(this.filePath, this.projectKey);
                        ReloadForm.reloadFormKey(metaFactory, key, resource1);
                        if (StringUtils.isNotEmpty((CharSequence)refObjectKey2)) {
                            String s2 = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey2);
                            reloadMetaFormProfiles = DataObjectHelper.reload(null, refObjectKey2, s2, s2);
                            reloadMetaFormProfiles.add(metaFormProfile);
                        }
                    }
                }
            } else if (objectType.equals("DataObject")) {
                String s;
                MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
                MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(key);
                String extend = metaDataObjectProfile.getExtend();
                if (StringUtils.isNotBlank((CharSequence)extend)) {
                    s = LoadFileTree.loadFilePathByDataObjectFieldKey(extend);
                    DataObjectHelper.reload(null, extend, s, null);
                }
                if (isNew) {
                    dataObjectList.remove(key);
                } else {
                    s = LoadFileTree.loadFilePathByDataObjectFieldKey(key);
                    reloadMetaFormProfiles = DataObjectHelper.reload(null, key, s, this.filePath);
                }
            }
            if (isNew) {
                LoadFileTree.removeFilePath(this.filePath);
            }
            if (isNew && objectType.equals("Form")) {
                result.add(UICommand.closeFilePath(this.filePath));
                result.add(UICommand.closeFormKey(key));
                if (reloadMenuTree) {
                    result.add(UICommand.reloadMenuTree());
                    result.add(UICommand.freshFileTree());
                }
            } else {
                result.add(UICommand.reloadXmlSource(this.filePath));
                if (nowActiveFormPath != null && nowActiveFormPath.length() >= 0) {
                    result.add(UICommand.reloadXmlSource(nowActiveFormPath));
                }
                if (secondLine.contains("Extend")) {
                    result.add(UICommand.reloadFormKey(key));
                } else if (reloadMetaFormProfiles != null) {
                    for (MetaFormProfile metaFormProfile : reloadMetaFormProfiles) {
                        result.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
                    }
                }
            }
            XmlFileProcessor.instance.clearTmpFile(this.filePath);
        }
        this.processDocumentDirty(result, this.formDocument, context);
        return UICommand.toJson(result);
    }

    private boolean deleteEntryNode(IMetaFactory iMetaFactory, String key) throws Throwable {
        DeleteXmlFileCmd deleteXmlFileCmd = new DeleteXmlFileCmd();
        LinkedHashMap<String, String> allItems = deleteXmlFileCmd.getAllItems();
        AtomicBoolean isRemove = new AtomicBoolean(false);
        SAXReader reader = new SAXReader();
        OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
        for (Map.Entry<String, String> entry : allItems.entrySet()) {
            String keya = entry.getKey();
            String formKey = entry.getValue();
            if (!formKey.equals(key) && !formKey.startsWith("FormKey=" + key)) continue;
            int fistIndex = keya.indexOf("/");
            String projectKey = keya.substring(0, fistIndex);
            String entryPath = String.valueOf(iMetaFactory.getProjectResolver(projectKey).getPath("")) + "Entry.xml";
            Document document = reader.read(new File(entryPath));
            FileOutputStream fileOutputStream = new FileOutputStream(entryPath);
            XMLWriter writer = new XMLWriter(fileOutputStream, format);
            keya = keya.substring(fistIndex);
            String substring = keya.substring(1);
            int endIndex = substring.lastIndexOf("/");
            Element nodes = (Element)document.getRootElement().selectSingleNode(substring.substring(0, endIndex));
            Element node = (Element)document.getRootElement().selectSingleNode(substring);
            if (Objects.isNull(nodes)) {
                nodes = document.getRootElement();
            }
            if (nodes != null) {
                isRemove.set(nodes.remove(node));
            }
            writer.write(document);
            EntryProcessor.instance.reloadEntry(projectKey);
        }
        return isRemove.get();
    }

    private void processDocumentDirty(List<UICommand> uiCommands, DocumentRecordDirty formDocument, DefaultContext context) throws Throwable {
        if (Objects.isNull(formDocument)) {
            return;
        }
        if (DesignActionUtil.getPreferencesInfo("IsShowData").equals("false")) {
            return;
        }
        if (!this.uiFormKey.equals(this.documentFormKey)) {
            return;
        }
        String formKey = formDocument.getMetaForm().getKey();
        MetaFormDiffProcessor.instance.synchronizedDocumentDataSource(formDocument);
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile metaFormProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(formKey);
        String extend = metaFormProfile.getExtend();
        if (StringUtils.isNotBlank((CharSequence)extend) && !metaFormProfile.getMergeToSource().booleanValue()) {
            return;
        }
        if (metaFormProfile.getForm().getFormType() == 3) {
            return;
        }
        context.setFormKey(formDocument.getMetaForm().getKey());
        context.setDocument((com.bokesoft.yigo.struct.document.Document)formDocument);
        RichDocumentContext parentContext = (RichDocumentContext)context.getParentContext();
        if (Objects.isNull(parentContext)) {
            parentContext = new RichDocumentContext(context);
            parentContext.setDocument((com.bokesoft.yigo.struct.document.Document)formDocument);
            context.setParentContext((DefaultContext)parentContext);
        }
        formDocument.setContext(parentContext);
        try {
            formDocument.setMetaForm(metaFormProfile.getForm());
            JSONObject documentDirty = formDocument.getDirtyJSON(parentContext);
            uiCommands.add(UICommand.processDocumentDirty(formKey, documentDirty));
        }
        catch (Throwable e) {
            LogSvr.getInstance().error("", e);
        }
    }

    private boolean isGeneralConfiguration(String line) {
        return line.equals("<CommonDef>") || line.startsWith("<Setting") || line.equals("<RightsDefinition>") || line.equals("<Enhance>") || line.equals("<DataElementDef>") || line.equals("<DomainDef>") || line.equals("<IOSetting>") || line.startsWith("<Solution");
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new CancelXmlFileCmd();
    }
}

