/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.MetaFormDiffProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AddSelectComponentCmd
extends DesignerServiceCmd {
    public static final String CMD = "AddSelectComponent";
    private String formKey;
    private String enterPanel;
    private String component;
    private String prefix;
    private String suffix;
    private Boolean isCreateLike;
    private Boolean isCreateOK;
    private Boolean isCreateReset;

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> arguments) throws Throwable {
        this.formKey = TypeConvertor.toString((Object)arguments.get((Object)"formKey")).trim();
        this.enterPanel = TypeConvertor.toString((Object)arguments.get((Object)"enterPanel"));
        this.component = TypeConvertor.toString((Object)arguments.get((Object)"component")).trim();
        this.prefix = TypeConvertor.toString((Object)arguments.get((Object)"prefix")).trim();
        if (StringUtils.isEmpty((CharSequence)this.prefix)) {
            this.prefix = "Head_";
        }
        this.suffix = TypeConvertor.toString((Object)arguments.get((Object)"suffix")).trim();
        this.isCreateLike = TypeConvertor.toBoolean((Object)arguments.get((Object)"isCreateLike"));
        this.isCreateOK = TypeConvertor.toBoolean((Object)arguments.get((Object)"isCreateOK"));
        this.isCreateReset = TypeConvertor.toBoolean((Object)arguments.get((Object)"isCreateReset"));
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        TagNode tagNode;
        boolean mergeDiff = false;
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        String pathByFormKey = LoadFileTree.getPathByFormKey(this.formKey);
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(pathByFormKey);
        TagNode ptagNode = xmlTreeWithPath.xmlTree.getTagNode("GridLayoutPanel@" + this.enterPanel);
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile formProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(this.formKey);
        MetaForm form = formProfile.getForm();
        IDLookup idLookup = IDLookup.getIDLookup(form);
        MetaGridLayoutPanel metaGridLayoutPanel = (MetaGridLayoutPanel)form.componentByKey(this.enterPanel);
        MetaColumnDefCollection metaColumnDefCollection = metaGridLayoutPanel.getMetaColumnDefCollection();
        MetaRowDefCollection metaRowDefCollection = metaGridLayoutPanel.getMetaRowDefCollection();
        int maxY = metaRowDefCollection.size() - 1;
        int maxX = metaColumnDefCollection.size() - 1;
        if (StringUtils.isNotEmpty((CharSequence)this.component)) {
            String[] queryConditionsSplit = this.component.split(",");
            int index = 0;
            int i = 1;
            while (i <= queryConditionsSplit.length) {
                MetaDictProperties properties;
                String queryCondition = queryConditionsSplit[i - 1];
                MetaGridCell cell = idLookup.getGridCellByKey(queryCondition);
                String key = cell.getKey();
                String caption = cell.getCaption();
                int controlType = cell.getCellType();
                String tableKey = cell.getTableKey();
                String columnKey = cell.getColumnKey();
                TagNode tagNode2 = new TagNode(ControlType.toString((Integer)controlType), null);
                tagNode2.setAttribute("Key", String.valueOf(this.prefix) + key + this.suffix);
                tagNode2.setAttribute("Caption", caption);
                String columnIndex = String.valueOf((i - 1) % (maxX + 1));
                String rowIndex = String.valueOf(index);
                tagNode2.setAttribute("X", columnIndex);
                tagNode2.setAttribute("Y", rowIndex);
                tagNode2.setAttribute("Visible", "true");
                tagNode2.setAttribute("Enable", "true");
                if (i % (maxX + 1) == 0) {
                    ++index;
                }
                if (index > maxY) {
                    index = maxY;
                }
                if (controlType == 206) {
                    properties = (MetaDictProperties)cell.getProperties();
                    tagNode2.setAttribute("ItemKey", properties.getItemKey());
                } else if (controlType == 204) {
                    TagNode node;
                    List<AbstractNode> items;
                    properties = (MetaComboBoxProperties)cell.getProperties();
                    int sourceType = properties.getSourceType();
                    tagNode2.setAttribute("SourceType", ComboBoxSourceType.format((Integer)sourceType));
                    if (sourceType == 1) {
                        if (properties.getFormulaItems() != null) {
                            TagNode formulaItems = new TagNode("FormulaItems", null);
                            tagNode2.addNode(formulaItems);
                            formulaItems.setCDataValue(properties.getFormulaItems().getContent());
                        }
                    } else if (sourceType == 0 && (items = (node = xmlTreeWithPath.xmlTree.getTagNode("GridCell@" + key)).getChildrenByTagName("Item")).size() > 0) {
                        for (AbstractNode item : items) {
                            node.addNode(item);
                        }
                    }
                }
                ptagNode.addNode(tagNode2, ptagNode.getChildren().size() - 6);
                TagNode condition = new TagNode("Condition", null);
                tagNode2.addNode(condition);
                if (controlType == 254 || controlType == 205 || controlType == 210) {
                    condition.setAttribute("CondSign", "between");
                    condition.setAttribute("Group", queryCondition);
                    condition.setAttribute("GroupHead", "true");
                    TagNode tagNode1 = new TagNode(ControlType.toString((Integer)controlType), null);
                    tagNode1.setAttribute("Visible", "true");
                    tagNode1.setAttribute("Enable", "true");
                    tagNode1.setAttribute("Key", String.valueOf(this.prefix) + key + this.suffix + "_Comp2");
                    tagNode1.setAttribute("Caption", String.valueOf(caption) + "(\u7ed3\u675f)");
                    tagNode1.setAttribute("X", columnIndex);
                    tagNode1.setAttribute("Y", rowIndex);
                    TagNode condition1 = new TagNode("Condition", null);
                    condition1.setAttribute("CondSign", "between");
                    condition1.setAttribute("Group", queryCondition);
                    condition1.setAttribute("GroupTail", "true");
                    tagNode1.addNode(condition1);
                    ptagNode.addNode(tagNode1, ptagNode.getChildren().size() - 6);
                } else if (controlType == 206 || controlType == 202) {
                    condition.setAttribute("CondSign", "in");
                } else if (controlType == 204) {
                    condition.setAttribute("CondSign", "=");
                } else {
                    condition.setAttribute("CondSign", "like");
                }
                condition.setAttribute("TableKey", tableKey);
                condition.setAttribute("ColumnKey", columnKey);
                ++i;
            }
            mergeDiff = true;
        }
        if (this.isCreateOK.booleanValue()) {
            tagNode = new TagNode("Button", null);
            ptagNode.addNode(tagNode, ptagNode.getChildren().size() - 6);
            tagNode.setAttribute("X", String.valueOf(maxX - 2 <= 0 ? 0 : maxX - 2));
            tagNode.setAttribute("Y", String.valueOf(maxY));
            tagNode.setAttribute("Visible", "true");
            tagNode.setAttribute("Enable", "true");
            tagNode.setAttribute("Key", String.valueOf(this.prefix) + "Query" + this.suffix);
            tagNode.setAttribute("Caption", "\u67e5\u8be2");
            TagNode onClick = new TagNode("OnClick", null);
            tagNode.addNode(onClick);
            onClick.setCDataValue("DealCondition();LoadData();ShowData();");
            mergeDiff = true;
        }
        if (this.isCreateReset.booleanValue()) {
            tagNode = new TagNode("Button", null);
            ptagNode.addNode(tagNode, ptagNode.getChildren().size() - 6);
            tagNode.setAttribute("X", String.valueOf(maxX));
            tagNode.setAttribute("Y", String.valueOf(maxY));
            tagNode.setAttribute("Visible", "true");
            tagNode.setAttribute("Enable", "true");
            tagNode.setAttribute("Key", String.valueOf(this.prefix) + "Reset" + this.suffix);
            tagNode.setAttribute("Caption", "\u91cd\u7f6e");
            TagNode onClick = new TagNode("OnClick", null);
            tagNode.addNode(onClick);
            onClick.setCDataValue("ResetCondition();");
            mergeDiff = true;
        }
        if (this.isCreateLike.booleanValue()) {
            tagNode = new TagNode("Embed", null);
            tagNode.setAttribute("X", "0");
            tagNode.setAttribute("Y", String.valueOf(maxY - 1));
            tagNode.setAttribute("Visible", "true");
            tagNode.setAttribute("Enable", "true");
            tagNode.setAttribute("XSpan", String.valueOf(maxY));
            tagNode.setAttribute("Key", String.valueOf(this.prefix) + "FavoriteEmbed" + this.suffix);
            tagNode.setAttribute("Caption", "\u67e5\u8be2\u53d8\u5f0f\u6a21\u677f");
            tagNode.setAttribute("FormKey", "V_Favorite_Impl");
            tagNode.setAttribute("IncludeDataTable", "false");
            tagNode.setAttribute("RootKey", "FavoritePanel");
            ptagNode.addNode(tagNode, ptagNode.getChildren().size() - 6);
            mergeDiff = true;
        }
        if (mergeDiff) {
            Diff diff = new Diff("", this.formKey, true);
            diff.setMetaForm(form);
            XmlDiffProcessor.genXmlDiff(xmlTreeWithPath, ptagNode, diff, true);
            ArrayList<Diff> diffs = new ArrayList<Diff>();
            diffs.add(diff);
            Map<String, String> tmpFiles = XmlFileProcessor.instance.processDiff(diffs, false);
            String xmlError = MetaFormDiffProcessor.instance.processDiffReloadForm(null, tmpFiles);
            result.add(UICommand.reloadFormKey(this.formKey));
            result.add(UICommand.refreshMenuTree(this.enterPanel));
            result.add(UICommand.reloadXmlSource(pathByFormKey));
            result.add(UICommand.locate(this.enterPanel));
            if (!"\u64cd\u4f5c\u6210\u529f".equals(xmlError)) {
                result.add(UICommand.showError(xmlError));
            } else {
                result.add(UICommand.showTip("\u64cd\u4f5c\u6210\u529f"));
            }
        }
        return UICommand.toJson(result);
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new AddSelectComponentCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

