/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.bpm.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.vo.JsonQuestVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class GetDataUtil {
    private static final Logger logger = Logger.getLogger(GetDataUtil.class.getName());
    private boolean isFrist = true;
    public static final GetDataUtil instance = new GetDataUtil();

    public ResponseResult<JSONArray> getAllNodes(JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            Element root = this.getRootElementByFilePath(jsonQuestVo.getFilePath());
            List elements = root.elements();
            if (CollectionUtils.isEmpty((Collection)elements)) {
                result.setCode(1);
                result.setMsg("\u5f53\u524d\u5de5\u4f5c\u6d41\u6587\u4ef6\u4e2d\u6ca1\u6709\u8282\u70b9");
                return result;
            }
            JSONArray nodesJsonArray = new JSONArray();
            for (Element ele : elements) {
                if (ele.attributeValue("Key") == null) continue;
                JSONObject nodeJsonObj = new JSONObject();
                nodeJsonObj.put("name", (Object)ele.attributeValue("Caption"));
                nodeJsonObj.put("value", (Object)ele.attributeValue("Key"));
                nodesJsonArray.add((Object)nodeJsonObj);
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u5f53\u524d\u6587\u4ef6\u7684\u6240\u6709\u8282\u70b9\u5143\u7d20\u6210\u529f");
            result.setData(nodesJsonArray);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u5f53\u524d\u6587\u4ef6\u7684\u6240\u6709\u8282\u70b9\u5143\u7d20\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u5f53\u524d\u6587\u4ef6\u7684\u6240\u6709\u8282\u70b9\u5143\u7d20\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONArray> getInline() {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            MetaBPM metaBPM = MetaFactory.getGlobalInstance().getMetaBPM();
            HashMap profileMap = metaBPM.getProfileMap();
            JSONArray nodesJsonArray = new JSONArray();
            for (Map.Entry ele : profileMap.entrySet()) {
                if (ele.getKey() == null) continue;
                JSONObject nodeJsonObj = new JSONObject();
                nodeJsonObj.put("name", (Object)((ProcessDefinitionProfile)ele.getValue()).getCaption());
                nodeJsonObj.put("value", (Object)((ProcessDefinitionProfile)ele.getValue()).getKey());
                nodesJsonArray.add((Object)nodeJsonObj);
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u6240\u6709\u7684\u6d41\u7a0b\u6807\u8bc6\u6210\u529f");
            result.setData(nodesJsonArray);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u6240\u6709\u7684\u6d41\u7a0b\u6807\u8bc6\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u6240\u6709\u7684\u6d41\u7a0b\u6807\u8bc6\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONArray> getStatusList(JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            MetaStatusCollection statusCollection;
            String filePath = jsonQuestVo.getFilePath();
            String os = System.getProperty("os.name");
            String[] split = os.toLowerCase().startsWith("win") ? filePath.split("\\\\") : filePath.split("/");
            MetaSolution solution = MetaFactory.getGlobalInstance().getSolution();
            MetaProjectCollection projectCollection = solution.getProjectCollection();
            MetaCommonDef basisconfig = Optional.ofNullable((MetaProjectProfile)projectCollection.get(split[split.length - 3])).map(project -> project.getProject().getCommonDef()).orElse(null);
            MetaStatusCollection metaStatusCollection = statusCollection = basisconfig != null ? basisconfig.getStatusCollection() : null;
            if (statusCollection == null || statusCollection.size() == 0) {
                statusCollection = MetaFactory.getGlobalInstance().getCommonDef("").getStatusCollection();
            }
            JSONArray nodesJsonArray = new JSONArray();
            int i = 0;
            while (i < statusCollection.size()) {
                if (((MetaStatus)statusCollection.get(i)).getKey() != null) {
                    JSONObject nodeJsonObj = new JSONObject();
                    nodeJsonObj.put("name", (Object)(String.valueOf(((MetaStatus)statusCollection.get(i)).getKey()) + "," + ((MetaStatus)statusCollection.get(i)).getCaption()));
                    nodeJsonObj.put("value", (Object)((MetaStatus)statusCollection.get(i)).getKey());
                    nodesJsonArray.add((Object)nodeJsonObj);
                }
                ++i;
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u72b6\u6001\u96c6\u5408\u6210\u529f");
            result.setData(nodesJsonArray);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u72b6\u6001\u96c6\u5408\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u72b6\u6001\u96c6\u5408\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONObject> getBpmBindingKeyList(JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONObject> result = new ResponseResult<JSONObject>();
        try {
            MetaDataObjectList dataObjectList;
            JSONObject nodeJsonObj;
            String projectKey = this.getProjectKeyByFilePath(jsonQuestVo.getFilePath());
            JSONArray formJsonArray = new JSONArray();
            JSONArray dataObjectJsonArray = new JSONArray();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            if (metaFormList != null && !metaFormList.isEmpty()) {
                int i = 0;
                while (i < metaFormList.size()) {
                    nodeJsonObj = new JSONObject();
                    MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(i);
                    if (metaFormProfile != null) {
                        String formKey = metaFormProfile.getKey();
                        String formCaption = metaFormProfile.getCaption();
                        if (this.hasMainTable(formKey, 1)) {
                            nodeJsonObj.put("name", (Object)(String.valueOf(formKey) + " " + formCaption));
                            nodeJsonObj.put("value", (Object)formKey);
                            formJsonArray.add((Object)nodeJsonObj);
                        }
                    }
                    ++i;
                }
                formJsonArray.sort(Comparator.comparing(obj -> {
                    String key = ((JSONObject)obj).getString("value");
                    return key;
                }));
            }
            if ((dataObjectList = metaFactory.getDataObjectList()) != null && !dataObjectList.isEmpty()) {
                int i = 0;
                while (i < dataObjectList.size()) {
                    nodeJsonObj = new JSONObject();
                    MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(i);
                    if (metaDataObjectProfile != null && metaDataObjectProfile.getProject() != null && projectKey.equals(metaDataObjectProfile.getProject().getKey())) {
                        String dataObjeectKey = metaDataObjectProfile.getKey();
                        String dataObjeectCaption = metaDataObjectProfile.getCaption();
                        int secondType = metaDataObjectProfile.getSecondaryType();
                        if (this.hasMainTable(dataObjeectKey, 2) && secondType == 2) {
                            nodeJsonObj.put("name", (Object)(String.valueOf(dataObjeectKey) + " " + dataObjeectCaption));
                            nodeJsonObj.put("value", (Object)dataObjeectKey);
                            dataObjectJsonArray.add((Object)nodeJsonObj);
                        }
                    }
                    ++i;
                }
                dataObjectJsonArray.sort(Comparator.comparing(obj -> {
                    String key = ((JSONObject)obj).getString("value");
                    return key;
                }));
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u7ed1\u5b9a\u6807\u8bc6\u5217\u8868\u6210\u529f");
            JSONObject data = new JSONObject();
            data.put("formKeyList", (Object)formJsonArray);
            data.put("dataObjectKeyList", (Object)dataObjectJsonArray);
            result.setData(data);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u6d41\u7a0b\u6807\u8bc6\u5217\u8868\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u6d41\u7a0b\u6807\u8bc6\u5217\u8868\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONArray> getAllFormKeyList() {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            MetaDataObjectList dataObjectList;
            JSONArray formJsonArray = new JSONArray();
            JSONObject nodeJsonObj = new JSONObject();
            nodeJsonObj.put("name", (Object)"\u65e0");
            nodeJsonObj.put("value", (Object)"");
            formJsonArray.add((Object)nodeJsonObj);
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            if (metaFormList != null && !metaFormList.isEmpty()) {
                int i = 0;
                while (i < metaFormList.size()) {
                    nodeJsonObj = new JSONObject();
                    MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(i);
                    if (metaFormProfile != null) {
                        String formKey = metaFormProfile.getKey();
                        String formCaption = metaFormProfile.getCaption();
                        nodeJsonObj.put("name", (Object)(String.valueOf(formKey) + " " + formCaption));
                        nodeJsonObj.put("value", (Object)formKey);
                        formJsonArray.add((Object)nodeJsonObj);
                    }
                    ++i;
                }
            }
            if ((dataObjectList = metaFactory.getDataObjectList()) != null && !dataObjectList.isEmpty()) {
                int i = 0;
                while (i < dataObjectList.size()) {
                    nodeJsonObj = new JSONObject();
                    MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(i);
                    if (metaDataObjectProfile != null) {
                        String formKey = metaDataObjectProfile.getKey();
                        String formCaption = metaDataObjectProfile.getCaption();
                        nodeJsonObj.put("name", (Object)(String.valueOf(formKey) + " " + formCaption));
                        nodeJsonObj.put("value", (Object)formKey);
                        formJsonArray.add((Object)nodeJsonObj);
                    }
                    ++i;
                }
            }
            JSONArray newJsonArray = new JSONArray();
            if (!CollectionUtils.isEmpty((Collection)formJsonArray)) {
                Set<Object> sets = formJsonArray.stream().collect(Collectors.toSet());
                sets.forEach(q -> {
                    boolean bl = newJsonArray.add(q);
                });
                newJsonArray.sort(Comparator.comparing(obj -> {
                    String key = ((JSONObject)obj).getString("value");
                    return key;
                }));
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u6d41\u6240\u6709\u8868\u5355\u5217\u8868\u6210\u529f");
            result.setData(newJsonArray);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u6d41\u6240\u6709\u8868\u5355\u5217\u8868\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u6d41\u6240\u6709\u8868\u5355\u5217\u8868\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONArray> getProcessKeyList(JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            Element root = this.getRootElementByFilePath(jsonQuestVo.getFilePath(), true);
            List elements = root.elements();
            if (CollectionUtils.isEmpty((Collection)elements) || root.element("DeployInfoCollection") == null || root.element("DeployInfoCollection").elements("DeployInfo") == null) {
                result.setCode(1);
                result.setMsg("\u5f53\u524d\u6587\u4ef6\u4e2d\u6ca1\u6709\u53d1\u5e03\u7684\u6d41\u7a0b");
                return result;
            }
            List deployInfoList = root.element("DeployInfoCollection").elements("DeployInfo");
            JSONArray nodesJsonArray = new JSONArray();
            for (Element ele : deployInfoList) {
                if (ele.attributeValue("Key") == null) continue;
                JSONObject nodeJsonObj = new JSONObject();
                nodeJsonObj.put("name", (Object)ele.attributeValue("Key"));
                nodeJsonObj.put("value", (Object)ele.attributeValue("Key"));
                nodesJsonArray.add((Object)nodeJsonObj);
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u6d41\u7a0b\u6807\u8bc6\u5217\u8868\u6210\u529f");
            result.setData(nodesJsonArray);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u6d41\u7a0b\u6807\u8bc6\u5217\u8868\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u6d41\u7a0b\u6807\u8bc6\u5217\u8868\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONObject> getPermListByKey(String key) {
        ResponseResult<JSONObject> result = new ResponseResult<JSONObject>();
        JSONObject data = new JSONObject();
        try {
            MetaFormProfile metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(key);
            if (metaFormProfile == null) {
                result.setCode(1);
                result.setMsg("\u8be5key" + key + "\u5bf9\u5e94\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
                return result;
            }
            this.setOperPermDataSource(data, metaFormProfile);
            this.setCompAndGridPermDataSource(data, metaFormProfile);
            result.setCode(0);
            result.setMsg("\u83b7\u53d6Key\u83b7\u53d6\u6743\u9650\u5217\u8868\u6210\u529f");
            result.setData(data);
        }
        catch (Throwable e) {
            logger.warning("\u6839\u636eKey\u83b7\u53d6\u6743\u9650\u5217\u8868\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u6839\u636eKey\u83b7\u53d6\u6743\u9650\u5217\u8868\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public boolean hasMainTable(String mapKey, int mapType) throws Throwable {
        String primaryTableKey;
        boolean hasMainTable = false;
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObject metaDataObject = null;
        if (mapType == 1) {
            MetaDataSource dataSource;
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(mapKey);
            MetaForm form = metaFormProfile.getForm();
            if (form.getFormType() != 2 && (dataSource = Optional.ofNullable(form).map(MetaForm::getDataSource).orElse(Optional.ofNullable(metaFactory.getMetaForm(mapKey)).map(MetaForm::getDataSource).orElse(null))) != null) {
                String refObjectKey = dataSource.getRefObjectKey();
                metaDataObject = StringUtils.isNotEmpty((CharSequence)refObjectKey) ? ((MetaDataObjectProfile)dataObjectList.get(refObjectKey)).getDataObject() : dataSource.getDataObject();
            }
        } else if (mapType == 2) {
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            metaDataObject = ((MetaDataObjectProfile)dataObjectList.get(mapKey)).getDataObject();
        }
        String string = primaryTableKey = metaDataObject != null ? metaDataObject.getMainTableKey() : null;
        if (StringUtils.isNotEmpty((CharSequence)primaryTableKey)) {
            hasMainTable = true;
        }
        return hasMainTable;
    }

    private void setOperPermDataSource(JSONObject data, MetaFormProfile metaFormProfile) {
        MetaOperationCollection operationCollection = metaFormProfile.getForm().getOperationCollection();
        if (operationCollection != null && operationCollection.size() > 0) {
            JSONObject iteam = null;
            JSONArray operPermArray = new JSONArray();
            for (KeyPairCompositeObject next : operationCollection) {
                if (next == null || !StringUtils.isNotEmpty((CharSequence)next.getKey())) continue;
                iteam = new JSONObject();
                iteam.put("Key", (Object)next.getKey());
                if (next instanceof MetaOperationCollection) {
                    iteam.put("Caption", (Object)((MetaOperationCollection)next).getCaption());
                } else if (next instanceof MetaOperation) {
                    iteam.put("Caption", (Object)((MetaOperation)next).getCaption());
                }
                iteam.put("OptSelect", (Object)false);
                operPermArray.add((Object)iteam);
            }
            if (!CollectionUtils.isEmpty((Collection)operPermArray)) {
                operPermArray.sort((o1, o2) -> ((JSONObject)o1).getString("Key").compareToIgnoreCase(((JSONObject)o2).getString("Key")));
            }
            data.put("operPermArray", (Object)operPermArray);
        }
    }

    private void setCompAndGridPermDataSource(JSONObject data, MetaFormProfile metaFormProfile) {
        List allComponents = metaFormProfile.getForm().getAllComponents();
        if (!CollectionUtils.isEmpty((Collection)allComponents)) {
            JSONObject iteam = null;
            JSONArray compPermArray = new JSONArray();
            JSONArray gridPermArray = new JSONArray();
            for (MetaComponent comp : allComponents) {
                iteam = new JSONObject();
                if (StringUtils.isNotEmpty((CharSequence)comp.getKey())) {
                    iteam.put("Key", (Object)comp.getKey());
                    iteam.put("Caption", (Object)comp.getCaption());
                    iteam.put("VisibleSelect", (Object)true);
                    iteam.put("EnableSelect", (Object)false);
                    compPermArray.add((Object)iteam);
                }
                if (!(comp instanceof MetaGrid)) continue;
                JSONObject iteamGrid = null;
                iteamGrid = new JSONObject();
                iteamGrid.put("GridName", (Object)comp.getKey());
                MetaGridColumnCollection columnCollection = ((MetaGrid)comp).getColumnCollection();
                JSONObject columnItem = null;
                JSONArray columnArray = new JSONArray();
                for (MetaGridColumn column : columnCollection) {
                    columnItem = new JSONObject();
                    columnItem.put("Key", (Object)column.getKey());
                    columnItem.put("Caption", (Object)column.getCaption());
                    columnItem.put("EnableSelect", (Object)false);
                    columnArray.add((Object)columnItem);
                }
                iteamGrid.put("GridDataArray", (Object)columnArray);
                gridPermArray.add((Object)iteamGrid);
            }
            if (!CollectionUtils.isEmpty((Collection)compPermArray)) {
                compPermArray.sort((o1, o2) -> ((JSONObject)o1).getString("Key").compareToIgnoreCase(((JSONObject)o2).getString("Key")));
            }
            if (!CollectionUtils.isEmpty((Collection)gridPermArray)) {
                gridPermArray.sort((o1, o2) -> ((JSONObject)o1).getString("GridName").compareToIgnoreCase(((JSONObject)o2).getString("GridName")));
            }
            data.put("compPermArray", (Object)compPermArray);
            data.put("gridPermArray", (Object)gridPermArray);
        }
    }

    private String getProjectKeyByFilePath(String filePath) {
        String parentPath = new File(filePath).getParent();
        return parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
    }

    private Element getRootElementByFilePath(String filePath) throws Throwable {
        String tempPath = XmlFileProcessor.instance.getTmpFile(filePath);
        if (StringUtils.isBlank((CharSequence)tempPath)) {
            tempPath = filePath;
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(tempPath));
        return document.getRootElement();
    }

    private Element getRootElementByFilePath(String filePath, boolean is) throws Throwable {
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(filePath));
        return document.getRootElement();
    }

    public ResponseResult<JSONArray> SaveBPMXML(String filePaths) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            String newContent = FileUtils.readFileToString((File)new File(filePaths), (String)"UTF-8");
            XmlFileProcessor.instance.clearTmpFile(filePaths);
            result.setCode(0);
            result.setMsg("\u4fdd\u5b58\u5de5\u4f5c\u6d41\u6210\u529f");
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            String key = LoadFileTree.getKeyByFilePath(filePaths);
            String newSecondLine = DesignIOMetaUtil.getSecondLine(newContent);
            String version = newSecondLine.contains("Version") ? DesignIOMetaUtil.getSubString(newSecondLine, "Version=\"([A-Za-z0-9]\\w*)\"") : "1";
            globalInstance.updateProcessDefination(key, Integer.parseInt(version));
            globalInstance.updateProcessDefinationByDeployKey(key);
        }
        catch (Throwable e) {
            logger.warning("\u4fdd\u5b58\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u4fdd\u5b58\u51fa\u73b0\u5f02\u5e38\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }
}

