/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.bpm.po;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.enums.NodeKeyAndCaptionEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class Swimline {
    private static final Logger logger = Logger.getLogger(Swimline.class.getName());
    private String NodeType;
    private String ID;
    private String Key;
    private String Caption;
    private String Direction;
    private String Position;
    private String Size;

    public Element save(JSONObject operNodeJson, Element root, String nodeType, String nodeId) throws Throwable {
        Element node = null;
        try {
            List swimlineList;
            String key = operNodeJson.getJSONObject("props").getJSONObject("Key").getString("value");
            String string = key = StringUtils.isEmpty((CharSequence)key) ? nodeId : key;
            if (root.element("SwimlineCollection") == null) {
                root.addElement("SwimlineCollection");
            }
            if (!CollectionUtils.isEmpty((Collection)(swimlineList = root.element("SwimlineCollection").elements("Swimline")))) {
                for (Element ele : swimlineList) {
                    if (!key.equals(ele.attributeValue("Key"))) continue;
                    root.element("SwimlineCollection").remove(ele);
                }
            }
            Element swimlineCollectionNode = root.element("SwimlineCollection");
            node = this.saveCommonAttributesToXml(operNodeJson, swimlineCollectionNode, nodeType, nodeId);
            JSONObject propsJsonObj = operNodeJson.getJSONObject("props");
            Set keys = propsJsonObj.keySet();
            String v = "";
            ArrayList<String> list = new ArrayList<String>();
            block15: for (String k : keys) {
                v = propsJsonObj.getJSONObject(k).getString("value");
                if ("null".equals(v)) {
                    v = "";
                }
                if ("X".equals(k) || "Y".equals(k)) {
                    list.add(v);
                }
                if ("Width".equals(k) || "Height".equals(k)) {
                    if (list.size() == 2) {
                        list.clear();
                    }
                    list.add(v);
                }
                switch (k) {
                    case "Direction": {
                        this.saveAttributeToXml(node, propsJsonObj, k);
                        break;
                    }
                    case "X": 
                    case "Y": {
                        if (list == null || list.size() != 2) continue block15;
                        node.addAttribute("Position", "X:" + (String)list.get(0) + "," + "Y:" + (String)list.get(1));
                        break;
                    }
                    case "Height": 
                    case "Width": {
                        if (list == null || list.size() != 2) continue block15;
                        node.addAttribute("Size", "Width:" + (String)list.get(1) + "," + "Height:" + (String)list.get(0));
                        break;
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)node.attributeValue("Direction"))) {
                this.setDirection(node.attributeValue("Direction"));
            } else {
                this.setDirection("Vertical");
            }
        }
        catch (Throwable e) {
            logger.warning("\u4fdd\u5b58\u516c\u5171\u5c5e\u6027\u5230xml\u6587\u4ef6\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return node;
    }

    public void saveSelfAttributesToXml(JSONObject operNodeJson, Element node) throws Throwable {
    }

    public JSONObject setFrontDefaultValues() {
        HashMap<String, String> otherAttributesMap = new HashMap<String, String>(1);
        otherAttributesMap.put("Direction", this.getDirection());
        return this.getFrontDefaultValuesJson(otherAttributesMap);
    }

    public Element saveCommonAttributesToXml(JSONObject operNodeJson, Element root, String nodeType, String nodeId) {
        String id = nodeId.replaceAll("rect", "").replaceAll("path", "");
        String key = operNodeJson.getJSONObject("props").getJSONObject("Key").getString("value");
        key = StringUtils.isEmpty((CharSequence)key) ? nodeId : key;
        String caption = operNodeJson.getJSONObject("props").getJSONObject("Caption").getString("value");
        if (StringUtils.isEmpty((CharSequence)caption)) {
            caption = NodeKeyAndCaptionEnum.valueOf(nodeType).getCaption();
        }
        Element node = null;
        List elements = root.elements(nodeType);
        if (!CollectionUtils.isEmpty((Collection)elements)) {
            for (Element ele : elements) {
                if (!key.equals(ele.attributeValue("Key"))) continue;
                node = ele;
                break;
            }
        }
        if (node == null) {
            node = root.addElement(nodeType);
        }
        node.addAttribute("ID", id).addAttribute("Caption", caption).addAttribute("Key", key);
        this.setNodeType(nodeType);
        this.setID(id);
        this.setCaption(caption);
        this.setKey(key);
        return node;
    }

    public JSONObject getFrontDefaultValuesJson(Map<String, String> otherAttributesMap) {
        JSONObject nodeJson = new JSONObject();
        this.setFrontDefaultValue(this, otherAttributesMap, nodeJson);
        return nodeJson;
    }

    private void setFrontDefaultValue(Swimline node, Map<String, String> otherAttributesMap, JSONObject nodeJson) {
        int length = 4;
        if (otherAttributesMap != null && otherAttributesMap.size() > 0) {
            length += otherAttributesMap.size();
        }
        Map<String, String> commonAttributesMap = this.setCommonAttributesToJson(node, length);
        if (otherAttributesMap != null && otherAttributesMap.size() > 0) {
            commonAttributesMap.putAll(otherAttributesMap);
        }
        this.setProps(commonAttributesMap, nodeJson);
    }

    public void saveAttributeToXml(Element node, JSONObject propsJsonObj, String attribute) {
        String v = propsJsonObj.getJSONObject(attribute).getString("value");
        if (StringUtils.isNotEmpty((CharSequence)v)) {
            if (node.attribute(attribute) != null) {
                node.remove(node.attribute(attribute));
            }
            node.addAttribute(attribute, v);
        } else {
            this.deleteXmlElementAttribute(node, node.attribute(attribute));
        }
    }

    private Map<String, String> setCommonAttributesToJson(Swimline node, int length) {
        HashMap<String, String> commonAttributesMap = new HashMap<String, String>(length);
        commonAttributesMap.put("NodeType", node.getNodeType());
        commonAttributesMap.put("ID", node.getID());
        commonAttributesMap.put("Key", node.getKey());
        commonAttributesMap.put("Caption", node.getCaption());
        return commonAttributesMap;
    }

    private void setProps(Map<String, String> commonAttributesMap, JSONObject nodeJson) {
        String key = "";
        JSONObject v = null;
        for (Map.Entry<String, String> map : commonAttributesMap.entrySet()) {
            key = map.getKey();
            v = new JSONObject();
            v.put("value", (Object)map.getValue());
            nodeJson.put(key, (Object)v);
        }
    }

    public boolean deleteXmlElementAttribute(Element element, Attribute attribute) {
        if (attribute != null) {
            return element.remove(attribute);
        }
        return false;
    }

    public String getNodeType() {
        return this.NodeType;
    }

    public void setNodeType(String nodeType) {
        this.NodeType = nodeType;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getKey() {
        return this.Key;
    }

    public void setKey(String key) {
        this.Key = key;
    }

    public String getCaption() {
        return this.Caption;
    }

    public void setCaption(String caption) {
        this.Caption = caption;
    }

    public String getDirection() {
        return this.Direction;
    }

    public void setDirection(String direction) {
        this.Direction = direction;
    }

    public String getPosition() {
        return this.Position;
    }

    public void setPosition(String position) {
        this.Position = position;
    }

    public String getSize() {
        return this.Size;
    }

    public void setSize(String size) {
        this.Size = size;
    }
}

