/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.bpm.po;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.enums.NodeKeyAndCaptionEnum;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.FilePathHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class Path {
    private static final Logger logger = Logger.getLogger(Path.class.getName());
    private String NodeType;
    private String ID;
    private String Key;
    private String Caption;
    private String TargetNodeKey;
    private String State = "";
    private String Condition = "";

    public JSONObject save(String filePath, JSONObject frontFullJson, String nodeId, JSONObject operNodeJson) throws Throwable {
        JSONObject resultJson = new JSONObject();
        FileOutputStream fileOutputStream = null;
        XMLWriter writer = null;
        try {
            try {
                String tempPath = XmlFileProcessor.instance.getTmpFile(filePath);
                if (StringUtils.isBlank((CharSequence)tempPath)) {
                    tempPath = filePath;
                }
                SAXReader reader = new SAXReader();
                Document document = reader.read(new File(tempPath));
                Element root = document.getRootElement();
                String fromNodeKey = operNodeJson.getString("from");
                String from = frontFullJson.getJSONObject("states").getJSONObject(fromNodeKey).getJSONObject("props").getJSONObject("Key").getString("value");
                String toNodeKey = operNodeJson.getString("to");
                String to = frontFullJson.getJSONObject("states").getJSONObject(toNodeKey).getJSONObject("props").getJSONObject("Key").getString("value");
                String tagName = operNodeJson.getJSONObject("props").getJSONObject("NodeType").getString("value");
                String id = operNodeJson.getJSONObject("props").getJSONObject("ID").getString("value");
                id = StringUtils.isNotEmpty((CharSequence)id) ? id : nodeId;
                id = id.replace("path", "");
                String key = operNodeJson.getJSONObject("props").getJSONObject("Key").getString("value");
                key = StringUtils.isEmpty((CharSequence)key) ? nodeId : key;
                Path path = this.saveAttributesIntoXml(nodeId, operNodeJson, root, from, to, tagName, key);
                OutputFormat format = this.getOutputFormat();
                String solutionPath = String.valueOf(FilePathHelper.getWorkspacePath()) + File.separator;
                String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", String.valueOf(filePath.substring(solutionPath.length()).replace(File.separator, "__")) + "." + System.currentTimeMillis()).toString();
                fileOutputStream = new FileOutputStream(newFilePath);
                writer = new XMLWriter(fileOutputStream, format);
                XmlFileProcessor.stackput(filePath, newFilePath);
                writer.write(document);
                Map<String, String> commonAttributesMap = this.setCommonAttributesToJson(tagName, id, key, path.getCaption(), to);
                if (NodeKeyAndCaptionEnum.SequenceFlow.getKey().equals(tagName)) {
                    commonAttributesMap.put("State", path.getState());
                    if (this.isAuditOrMultiAudit(root, from)) {
                        commonAttributesMap.put("Condition", path.getCondition());
                    }
                }
                this.setProps(commonAttributesMap, resultJson);
            }
            catch (Throwable e) {
                logger.warning("\u4fdd\u5b58\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
        catch (Throwable throwable) {
            this.closeFileStream(fileOutputStream, writer);
            throw throwable;
        }
        this.closeFileStream(fileOutputStream, writer);
        return resultJson;
    }

    private boolean isAuditOrMultiAudit(Element root, String fromKey) {
        List elements = root.elements();
        for (Element element : elements) {
            boolean isAuditOrMultiAudit;
            boolean bl = isAuditOrMultiAudit = fromKey.equals(element.attributeValue("Key")) && (NodeKeyAndCaptionEnum.Audit.getKey().equals(element.getName()) || NodeKeyAndCaptionEnum.MultiAudit.getKey().equals(element.getName()) || NodeKeyAndCaptionEnum.Decision.getKey().equals(element.getName()) || NodeKeyAndCaptionEnum.Countersign.getKey().equals(element.getName()));
            if (!isAuditOrMultiAudit) continue;
            return true;
        }
        return false;
    }

    private Path saveAttributesIntoXml(String nodeId, JSONObject operNodeJson, Element root, String from, String to, String tagName, String key) {
        Path path = new Path();
        List elements = root.elements();
        for (Element element : elements) {
            Element node;
            if (!from.equals(element.attributeValue("Key"))) continue;
            Element transitionCollectionEle = element.element("TransitionCollection");
            if (transitionCollectionEle != null) {
                List sequenceFlowEleList = transitionCollectionEle.elements(tagName);
                if (sequenceFlowEleList != null && !sequenceFlowEleList.isEmpty()) {
                    for (Element e : sequenceFlowEleList) {
                        if (!key.equals(e.attributeValue("Key"))) continue;
                        transitionCollectionEle.remove(e);
                    }
                }
            } else {
                transitionCollectionEle = element.addElement("TransitionCollection");
            }
            if ((node = this.setCommonAttributes(operNodeJson, transitionCollectionEle, tagName, nodeId, to)) != null) {
                path.setCaption(node.attributeValue("Caption"));
            }
            if (!NodeKeyAndCaptionEnum.SequenceFlow.getKey().equals(tagName)) {
                return path;
            }
            JSONObject propsJsonObj = operNodeJson.getJSONObject("props");
            Set keys = propsJsonObj.keySet();
            String v = "";
            for (String k : keys) {
                v = propsJsonObj.getJSONObject(k).getString("value");
                if ("null".equals(v)) {
                    v = "";
                }
                switch (k) {
                    case "State": {
                        if (!"true".equalsIgnoreCase(v) && StringUtils.isNotEmpty((CharSequence)v)) {
                            this.saveAttributeToXml(node, propsJsonObj, k);
                            path.setState(v);
                            break;
                        }
                        this.deleteXmlElementAttribute(node, node.attribute(k));
                        break;
                    }
                    case "Condition": {
                        if (!this.isAuditOrMultiAudit(root, from)) break;
                        if (!"true".equalsIgnoreCase(v) && StringUtils.isNotEmpty((CharSequence)v)) {
                            node.addAttribute(k, v);
                            path.setCondition(v);
                            break;
                        }
                        this.deleteXmlElementAttribute(node, node.attribute(k));
                        break;
                    }
                }
            }
        }
        return path;
    }

    private Element setCommonAttributes(JSONObject operNodeJson, Element element, String tagName, String nodeId, String targetNodeKey) {
        String id = nodeId.replace("rect", "").replace("path", "");
        String key = operNodeJson.getJSONObject("props").getJSONObject("Key").getString("value");
        key = StringUtils.isEmpty((CharSequence)key) ? nodeId : key;
        String caption = operNodeJson.getJSONObject("props").getJSONObject("Caption").getString("value");
        if (StringUtils.isEmpty((CharSequence)caption)) {
            caption = NodeKeyAndCaptionEnum.valueOf(tagName).getCaption();
        }
        Element node = null;
        List elements = element.elements(tagName);
        if (!CollectionUtils.isEmpty((Collection)elements)) {
            for (Element ele : elements) {
                if (!key.equals(ele.attributeValue("Key"))) continue;
                node = ele;
                break;
            }
        }
        if (node == null) {
            node = element.addElement(tagName);
        }
        return node.addAttribute("ID", id).addAttribute("Key", key).addAttribute("Caption", caption).addAttribute("TargetNodeKey", targetNodeKey);
    }

    private void saveAttributeToXml(Element node, JSONObject propsJsonObj, String attribute) {
        String v = propsJsonObj.getJSONObject(attribute).getString("value");
        if (StringUtils.isNotEmpty((CharSequence)v)) {
            node.addAttribute(attribute, v);
        } else {
            this.deleteXmlElementAttribute(node, node.attribute(attribute));
        }
    }

    private Map<String, String> setCommonAttributesToJson(String tagName, String id, String key, String caption, String targetNodeKey) {
        HashMap<String, String> commonAttributesMap = new HashMap<String, String>(7);
        commonAttributesMap.put("NodeType", tagName);
        commonAttributesMap.put("ID", id);
        commonAttributesMap.put("Key", key);
        commonAttributesMap.put("Caption", caption);
        commonAttributesMap.put("TargetNodeKey", targetNodeKey);
        return commonAttributesMap;
    }

    private void deleteXmlElementAttribute(Element element, Attribute attribute) {
        if (attribute != null) {
            element.remove(attribute);
        }
    }

    private void setProps(Map<String, String> commonAttributesMap, JSONObject nodeJson) {
        for (Map.Entry<String, String> map : commonAttributesMap.entrySet()) {
            String key = map.getKey();
            JSONObject v = new JSONObject();
            v.put("value", (Object)map.getValue());
            nodeJson.put(key, (Object)v);
        }
    }

    private OutputFormat getOutputFormat() {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(4);
        format.setExpandEmptyElements(false);
        format.setPadText(false);
        return format;
    }

    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            logger.warning("\u5173\u95edwriter\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public String getNodeType() {
        return this.NodeType;
    }

    public void setNodeType(String nodeType) {
        this.NodeType = nodeType;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getKey() {
        return this.Key;
    }

    public void setKey(String key) {
        this.Key = key;
    }

    public String getCaption() {
        return this.Caption;
    }

    public void setCaption(String caption) {
        this.Caption = caption;
    }

    public String getTargetNodeKey() {
        return this.TargetNodeKey;
    }

    public void setTargetNodeKey(String targetNodeKey) {
        this.TargetNodeKey = targetNodeKey;
    }

    public String getState() {
        return this.State;
    }

    public void setState(String state) {
        this.State = state;
    }

    public String getCondition() {
        return this.Condition;
    }

    public void setCondition(String condition) {
        this.Condition = condition;
    }
}

