/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.designerxmlattr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class GenerateXmlAttrsJsonFile {
    public static void main(String[] args) {
        GenerateXmlAttrsJsonFile.readXmlAttrs();
    }

    public static void readXmlAttrs() {
        try {
            Map<String, String> fieldDesc = GenerateXmlAttrsJsonFile.getFieldDesc();
            Map map = Collections.synchronizedMap(new HashMap());
            Reflections reflections = new Reflections("com.bokesoft", new Scanner[0]);
            Set classes = reflections.getSubTypesOf(AbstractMetaObject.class);
            classes.parallelStream().forEach(item -> GenerateXmlAttrsJsonFile.generateXmlAttrsMap(item, map, fieldDesc));
            String FunctionsJson = JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat});
            GenerateXmlAttrsJsonFile.writeToFile(FunctionsJson);
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }

    private static void writeToFile(String functionsJson) {
        File file = FileUtils.getFile((String[])new String[]{WebDesignerConfiguration.getxmlAttrJsonFilePath()});
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream outputStream = FileUtils.openOutputStream((File)file);){
                outputStream.write(functionsJson.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
    }

    private static void generateXmlAttrsMap(Class<? extends AbstractMetaObject> clazz, Map<String, JSONObject> fieldMap, Map<String, String> fieldDesc) {
        try {
            String tagName;
            clazz.getMethod("getTagName", new Class[0]);
            String string = tagName = StringUtils.isNotEmpty((CharSequence)clazz.getSimpleName()) ? clazz.getSimpleName().substring(4) : "";
            if (StringUtils.isNotEmpty((CharSequence)tagName)) {
                GenerateXmlAttrsJsonFile.readAttrsFromMeta(clazz, tagName, fieldMap, fieldDesc);
                while (clazz.getSuperclass() != null && clazz.getSuperclass() != AbstractMetaObject.class) {
                    clazz = clazz.getSuperclass();
                    GenerateXmlAttrsJsonFile.readAttrsFromMeta(clazz, tagName, fieldMap, fieldDesc);
                }
            }
        }
        catch (FileNotFoundException | NoSuchMethodException e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
    }

    private static void readAttrsFromMeta(Class<? extends AbstractMetaObject> clazz, String tagName, Map<String, JSONObject> fieldMap, Map<String, String> fieldDesc) throws FileNotFoundException {
        Field[] fields;
        JSONObject jsonObject = new JSONObject();
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                PropertyDescriptor pd;
                Field field = fieldArray[n2];
                field.setAccessible(true);
                try {
                    pd = new PropertyDescriptor(field.getName(), clazz);
                }
                catch (IntrospectionException e) {
                    break block14;
                }
                if (pd != null && (field.getType() == Integer.class || field.getType() == String.class || field.getType() == Boolean.class || field.getType() == Byte.class || field.getType() == Short.class || field.getType() == Long.class || field.getType() == Float.class || field.getType() == Double.class || field.getType() == DefSize.class)) {
                    String attrName = String.valueOf(field.getName().substring(0, 1).toUpperCase()) + field.getName().substring(1);
                    String fieldDtl = fieldDesc.get(attrName.toUpperCase());
                    if (StringUtils.isNotEmpty((CharSequence)fieldDtl)) {
                        jsonObject.put(attrName, (Object)fieldDtl);
                    }
                } else if (field.getType().toString().endsWith("Properties")) {
                    Field[] fieldArray2 = field.getType().getDeclaredFields();
                    int n3 = fieldArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block15: {
                            String attrName;
                            String fieldDtl;
                            Field childField = fieldArray2[n4];
                            childField.setAccessible(true);
                            try {
                                pd = new PropertyDescriptor(childField.getName(), field.getType());
                            }
                            catch (IntrospectionException e) {
                                break block15;
                            }
                            if (pd != null && (childField.getType() == Integer.class || childField.getType() == String.class || childField.getType() == Boolean.class || field.getType() == Byte.class || field.getType() == Short.class || field.getType() == Long.class || field.getType() == Float.class || field.getType() == Double.class) && StringUtils.isNotEmpty((CharSequence)(fieldDtl = fieldDesc.get((attrName = String.valueOf(childField.getName().substring(0, 1).toUpperCase()) + childField.getName().substring(1)).toUpperCase())))) {
                                jsonObject.put(attrName, (Object)fieldDtl);
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        if (jsonObject.length() > 0) {
            if (fieldMap.get(tagName) != null) {
                for (String key : fieldMap.get(tagName).keySet()) {
                    jsonObject.put(key, fieldMap.get(tagName).get(key));
                }
            }
            fieldMap.put(tagName, jsonObject);
        }
    }

    private static Map<String, String> getFieldDesc() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        try {
            File[] allFiles;
            String rootPath = "\u4f5c\u4e3a\u5de5\u5177\u81ea\u884c\u586b\u5199\u8def\u5f84";
            String propertyLoadFilePath = FilePathHelper.toFrontFilePath(String.valueOf(rootPath) + "/solutions/sln-erpdesigner-solution/webconfig/Form/IOMetaObject/PropertyLoadPanel");
            String propertySettingFilePath = FilePathHelper.toFrontFilePath(String.valueOf(rootPath) + "/solutions/sln-erpdesigner-solution/webconfig/Form/IOMetaObject/PropertySettingPanel");
            File propertyLoadFile = new File(propertyLoadFilePath);
            File propertySettingFile = new File(propertySettingFilePath);
            File[] fileArray = allFiles = (File[])ArrayUtils.addAll((Object[])propertyLoadFile.listFiles(), (Object[])propertySettingFile.listFiles());
            int n = allFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String xml = FileUtil.File2String((String)file.getAbsolutePath());
                if (xml != null) {
                    XmlTree xmlTree = XmlParser.parse(xml, false, false);
                    TagNode bodyNode = xmlTree.getRoot().findFirstTagNodeByTagName("Block");
                    GenerateXmlAttrsJsonFile.readDesignXml(bodyNode.getChildren(), attrMap);
                }
                ++n2;
            }
            return attrMap;
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
            return attrMap;
        }
    }

    private static Map<String, String> readDesignXml(List<AbstractNode> attrNodes, Map<String, String> attrMap) {
        for (AbstractNode node : attrNodes) {
            if (!(node instanceof TagNode)) continue;
            TagNode attrNode = (TagNode)node;
            if (StringUtils.endsWith((CharSequence)attrNode.getTagName(), (CharSequence)"Panel") || StringUtils.equals((CharSequence)attrNode.getTagName(), (CharSequence)"Grid") || StringUtils.equals((CharSequence)attrNode.getTagName(), (CharSequence)"GridColumnCollection")) {
                GenerateXmlAttrsJsonFile.readDesignXml(attrNode.getChildren(), attrMap);
                continue;
            }
            String key = attrNode.getAttributes().get("Key");
            String caption = attrNode.getAttributes().get("Caption");
            if (key == null || caption == null) continue;
            String string = key = key.lastIndexOf("_") != -1 ? key.substring(key.lastIndexOf("_") + 1).toUpperCase() : key.toUpperCase();
            if (StringUtils.isNotBlank((CharSequence)attrMap.get(key)) && !ArrayUtils.contains((Object[])attrMap.get(key).split("/"), (Object)caption)) {
                attrMap.put(key, String.valueOf(attrMap.get(key)) + "/" + caption);
                continue;
            }
            attrMap.put(key, caption);
        }
        return attrMap;
    }
}

