/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.all.initiator;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.desigerfunction.datasource.GenerateFunctionsJsonFile;
import com.bokesoft.erp.webdesigner.language.LanguageInitiator;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.DesignerDebuggerImpl;
import com.bokesoft.yes.base.IStartListener;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.design.cmd.ExpAutoCompleteCmd;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDataElementDefLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDomainDefLoad;
import com.bokesoft.yes.parser.ExprDebuggerProxy;
import com.bokesoft.yes.parser.IExprDebugger;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.domain.MetaDomainCollection;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;

public class InitializingDesigner
implements IStartListener {
    private static List<String> FormulaKeys;
    private static boolean enable;
    private static int initCacheID;

    static {
        enable = false;
        initCacheID = 0;
    }

    public static int isInitCacheID() {
        return initCacheID;
    }

    public static void setInitCache(int initCacheID) {
        InitializingDesigner.initCacheID = initCacheID;
    }

    public static boolean isEnable() {
        return enable;
    }

    public static void setEnable(boolean enable) {
        InitializingDesigner.enable = enable;
    }

    public void invoke(DefaultContext defaultContext) throws Throwable {
        Random random = new Random();
        initCacheID = random.nextInt();
        InitializingDesigner.getFormulaKeys();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(6, 10, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
        String solutionspath = String.valueOf(WebDesignerConfiguration.getDesignerDataPath()) + File.separator + "solutions";
        executorService.execute(() -> {
            InputStream domain = this.getClass().getResourceAsStream("/Designer_Domain.xml");
            MetaDomainDefLoad domainLoad = new MetaDomainDefLoad(1);
            InputStream dataElement = this.getClass().getResourceAsStream("/Designer_DataElement.xml");
            MetaDataElementDefLoad dataElementLoad = new MetaDataElementDefLoad(1);
            try {
                domainLoad.load(domain);
                MetaDomainDef metaDomainDef = (MetaDomainDef)domainLoad.getRootMetaObject();
                for (MetaDomain metaDomain : metaDomainDef.getDomainCollection()) {
                    MetaDomain domain1 = MetaUtil.getDomain((IMetaFactory)MetaFactory.getGlobalInstance(), (String)metaDomain.getKey());
                    if (domain1 != null) continue;
                    String key = MetaFactory.getGlobalInstance().getSolution().getKey();
                    MetaDomainCollection domainCollection = MetaFactory.getGlobalInstance().getDomainDef(key).getDomainCollection();
                    domainCollection.add(metaDomain);
                }
                dataElementLoad.load(dataElement);
                MetaDataElementDef metaDataElementDef = (MetaDataElementDef)dataElementLoad.getRootMetaObject();
                for (MetaDataElement metaDataElement : metaDataElementDef.getDataElementCollection()) {
                    MetaDataElement dataElement1 = MetaUtil.getDataElement((IMetaFactory)MetaFactory.getGlobalInstance(), (String)metaDataElement.getKey());
                    if (dataElement1 != null) continue;
                    String key = MetaFactory.getGlobalInstance().getSolution().getKey();
                    MetaDataElementCollection dataElementCollection = MetaFactory.getGlobalInstance().getDataElementDef(key).getDataElementCollection();
                    String domainKey = metaDataElement.getDomainKey();
                    MetaDomain domain1 = MetaUtil.getDomain((IMetaFactory)MetaFactory.getGlobalInstance(), (String)domainKey);
                    metaDataElement.setDomain(domain1);
                    dataElementCollection.add(metaDataElement);
                }
                MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
                HashSet formKeySet = new HashSet(metaFormList.keySet());
                for (String formKey : formKeySet) {
                    ReloadForm.processTemplateDataElement(MetaFactory.getGlobalInstance(), MetaFactory.getGlobalInstance().getMetaForm(formKey));
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
        executorService.execute(ExpAutoCompleteCmd::generateFunctionCache);
        if (enable) {
            executorService.execute(() -> {
                boolean exists;
                String settingPath = String.valueOf(WebDesignerConfiguration.getDesignerDataPath()) + File.separator + "DesignerData.xml";
                String designerPath = WebDesignerConfiguration.getDesignerDataPath();
                File file = new File(settingPath);
                File designerDir = new File(designerPath);
                if (!designerDir.exists()) {
                    designerDir.mkdirs();
                }
                boolean bl = exists = file.exists() && file.isFile();
                if (!exists) {
                    InitializingDesigner.writeDesignerDatatoFile(file);
                }
            });
            executorService.execute(() -> {
                GenerateFunctionsJsonFile.generateFunctionsJsonFile();
                GenerateFunctionsJsonFile.writeToFile(GenerateFunctionsJsonFile.FunctionsJson);
            });
            executorService.execute(() -> {
                ISessionInfoProvider simpleProvider = SessionInfoProviderHolder.getSimpleProvider();
                ISessionInfoMap sessionInfoMap = simpleProvider.getSessionInfoMap();
                if (sessionInfoMap.getTimeout() == 3600) {
                    sessionInfoMap.setTimeout(86400);
                }
            });
            executorService.execute(() -> {
                try {
                    if (!InitializingDesigner.delAllFile(solutionspath)) {
                        new File(solutionspath).mkdir();
                    }
                    LoadFileTree.ensureLoad();
                    Collection<String> solutionPaths = LoadFileTree.metaDesignerSolutionPathMap.values();
                    LanguageInitiator.init(solutionPaths);
                    try {
                        Set<String> designerSolutionTmpDataPaths = WebDesignerConfiguration.getDesignerSolutionTmpDataPaths();
                        for (String designerSolutionTmpDataPath : designerSolutionTmpDataPaths) {
                            boolean exists = InitializingDesigner.delAllFile(designerSolutionTmpDataPath);
                            if (exists) continue;
                            new File(designerSolutionTmpDataPath).mkdir();
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable e) {
                    LogSvr.getInstance().error(e.getMessage(), e);
                }
            });
            DesignerDebuggerImpl debugger = new DesignerDebuggerImpl();
            ExprDebuggerProxy.setExprDebugger((IExprDebugger)debugger);
        }
        executorService.shutdown();
    }

    public static List<String> getFormulaKeys() throws IOException {
        if (FormulaKeys != null) {
            return FormulaKeys;
        }
        File file = FileUtils.getFile((String[])new String[]{FilePathHelper.getCoreSolutionPath(), "Formula"});
        if (!file.exists()) {
            file.mkdir();
        }
        Object[] array = file.listFiles();
        ArrayList<String> fileNames = new ArrayList<String>();
        if (ArrayUtils.isEmpty((Object[])array)) {
            return fileNames;
        }
        int i = 0;
        while (i < array.length) {
            if (((File)array[i]).isFile()) {
                String name = ((File)array[i]).getName();
                fileNames.add(name.substring(0, name.indexOf(".")));
            }
            ++i;
        }
        FormulaKeys = fileNames;
        return fileNames;
    }

    private static boolean delAllFile(String path) {
        boolean exists;
        File file = new File(path);
        boolean bl = exists = file.exists() && file.isDirectory();
        if (exists) {
            String[] tempList = file.list();
            File temp = null;
            if (tempList != null) {
                String[] stringArray = tempList;
                int n = tempList.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    temp = path.endsWith(File.separator) ? new File(String.valueOf(path) + s) : new File(String.valueOf(path) + File.separator + s);
                    if (temp.isFile()) {
                        temp.delete();
                    }
                    if (temp.isDirectory()) {
                        InitializingDesigner.delAllFile(String.valueOf(path) + File.separator + s);
                        InitializingDesigner.delFolder(String.valueOf(path) + File.separator + s);
                    }
                    ++n2;
                }
            }
        }
        return exists;
    }

    public static void delFolder(String folderPath) {
        try {
            InitializingDesigner.delAllFile(folderPath);
            File myFilePath = new File(folderPath);
            myFilePath.delete();
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
    }

    public static void writeDesignerDatatoFile(File file) {
        try {
            file.createNewFile();
            TagNode root = new TagNode("DesignerData", null);
            TagNode Preference = new TagNode("Preference", null);
            TagNode renderType = new TagNode("RenderType", null).setAttribute("Value", "true");
            TagNode isShowData = new TagNode("IsShowData", null).setAttribute("Value", "false");
            TagNode isSetKeyAndCaption = new TagNode("IsSetKeyAndCaption", null).setAttribute("Value", "true");
            TagNode xmlWordWrap = new TagNode("XmlWordWrap", null).setAttribute("Value", "true");
            TagNode showError = new TagNode("ShowError", null).setAttribute("Value", "true");
            TagNode delayedProcessScope = new TagNode("DelayedProcessScope", null).setAttribute("Value", "false");
            TagNode expandAllPropertyPanelGroup = new TagNode("ExpandAllPropertyPanelGroup", null).setAttribute("Value", "false");
            TagNode autoLocateFileTree = new TagNode("AutoLocateFileTree", null).setAttribute("Value", "true");
            Preference.addNode(renderType);
            Preference.addNode(isShowData);
            Preference.addNode(isSetKeyAndCaption);
            Preference.addNode(xmlWordWrap);
            Preference.addNode(showError);
            Preference.addNode(delayedProcessScope);
            Preference.addNode(expandAllPropertyPanelGroup);
            Preference.addNode(autoLocateFileTree);
            root.addNode(Preference);
            String xml = DesignIOMetaUtil.getXml(root);
            FileUtils.writeStringToFile((File)file, (String)xml, (String)"UTF-8");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

