/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.all.controller.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.all.controller.SettingControl;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.setting.impl.SettingService;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.vo.SettingVo;
import com.bokesoft.yes.tools.zip.GZIPTools;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SettingControlUtil {
    private static final Logger logger = Logger.getLogger(SettingControl.class.getName());

    public static void getYigoData(SettingVo settingVo) throws Throwable {
        String yigoData = settingVo.getYigoData();
        if (yigoData != null) {
            byte[] bytes = Base64.decode((byte[])yigoData.getBytes());
            String resultDate = GZIPTools.decompress((InputStream)new ByteArrayInputStream(bytes), (String)"UTF-8");
            JSONObject jsonObject = JSONObject.parseObject((String)resultDate);
            settingVo.setDiff(jsonObject.getString("diff"));
            settingVo.setDocument(jsonObject.getString("document"));
            settingVo.setFormkey(jsonObject.getString("formkey"));
            settingVo.setPath(jsonObject.getString("path"));
            settingVo.setType(jsonObject.getString("type"));
        }
    }

    public static ResponseResult<JSONObject> getResponseResult(SettingVo settingVo, SettingService handleSetting) {
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        try {
            SettingControlUtil.getYigoData(settingVo);
            return handleSetting.handleData(settingVo);
        }
        catch (Exception e) {
            String type = settingVo.getType();
            logger.warning("\u83b7\u53d6" + type + "\u6570\u636e\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u83b7\u53d6" + type + "\u6570\u636e\u5931\u8d25\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            ArrayList<UICommand> uiCommands = new ArrayList<UICommand>();
            uiCommands.add(UICommand.showError(e.getMessage()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("UICommand", uiCommands);
            jsonObject.put("error", (Object)true);
            response.setData(jsonObject);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return response;
    }
}

