/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.all.controller;

import com.alibaba.fastjson.JSONArray;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.dataMigration.util.DataMigrationOperXmlUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.design.vo.JsonDataMapVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dataMapAttributes"})
public class MapAttributesController {
    private static final Logger logger = Logger.getLogger(MapAttributesController.class.getName());
    private final DataMapOperXmlUtil dataMapOperJsonUtil = new DataMapOperXmlUtil();
    private final DataMigrationOperXmlUtil dataMigrationOperXmlUtil = new DataMigrationOperXmlUtil();

    @PostMapping(value={"/dataMapUpdateXml"})
    @ResponseBody
    public ResponseResult<JSONArray> dataMapUpdateXml(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        String filePath = jsonDataMapVo.getFilePath();
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            response.setCode(1);
            response.setMsg("\u8bf7\u6c42\u53c2\u6570filePath\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return response;
        }
        String content = jsonDataMapVo.getContent();
        if (StringUtils.isEmpty((CharSequence)content)) {
            response.setCode(1);
            response.setMsg("\u8bf7\u6c42\u53c2\u6570content\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return response;
        }
        try {
            response = this.dataMapOperJsonUtil.dataMapUpdateXml(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u66f4\u65b0xml\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u66f4\u65b0xml\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/getFormField"})
    @ResponseBody
    public ResponseResult<JSONArray> getFormField(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            String tempPath = XmlFileProcessor.instance.getTmpFile(jsonDataMapVo.getFilePath());
            if (StringUtils.isBlank((CharSequence)tempPath)) {
                tempPath = jsonDataMapVo.getFilePath();
            }
            Element element = DataMapOperJsonUtil.getElement(tempPath);
            return this.dataMapOperJsonUtil.getFormField(jsonDataMapVo, element);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u8868\u5355\u6570\u636e\u6e90\u5b57\u6bb5\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u8868\u5355\u6570\u636e\u6e90\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/findAllFormField"})
    @ResponseBody
    public ResponseResult<JSONArray> findAllFormField(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            String filePath;
            String tmpFile;
            String formKey = jsonDataMapVo.getFormKey();
            if (StringUtils.isNotEmpty((CharSequence)formKey)) {
                formKey = formKey.split("__")[0];
            }
            if ((tmpFile = XmlFileProcessor.instance.getTmpFile(filePath = jsonDataMapVo.getFilePath())) != null) {
                filePath = tmpFile;
            }
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
            Element element = DataMapOperJsonUtil.getElement(filePath);
            String name = element.getName();
            String nodeName = jsonDataMapVo.getNodeName();
            if ("Map".equals(name)) {
                formKey = this.getFormKey(jsonDataMapVo, element, nodeName);
            } else if ("SourceTableCollection".equals(nodeName)) {
                formKey = element.attributeValue("SrcDataObjectKey");
            } else if ("TargetTableCollection".equals(nodeName)) {
                formKey = element.attributeValue("TgtDataObjectKey");
            }
            JSONArray nodesJsonArray = new JSONArray();
            TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
            MetaForm metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
            MetaDataObject metaDataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
            if ("Map".equals(name)) {
                MetaTableCollection tableCollection = null;
                String extend = element.attributeValue("Extend");
                String mergeToSource = element.attributeValue("MergeToSource");
                boolean isFilter = StringUtils.isNotEmpty((CharSequence)extend) && StringUtils.isNotEmpty((CharSequence)mergeToSource);
                String formKey1 = this.getFormKey(jsonDataMapVo, element, nodeName);
                MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey1);
                IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
                if (metaForm != null) {
                    tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
                } else if (metaDataObject != null) {
                    tableCollection = metaDataObject.getTableCollection();
                }
                if (tableCollection != null) {
                    int i = 0;
                    while (i < tableCollection.size()) {
                        Collection elementMap;
                        MetaTable metaColumns = (MetaTable)tableCollection.get(i);
                        int finalI = i + 1;
                        String finalTable = metaColumns.getKey();
                        Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
                        if (!MapUtils.isEmpty(columKeysAndFieldKeys) && !metaColumns.getKey().contains("_NODB") && (elementMap = metaColumns.items()) != null) {
                            for (MetaColumn metaColumn : elementMap) {
                                List<String> fieldKeys;
                                if (metaColumn.getKey().contains("_NODB") || CollectionUtils.isEmpty(fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey()))) continue;
                                for (String fieldKey : fieldKeys) {
                                    if (isFilter) {
                                        Map<String, String> map = DataMapOperXmlUtil.filterFiledMap(extend, metaForm1);
                                        if (map.containsValue(fieldKey)) continue;
                                        this.dataMapOperJsonUtil.setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, false, false, nodeName, metaColumns, xmlTreeWithPath, idLookup, fieldKey);
                                        continue;
                                    }
                                    this.dataMapOperJsonUtil.setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, false, false, nodeName, metaColumns, xmlTreeWithPath, idLookup, fieldKey);
                                }
                            }
                        }
                        ++i;
                    }
                }
            } else if ("DataMigration".equals(name)) {
                this.dataMapOperJsonUtil.setLayuiArrayUniversal(formKey, metaForm, metaDataObject, nodesJsonArray, true, false, nodeName, xmlTreeWithPath);
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5\u6210\u529f");
            result.setData(nodesJsonArray);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    private String getFormKey(@RequestBody JsonDataMapVo jsonDataMapVo, Element element, String nodeName) {
        String formKey1 = null;
        if ("SourceTableCollection".equals(nodeName)) {
            formKey1 = element.attributeValue("SrcFormKey");
        } else if ("TargetTableCollection".equals(nodeName)) {
            formKey1 = element.attributeValue("TgtFormKey");
        } else {
            String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
            List feedbackElements = element.element("FeedbackCollection").elements("FeedbackObject");
            for (Element element1 : feedbackElements) {
                if (!objectKey.equalsIgnoreCase(element1.attributeValue("FormKey"))) continue;
                formKey1 = element1.attributeValue("FormKey");
                break;
            }
        }
        return formKey1;
    }

    @PostMapping(value={"/getTableKeyField"})
    @ResponseBody
    public ResponseResult<JSONArray> getTableKeyField(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.getTableKeyField(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u8868\u5355\u6570\u636e\u6e90\u5b57\u6bb5\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u8868\u5355\u6570\u636e\u6e90\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/findTabaleKeyField"})
    @ResponseBody
    public ResponseResult<JSONArray> findTableKeyField(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.getTreeFields(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u8868\u5355\u6570\u636e\u6e90\u5b57\u6bb5\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u8868\u5355\u6570\u636e\u6e90\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/deleteField"})
    @ResponseBody
    public ResponseResult<JSONArray> deleteField(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.getdeleteField(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u8868\u5355\u6570\u636e\u6e90\u5b57\u6bb5\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u8868\u5355\u6570\u636e\u6e90\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/fieldInfo"})
    @ResponseBody
    public ResponseResult<JSONArray> fieldInfo(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.fieldInfo(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/ligatureinfo"})
    @ResponseBody
    public ResponseResult<JSONArray> ligatureinfo(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.ligatureinfo(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u8fde\u7ebf\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u8fde\u7ebf\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/getTargetTableList"})
    @ResponseBody
    public ResponseResult<JSONArray> getTargetTableList(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.getTargetTableList(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u76ee\u6807\u8868\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u76ee\u6807\u8868\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/getSourceFieldList"})
    @ResponseBody
    public ResponseResult<JSONArray> getSourceFieldList(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.getSourceFieldList(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u76ee\u6807\u8868\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u76ee\u6807\u8868\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/getRefFieldKey"})
    @ResponseBody
    public ResponseResult<JSONArray> getRefFieldKey(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.getRefFieldKey(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u4e3b\u8868\u5b57\u6bb5\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u4e3b\u8868\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/setTargetField"})
    @ResponseBody
    public ResponseResult<JSONArray> setTargetField(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.setTargetField(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u6dfb\u52a0\u76ee\u6807\u5b57\u6bb5\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u6dfb\u52a0\u76ee\u6807\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/isConnected"})
    @ResponseBody
    public ResponseResult<Boolean> isConnected(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<Boolean> response = new ResponseResult<Boolean>();
        try {
            return this.dataMapOperJsonUtil.isConnected(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u5224\u65ad\u8fde\u7ebf\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u5224\u65ad\u8fde\u7ebf\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/getAllFormkey"})
    @ResponseBody
    public ResponseResult<JSONArray> getAllFormkey(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.getAllFormkey(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u6240\u6709\u8868\u5355\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u6240\u6709\u8868\u5355\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/coordinateData"})
    @ResponseBody
    public ResponseResult<JSONArray> coordinateData(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.coordinateData(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u5750\u6807\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u5750\u6807\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/updateLigatureXML"})
    @ResponseBody
    public ResponseResult<JSONArray> updateLigatureXML(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.updateLigatureXML(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u5750\u6807\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u5750\u6807\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/handleDeleteXML"})
    @ResponseBody
    public ResponseResult<JSONArray> handleDeleteXML(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMapOperJsonUtil.handleDeleteXML(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u5220\u9664\u53cd\u586b\u8868\u5355\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u5220\u9664\u53cd\u586b\u8868\u5355\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/getMigrationField"})
    @ResponseBody
    public ResponseResult<JSONArray> getMigrationField(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            Element element = DataMapOperJsonUtil.getElement(jsonDataMapVo.getFilePath());
            return this.dataMigrationOperXmlUtil.getMigrationField(jsonDataMapVo, element);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u6570\u636e\u5bf9\u8c61\u5b57\u6bb5\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u6570\u636e\u5bf9\u8c61\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/getStatusFideldKey"})
    @ResponseBody
    public ResponseResult<JSONArray> getStatusFideldKey(@RequestBody JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.dataMigrationOperXmlUtil.getStatusFideldKey(jsonDataMapVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u72b6\u6001\u5b57\u6bb5\u6807\u8bc6\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u72b6\u6001\u5b57\u6bb5\u6807\u8bc6\u5f02\u5e38\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return response;
    }
}

