/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.all.controller;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.dataObject.util.DataObjectOperJsonUtil;
import com.bokesoft.yes.design.vo.DataObjectVO;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.helper.DocumentHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.tools.zip.GZIPTools;
import com.bokesoft.yigo.struct.document.Document;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dataObjectController"})
public class DataObjectController {
    private final DataObjectOperJsonUtil dataObjectOperJsonUtil = new DataObjectOperJsonUtil();

    @PostMapping(value={"/handleDataObject"})
    public ResponseResult<JSONObject> handleDataObject(@RequestBody DataObjectVO dataObjectVO) {
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        JSONObject data = new JSONObject();
        try {
            String yigoData = dataObjectVO.getYigoData();
            if (yigoData != null) {
                byte[] bytes = Base64.decode((byte[])yigoData.getBytes());
                String resultDate = GZIPTools.decompress((InputStream)new ByteArrayInputStream(bytes), (String)"UTF-8");
                JSONObject jsonObject = JSONObject.parseObject((String)resultDate);
                dataObjectVO.setFormkey(jsonObject.getString("formkey"));
                dataObjectVO.setDataobjectkey(jsonObject.getString("dataobjectkey"));
                dataObjectVO.setDocument(jsonObject.getString("document"));
                dataObjectVO.setKey(jsonObject.getString("key"));
                dataObjectVO.setPath(jsonObject.getString("filePath"));
                dataObjectVO.setMark(jsonObject.getString("mark"));
                dataObjectVO.setValue(jsonObject.getString("value"));
                dataObjectVO.setDiff(jsonObject.getString("diff"));
            }
            String formKey = dataObjectVO.getFormkey();
            Document document = DocumentHelper.parseDocumentFormJSON(dataObjectVO.getDocument());
            String diffJsonString = dataObjectVO.getDiff();
            JSONArray array = new JSONArray(diffJsonString);
            int len = array.length();
            ArrayList<Diff> diffs = new ArrayList<Diff>(len);
            int i = 0;
            while (i < len) {
                diffs.add(Diff.fromJson(array.getJSONObject(i)));
                ++i;
            }
            return this.dataObjectOperJsonUtil.handleDataObject(formKey, document, diffs);
        }
        catch (RuntimeException e) {
            LogSvr.getInstance().warn("\u64cd\u4f5c\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            data.put("code", (Object)999);
            data.put("msg", (Object)e.getMessage());
        }
        catch (Throwable e) {
            LogSvr.getInstance().warn("\u64cd\u4f5c\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            data.put("code", (Object)999);
            data.put("msg", (Object)("\u64cd\u4f5c\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage()));
        }
        response.setData(data);
        return response;
    }

    @PostMapping(value={"/FieldinforOrBasicAttribute"})
    public ResponseResult<JSONObject> FieldinforOrBasicAttribute(@RequestBody DataObjectVO dataObjectVO) {
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        try {
            return this.dataObjectOperJsonUtil.FieldinforOrBasicAttribute(dataObjectVO);
        }
        catch (Exception e) {
            LogSvr.getInstance().error("\u5904\u7406\u5b57\u6bb5\u4fe1\u606f\u548c\u57fa\u672c\u5c5e\u6027\u5931\u8d25\uff01", (Throwable)e);
            response.setCode(999);
            response.setMsg("\u5904\u7406\u5b57\u6bb5\u4fe1\u606f\u548c\u57fa\u672c\u5c5e\u6027\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        return response;
    }

    @PostMapping(value={"/getKey"})
    public ResponseResult<JSONObject> getKey(@RequestBody DataObjectVO dataObjectVO) {
        return this.dataObjectOperJsonUtil.getKey(dataObjectVO);
    }

    @PostMapping(value={"/getEmbedKey"})
    public String getEmbedKey(@RequestBody DataObjectVO dataObjectVO) {
        return this.dataObjectOperJsonUtil.getEmbedKey(dataObjectVO);
    }
}

