/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.all.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.yes.design.bpm.util.BpmOperToXmlUtil;
import com.bokesoft.yes.design.bpm.util.GetDataUtil;
import com.bokesoft.yes.design.vo.JsonQuestVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/bpmAttributes"})
public class BpmAttributesController {
    private static final Logger logger = Logger.getLogger(BpmAttributesController.class.getName());
    public static final int OPER_TYPE_ONE = 1;
    public static final int OPER_TYPE_TWO = 2;
    public static final int OPER_TYPE_THREE = 3;
    private final BpmOperToXmlUtil bpmOperUtil = new BpmOperToXmlUtil();
    private final GetDataUtil getDataUtil = new GetDataUtil();

    @PostMapping(value={"/handleNodesAndPaths"})
    @ResponseBody
    public Object handleNodesAndPaths(@RequestBody JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        try {
            if (this.validateRquestParams(jsonQuestVo, response)) {
                return response;
            }
            switch (jsonQuestVo.getOperType()) {
                case 1: 
                case 2: 
                case 3: {
                    response = this.bpmOperUtil.handleNodesAndPaths(jsonQuestVo, jsonQuestVo.getOperType());
                    break;
                }
                default: {
                    response.setCode(-1);
                    response.setMsg("\u672a\u77e5\u64cd\u4f5c");
                    return response;
                }
            }
        }
        catch (Exception e) {
            logger.warning("\u64cd\u4f5c\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u64cd\u4f5c\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
        return JSONObject.toJSONString(response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect});
    }

    @PostMapping(value={"/updateXml"})
    @ResponseBody
    public ResponseResult<JSONObject> updateXml(@RequestBody JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        String filePath = jsonQuestVo.getFilePath();
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            response.setCode(1);
            response.setMsg("\u8bf7\u6c42\u53c2\u6570filePath\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return response;
        }
        String content = jsonQuestVo.getContent();
        if (StringUtils.isEmpty((CharSequence)content)) {
            response.setCode(1);
            response.setMsg("\u8bf7\u6c42\u53c2\u6570content\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return response;
        }
        try {
            response = this.bpmOperUtil.updateXml(jsonQuestVo);
        }
        catch (Exception e) {
            logger.warning("\u66f4\u65b0xml\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u66f4\u65b0xml\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/deployBpm"})
    @ResponseBody
    public ResponseResult<JSONObject> deployBpm(@RequestBody JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONObject> response = new ResponseResult();
        try {
            response = this.bpmOperUtil.deployBpm(jsonQuestVo);
        }
        catch (Exception e) {
            logger.warning("\u90e8\u7f72\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u90e8\u7f72\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/workflowAndBillsConfig"})
    @ResponseBody
    public ResponseResult<List<JSONObject>> workflowAndBillsConfig(@RequestBody JsonQuestVo jsonQuestVo) {
        ResponseResult<List<JSONObject>> response = new ResponseResult<List<JSONObject>>();
        try {
            return this.bpmOperUtil.workflowAndBillsConfig(jsonQuestVo);
        }
        catch (Exception e) {
            logger.warning("\u6d41\u7a0b\u5355\u636e\u5173\u8054\u8bbe\u7f6e\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u6d41\u7a0b\u5355\u636e\u5173\u8054\u8bbe\u7f6e\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/newVersion"})
    @ResponseBody
    public ResponseResult<JSONObject> newVersion(@RequestBody JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        try {
            return this.bpmOperUtil.newVersion(jsonQuestVo);
        }
        catch (Exception e) {
            logger.warning("\u65b0\u589e\u7248\u672c\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u65b0\u589e\u7248\u672c\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/getAllNodes"})
    @ResponseBody
    public ResponseResult<JSONArray> getAllNodes(@RequestBody JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            if (StringUtils.isEmpty((CharSequence)jsonQuestVo.getFilePath())) {
                response.setCode(1);
                response.setMsg("\u8bf7\u6c42\u53c2\u6570filePath\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
                return response;
            }
            return this.getDataUtil.getAllNodes(jsonQuestVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u5f53\u524d\u6587\u4ef6\u7684\u6240\u6709\u8282\u70b9\u5143\u7d20\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u5f53\u524d\u6587\u4ef6\u7684\u6240\u6709\u8282\u70b9\u5143\u7d20\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/getInline"})
    @ResponseBody
    public ResponseResult<JSONArray> getInline() {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.getDataUtil.getInline();
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u6240\u6709\u7684\u6d41\u7a0b\u6807\u8bc6\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u6240\u6709\u7684\u6d41\u7a0b\u6807\u8bc6\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/getStatusList"})
    @ResponseBody
    public ResponseResult<JSONArray> getStatus(@RequestBody JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            if (StringUtils.isEmpty((CharSequence)jsonQuestVo.getFilePath())) {
                response.setCode(1);
                response.setMsg("\u8bf7\u6c42\u53c2\u6570filePath\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
                return response;
            }
            return this.getDataUtil.getStatusList(jsonQuestVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u72b6\u6001\u96c6\u5408\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u72b6\u6001\u96c6\u5408\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/getBpmBindingKeyList"})
    @ResponseBody
    public ResponseResult<JSONObject> getBpmBindingKeyList(@RequestBody JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        try {
            if (StringUtils.isEmpty((CharSequence)jsonQuestVo.getFilePath())) {
                response.setCode(1);
                response.setMsg("\u8bf7\u6c42\u53c2\u6570filePath\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
                return response;
            }
            return this.getDataUtil.getBpmBindingKeyList(jsonQuestVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u7ed1\u5b9a\u6807\u8bc6\u5217\u8868\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u7ed1\u5b9a\u6807\u8bc6\u5217\u8868\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/getProcessKeyList"})
    @ResponseBody
    public ResponseResult<JSONArray> getProcessKeyList(@RequestBody JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            if (StringUtils.isEmpty((CharSequence)jsonQuestVo.getFilePath())) {
                response.setCode(1);
                response.setMsg("\u8bf7\u6c42\u53c2\u6570filePath\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
                return response;
            }
            return this.getDataUtil.getProcessKeyList(jsonQuestVo);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u6d41\u7a0b\u6807\u8bc6\u5217\u8868\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u6d41\u7a0b\u6807\u8bc6\u5217\u8868\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @PostMapping(value={"/getAllFormKeyList"})
    @ResponseBody
    public ResponseResult<JSONArray> getAllFormKeyList() {
        ResponseResult<JSONArray> response = new ResponseResult<JSONArray>();
        try {
            return this.getDataUtil.getAllFormKeyList();
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u6d41\u7a0b\u6807\u8bc6\u5217\u8868\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u6d41\u7a0b\u6807\u8bc6\u5217\u8868\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @RequestMapping(value={"/getWorkflowAndBillsTableData"})
    @ResponseBody
    public Object getWorkflowAndBillsTableData(@RequestBody JsonQuestVo jsonQuestVo) {
        ResponseResult response = new ResponseResult();
        try {
            if (StringUtils.isEmpty((CharSequence)jsonQuestVo.getFilePath())) {
                response.setCode(1);
                response.setMsg("\u8bf7\u6c42\u53c2\u6570filePath\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
                return response;
            }
            return this.bpmOperUtil.getWorkflowAndBillsTableData(jsonQuestVo.getFilePath());
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u6d41\u7a0b\u5355\u636e\u5173\u8054\u8bbe\u7f6e\u6570\u636e\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u83b7\u53d6\u6d41\u7a0b\u5355\u636e\u5173\u8054\u8bbe\u7f6e\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    @RequestMapping(value={"/getPermListByKey"})
    @ResponseBody
    public Object getPermListByKey(@RequestParam(value="key") String key) {
        ResponseResult response = new ResponseResult();
        try {
            if (StringUtils.isEmpty((CharSequence)key)) {
                response.setCode(1);
                response.setMsg("\u8bf7\u6c42\u53c2\u6570key\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
                return response;
            }
            return this.getDataUtil.getPermListByKey(key);
        }
        catch (Exception e) {
            logger.warning("\u6839\u636eKey\u83b7\u53d6\u6743\u9650\u5217\u8868\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            response.setCode(999);
            response.setMsg("\u6839\u636eKey\u83b7\u53d6\u6743\u9650\u5217\u8868\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:" + e.getMessage());
            return response;
        }
    }

    private boolean validateRquestParams(@RequestBody JsonQuestVo jsonQuestVo, ResponseResult<JSONObject> response) {
        if (jsonQuestVo.getOperType() == null || jsonQuestVo.getOperType() == 0) {
            response.setCode(1);
            response.setMsg("\u8bf7\u6c42\u53c2\u6570operType\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)jsonQuestVo.getFilePath())) {
            response.setCode(1);
            response.setMsg("\u8bf7\u6c42\u53c2\u6570filePath\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)jsonQuestVo.getContent())) {
            response.setCode(1);
            response.setMsg("\u8bf7\u6c42\u53c2\u6570content\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)jsonQuestVo.getNodeId())) {
            response.setCode(1);
            response.setMsg("\u8bf7\u6c42\u53c2\u6570nodeId\u503c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return true;
        }
        return false;
    }
}

