// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE

(function (mod) {
    if (typeof exports == "object" && typeof module == "object") // CommonJS
        mod(require("../../lib/codemirror"));
    else if (typeof define == "function" && define.amd) // AMD
        define(["../../lib/codemirror"], mod);
    else // Plain browser env
        mod(CodeMirror);
})(function (CodeMirror) {
    "use strict";

    var HINT_ELEMENT_CLASS = "CodeMirror-hint";
    var ACTIVE_HINT_ELEMENT_CLASS = "CodeMirror-hint-active";

    //yigo前端函数文档说明
    var yigoFrontFnsExplain = [];
    yigoFrontFnsExplain = ["装载数据 LoadData() 说明：装载数据 返回值：数据集合",
        "获取字典项中某个属性的值 GetDictValue(ItemKey, OID, FieldKey) 说明：ItemKey:字典标识,OID:字典的数据对象OID,FieldKey:属性标识 返回值：GetDictValue('Material', 10001, 'MaterialHead.Code')获取字典项中属性Code的值",
        "字符串截取函数 方法：Mid(sText, pos, length) 说明：获取参数sText从pos位置开始的length字符的子串 返回值：Mid('abcdefg',3,2),返回'de'",
        "根据条件返回值 方法：Object IIF(Boolean value, Object v1, Object v2) 说明：value:条件；v1:参数1为真时，返回的值；v2:参数1为假时，返回的值；返回值描述：例：IIF(1==2,1,2) 返回2；IIF(1==2,1) 返回值为null"
    ];

    // This is the old interface, kept around for now to stay
    // backwards-compatible.
    CodeMirror.showHint = function (cm, getHints, options) {
        if (!getHints) return cm.showHint(options);
        if (options && options.async) getHints.async = true;
        var newOpts = {hint: getHints};
        if (options) for (var prop in options) newOpts[prop] = options[prop];
        return cm.showHint(newOpts);
    };

    // This is the old interface, kept around for now to stay
    // backwards-compatible.
    CodeMirror.showHint1 = function (cm, getHints, options) {
        if (!getHints) return cm.showHint1(options);
        if (options && options.async) getHints.async = true;
        var newOpts = {hint: getHints};
        if (options) for (var prop in options) newOpts[prop] = options[prop];
        return cm.showHint1(newOpts);
    };

    CodeMirror.defineExtension("showHint", function (options) {
        options = parseOptions(this, this.getCursor("start"), options);
        var selections = this.listSelections()
        if (selections.length > 1) return;
        // By default, don't allow completion when something is selected.
        // A hint function can have a `supportsSelection` property to
        // indicate that it can handle selections.
        if (this.somethingSelected()) {
            if (!options.hint.supportsSelection) return;
            // Don't try with cross-line selections
            for (var i = 0; i < selections.length; i++)
                if (selections[i].head.line != selections[i].anchor.line) return;
        }

        if (this.state.completionActive) this.state.completionActive.close();
        var completion = this.state.completionActive = new Completion(this, options);
        if (!completion.options.hint) return;

        CodeMirror.signal(this, "startCompletion", this);
        completion.update(true);
    });

    CodeMirror.defineExtension("showHint1", function (options, datas) {
        yigoFrontFnsExplain = datas.yigoFrontFnsExplainData;
        options = parseOptions(this, this.getCursor("start"), options);
        var selections = this.listSelections()
        if (selections.length > 1) return;
        // By default, don't allow completion when something is selected.
        // A hint function can have a `supportsSelection` property to
        // indicate that it can handle selections.
        if (this.somethingSelected()) {
            if (!options.hint.supportsSelection) return;
            // Don't try with cross-line selections
            for (var i = 0; i < selections.length; i++)
                if (selections[i].head.line != selections[i].anchor.line) return;
        }

        if (this.state.completionActive) this.state.completionActive.close();
        var completion = this.state.completionActive = new Completion(this, options);
        if (!completion.options.hint) return;

        CodeMirror.signal(this, "startCompletion", this);

        completion.update1(true, datas);
    });

    function Completion(cm, options) {
        this.cm = cm;
        this.options = options;
        this.widget = null;
        //this.widget1 = null;
        this.debounce = 0;
        this.tick = 0;
        this.startPos = this.cm.getCursor("start");
        this.startLen = this.cm.getLine(this.startPos.line).length - this.cm.getSelection().length;

        var self = this;
        cm.on("cursorActivity", this.activityFunc = function () {
            self.cursorActivity();
        });
    }

    var requestAnimationFrame = window.requestAnimationFrame || function (fn) {
        return setTimeout(fn, 1000 / 60);
    };
    var cancelAnimationFrame = window.cancelAnimationFrame || clearTimeout;

    Completion.prototype = {
        close: function () {
            if (!this.active()) return;
            this.cm.state.completionActive = null;
            this.tick = null;
            this.cm.off("cursorActivity", this.activityFunc);

            if (this.widget && this.data) CodeMirror.signal(this.data, "close");
            if (this.widget) {
                this.widget.close();
            }
            /*if (this.widget1) {
               this.widget1.close();
            }*/
            CodeMirror.signal(this.cm, "endCompletion", this.cm);
        },

        active: function () {
            return this.cm.state.completionActive == this;
        },

        pick: function (data, i) {
            if (data.from.ch == -1) {
                console.log("自动完成开始位置错误");
            }
            if (data.to.ch == -1) {
                console.log("自动完成结束位置错误");
            }
            var completion = data.list[i];
            if (!completion) {
                return;
            }
            let targetContent = completion.substring(completion.indexOf("("), completion.indexOf(")") + 1);
            if (targetContent) {
                let len = 0;
                for (let i = 0;i<targetContent.length;i++) {
                    if (targetContent[i] == ",") {
                        len = len + 1;
                    }
                }
                completion = completion.replace(targetContent,"");
                completion += "(";
                for (let i = 0;i<len;i++) {
                    completion += ",";
                }
                completion += ")";
            }
            if (completion.hint) {
                completion.hint(this.cm, data, completion);
            } else {
                //如果当前输入字符为"+-*/=%><&|"等运算符，那么替换的位置加1
                if (data && (data.currentInputChar == "+" || data.currentInputChar == "-"
                    || data.currentInputChar == "*" || data.currentInputChar == "/"
                    || data.currentInputChar == "=" || data.currentInputChar == "%"
                    || data.currentInputChar == ">" || data.currentInputChar == "<"
                    || data.currentInputChar == "&" || data.currentInputChar == "|"
                    || data.currentInputChar == "'" || data.currentInputChar == "\""
                    || data.currentInputChar == "(" || data.currentInputChar == ","
                    || data.currentInputChar == "，")) {
                    data.from.ch = data.from.ch + 1;
                    data.to.ch = data.to.ch;
                }
                this.cm.replaceRange(getText(completion), completion.from || data.from,
                    completion.to || data.to, "complete");
                // 2021-10-09 设置光标位置：如果是函数，那么光标在"("后；否则，光标在当前行最后。
                let len = 0;
                if (data.list[i].indexOf("(") != -1 && data.list[i].indexOf(")") - data.list[i].indexOf("(") > 1) {
                    len = completion.substring(0, data.list[i].indexOf("(")).length;
                } else {
                    len = data.list[i].length;
                }
                this.cm.setCursor({line:this.cm.getCursor().line, ch:parseInt(data.from.ch + len + 1)});
            }
            CodeMirror.signal(data, "pick", completion);
            this.close();
        },

        cursorActivity: function () {
            if (this.debounce) {
                cancelAnimationFrame(this.debounce);
                this.debounce = 0;
            }

            var pos = this.cm.getCursor(), line = this.cm.getLine(pos.line);
            if (pos.line != this.startPos.line || line.length - pos.ch != this.startLen - this.startPos.ch ||
                pos.ch < this.startPos.ch || this.cm.somethingSelected() ||
                (pos.ch && this.options.closeCharacters.test(line.charAt(pos.ch - 1)))) {
                this.close();
            } else {
                var self = this;
                this.debounce = requestAnimationFrame(function () {
                    self.update();
                });
                if (this.widget) {
                    this.widget.disable();
                }
                /*if (this.widget1)
                {
                   this.widget1.disable();
                }*/
            }
        },

        update: function (first) {
            if (this.tick == null) return;
            if (!this.options.hint.async) {
                this.finishUpdate(this.options.hint(this.cm, this.options), first);
            } else {
                var myTick = ++this.tick, self = this;
                this.options.hint(this.cm, function (data) {
                    if (self.tick == myTick) self.finishUpdate(data, first);
                }, this.options);
            }
        },

        update1: function (first, datas) {
            if (this.tick == null) return;
            if (!this.options.hint.async) {
                //
                //datas = JSON.parse(datas);
                this.finishUpdate1(datas, first);
            } else {
                var myTick = ++this.tick, self = this;
                this.options.hint(this.cm, function (data) {
                    if (self.tick == myTick) self.finishUpdate(data, first);
                }, this.options);
            }
        },

        finishUpdate1: function (data, first) {
            if (this.data) {
                CodeMirror.signal(this.data, "update");
            }

            var picked = (this.widget && this.widget.picked) || (first && this.options.completeSingle);
            if (this.widget) {
                this.widget.close();
            }
            /*   if (this.widget1)
               {
                  this.widget1.close();
               }*/
            if (data && this.data && isNewCompletion(this.data, data)) {
                return;
            }
            this.data = data;

            if (data && data.list.length) {
                if (picked && data.list.length == 1) {
                    this.pick(data, 0);
                } else {
                    this.widget = new Widget1(this, data);
                    //new Widget1(this, data);
                    CodeMirror.signal(data, "shown");
                }
            }
        },

        finishUpdate: function (data, first) {
            if (this.data) {
                CodeMirror.signal(this.data, "update");
            }

            var picked = (this.widget && this.widget.picked) || (first && this.options.completeSingle);
            if (this.widget) {
                this.widget.close();
            }

            if (data && this.data && isNewCompletion(this.data, data)) {
                return;
            }
            this.data = data;

            if (data && data.list.length) {
                if (picked && data.list.length == 1) {
                    this.pick(data, 0);
                } else {
                    this.widget = new Widget(this, data);
                    CodeMirror.signal(data, "shown");
                }
            }
        }
    };

    function isNewCompletion(old, nw) {
        var moved = CodeMirror.cmpPos(nw.from, old.from)
        return moved > 0 && old.to.ch - old.from.ch != nw.to.ch - nw.from.ch
    }

    function parseOptions(cm, pos, options) {
        var editor = cm.options.hintOptions;
        var out = {};
        for (var prop in defaultOptions) out[prop] = defaultOptions[prop];
        if (editor) for (var prop in editor)
            if (editor[prop] !== undefined) out[prop] = editor[prop];
        if (options) for (var prop in options)
            if (options[prop] !== undefined) out[prop] = options[prop];
        if (out.hint.resolve) out.hint = out.hint.resolve(cm, pos)
        return out;
    }

    function getText(completion) {
        if (typeof completion == "string") return completion;
        else return completion.text;
    }

    function buildKeyMap(completion, handle) {
        var baseMap = {
            Up: function () {
                handle.moveFocus(-1);
            },
            Down: function () {
                handle.moveFocus(1);
            },
            PageUp: function () {
                handle.moveFocus(-handle.menuSize() + 1, true);
            },
            PageDown: function () {
                handle.moveFocus(handle.menuSize() - 1, true);
            },
            Home: function () {
                handle.setFocus(0);
            },
            End: function () {
                handle.setFocus(handle.length - 1);
            },
            Enter: handle.pick,
            Tab: handle.pick,
            Esc: handle.close
        };
        var custom = completion.options.customKeys;
        var ourMap = custom ? {} : baseMap;

        function addBinding(key, val) {
            var bound;
            if (typeof val != "string")
                bound = function (cm) {
                    return val(cm, handle);
                };
            // This mechanism is deprecated
            else if (baseMap.hasOwnProperty(val))
                bound = baseMap[val];
            else
                bound = val;
            ourMap[key] = bound;
        }

        if (custom)
            for (var key in custom) if (custom.hasOwnProperty(key))
                addBinding(key, custom[key]);
        var extra = completion.options.extraKeys;
        if (extra)
            for (var key in extra) if (extra.hasOwnProperty(key))
                addBinding(key, extra[key]);
        return ourMap;
    }

    function getHintElement(hintsElement, el) {
        while (el && el != hintsElement) {
            if (el.nodeName.toUpperCase() === "LI" && el.parentNode == hintsElement) return el;
            el = el.parentNode;
        }
    }

    function Widget1(completion, data) {
        this.completion = completion;
        this.data = data;
        this.picked = false;
        var widget = this, cm = completion.cm;

        var winW = window.innerWidth || Math.max(document.body.offsetWidth, document.documentElement.offsetWidth);
        var hints = this.hints = document.createElement("ul");
        var hints2 = this.hints2 = document.createElement("ul");

        //文档说明提示框
        var completions = data.list;
        try {
            if (completions.toString().indexOf("vm") < 0 || this.completion.options.ignorePick) {
                hints2.className = "CodeMirror-hints";

                //for (var i = 0; i < 1; ++i) {
                var elt = hints2.appendChild(document.createElement("li")), cur = completions[0];
                var key = data.key;
                var index = 0;
                if (typeof (key) != "undefined") {
                    key = key.replace(",", "").replace(",", "").replace("(", "").replace(")", "").replace(" ", "");
                    var showList = data.showList;
                    index = showList[0];
                } else {
                    if ((cur.displayText || getText(cur)).indexOf("sendMail") > -1) {
                        key = "sendMail";
                    } else {
                        key = (cur.displayText || getText(cur)).replace(",", "").replace(",", "").replace("(", "").replace(")", "").replace(" ", "");
                    }
                }

                if (cur.render) cur.render(elt, data, cur);
                else{
                    if (this.completion.options.ignorePick){
                        buildRefHints2(hints2, index)
                    }else {
                        elt.appendChild(document.createTextNode(yigoFrontFnsExplain[index]));
                    }
                }
                elt.hintId = i;
                //}

                var pos = cm.cursorCoords(completion.options.alignWithWord ? data.from : null);
                var left = pos.left, top = pos.bottom, below = true;

                //hints2.style.left =  275+ left + "px";
                hints2.style.width = 400 + "px";
                hints2.style.height = 300 + "px";
                hints2.style.top = top + "px";
                hints2.style.backgroundColor = "#FAFAD2";
                hints2.style.overflowY = "auto";
                //(completion.options.container || document.body).appendChild(hints2);
                //结束
                hints.style.width = 350 + "px";
            } else {
                hints.style.width = 230 + "px";
            }
        } catch (e) {

        }

        hints.className = "CodeMirror-hints";
        this.selectedHint = data.selectedHint || 0;

        var completions = data.list;
        for (var i = 0; i < completions.length; ++i) {
            var elt = hints.appendChild(document.createElement("li")), cur = completions[i];
            var className = HINT_ELEMENT_CLASS + (i != this.selectedHint ? "" : " " + ACTIVE_HINT_ELEMENT_CLASS);
            if (cur.className != null) className = cur.className + " " + className;
            elt.className = className;
            if (cur.render) cur.render(elt, data, cur);
            else elt.appendChild(document.createTextNode(cur.displayText || getText(cur)));
            elt.hintId = i;
        }

        var pos = cm.cursorCoords(completion.options.alignWithWord ? data.from : null);
        var left = pos.left, top = pos.bottom, below = true;
        hints.style.left = left + "px";
        hints.style.top = top + "px";
        hints2.style.left = parseInt(String(hints.style.left).replace("px", "")) - parseInt(String(hints.style.width).replace("px", "")) - 50 + "px";

        // If we're at the edge of the screen, then we want the menu to appear on the left of the cursor.
        //var winW = window.innerWidth || Math.max(document.body.offsetWidth, document.documentElement.offsetWidth);
        var winH = window.innerHeight || Math.max(document.body.offsetHeight, document.documentElement.offsetHeight);
        (completion.options.container || document.body).appendChild(hints);

        var box = hints.getBoundingClientRect();
        var overlapY = box.bottom - winH;
        var height = box.bottom - box.top, curTop = pos.top - (pos.bottom - box.top);
        let hints2Height = hints2.clientHeight > 0 ? hints2.clientHeight : 300;
        if (overlapY > 0) {
            if (curTop - height > 0) { // Fits above cursor
                below = false;
                if (hints.scrollWidth > hints.clientWidth && hints.scrollHeight <= hints.clientHeight) {
                    hints.style.top = (top = pos.top - height) - 18 + "px";
                    hints2.style.top = (top = pos.top - hints2Height) + 44 + "px";
                } else {
                    hints.style.top = (top = pos.top - height) + "px";
                    hints2.style.top = (top = pos.top - hints2Height) + 49 + "px";
                }
            } else if (height > winH) {
                hints.style.height = (winH - 5) + "px";
                hints.style.top = (top = pos.bottom - box.top) + "px";
                hints2.style.top = (top = pos.bottom - box.top) + "px";
                var cursor = cm.getCursor();
                if (data.from.ch != cursor.ch) {
                    pos = cm.cursorCoords(cursor);
                    hints.style.left = (left = pos.left) + "px";
                    hints2.style.left = parseInt(String(hints.style.left).replace("px", ""))
                        - parseInt(String(hints.style.width).replace("px", "")) - 50 + "px";
                    box = hints.getBoundingClientRect();
                }
            }
        } else {
            if (curTop - height > 0) {
                let bellowGap = winH - (top = pos.top - height) - height;
                below = false;
                if (bellowGap > hints2Height) {
                    below = true;
                }
                if (hints.scrollWidth > hints.clientWidth) {
                    if (below == true) {
                        hints.style.top = pos.top + 14 + "px";
                        hints2.style.top = hints.style.top;
                    } else {
                        hints.style.top = (pos.top - height) - 18 + "px";
                        hints2.style.top = (pos.top - hints2Height) + 44 + "px";
                    }
                } else {
                    if (below == true) {
                        hints.style.top = pos.top + 14 + "px";
                        hints2.style.top = hints.style.top;
                    } else {
                        hints.style.top = (pos.top - height) + "px";
                        hints2.style.top = (pos.top - hints2Height) + 49 + "px";
                    }
                }
            } else if (height > winH) {
                hints.style.height = (winH - 5) + "px";
                hints.style.top = (top = pos.bottom - box.top) + "px";
                hints2.style.top = (top = pos.bottom - box.top) + "px";
                let cursor = cm.getCursor();
                if (data.from.ch != cursor.ch) {
                    pos = cm.cursorCoords(cursor);
                    hints.style.left = (left = pos.left) + "px";
                    hints2.style.left = parseInt(String(hints.style.left).replace("px", ""))
                        - parseInt(String(hints2.style.width).replace("px", "")) - 5 + "px";
                    box = hints.getBoundingClientRect();
                }
            }
        }

        var overlapX = box.right - winW;
        if (overlapX > 0) {
            if (box.right - box.left > winW) {
                hints.style.width = (winW - 5) + "px";
                overlapX -= (box.right - box.left) - winW;
            }
            hints.style.left = (left = pos.left - overlapX) + "px";
            hints2.style.left = parseInt(String(hints.style.left).replace("px", ""))
                - parseInt(String(hints.style.width).replace("px", "")) - 50 + "px";
        }

        (completion.options.container || document.body).appendChild(hints2);

        cm.addKeyMap(this.keyMap = buildKeyMap(completion, {
            moveFocus: function (n, avoidWrap) {
                widget.changeActive(widget.selectedHint + n, avoidWrap);
            },
            setFocus: function (n) {
                widget.changeActive(n);
            },
            menuSize: function () {
                return widget.screenAmount();
            },
            length: completions.length,

            close: function () {
                completion.close();
            },
            pick: function () {
                widget.pick();
            },
            data: data
        }));

        if (completion.options.closeOnUnfocus) {
            var closingOnBlur;
            cm.on("blur", this.onBlur = function () {
                closingOnBlur = setTimeout(function () {
                    completion.close();
                }, 100);
            });
            cm.on("focus", this.onFocus = function () {
                clearTimeout(closingOnBlur);
            });
        }

        var startScroll = cm.getScrollInfo();
        cm.on("scroll", this.onScroll = function () {
            var curScroll = cm.getScrollInfo(), editor = cm.getWrapperElement().getBoundingClientRect();
            var newTop = top + startScroll.top - curScroll.top;
            var point = newTop - (window.pageYOffset || (document.documentElement || document.body).scrollTop);
            if (!below) point += hints.offsetHeight;
            if (point <= editor.top || point >= editor.bottom) return completion.close();
            hints.style.top = newTop + "px";
            hints.style.left = (left + startScroll.left - curScroll.left) + "px";
        });

        CodeMirror.on(hints, "dblclick", function (e) {
            var t = getHintElement(hints, e.target || e.srcElement);
            if (t && t.hintId != null) {
                widget.changeActive(t.hintId);
                widget.pick();
            }
        });

        CodeMirror.on(hints, "click", function (e) {
            var t = getHintElement(hints, e.target || e.srcElement);
            if (t && t.hintId != null) {
                widget.changeActive(t.hintId);
                if (completion.options.completeOnSingleClick) widget.pick();
            }
        });

        CodeMirror.on(hints, "mousedown", function () {
            setTimeout(function () {
                cm.focus();
            }, 20);
        });

        CodeMirror.signal(data, "select", completions[0], hints.firstChild);
        //设置水平滚动条
        hints.style.overflowX = "auto";
        hints2.style.overflowX = "auto";
        return true;
    }

    function Widget(completion, data) {
        this.completion = completion;
        this.data = data;
        this.picked = false;
        var widget = this, cm = completion.cm;

        var hints = this.hints = document.createElement("ul");
        hints.className = "CodeMirror-hints";
        this.selectedHint = data.selectedHint || 0;

        var completions = data.list;
        for (var i = 0; i < completions.length; ++i) {
            var liElement = document.createElement("li");
            var elt = hints.appendChild(liElement), cur = completions[i];
            var className = HINT_ELEMENT_CLASS + (i != this.selectedHint ? "" : " " + ACTIVE_HINT_ELEMENT_CLASS);
            if (cur.className != null) className = cur.className + " " + className;
            elt.className = className;
            if (cur.render) cur.render(elt, data, cur);
            else elt.appendChild(document.createTextNode(cur.displayText || getText(cur)));
            elt.hintId = i;
        }

        var pos = cm.cursorCoords(completion.options.alignWithWord ? data.from : null);
        var left = pos.left, top = pos.bottom, below = true;
        hints.style.left = left + "px";
        hints.style.top = top + "px";

        // If we're at the edge of the screen, then we want the menu to appear on the left of the cursor.
        var winW = window.innerWidth || Math.max(document.body.offsetWidth, document.documentElement.offsetWidth);
        var winH = window.innerHeight || Math.max(document.body.offsetHeight, document.documentElement.offsetHeight);
        (completion.options.container || document.body).appendChild(hints);
        var box = hints.getBoundingClientRect(), overlapY = box.bottom - winH;
        if (overlapY > 0) {
            var height = box.bottom - box.top, curTop = pos.top - (pos.bottom - box.top);
            if (curTop - height > 0) { // Fits above cursor
                hints.style.top = (top = pos.top - height) + "px";
                below = false;
            } else if (height > winH) {
                hints.style.height = (winH - 5) + "px";
                hints.style.top = (top = pos.bottom - box.top) + "px";
                var cursor = cm.getCursor();
                if (data.from.ch != cursor.ch) {
                    pos = cm.cursorCoords(cursor);
                    hints.style.left = (left = pos.left) + "px";
                    box = hints.getBoundingClientRect();
                }
            }
        }
        var overlapX = box.right - winW;
        if (overlapX > 0) {
            if (box.right - box.left > winW) {
                hints.style.width = (winW - 5) + "px";
                overlapX -= (box.right - box.left) - winW;
            }
            hints.style.left = (left = pos.left - overlapX) + "px";
        }

        cm.addKeyMap(this.keyMap = buildKeyMap(completion, {
            moveFocus: function (n, avoidWrap) {
                widget.changeActive(widget.selectedHint + n, avoidWrap);
            },
            setFocus: function (n) {
                widget.changeActive(n);
            },
            menuSize: function () {
                return widget.screenAmount();
            },
            length: completions.length,
            close: function () {
                completion.close();
            },
            pick: function () {
                widget.pick();
            },
            data: data
        }));

        if (completion.options.closeOnUnfocus) {
            var closingOnBlur;
            cm.on("blur", this.onBlur = function () {
                closingOnBlur = setTimeout(function () {
                    completion.close();
                }, 100);
            });
            cm.on("focus", this.onFocus = function () {
                clearTimeout(closingOnBlur);
            });
        }

        var startScroll = cm.getScrollInfo();
        cm.on("scroll", this.onScroll = function () {
            var curScroll = cm.getScrollInfo(), editor = cm.getWrapperElement().getBoundingClientRect();
            var newTop = top + startScroll.top - curScroll.top;
            var point = newTop - (window.pageYOffset || (document.documentElement || document.body).scrollTop);
            if (!below) point += hints.offsetHeight;
            if (point <= editor.top || point >= editor.bottom) return completion.close();
            hints.style.top = newTop + "px";
            hints.style.left = (left + startScroll.left - curScroll.left) + "px";
        });

        CodeMirror.on(hints, "dblclick", function (e) {
            var t = getHintElement(hints, e.target || e.srcElement);
            if (t && t.hintId != null) {
                widget.changeActive(t.hintId);
                widget.pick();
            }
        });

        CodeMirror.on(hints, "click", function (e) {
            var t = getHintElement(hints, e.target || e.srcElement);
            if (t && t.hintId != null) {
                widget.changeActive(t.hintId);
                if (completion.options.completeOnSingleClick) widget.pick();
            }
        });

        CodeMirror.on(hints, "mousedown", function () {
            setTimeout(function () {
                cm.focus();
            }, 20);
        });

        CodeMirror.signal(data, "select", completions[0], hints.firstChild);
        return true;
    }

    Widget.prototype = {
        close: function () {
            if (this.completion.widget != this) return;
            this.completion.widget = null;
            this.hints.parentNode.removeChild(this.hints);
            try {
                this.hints2.parentNode.removeChild(this.hints2);//此处消失
            } catch (e) {

            }
            this.completion.cm.removeKeyMap(this.keyMap);

            var cm = this.completion.cm;
            if (this.completion.options.closeOnUnfocus) {
                cm.off("blur", this.onBlur);
                cm.off("focus", this.onFocus);
            }
            cm.off("scroll", this.onScroll);
        },

        disable: function () {
            this.completion.cm.removeKeyMap(this.keyMap);
            var widget = this;
            this.keyMap = {
                Enter: function () {
                    widget.picked = true;
                }
            };
            this.completion.cm.addKeyMap(this.keyMap);
        },

        pick: function () {
            this.completion.pick(this.data, this.selectedHint);
        },

        changeActive: function (i, avoidWrap) {
            if (i >= this.data.list.length)
                i = avoidWrap ? this.data.list.length - 1 : 0;
            else if (i < 0)
                i = avoidWrap ? 0 : this.data.list.length - 1;
            if (this.selectedHint == i) return;
            var node = this.hints.childNodes[this.selectedHint];
            node.className = node.className.replace(" " + ACTIVE_HINT_ELEMENT_CLASS, "");
            node = this.hints.childNodes[this.selectedHint = i];
            node.className += " " + ACTIVE_HINT_ELEMENT_CLASS;
            if (node.offsetTop < this.hints.scrollTop)
                this.hints.scrollTop = node.offsetTop - 3;
            else if (node.offsetTop + node.offsetHeight > this.hints.scrollTop + this.hints.clientHeight)
                this.hints.scrollTop = node.offsetTop + node.offsetHeight - this.hints.clientHeight + 3;
            CodeMirror.signal(this.data, "select", this.data.list[this.selectedHint], node);
        },

        screenAmount: function () {
            return Math.floor(this.hints.clientHeight / this.hints.firstChild.offsetHeight) || 1;
        }
    };

    Widget1.prototype = {
        close: function () {
            if (this.completion.widget != this) return;
            this.completion.widget = null;
            this.hints.parentNode.removeChild(this.hints);
            try {
                this.hints2.parentNode.removeChild(this.hints2);//此处消失
            } catch (e) {

            }
            this.completion.cm.removeKeyMap(this.keyMap);
            var cm = this.completion.cm;
            if (this.completion.options.closeOnUnfocus) {
                cm.off("blur", this.onBlur);
                cm.off("focus", this.onFocus);
            }
            cm.off("scroll", this.onScroll);
        },

        disable: function () {
            this.completion.cm.removeKeyMap(this.keyMap);
            var widget = this;
            this.keyMap = {
                Enter: function () {
                    widget.picked = true;
                }
            };
            this.completion.cm.addKeyMap(this.keyMap);
        },

        pick: function () {
            if (this.completion.options.ignorePick) return;
            this.completion.pick(this.data, this.selectedHint);
        },

        changeActive: function (i, avoidWrap) {
            try {

                var length = this.data.list.length;
                if (length == i) {
                    i = 0;
                }
                if (-1 == i) {
                    i = length - 1;
                }
                this.hints2.innerHTML = "";
                var elt = this.hints2.appendChild(document.createElement("li"));


                var key = this.data.key;
                var index = i;
                if (typeof (key) != "undefined") {
                    key = key.replace(",", "").replace(",", "").replace("(", "").replace(")", "").replace(" ", "");
                    var showList = this.data.showList;
                    index = showList[i];
                } else {
                    //var key = "";
                    if (this.data.list[0].indexOf("sendMail") > -1) {
                        key = "sendMail";
                    } else {
                        key = this.data.list[0].replace(",", "").replace("(", "").replace(",", "").replace(")", "").replace(" ", "");
                    }
                }
                if (this.completion.options.ignorePick){
                    buildRefHints2(this.hints2, index);
                }else {
                    elt.appendChild(document.createTextNode(yigoFrontFnsExplain[index]));
                }

            } catch (e) {

            }

            if (i >= this.data.list.length)
                i = avoidWrap ? this.data.list.length - 1 : 0;
            else if (i < 0)
                i = avoidWrap ? 0 : this.data.list.length - 1;
            if (this.selectedHint == i) return;
            var node = this.hints.childNodes[this.selectedHint];
            node.className = node.className.replace(" " + ACTIVE_HINT_ELEMENT_CLASS, "");
            node = this.hints.childNodes[this.selectedHint = i];
            node.className += " " + ACTIVE_HINT_ELEMENT_CLASS;
            if (node.offsetTop < this.hints.scrollTop)
                this.hints.scrollTop = node.offsetTop - 3;
            else if (node.offsetTop + node.offsetHeight > this.hints.scrollTop + this.hints.clientHeight)
                this.hints.scrollTop = node.offsetTop + node.offsetHeight - this.hints.clientHeight + 3;
            CodeMirror.signal(this.data, "select", this.data.list[this.selectedHint], node);
        },

        screenAmount: function () {
            return Math.floor(this.hints.clientHeight / this.hints.firstChild.offsetHeight) || 1;
        }
    };

    function applicableHelpers(cm, helpers) {
        if (!cm.somethingSelected()) return helpers
        var result = []
        for (var i = 0; i < helpers.length; i++)
            if (helpers[i].supportsSelection) result.push(helpers[i])
        return result
    }

    function resolveAutoHints(cm, pos) {
        var helpers = cm.getHelpers(pos, "hint"), words
        if (helpers.length) {
            var async = false, resolved
            for (var i = 0; i < helpers.length; i++) if (helpers[i].async) async = true
            if (async) {
                resolved = function (cm, callback, options) {
                    var app = applicableHelpers(cm, helpers)

                    function run(i, result) {
                        if (i == app.length) return callback(null)
                        var helper = app[i]
                        if (helper.async) {
                            helper(cm, function (result) {
                                if (result) callback(result)
                                else run(i + 1)
                            }, options)
                        } else {
                            var result = helper(cm, options)
                            if (result) callback(result)
                            else run(i + 1)
                        }
                    }

                    run(0)
                }
                resolved.async = true
            } else {
                resolved = function (cm, options) {
                    var app = applicableHelpers(cm, helpers)
                    for (var i = 0; i < app.length; i++) {
                        var cur = app[i](cm, options)
                        if (cur && cur.list.length) return cur
                    }
                }
            }
            resolved.supportsSelection = true
            return resolved
        } else if (words = cm.getHelper(cm.getCursor(), "hintWords")) {
            return function (cm) {
                return CodeMirror.hint.fromList(cm, {words: words})
            }
        } else if (CodeMirror.hint.anyword) {
            return function (cm, options) {
                return CodeMirror.hint.anyword(cm, options)
            }
        } else {
            return function () {
            }
        }
    }

    /*
    构建引用详细信息显示框
     */
    function buildRefHints2(hints2, index){
        hints2.innerHTML="";
        var lines = yigoFrontFnsExplain[index].split("{n}");
        for (let i = 0; i < lines.length; i++) {
            var liEl = hints2.appendChild(document.createElement("li"))
            liEl.appendChild(document.createTextNode(lines[i]));
            if (i === 1){
                liEl.className = "cm-searching";
            }
            if ((i+1)%2 !== 0){
                liEl.style.fontWeight = "bold";
            }
        }
    }

    CodeMirror.registerHelper("hint", "auto", {
        resolve: resolveAutoHints
    });

    CodeMirror.registerHelper("hint", "fromList", function (cm, options) {
        var cur = cm.getCursor(), token = cm.getTokenAt(cur);
        var to = CodeMirror.Pos(cur.line, token.end);
        if (token.string && /\w/.test(token.string[token.string.length - 1])) {
            var term = token.string, from = CodeMirror.Pos(cur.line, token.start);
        } else {
            var term = "", from = to;
        }
        var found = [];
        for (var i = 0; i < options.words.length; i++) {
            var word = options.words[i];
            if (word.slice(0, term.length) == term)
                found.push(word);
        }

        if (found.length) return {list: found, from: from, to: to};
    });

    CodeMirror.commands.autocomplete = CodeMirror.showHint;

    var defaultOptions = {
        hint: CodeMirror.hint.auto,
        completeSingle: true,
        alignWithWord: true,
        closeCharacters: /[\s()\[\]{};:>,]/,
        closeOnUnfocus: true,
        completeOnSingleClick: true,
        container: null,
        customKeys: null,
        extraKeys: null
    };

    CodeMirror.defineOption("hintOptions", null);
});