package com.bokesoft.yes.helper;

import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.xml.node.Xml4jUtil;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaDataObjectLoad;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaDataObjectSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.common.MetaExtendCollection;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

import java.util.*;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class DataObjectHelper {
    public static final String MODULE_KEY = "D_DataObjectModule";
    public static final BiConsumer<ProfileInfo, MetaTableCollection> tableHandler = (targetProfileInfo, tableCollection) -> {
        for (MetaTable table : tableCollection) {
            table.setKey(targetProfileInfo.getKey());
            table.setCaption(targetProfileInfo.getCaption());
            table.setPersist(true);
        }
    };

    public static MetaDataObjectProfile getProfile(String dataObjectKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        return dataObjectList.get(dataObjectKey);
    }

    public static MetaDataObject loadByKey(String dataObjectKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();

        MetaDataObjectProfile dataObjectProfile = metaFactory.getDataObjectList().get(dataObjectKey);
        String resource = dataObjectProfile.getResource();
        IMetaProject project = dataObjectProfile.getProject();

        IMetaResolver resolver = metaFactory.getProjectResolver(project.getKey());
        MetaDataObjectLoad load = new MetaDataObjectLoad(AppRunType.Dev);
        load.load(resolver, resource);

        MetaDataObject metaDataObject = (MetaDataObject) load.getRootMetaObject();
        metaDataObject.setProject(project);
        return metaDataObject;
    }

    public static String createXml(MetaDataObject dataObject) throws Throwable {
        MetaDataObjectSave metaDataObjectSave = new MetaDataObjectSave(dataObject);
        Document document = metaDataObjectSave.getDocument();
        XmlCreator creator = new XmlCreator(document, null);
        String extend = dataObject.getExtend();
        if (StringUtils.isBlank(extend)) {
            return creator.createXml();
        }

        String extendFilePath = LoadFileTree.getPathByDataObject(extend);
        String tmpFilePath = XmlFileProcessor.instance.getTmpFile(extendFilePath);
        String realFilePath = StringUtils.isNotBlank(tmpFilePath) ? tmpFilePath : extendFilePath;
        XmlTree xmlTree = Xml4jUtil.parseTree(realFilePath);

        TagNode rootNode = DataObjectHelper.createVestNode(creator.createXmlTree().getRoot(), xmlTree);
        assert rootNode != null;
        rootNode.setAttribute(ConstantUtil.CAPTION, dataObject.getCaption());
        rootNode.setAttribute(ConstantUtil.EXTEND, extend);
        rootNode.setAttribute(ConstantUtil.PRIMARY_TABLE_KEY, dataObject.getMainTableKey());
        rootNode.setAttribute(ConstantUtil.VERSION, "1");
        return rootNode.toXml(0);
    }

    public static MetaDataObjectProfile createInsideProfile(MetaForm metaForm) throws Throwable {
        final MetaDataObject sourceDataObject = DataObjectHelper.getProfile(MODULE_KEY).getDataObject();
        ProfileInfo targetProfileInfo = ProfileInfo.getInstance(metaForm);
        return DataObjectHelper.createProfile(sourceDataObject, targetProfileInfo);
    }

    public static MetaDataObjectProfile createOutsideProfile(String key, String caption, String projectKey, String parentKey) throws Throwable {
        if (StringUtils.isBlank(parentKey)) {
            final MetaDataObjectProfile sourceProfile = DataObjectHelper.getProfile(MODULE_KEY);
            final MetaDataObject sourceDataObject = sourceProfile.getDataObject();
            ProfileInfo targetProfileInfo = ProfileInfo.getInstance(key, caption, projectKey);
            return DataObjectHelper.createProfile(sourceDataObject, targetProfileInfo);
        }

        // 马甲
        final MetaDataObjectProfile sourceProfile = DataObjectHelper.getProfile(parentKey);
        final MetaDataObject sourceDataObject = sourceProfile.getDataObject();

        String mainTableKey = sourceDataObject.getMainTableKey();
        ProfileInfo targetProfileInfo = ProfileInfo.getInstance(key, caption, projectKey, mainTableKey, parentKey);
        MetaDataObjectProfile targetProfile = DataObjectHelper.createProfile(sourceDataObject, targetProfileInfo);
//        MetaDataObject targetDataObject = targetProfile.getDataObject();

//        MetaTableCollection sourceTableCollection = targetDataObject.getTableCollection();
//        MetaTableCollection targetTableCollection = MetaObjectHelper.clone(sourceTableCollection);
//        targetTableCollection.setTableLogicList(new ArrayList<>());
//        targetTableCollection.clear();
//        for (MetaTable metaTable : sourceTableCollection) {
//            if (StringUtils.endsWithAny(metaTable.getKey(), "_CF", MetaFormNODBProcess.STR_NODBTable_Profix)) {
//                continue;
//            }
//            targetTableCollection.add(metaTable);
//        }
//        targetTableCollection.doPostProcess(mainTableKey);
//        targetDataObject.setTableCollection(targetTableCollection);
        return targetProfile;
    }

    public static List<MetaFormProfile> reload(DefaultContext context,String dataObjectKey, String dataObjectFilePath, String formFilePath) throws Throwable {
        return reload(context,dataObjectKey, dataObjectFilePath, formFilePath, null);
    }

    /**
     *
     * @param dataObjectKey
     * @param dataObjectFilePath
     * @param formFilePath
     * @param snapshotFilePath 快照文件路径
     * @return
     * @throws Throwable
     */
    public static List<MetaFormProfile> reload(DefaultContext context,String dataObjectKey, String dataObjectFilePath, String formFilePath, String snapshotFilePath) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(dataObjectKey);

        String mergeToSourceMapKey = ""; // 数据对象马甲Key
        Set<MetaFormProfile> allMetaFormProfiles = new HashSet<>();
        if (Objects.nonNull(metaDataObjectProfile)) {
            if (StringUtils.isNotBlank(metaDataObjectProfile.getExtend())) {
                String extendPath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObjectProfile.getExtend());
                String tempPath = XmlFileProcessor.instance.getTmpFile(extendPath);
                extendPath = StringUtils.isNotBlank(tempPath) ? tempPath : extendPath;
                List<MetaFormProfile> metaFormProfiles = DesignReloadMetaObject.reloadMetaDataObjectRollbackError(metaDataObjectProfile.getExtend(), extendPath);
                allMetaFormProfiles.addAll(metaFormProfiles);
            } else {
                for (MetaDataObjectProfile dataObjectProfile : dataObjectList) {
                    if (StringUtils.equals(dataObjectProfile.getExtend(), dataObjectKey)) {
                        mergeToSourceMapKey = dataObjectProfile.getKey();
                        break;
                    }
                }
            }
        }

        List<MetaFormProfile> metaFormProfiles = DesignReloadMetaObject.reloadMetaDataObjectRollbackError(dataObjectKey, dataObjectFilePath, formFilePath, snapshotFilePath);
        allMetaFormProfiles.addAll(metaFormProfiles);

        if (StringUtils.isNotBlank(mergeToSourceMapKey) && Objects.nonNull(dataObjectList.get(mergeToSourceMapKey))) {
            String vestPath = LoadFileTree.loadFilePathByDataObjectFieldKey(mergeToSourceMapKey);
            String tempVestPath = XmlFileProcessor.instance.getTmpFile(vestPath);
            vestPath = StringUtils.isNotBlank(tempVestPath) ? tempVestPath : vestPath;
            List<MetaFormProfile> metaFormProfiles3 = DesignReloadMetaObject.reloadMetaDataObjectRollbackError(mergeToSourceMapKey, vestPath);
            allMetaFormProfiles.addAll(metaFormProfiles3);
        }

        Map<String, MetaFormProfile> profileMap = allMetaFormProfiles.stream().collect(Collectors.toMap(MetaFormProfile::getKey, Function.identity(), (itemA, itemB) -> itemB));
        MetaFormList metaFormList = metaFactory.getMetaFormList();

        List<String> resultKeyList = new ArrayList<>();
        List<MetaFormProfile> resultProfileList = new ArrayList<>();
        for (Map.Entry<String, MetaFormProfile> entry : profileMap.entrySet()) {
            String formKey = entry.getKey();
            if (resultKeyList.contains(formKey)) {
                continue;
            }
            MetaFormProfile profile = entry.getValue();
            if (profile .getResource() == null){
                continue;
            }
            String parentKey = profile.getExtend();
            if (StringUtils.isNotBlank(parentKey) && !resultKeyList.contains(parentKey)) {
                resultKeyList.add(parentKey);
                MetaFormProfile parentProfile = profileMap.getOrDefault(parentKey, metaFormList.get(parentKey));
                resultProfileList.add(parentProfile);
            }
            resultKeyList.add(formKey);
            resultProfileList.add(profile);
        }

        List<MetaFormProfile> sortedReloadFormList = sortNeedReloadFormList(metaFormList, resultProfileList);
        DesignReloadMetaObject.postReloadMetaDataObject(context,dataObjectKey, sortedReloadFormList, formFilePath);
        return resultProfileList;
    }

    public static Set<MetaFormProfile> getAllMetaFormProfilesByDataObjectKey(String dataObjectKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(dataObjectKey);

        String mergeToSourceMapKey = ""; // 数据对象马甲Key
        Set<MetaFormProfile> allMetaFormProfiles = new HashSet<>();
        if (Objects.nonNull(metaDataObjectProfile)) {
            if (StringUtils.isNotBlank(metaDataObjectProfile.getExtend())) {
                List<MetaFormProfile> metaFormProfiles = DesignReloadMetaObject.getReloadMetaFormProfiles(metaDataObjectProfile.getExtend(), metaFactory);
                allMetaFormProfiles.addAll(metaFormProfiles);
            } else {
                for (MetaDataObjectProfile dataObjectProfile : dataObjectList) {
                    if (StringUtils.equals(dataObjectProfile.getExtend(), dataObjectKey)) {
                        mergeToSourceMapKey = dataObjectProfile.getKey();
                        break;
                    }
                }
            }
        }
        List<MetaFormProfile> metaFormProfiles = DesignReloadMetaObject.getReloadMetaFormProfiles(dataObjectKey, metaFactory);
        allMetaFormProfiles.addAll(metaFormProfiles);

        if (StringUtils.isNotBlank(mergeToSourceMapKey) && Objects.nonNull(dataObjectList.get(mergeToSourceMapKey))) {
            List<MetaFormProfile> metaFormProfiles3 = DesignReloadMetaObject.getReloadMetaFormProfiles(mergeToSourceMapKey, metaFactory);
            allMetaFormProfiles.addAll(metaFormProfiles3);
        }

        return allMetaFormProfiles;
    }
    private static MetaDataObjectProfile createProfile(MetaDataObject sourceDataObject, ProfileInfo targetProfileInfo) throws Throwable {
        // data object
        MetaDataObject dataObject = (MetaDataObject) sourceDataObject.depthClone();
        dataObject.setKey(targetProfileInfo.getKey());
        dataObject.setExtend(targetProfileInfo.getExtend());
        dataObject.setCaption(targetProfileInfo.getCaption());
        dataObject.setMainTableKey(targetProfileInfo.getMainTableKey());
        dataObject.setProject(targetProfileInfo.getProject());
        dataObject.setPrimaryType(targetProfileInfo.getPrimaryType());
        dataObject.setVersion(1);
        if (targetProfileInfo.getPrimaryType() == DataObjectPrimaryType.VIRTUAL) {
            dataObject.setPrimaryType(DataObjectPrimaryType.TEMPLATE);
        }
        if (StringUtils.isNotBlank(targetProfileInfo.getExtend())) {
            sourceDataObject.setMergeToSourceMapKey(targetProfileInfo.getKey());
        } else {
            MetaTableCollection tableCollection = dataObject.getTableCollection();
            MetaTableCollection collection = new MetaTableCollection();
            dataObject.setTableCollection(collection);
            for (MetaTable table : tableCollection) {
                table.setKey(targetProfileInfo.getKey());
                table.setCaption(targetProfileInfo.getCaption());
                table.setPersist(true);
                collection.add(table);
            }
        }
        dataObject.doPostProcess(0, null);
        // data object profile
        MetaDataObjectProfile dataObjectProfile = new MetaDataObjectProfile();
        dataObjectProfile.setKey(targetProfileInfo.getKey());
        dataObjectProfile.setExtend(targetProfileInfo.getExtend());
        dataObjectProfile.setCaption(targetProfileInfo.getCaption());
        dataObjectProfile.setResource(targetProfileInfo.getResource());
        dataObjectProfile.setDataObject(dataObject);
        dataObjectProfile.setProject(targetProfileInfo.getProject());
        dataObjectProfile.setPrimaryType(targetProfileInfo.getPrimaryType());
        dataObjectProfile.setSecondaryType(targetProfileInfo.getSecondaryType());
        return dataObjectProfile;
    }

    private static TagNode createVestNode(TagNode node, XmlTree xmlTree) {
        String tagName = node.getTagName();
        if (StringUtils.equalsAnyIgnoreCase(tagName, MetaEmbedTableCollection.TAG_NAME, MetaPreLoadProcess.TAG_NAME, MetaPostLoadProcess.TAG_NAME, MetaPreSaveProcess.TAG_NAME,
                MetaPostSaveProcess.TAG_NAME, MetaPreDeleteProcess.TAG_NAME,MetaTableCollection.TAG_NAME, MetaPostDeleteProcess.TAG_NAME, MetaStatusCollection.TAG_NAME, MetaStatusTriggerCollection.TAG_NAME,
                MetaExtendCollection.TAG_NAME, MetaCheckRuleCollection.TAG_NAME, MetaMacroCollection.TAG_NAME)) {
            return null;
        }

        if (StringUtils.equals(tagName, ConstantUtil.TABLE)) {
            String key = node.getAttributes().get(ConstantUtil.KEY);
            if (!xmlTree.containKey(ConstantUtil.TABLE + "@" + key)) {
                return null;
            }
        }

        String attrName = node.getPrimaryAttrName();
        TagNode vestNode = new TagNode(tagName);
        if (StringUtils.isNotBlank(attrName)) {
            vestNode.setAttribute(attrName, node.getAttributes().get(attrName));
        }

        if (StringUtils.equals(tagName, ConstantUtil.TABLE)) {
            return vestNode;
        }
        List<AbstractNode> childNodeList = node.getChildren();
        for (AbstractNode childNode : childNodeList) {
            if (!(childNode instanceof TagNode)) {
                continue;
            }
            TagNode vestChildNode = DataObjectHelper.createVestNode((TagNode) childNode, xmlTree);
            if (Objects.isNull(vestChildNode)) {
                continue;
            }
            vestNode.addNode(vestChildNode);
        }
        return vestNode;
    }

    private static List<MetaFormProfile> sortNeedReloadFormList(MetaFormList metaFormList, List<MetaFormProfile> resultProfileList) {
        List<MetaFormProfile> templateFormList = resultProfileList.stream()
                .filter(item -> item.getFormType() == FormType.Template)
                .sorted(Comparator.comparing(MetaFormProfile::getKey))
                .collect(Collectors.toList());
        List<MetaFormProfile> templateSortFormList = getNeedReloadFormList(metaFormList, templateFormList);

        List<MetaFormProfile> notTemplateFormList = resultProfileList.stream()
                .filter(item -> item.getFormType() != FormType.Template)
                .sorted(Comparator.comparing(MetaFormProfile::getKey))
                .collect(Collectors.toList());
        List<MetaFormProfile> notTemplateSortFormList = getNeedReloadFormList(metaFormList, notTemplateFormList);

        List<MetaFormProfile> sortedReloadFormList = new ArrayList<>();
        sortedReloadFormList.addAll(templateSortFormList);
        sortedReloadFormList.addAll(notTemplateSortFormList);
        return sortedReloadFormList;
    }

    private static List<MetaFormProfile> getNeedReloadFormList(MetaFormList metaFormList, List<MetaFormProfile> resultProfileList) {
        List<MetaFormProfile> firstReloadFormList = resultProfileList.stream()
                .filter(item -> StringUtils.isNotBlank(item.getExtend())).map(item -> metaFormList.get(item.getExtend()))
                .distinct()
                .sorted(Comparator.comparing(MetaFormProfile::getKey))
                .collect(Collectors.toList());
        List<MetaFormProfile> secondReloadFormList = resultProfileList.stream()
                .filter(item -> StringUtils.isNotBlank(item.getExtend()) && item.getMergeToSource())
                .sorted(Comparator.comparing(MetaFormProfile::getKey))
                .collect(Collectors.toList());
        List<MetaFormProfile> thirdReloadFormList = resultProfileList.stream()
                .filter(item -> !firstReloadFormList.contains(item) && !secondReloadFormList.contains(item))
                .sorted(Comparator.comparing(MetaFormProfile::getKey))
                .collect(Collectors.toList());

        List<MetaFormProfile> sortedReloadFormList = new ArrayList<>();
        sortedReloadFormList.addAll(firstReloadFormList);
        sortedReloadFormList.addAll(secondReloadFormList);
        sortedReloadFormList.addAll(thirdReloadFormList);
        return sortedReloadFormList;
    }
}

class ProfileInfo {
    private String key;
    private String caption;
    private String resource;
    private String extend = "";
    private String mainTableKey;
    private int primaryType = DataObjectPrimaryType.ENTITY;
    private IMetaProject project;

    public static ProfileInfo getInstance(MetaForm metaForm) {
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.key = metaForm.getKey();
        profileInfo.mainTableKey = metaForm.getKey();
        profileInfo.caption = metaForm.getKey();
        profileInfo.project = metaForm.getProject();
        if (metaForm.getFormType() == FormType.Template) {
            profileInfo.primaryType = DataObjectPrimaryType.VIRTUAL;
        }
        return profileInfo;
    }

    public static ProfileInfo getInstance(String key, String caption, String projectKey) throws Throwable {
        return getInstance(key, caption, projectKey, null, null);
    }

    public static ProfileInfo getInstance(String key, String caption, String projectKey, String mainTableKey, String parentKey) throws Throwable {
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.key = key;
        profileInfo.caption = caption;
        profileInfo.resource = "DataObject/" + key + ".xml";
        if (StringUtils.isNotBlank(mainTableKey)) {
            profileInfo.mainTableKey = mainTableKey;
        } else {
            profileInfo.mainTableKey = key;
        }
        if (StringUtils.isNotBlank(parentKey)) {
            profileInfo.extend = parentKey;
        }
        profileInfo.project = MetaFactory.getGlobalInstance().getMetaProject(projectKey);
        return profileInfo;
    }

    public String getKey() {
        return key;
    }

    public String getCaption() {
        return caption;
    }

    public String getResource() {
        return resource;
    }

    public String getExtend() {
        return extend;
    }

    public String getMainTableKey() {
        return mainTableKey;
    }

    public int getPrimaryType() {
        return primaryType;
    }

    @SuppressWarnings("SameReturnValue")
    public int getSecondaryType() {
        return DataObjectSecondaryType.NORMAL;
    }

    public IMetaProject getProject() {
        return project;
    }
}