package com.bokesoft.yes.design.xml.node;

import com.bokesoft.yes.design.xml.parse.Element;

public class CDataNode extends AbstractNode {
	
	public CDataNode(String text, Element element) {
		super(text, element);
	}

	@Override
	public String toXml(int level) {
		StringBuilder strBuilder = new StringBuilder();
		appendLevelBlank(strBuilder, level);
		strBuilder.append("<![CDATA[").append(getText()).append("]]>");
		return strBuilder.toString();
	}

	@Override
	public AbstractNode clone() {
		return new CDataNode(this.getText(), null);
	}

	@Override
	public boolean hasPrimaryAttribute() {
		return false;
	}

	public void setText(String text) {
		this.text = text;
	}
}
