package com.bokesoft.yes.design.utils;

import com.bokesoft.yes.design.cmd.*;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.Tree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.vo.CheckXSDResult;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefSave;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaDataObjectSave;
import com.bokesoft.yes.meta.persist.dom.entry.MetaEntrySave;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.Xml4jUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

import java.io.File;
import java.util.List;
import java.util.Set;

public class MetaUtils {

    public static void saveMetaCommonDef(IMetaFactory metaFactory, MetaCommonDef metaCommonDef, String filePath, String fileName, String projectKey,
                                         String solutionKey, List<UICommand> result, String content) throws Throwable {
        File file = new File(filePath);
        MetaCommonDefSave save = new MetaCommonDefSave(metaCommonDef);
        Document newDocument = save.getDocument();
        String newXml = getNewXml(file.getAbsolutePath(), newDocument);
        CheckXSDUtils.checkXSD(metaFactory, MetaCommonDef.TAG_NAME, "", fileName, newXml, "", metaCommonDef, null);
        FileUtils.writeStringToFile(file, newXml, "UTF-8");
        XmlFileProcessor.instance.clearTmpFile(filePath);
        CommonDefProcessor.getInstance().reloadCommonDef(projectKey, solutionKey);
        result.add(UICommand.reloadMenuTree());
    }

    public static void saveMetaForm(IMetaFactory metaFactory, MetaForm metaForm, String filePath, String formKey, String cmd, String oldContent,
                                    String fileName, List<UICommand> result, DefaultContext context) throws Throwable {
        String newXml = getNewXml(filePath, metaForm, null);
        CheckXSDUtils.checkXSD(metaFactory, MetaForm.TAG_NAME, formKey, fileName, newXml, "", null, null);
        FileUtils.writeStringToFile(new File(filePath), newXml, "UTF-8");
        SaveFileContentCmd.reloadForm(metaFactory, formKey, result);
        if (metaForm.getDataSource() != null) {
            RebuildTableUtil.rebuildTable(context, filePath);
        }
        XmlFileProcessor.recycleToTmpFormAndFileMap.remove("Entry@Entry" + formKey);
        result.add(UICommand.reloadXmlSource(filePath));
        SaveFileContentCmd.reloadDataObjects(result, metaFactory, filePath);
        SaveFilesByFormKeyCmd.removeScopeCache(metaForm, metaFactory, result);
        XmlFileProcessor.instance.clearTmpFile(filePath);
    }


    public static void saveMetaDataObject(IMetaFactory metaFactory, MetaDataObject metaDataObject, String filePath, String formKey, String cmd,
                                          String oldContent, String fileName, List<UICommand> result, DefaultContext context ) throws Throwable {
        File file = new File(filePath);
        // FIXME:对于MetaColumn的某些属性比如Precision和Scale，MetaColumnAction 没有完整处理
        MetaDataObjectSave save = new MetaDataObjectSave(metaDataObject) {
            @Override
            protected IMetaActionMap getActionMap() {
                return MetaDataObjectActionMapEx.getInstance();
            }
        };
        Document newDocument = save.getDocument();
        String newXml = getNewXml(file.getAbsolutePath(), newDocument);
        CheckXSDUtils.checkXSD(metaFactory, MetaDataObject.TAG_NAME, formKey, fileName, newXml, "", null, null);
        FileUtils.writeStringToFile(file, newXml, "UTF-8");
        if(SaveFileContentCmd.CMD.equals(cmd)){
            SaveFileContentCmd.reloadDataObject(metaFactory, formKey, result, filePath, context);
        }else{
            SaveFilesByFormKeyCmd.reloadDataObject(metaFactory, formKey, result, filePath);
        }
        SaveFilesByFormKeyCmd.removeScopeCache(null, metaFactory, result);
        XmlFileProcessor.instance.clearTmpFile(filePath);
        result.add(UICommand.reloadXmlSource(filePath));
    }

    public static void saveMetaEntry(IMetaFactory metaFactory, MetaEntry metaEntry, String filePath, String projectKey, String fileName,
                                     List<UICommand> result) throws Throwable {
        File file = new File(filePath);
        MetaEntrySave save = new MetaEntrySave(metaEntry);
        Document newDocument = save.getDocument();
        String newXml = getNewXml(file.getAbsolutePath(), newDocument);
        CheckXSDUtils.checkXSD(metaFactory, MetaEntry.TAG_NAME, "", fileName, newXml, projectKey, null, metaEntry);
        FileUtils.writeStringToFile(file, newXml, "UTF-8");
        XmlFileProcessor.instance.clearTmpFile(filePath);
        projectKey = LoadFileTree.getProjectKey(filePath);
        EntryProcessor.instance.reloadEntry(projectKey);
        result.add(UICommand.reloadMenuTree());
    }

    private static String getNewXml(String filePath, Document newDocument) throws Throwable {
        XmlTree oldXmlTree = Xml4jUtil.parseTree(filePath);
        CheckXSDUtils.resortAttrPosition(oldXmlTree.getRoot(), filePath);
        XmlCreator creator = new XmlCreator(newDocument, oldXmlTree);
        String xml = creator.createXml();
        String newContent = xml.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
        return newContent;
    }

    public static String getNewXml(String filePath, MetaForm form, IMetaActionMap metaActionMap) throws Throwable {
        // FIXME:对于MetaColumn的某些属性比如Precision和Scale，MetaColumnAction 没有完整处理
        MetaFormSave save = new MetaFormSave(form) {
            @Override
            protected IMetaActionMap getActionMap() {
                if (metaActionMap == null) {
                    return MetaFormActionMapEx.getInstance();
                }
                return metaActionMap;
            }
        };
        Document newDocument = save.getDocument();
        return getNewXml(filePath, newDocument);
    }

}
