package com.bokesoft.yes.design.utils;

import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.yes.design.context.DesignerContext;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.design.cmd.CommitDiffCmd;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;

/**
 * 设计器重新加载配置对象
 * 特别的测试：
 * 1.通过源代码删除一个MetaDataObject中在用的字段（不删除表单上的字段），保存应报错
 * 2.删除一个MetaDataObjectA中在用的字段，删除表单MetaFormA上的字段，保存应报错，取消MetaDataObjectA应报错
 */
public class DesignReloadMetaObject {
    public static HashMap<String, Object> oldFormHashMap = new HashMap<>();//记录上一个正确的form

    /**
     * 重新加载Form配置文件，若碰到解析错误，回滚并抛出错误
     *
     * @param formKey
     * @return
     * @throws Throwable
     */
    public static List<MetaFormProfile> reloadMetaFormRollbackError(DefaultContext context, String formKey) throws Throwable {
        return reloadMetaFormRollbackError(context,formKey, null, null);
    }
    /**
     * 重新加载Form配置文件，若碰到解析错误，回滚并抛出错误
     *
     * @param formKey
     * @return
     * @throws Throwable
     */
    public static List<MetaFormProfile> reloadMetaFormRollbackError( String formKey) throws Throwable {
        return reloadMetaFormRollbackError(null,formKey);
    }

    /**


     * @return
     * @throws Throwable
     */
    public static List<MetaFormProfile> reloadMetaDataObjectRollbackError(String dataObjectKey, String resource) throws Throwable {
        return reloadMetaDataObjectRollbackError(dataObjectKey, resource, null);
    }
    public static List<MetaFormProfile> getReloadMetaFormProfiles(String dataObjectKey, IMetaFactory metaFactory)
            throws Throwable {
        List<MetaFormProfile> needReloadMetaFormProfiles = new ArrayList<>();
        loadEmbedOwnerAndVest(metaFactory, needReloadMetaFormProfiles, dataObjectKey);
        return needReloadMetaFormProfiles;
    }

    /**
     * 重新加载Form配置文件，若碰到解析错误，回滚并抛出错误
     *
     * @param formKey
     * @param cancelFilePath 取消的文件路径，这个文件不取临时文件，其他被影响的文件还是要取临时文件
     * @param snapshotFilePath 快照文件路径
     * @return
     * @throws Throwable
     */
    public static List<MetaFormProfile> reloadMetaFormRollbackError(DefaultContext context,String formKey,
                                                                    String cancelFilePath, String snapshotFilePath) throws Throwable {
        // 1.先统计出本次需要重新加载的配置对象
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        List<MetaFormProfile> needReloadMetaFormProfiles = getNeedReloadMetaFormProfiles(formKey, metaFactory);
        Set<String> openFormKeys = new HashSet<>();
        if (context != null && context.getParas() != null) {
            openFormKeys  =   getOpenFormKeys(context, metaFactory);
            openFormKeys.add(formKey);
        }
        // 2.尝试重新加载，并记录上次成功的resource
        int formCount = needReloadMetaFormProfiles.size();
        try {
            for (int i = 0; i < formCount; i++) {
                MetaFormProfile profile = needReloadMetaFormProfiles.get(i);
                if (context != null && !openFormKeys.contains(profile.getKey()) && !profile.getMergeToSource()) {
                    continue;
                }
                DesignerContext.addForm(profile);
                try {
                    oldFormHashMap.put(profile.getKey(), MetaObjectHelper.clone(profile));
                } catch (Exception e) {
                    oldFormHashMap.put(profile.getKey(), profile);
                }
            }
            List<String> reloadedFormKeys = new ArrayList<>();
            for (int i = 0; i < formCount; i++) {
                MetaFormProfile metaFormProfile = needReloadMetaFormProfiles.get(i);
                String key1 = metaFormProfile.getKey();
                if (context != null && !openFormKeys.contains(metaFormProfile.getKey()) && !metaFormProfile.getMergeToSource()) {
                    continue;
                }
                if (reloadedFormKeys.contains(key1)) {
                    continue;
                }

                String pathByFormKey = LoadFileTree.getPathByFormKey(key1);
                if (StringUtils.isBlank(pathByFormKey)) {
                    continue;
                }
                if (!pathByFormKey.equals(cancelFilePath)) {
                    String tmpFile = null;
                    if(snapshotFilePath != null){
                        tmpFile = snapshotFilePath;
                    }else{
                        tmpFile = XmlFileProcessor.instance.getTmpFile(pathByFormKey);
                    }
                    if (tmpFile != null) {
                        pathByFormKey = tmpFile;
                    }
                }
                String refObjectKey = null;
                MetaForm form = metaFormProfile.getForm();
                if (form != null && form.getDataSource() != null) {
                    refObjectKey = form.getDataSource().getRefObjectKey();
                }
                if (metaFormProfile.getMergeToSource()) {//功能马甲
                    //先reload原单在reload马甲
                    String extendFormKey = metaFormProfile.getExtend();
                    if (!extendFormKey.isEmpty() && !reloadedFormKeys.contains(extendFormKey)) {
                        String pathByFormKey1 = LoadFileTree.getPathByFormKey(extendFormKey);
                        // TODO 这里在满足条件的情况下可以不走下面
                        String tmpFilePath = XmlFileProcessor.instance.getTmpFile(pathByFormKey1);
                        if (StringUtils.isNotBlank(tmpFilePath)) {
                            pathByFormKey1 = tmpFilePath;
                        }
                        String extendRefObjectKey = null;
                        MetaForm extendForm = metaFactory.getMetaFormList().get(extendFormKey).getForm();
                        if (extendForm != null && extendForm.getDataSource() != null) {
                            extendRefObjectKey = extendForm.getDataSource().getRefObjectKey();
                        }
                        //reload原单
                        if (StringUtils.isNotEmpty(extendRefObjectKey) && StringUtils.isNotEmpty(cancelFilePath)) {
                            List<MetaFormProfile> metaFormProfiles = reloadForm(null,metaFactory, extendFormKey, pathByFormKey1, extendRefObjectKey, key1);
                            List<String> collect = metaFormProfiles.stream().map(MetaFormProfile::getKey).collect(Collectors.toList());
                            reloadedFormKeys.addAll(collect);
                        } else {
                            List<MetaFormProfile> metaFormProfiles = reloadForm(null,metaFactory, extendFormKey, pathByFormKey1, extendRefObjectKey);
                            List<String> collect = metaFormProfiles.stream().map(MetaFormProfile::getKey).collect(Collectors.toList());
                            reloadedFormKeys.addAll(collect);
                        }
                    }
                }
                if (reloadedFormKeys.contains(key1)) {
                    continue;
                }
                List<MetaFormProfile> metaFormProfiles = reloadForm(context,metaFactory, key1, pathByFormKey, refObjectKey);
                List<String> collect = metaFormProfiles.stream().map(MetaFormProfile::getKey).collect(Collectors.toList());
                reloadedFormKeys.addAll(collect);
                if (!reloadedFormKeys.contains(key1)) {
                    reloadedFormKeys.add(key1);
                }
            }
            ExecutorService executorService = new ThreadPoolExecutor(10, 64, 10L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            for (int i = 0; i < formCount; i++) {
                MetaFormProfile profile = needReloadMetaFormProfiles.get(i);
                if (context != null && !openFormKeys.contains(profile.getKey()) && !profile.getMergeToSource()) {
                    executorService.submit(() -> {
                        try {
                            reloadDesignMetaForm(metaFactory,profile);
                        } catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
            }
            executorService.shutdown();
            while (!executorService.awaitTermination(100, TimeUnit.MILLISECONDS)) ;
        } catch (Exception e) {
            LogSvr.getInstance().error("最新的临时文件将被移除！\n", e);
            // 3.一旦有错误，即全部重新加载
            oldFormHashMap.forEach((key, object) -> {
                try {
                    metaFactory.getMetaFormList().remove(key);
                    if (object instanceof MetaFormProfile) {
                        MetaFormProfile metaFormProfile = (MetaFormProfile) object;
                        if(metaFormProfile.getFormType() == FormType.Extension){
                            metaFactory.getExtFormList().remove(key);
                            metaFactory.getExtFormList().add((MetaFormProfile) object);
                        } else {
                            metaFactory.getMetaFormList().remove(key);
                            metaFactory.getMetaFormList().add((MetaFormProfile) object);
                        }
                    } else if (object instanceof MetaDataObjectProfile) {
                        metaFactory.getDataObjectList().add((MetaDataObjectProfile) object);
                    }
                } catch (Throwable ex) {
                    LogSvr.getInstance().error(ex.getMessage(), ex);
                }
            });
            for (int i = 0; i < formCount; i++) {
                MetaFormProfile metaFormProfile = needReloadMetaFormProfiles.get(i);
                String key = metaFormProfile.getKey();
                String pathByFormKey = LoadFileTree.getPathByFormKey(key);
                Stack<String> stack1 = XmlFileProcessor.filePathToTmpFileMap.get(pathByFormKey);
                if (stack1 != null && stack1.size() > 0) {
                    stack1.pop();//移除临时文件
                }
            }
            throw e;
        }
        return needReloadMetaFormProfiles;
    }
    public static void reloadDesignMetaForm(IMetaFactory metaFactory,MetaFormProfile metaFormProfile) throws Throwable {
        MetaObjectChange.fireChangeDesignMetaForm(metaFormProfile.getForm());
        metaFactory.reloadDesignMetaForm(metaFormProfile.getKey());
        metaFactory.getDesignMetaForm(metaFormProfile.getKey());
    }
    public static List<MetaFormProfile> getNeedReloadMetaFormProfiles(String formKey, IMetaFactory metaFactory)
            throws Throwable {
        List<MetaFormProfile> needReloadMetaFormProfiles = new ArrayList<>();
        MetaFormProfile formProfile = metaFactory.getMetaFormList().get(formKey);
        if(formProfile == null) formProfile = metaFactory.getExtFormList().get(formKey);
        needReloadMetaFormProfiles.add(formProfile);
        loadEmbedOwnerAndVest(metaFactory, needReloadMetaFormProfiles, null);
        if (formProfile.getMergeToSource()) {
            MetaFormProfile profile = metaFactory.getMetaFormList().get(formProfile.getExtend());
            if (profile != null && profile.getForm().getFormType() == FormType.Template) {
                needReloadMetaFormProfiles.add(profile);
                loadEmbedOwnerAndVest(metaFactory, needReloadMetaFormProfiles, null);
                needReloadMetaFormProfiles.remove(profile);
            }
        }
        return needReloadMetaFormProfiles;
    }

    private static List<MetaFormProfile> reloadForm(DefaultContext context ,IMetaFactory metaFactory, String key1, String pathByFormKey, String refObjectKey,
                                   String cancelFormkey) throws Throwable {
        if (StringUtils.isNotEmpty(refObjectKey)) {//数据对象表单需要先reload// 数据对象再去reloadform
            String refObjectKeyresource = LoadFileTree.getPathByDataObject(refObjectKey);
            MetaFormProfile metaFormProfile = metaFactory.getMetaFormList().get(cancelFormkey);
            if(metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(cancelFormkey);
            String formXmlPath = null;
            if (metaFormProfile != null && metaFormProfile.getMergeToSource()) {
                formXmlPath = LoadFileTree.getPathByFormKey(cancelFormkey);
            }
            return DataObjectHelper.reload(context,refObjectKey, refObjectKeyresource, formXmlPath);
        } else {
            MetaFormProfile metaFormProfile = metaFactory.getMetaFormList().get(key1);
            if (metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(key1);
            String projectKey = metaFormProfile.getProject().getKey();
            String resource1 = LoadFileTree.getResource(pathByFormKey, projectKey);
            ReloadForm.reloadFormKey(metaFactory, key1, resource1);
            return new ArrayList<>();
        }
    }

    private static List<MetaFormProfile> reloadForm(DefaultContext defaultContext,IMetaFactory metaFactory, String key1, String pathByFormKey, String refObjectKey) throws Throwable {
        return reloadForm(defaultContext,metaFactory, key1, pathByFormKey, refObjectKey, null);
    }

    public static List<MetaFormProfile> reloadMetaDataObjectRollbackError(String dataObjectKey, String resource, String cancelFilePath) throws Throwable {
        return reloadMetaDataObjectRollbackError(dataObjectKey, resource, cancelFilePath, null);
    }

    /**
     * /**
     * 重新加载DataObject配置文件，若碰到解析错误，回滚并抛出错误
     *
     * @param dataObjectKey
     * @param resource
     * @param cancelFilePath 取消的文件路径，这个文件不取临时文件，其他被影响的文件还是要取临时文件
     * @return
     * @throws Throwable
     */
    public static List<MetaFormProfile> reloadMetaDataObjectRollbackError(String dataObjectKey, String resource, String cancelFilePath, String snapshotFilePath) throws Throwable {
        // 1.先统计出本次需要重新加载的配置对象
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        List<MetaFormProfile> needReloadMetaFormProfiles = getReloadMetaFormProfiles(dataObjectKey, metaFactory);
        // needReloadMetaFormProfiles.sort(Comparator.comparing(MetaFormProfile::getKey));
        // 2.尝试重新加载，并记录上次成功的resource
        String resourceDataObject = resource;
        if (!StringUtils.equals(resource, cancelFilePath)) {
            String tmpDataObjectFile = null;
            if(snapshotFilePath != null){
                tmpDataObjectFile = snapshotFilePath;
            }else{
                tmpDataObjectFile = XmlFileProcessor.instance.getTmpFile(resource);
            }

            if (tmpDataObjectFile != null) {
                resourceDataObject = tmpDataObjectFile;
            }
        }
        int formCount = needReloadMetaFormProfiles.size();
        try {
            for (int i = 0; i < formCount; i++) {
                oldFormHashMap.put(needReloadMetaFormProfiles.get(i).getKey(), MetaObjectHelper.clone(needReloadMetaFormProfiles.get(i)));
            }
            MetaDataObjectProfile metaDataObjectProfile = metaFactory.getDataObjectList().get(dataObjectKey);
            if (metaDataObjectProfile != null) {
                oldFormHashMap.put("DataObject_" + dataObjectKey, MetaObjectHelper.clone(metaDataObjectProfile));
            }
//            final String projectKey = LoadFileTree.getProjectKeyByFilePath(resource);
            ReloadForm.reloadDataObjectKey(metaFactory, dataObjectKey, resourceDataObject, metaDataObjectProfile.getProject().getKey());
            metaFactory.getDataObject(dataObjectKey);
        } catch (Exception e) {
            LogSvr.getInstance().error("最新的临时文件将被移除！\n", e);
            // 3.一旦有错误，即全部重新加载
            oldFormHashMap.forEach((key, object) -> {
                try {
                    if (object instanceof MetaFormProfile) {
                        MetaFormProfile metaFormProfile = (MetaFormProfile)object;
                        if(metaFormProfile.getFormType() == FormType.Extension){
                            metaFactory.getExtFormList().remove(key);
                            metaFactory.getExtFormList().add((MetaFormProfile) object);
                        }else {
                            metaFactory.getMetaFormList().remove(key);
                            metaFactory.getMetaFormList().add((MetaFormProfile) object);
                        }
                    } else if (object instanceof MetaDataObjectProfile) {
                        metaFactory.getDataObjectList().remove(key.substring(11));
                        metaFactory.getDataObjectList().add((MetaDataObjectProfile) object);
                    }
                } catch (Throwable ex) {
                    LogSvr.getInstance().error(ex.getMessage(), ex);
                }
            });
            String pathByDataObject = LoadFileTree.getPathByDataObject(dataObjectKey);
            Stack<String> stack = XmlFileProcessor.filePathToTmpFileMap.get(pathByDataObject);
            if (stack != null && stack.size() > 0) {
                stack.pop();//移除临时文件
            }
            throw e;
        }
        return needReloadMetaFormProfiles;
    }

    public static void postReloadMetaDataObject(DefaultContext context,String dataObjectKey, List<MetaFormProfile> needReloadMetaFormProfiles, String cancelFilePath) throws Throwable {
        // 1.先统计出本次需要重新加载的配置对象
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        Set<String> openFormKeys  = getOpenFormKeys(context, metaFactory);
        int formCount = needReloadMetaFormProfiles.size();
        try {
            for (int i = 0; i < formCount; i++) {
                MetaFormProfile metaFormProfile = needReloadMetaFormProfiles.get(i);
                String key1 = metaFormProfile.getKey();
                String pathByFormKey = LoadFileTree.getPathByFormKey(key1);
                if (context != null && !openFormKeys.contains(metaFormProfile.getKey()) && !metaFormProfile.getMergeToSource()) {
                    continue;
                }
                if (StringUtils.isBlank(pathByFormKey)) {
                    continue;
                }
                if (!pathByFormKey.equals(cancelFilePath)) {
                    String tmpFile = XmlFileProcessor.instance.getTmpFile(pathByFormKey);
                    if (tmpFile != null) {
                        pathByFormKey = tmpFile;
                    }
                }
                String resource1 = LoadFileTree.getResource(pathByFormKey,metaFormProfile.getProject().getKey());
                ReloadForm.reloadFormKey(metaFactory, key1, resource1, false);
            }
            ExecutorService executorService = new ThreadPoolExecutor(10, 64, 10L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            for (int i = 0; i < formCount; i++) {
                MetaFormProfile profile = needReloadMetaFormProfiles.get(i);
                if (context != null && !openFormKeys.contains(profile.getKey())  && !profile.getMergeToSource()) {
                    executorService.submit(() -> {
                        try {
                            reloadDesignMetaForm(metaFactory,profile);
                        } catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
            }
            executorService.shutdown();
            while (!executorService.awaitTermination(100, TimeUnit.MILLISECONDS)) ;
        } catch (Exception e) {
            LogSvr.getInstance().error("最新的临时文件将被移除！\n", e);
            // 3.一旦有错误，即全部重新加载
            oldFormHashMap.forEach((key, object) -> {
                try {
                    if (object instanceof MetaFormProfile) {
                        MetaFormProfile metaFormProfile = (MetaFormProfile)object;
                        if(metaFormProfile.getFormType() == FormType.Extension){
                            metaFactory.getExtFormList().remove(key);
                            metaFactory.getExtFormList().add((MetaFormProfile) object);
                        } else {
                            metaFactory.getMetaFormList().remove(key);
                            metaFactory.getMetaFormList().add((MetaFormProfile) object);
                        }
                    } else if (object instanceof MetaDataObjectProfile) {
                        metaFactory.getDataObjectList().remove(key.substring(11));
                        metaFactory.getDataObjectList().add((MetaDataObjectProfile) object);
                    }
                } catch (Throwable ex) {
                    LogSvr.getInstance().error(ex.getMessage(), ex);
                }
            });
            String pathByDataObject = LoadFileTree.getPathByDataObject(dataObjectKey);
            Stack<String> stack = XmlFileProcessor.filePathToTmpFileMap.get(pathByDataObject);
            if (stack != null && stack.size() > 0) {
                stack.pop();//移除临时文件
            }
            for (int i = 0; i < formCount; i++) {
                MetaFormProfile metaFormProfile = needReloadMetaFormProfiles.get(i);
                String key = metaFormProfile.getKey();
                String pathByFormKey = LoadFileTree.getPathByFormKey(key);
                Stack<String> stack1 = XmlFileProcessor.filePathToTmpFileMap.get(pathByFormKey);
                if (stack1 != null && stack1.size() > 0) {
                    stack1.pop();//移除临时文件
                }
            }
            throw e;
        }
    }

    private static Set<String> getOpenFormKeys(DefaultContext context , IMetaFactory metaFactory) {
        Set<String> openFormKeys = new HashSet<>();
        if (context != null && context.getParas() != null) {
            openFormKeys = (Set<String>) context.getPara("openFormKeys");
            if (!openFormKeys.isEmpty()){
                Set<String> newExtenFormKeys = new HashSet<>();
                openFormKeys.forEach((key) -> {
					try {
                        MetaForm metaForm = metaFactory.getMetaForm(key);
                        if (StringUtils.isNotEmpty(metaForm.getExtend())){
                            newExtenFormKeys.add(metaForm.getExtend());
                        }
                    } catch (Throwable e) {
						//
					}
				});
                openFormKeys.addAll(newExtenFormKeys);
            }
        }
        return openFormKeys;
    }

    /**
     * 加载所有相关的模板宿主表单和扩展表单
     *
     * @param metaFactory
     * @param existMetaFormProfiles
     * @param dataObjectKey
     * @throws Throwable
     */
    public static void loadEmbedOwnerAndVest(IMetaFactory metaFactory, List<MetaFormProfile> existMetaFormProfiles, String dataObjectKey) throws Throwable {
        int existCount = existMetaFormProfiles.size();
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            checkEmbedOwnerAndVest(metaFormProfile, existMetaFormProfiles, dataObjectKey);
        }
        if (existCount != existMetaFormProfiles.size()) { // 若有新增的Form，递归增加
            loadEmbedOwnerAndVest(metaFactory, existMetaFormProfiles, dataObjectKey);
        }
    }

    private static void checkEmbedOwnerAndVest(MetaFormProfile metaFormProfile, List<MetaFormProfile> existMetaFormProfiles, String dataObjectKey) throws Throwable {
        if (existMetaFormProfiles.contains(metaFormProfile)||metaFormProfile.getResource()==null) {
            return;
        }
        MetaForm tmpMetaForm = metaFormProfile.getForm();
        if (tmpMetaForm != null) { // 只刷新已加载的表单
            if (dataObjectKey != null) {
                MetaDataSource metaDataSource = tmpMetaForm.getDataSource();
                if (metaDataSource != null && metaDataSource.getDataObject() != null) {
                    if (dataObjectKey.equals(metaDataSource.getDataObject().getKey())) {
                        if (hasDBTable(metaDataSource.getDataObject())) {
                            existMetaFormProfiles.add(metaFormProfile);
                        }
                        return;
                    }
                }
            }
            for (MetaEmbed metaEmbed : tmpMetaForm.getEmbeds()) {
                String embedKey = metaEmbed.getFormKey();
                for (MetaFormProfile existMetaFormProfile : existMetaFormProfiles) {
                    if (embedKey.equals(existMetaFormProfile.getKey())) {
                        existMetaFormProfiles.add(metaFormProfile);
                        return;
                    }
                }
            }
            String formExtend = tmpMetaForm.getExtend();
            final String tmpMetaFormKey = tmpMetaForm.getKey();
            for (MetaFormProfile existMetaFormProfile : existMetaFormProfiles) {
                if ((StringUtils.isNotBlank(formExtend) && StringUtils.equals(formExtend, existMetaFormProfile.getKey()))
                        || (StringUtils.isNotBlank(tmpMetaFormKey) && StringUtils.isNotBlank(existMetaFormProfile.getExtend()) && StringUtils.equals(formExtend, existMetaFormProfile.getExtend()))) {
                    existMetaFormProfiles.add(metaFormProfile);
                    return;
                }
            }
        }
    }

    private static boolean hasDBTable(MetaDataObject dataObject) {
        MetaTableCollection tableCollection = dataObject.getTableCollection();
        final Iterator<MetaTable> iterator = tableCollection.iterator();
        if (iterator.hasNext()) {
            final MetaTable next = iterator.next();
            if (!StringUtils.endsWith(next.getKey(), MetaFormNODBProcess.STR_NODBTable_Profix)) {
                return true;
            }
        }
        return false;
        // ArrayList<String> tableLogicList = tableCollection.getTableLogicList();
        // return tableLogicList.stream().filter(StringUtils::isNotBlank).anyMatch(item -> !StringUtils.endsWith(item, MetaFormNODBProcess.STR_NODBTable_Profix));
    }
}
