package com.bokesoft.yes.design.sql;

import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoad;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckListBox;
import com.bokesoft.yigo.meta.form.component.control.MetaComboBox;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.solution.MetaProject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

/**
 * 计算Column对象中的ItemKey属性
 */
public class CalcColumnItemKey {
    /**
     * 配置对象
     */
    public static IMetaFactory metaFactory;

    public static void main(String[] args) throws Throwable {
        String solutionPath = getSolutionPath(args);
        //System.out.println("solutionPath=" + solutionPath);

        // 读取配置
        loadSolution(solutionPath);
        //System.out.println("配置加载完成");

        for (MetaDataObjectProfile dataObjectProfile : metaFactory.getDataObjectList()) {
            MetaDataObject dataObject = dataObjectProfile.getDataObject();
            calcColumnItem(dataObject);
        }
    }

    private static void calcColumnItem(MetaDataObject metaDataObject) {
        if (Objects.isNull(metaDataObject)) {
            return;
        }
        MetaTableCollection metaTableCollection = metaDataObject.getTableCollection();
        if (metaTableCollection != null) {
            for (MetaTable metaTable : metaTableCollection) {
                calcColumnItem(metaDataObject, metaTable);
            }
        }
    }

    private static void calcColumnItem(MetaDataObject metaDataObject, MetaTable metaTable) {
        for (MetaColumn metaColumn : metaTable) {
            try {
                String itemKey = calcColumnItem(metaFactory, metaDataObject, metaTable, metaColumn);
                if (itemKey != null) {
                    //System.out.println(metaTable.getBindingDBTableName() + "." + metaColumn.getBindingDBColumnName()
                    //		+ ".ItemKey=" + itemKey);
                }
            } catch (Throwable e) {
                //System.out.println(e.getMessage());
            }
        }
    }

    public static String calcColumnItem(IMetaFactory metaFactory, MetaDataObject metaDataObject, MetaTable metaTable, MetaColumn metaColumn) throws Throwable {
        String itemKey = metaColumn.getItemKey();
        if (itemKey != null && itemKey.length() > 0) {
            return itemKey;
        }
        String columnKey = metaColumn.getKey();
        if (columnKey.equalsIgnoreCase(SystemField.SOID_SYS_KEY) || columnKey.equalsIgnoreCase("ParentID")) {
            return null;
        }

        List<String> itemKeys = new ArrayList<>();
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            MetaForm metaForm = metaFormProfile.getForm();
            if (Objects.isNull(metaForm)) {
                continue;
            }
            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
            String fieldKey = idLookup.getFieldKeyByTableColumnKey(metaTable.getKey(), metaColumn.getKey());
            if (fieldKey != null) {
                MetaComponent component = idLookup.getComponentByKey(fieldKey);
                if (component != null) {
                    if (component.getControlType() == ControlType.DICT) {
                        MetaDict metaDict = (MetaDict) component;
                        itemKey = metaDict.getItemKey();
                        if (!itemKeys.contains(itemKey)) {
                            itemKeys.add(itemKey);
                        }
                    } else if (component.getControlType() == ControlType.DYNAMICDICT) {
                        throw new RuntimeException("表" + metaTable.getBindingDBTableName() + "字段"
                                + metaColumn.getBindingDBColumnName() + "是一个动态字典，单元格维度报表中不支持。");
                    }
                } else {
                    MetaGridCell gridCell = idLookup.getGridCellByKey(fieldKey);
                    if (gridCell != null) {
                        if (gridCell.getCellType() == ControlType.DICT) {
                            MetaDictProperties dicProperties = (MetaDictProperties) gridCell.getProperties();
                            itemKey = dicProperties.getItemKey();
                            if (!itemKeys.contains(itemKey)) {
                                itemKeys.add(itemKey);
                            }
                        } else if (gridCell.getCellType() == ControlType.DYNAMICDICT) {
                            throw new RuntimeException("表" + metaTable.getBindingDBTableName() + "字段"
                                    + metaColumn.getBindingDBColumnName() + "是一个动态字典，单元格维度报表中不支持。");
                        }
                    }
                }
            }
        }
        int size = itemKeys.size();
        if (size == 0) {
            return null;
        } else if (size == 1) {
            return itemKeys.get(0);
        } else {
            throw new RuntimeException("表" + metaTable.getBindingDBTableName() + "字段"
                    + metaColumn.getBindingDBColumnName() + "是有多个ItemKey值，" + itemKeys + "。");
        }
    }

    /**
     * 根据metaTabKey获取metaForm
     *
     * @param metaFactory
     * @param metaTableKey
     * @return
     * @throws Throwable
     */
    public static HashMap<MetaForm, String> getMetaFormByTableKey(IMetaFactory metaFactory, String metaTableKey) throws Throwable {
        HashMap<MetaForm, String> metaFormList = new HashMap<>();
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            MetaForm metaForm = metaFormProfile.getForm();
            if (Objects.isNull(metaForm) || Objects.isNull(metaForm.getDataSource())) {
                continue;
            }

            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
            List<String> metaTableKeys = idLookup.getMetaTableKeys();
            for (String tableKey : metaTableKeys) {
                if (tableKey.equalsIgnoreCase(metaTableKey)) {
                    metaTableKey = tableKey;
                    break;
                }
            }
            MetaTable metaTable = null;
            try {
                metaTable = metaForm.getMetaTable(metaTableKey);
            } catch (Exception e) {

            }

            if (Objects.isNull(metaTable)) {
                continue;
            }
            String tableKey = metaFormList.get(metaForm);
            if (StringUtils.isNotEmpty(tableKey) && !tableKey.equalsIgnoreCase(metaTableKey)) {
                metaFormList.put(MetaObjectHelper.deptClone(metaForm), metaTable.getKey());
            } else {
                metaFormList.put(metaForm, metaTable.getKey());

            }

        }
        return metaFormList;
    }

    /**
     * 根据metaTabKey获取metaForm
     *
     * @param metaForm
     * @param metaTableKey
     * @param list
     * @return
     * @throws Throwable
     */
    public static HashMap<String, TransmitConditions> getMetaComponentByfileKey(MetaForm metaForm, String metaTableKey, List<Pair<String, String>> list, HashMap<String, TransmitConditions> list1) throws Throwable {
        for (Pair columnKey : list) {
            String columnKeyValue = (String) columnKey.getValue();
            String key = (String) columnKey.getKey();
            if (metaForm != null) {
                IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                String componentFieldKey = idLookup.getFieldKeyByTableColumnKey(metaTableKey, columnKeyValue);
                MetaColumn metaColumn = metaForm.getDataSource().getDataObject().getMetaTable(metaTableKey).get(columnKeyValue);
                if (componentFieldKey != null) {
                    MetaComponent component = idLookup.getComponentByKey(componentFieldKey);
                    if (component != null) {
                        TransmitConditions transmitConditions = TransmitConditions.TransmitConditionsInit(key);
                        transmitConditions.setMetaColumn(metaColumn);
                        transmitConditions.setCellType(component.getControlType());
                        transmitConditions.setFiledKey(key);
                        transmitConditions.setComponentFieldCaption(component.getCaption());
                        transmitConditions.setColumnKey(columnKeyValue);
                        if (component.getControlType() == ControlType.DICT) {//字典
                            MetaDict component1 = (MetaDict) component;
                            transmitConditions.setItemColumnKey(component1.getItemKey());
                        } else if (component.getControlType() == ControlType.COMBOBOX) {//下拉框
                            MetaComboBox component1 = (MetaComboBox) component;
                            if (component1.getSourceType() == ComboBoxSourceType.FORMULA) {
                                transmitConditions.setFormulaItems(MetaObjectHelper.deptClone(component1.getFormulaItems()));
                            } else if (component1.getSourceType() == ComboBoxSourceType.QUERY) {
                                transmitConditions.setMetaQueryDef(MetaObjectHelper.deptClone(component1.getQueryDef()));
                                transmitConditions.setItemsDependency(component1.getItemsDependency());
                            }


                            transmitConditions.setSourceType(component1.getSourceType());
                        } else if (component.getControlType() == ControlType.CHECKLISTBOX) {//多选下拉框
                            MetaCheckListBox component1 = (MetaCheckListBox) component;
                            if (component1.getSourceType() == ComboBoxSourceType.FORMULA) {
                                transmitConditions.setFormulaItems(MetaObjectHelper.deptClone(component1.getFormulaItems()));
                            } else if (component1.getSourceType() == ComboBoxSourceType.QUERY) {
                                transmitConditions.setMetaQueryDef(MetaObjectHelper.deptClone(component1.getQueryDef()));
                                transmitConditions.setItemsDependency(component1.getItemsDependency());
                            }
                            transmitConditions.setSourceType(component1.getSourceType());
                        }
                        list1.put(key, transmitConditions);
                    } else {
                        MetaGridCell gridCell = idLookup.getGridCellByKey(componentFieldKey);
                        if (gridCell != null) {
                            TransmitConditions transmitConditions = TransmitConditions.TransmitConditionsInit(key);
                            transmitConditions.setMetaColumn(metaColumn);
                            transmitConditions.setCellType(gridCell.getCellType());
                            transmitConditions.setComponentFieldCaption(gridCell.getCaption());
                            transmitConditions.setFiledKey(key);
                            transmitConditions.setColumnKey(columnKeyValue);
                            if (gridCell.getCellType() == ControlType.DICT) {
                                MetaDictProperties properties = (MetaDictProperties) gridCell.getProperties();
                                transmitConditions.setItemColumnKey(properties.getItemKey());
                            } else if (gridCell.getCellType() == ControlType.COMBOBOX) {//下拉框
                                MetaComboBoxProperties gridCell1 = (MetaComboBoxProperties) gridCell.getProperties();
                                if (gridCell1.getSourceType() == ComboBoxSourceType.FORMULA) {
                                    transmitConditions.setFormulaItems(MetaObjectHelper.deptClone(gridCell1.getFormulaItems()));
                                } else if (gridCell1.getSourceType() == ComboBoxSourceType.QUERY) {
                                    transmitConditions.setMetaQueryDef(MetaObjectHelper.deptClone(gridCell1.getQueryDef()));
                                    transmitConditions.setDependentFields(gridCell1.getDependedFields());
                                }
                                transmitConditions.setSourceType(gridCell1.getSourceType());
                            } else if (gridCell.getCellType() == ControlType.CHECKLISTBOX) {//多选下拉框
                                MetaComboBoxProperties gridCell1 = (MetaComboBoxProperties) gridCell.getProperties();
                                if (gridCell1.getSourceType() == ComboBoxSourceType.FORMULA) {
                                    transmitConditions.setFormulaItems(MetaObjectHelper.deptClone(gridCell1.getFormulaItems()));
                                } else if (gridCell1.getSourceType() == ComboBoxSourceType.QUERY) {
                                    transmitConditions.setMetaQueryDef(MetaObjectHelper.deptClone(gridCell1.getQueryDef()));
                                    transmitConditions.setDependentFields(gridCell1.getDependedFields());
                                }
                                transmitConditions.setSourceType(gridCell1.getSourceType());
                            }
                            list1.put(key, transmitConditions);
                        }
                    }
                } else {
                    TransmitConditions transmitConditions = TransmitConditions.TransmitConditionsInit(key);
                    transmitConditions.setMetaColumn(metaColumn);
                    if (transmitConditions.getCellType() == 0) {
                        transmitConditions.setCellType(ControlType.TEXTEDITOR);
                    }
                    transmitConditions.setFiledKey(key);
                    transmitConditions.setComponentFieldCaption(componentFieldKey);
                    transmitConditions.setColumnKey(columnKeyValue);
                    list1.put(key, transmitConditions);
                }

            }
        }
        return list1;
    }

    public static String getSolutionPath(String[] args) throws IOException {
        // 下面的路径是http://ccserver:8080/svn/MyERP_Core_Main/MyERP_Core/trunk/trunk_2_0/erp在你本机所对应的目录
        // 如果取得不对，你可以改成自己机器上的相关目录，或者将path通过参数传进来
        String solutionPath = FilePathHelper.getCoreSolutionPath();
        // String solutionPath = "D:\\SVN\\yes\\yes-webapp\\";
        if (args != null && args.length > 0) {
            solutionPath = args[0];
        }
        return Paths.get(solutionPath).toAbsolutePath().toString();
    }

    private static void loadSolution(String solutionPath) throws Throwable {
        IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
        metaFactory = new DefaultMetaFactory(metaResolverFactory);
        metaFactory.getSolution();
        //metaFactory.preLoadEntity();
        preLoadMetaFormNoVestNoTemplate(metaFactory);
    }

    /**
     * 只加载MetaForm的配置文件中的内容，不考虑任何马甲、模板
     *
     * @param metaFactory
     * @throws Throwable
     */
    private static void preLoadMetaFormNoVestNoTemplate(IMetaFactory metaFactory) throws Throwable {
        for (MetaFormProfile profile : metaFactory.getMetaFormList()) {
            MetaProject metaProject = (MetaProject) profile.getProject();
            IMetaResolver projectResourceResolver = metaFactory.getProjectResolver(metaProject.getKey());
            if (Objects.isNull(projectResourceResolver)) {
                throw new MetaException(MetaException.PROJECT_RESOLVER_UNDEFINED,
                        SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ProjectResolverUndefined), metaProject.getKey()));
            }

            MetaForm parentForm = null;
            MetaFormLoad formLoad = new MetaFormLoad(AppRunType.App, parentForm);
            formLoad.load(projectResourceResolver, profile.getResource());
            MetaForm metaForm = (MetaForm) formLoad.getRootMetaObject();
            metaForm.setMergeToSource(profile.getMergeToSource());

            metaForm.setProject(metaProject);
            metaForm.setResource(profile.getResource());
            // 需要处理引用的外部数据对象
            MetaDataSource metaDataSource = metaForm.getDataSource();
            if (metaDataSource != null) {
                MetaDataObject metaDataObject = metaDataSource.getDataObject();
                if (Objects.isNull(metaDataObject)) {
                    String refObjectKey = metaDataSource.getRefObjectKey();
                    if (refObjectKey != null && !refObjectKey.isEmpty()) {
                        metaDataObject = metaFactory.getDataObject(refObjectKey);
                        metaDataSource.setDataObject(metaDataObject);
                    }
                } else {
                    metaDataObject.setProject(metaProject);
                }
            }

            profile.setForm(metaForm);
        }
    }
}
