package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CommonDefProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.mergesingle.common.MergeSingleDiffUtil;
import com.bokesoft.yes.design.mergesingle.util.FormToolOperUtil;
import com.bokesoft.yes.design.newproject.DesignCommonDefMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefSave;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.FormVerb;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class CommonDefOperJsonUtil extends HandleSettingImpl {
    @Override
    public void reload(String filePath) throws Throwable {
        String projectKey = LoadFileTree.getProjectKey(filePath);

            TreeNode treeNode = LoadFileTree.getTreeNode(filePath);
            String solutionKey = treeNode.solutionKey;
        CommonDefProcessor.getInstance().reloadCommonDef(projectKey,solutionKey);

    }

    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        DataTable collecTable = document.get(ConstantUtil.TBL_OPERATION_TOOLBAR_DETAIL);
        DataTable fieldTable = document.get(ConstantUtil.TBL_OPERATIONS);
        DataTable macroDetail = document.get(ConstantUtil.TBL_MACRO_FORMULA);
        DataTable scriptList = document.get(ConstantUtil.TBL_SCRIPT_LIST);
        DataTable queryStatement = document.get(ConstantUtil.TBL_QueryStatement);
        DataTable parameterCollection = document.get(ConstantUtil.TBL_QUERY_PARAMETER_COLLECTION);
        DataTable queryCollection = document.get(ConstantUtil.TBL_QUERY_COLLECTION);
        DataTable statusCollection = document.get(ConstantUtil.TBL_STATUS_LIST);
//        DataTable paraGroupList = document.get(ConstantUtil.TBL_ParaGroup);
//        DataTable D_ParaTable = document.get(ConstantUtil.TBL_PARA_TABLE);
        //处理XMLTree
        //获取XMltree
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        //添加对应节点
        if (statusCollection.size() != 0) {
            TagNode tagNode = xmlTree.xmlTree.getRoot().getOrCreateChildByTagName(MetaStatusCollection.TAG_NAME);
            if (tagNode == null) {
                tagNode = new TagNode(MetaStatusCollection.TAG_NAME, null);
                xmlTree.xmlTree.getRoot().addNode(tagNode, 4);
            } else {
                tagNode.deleteChildByTagName("Status");
            }
            dealStatusList(statusCollection, tagNode);
        } else {
            xmlTree.xmlTree.getRoot().deleteChildByTagName(MetaStatusCollection.TAG_NAME);
        }
        dealOperationToobar(xmlTree, collecTable, fieldTable, macroDetail, scriptList, queryStatement, parameterCollection, queryCollection, diff);
        MergeSingleDiffUtil.genSingleXmlDiff(xmlTree.xmlTree.getRoot(), diff);
//        String path = diff.getFilePath();
//        //给diff一个完整的路径
//        diff.setFilePath(path);
//        //修改CommonDef直接保存到xml文件中不再生成临时文件
//        //处理xml
//        String orgXml = xmlTree.xmlTree.getOrgXml();
//        int startLine = diff.getStartLine();
//        String orgXmlFragment = diff.getOrgXmlFragment();
//        String newXmlFragment = diff.getNewXmlFragment();
//        boolean insertIndent = diff.isPropertyDiff() && !diff.isGridColumnDrag(); // 如果是根据属性差异生成的xml需要插入缩进
//        orgXml = CheckXMLChanged.mergeXML(orgXml, startLine, orgXmlFragment, newXmlFragment, null, insertIndent);
//        if (diff.getNewXmlFragment() != null) {
//            FileUtils.writeStringToFile(new File(path), orgXml, "UTF-8");
//        } else {
//            FileUtils.writeStringToFile(new File(path), xmlTree.xmlTree.getOrgXml(), "UTF-8");
//        }
//        jsonObject.put("xmlPath", StringUtil.isBlankOrNull(path) ? path : FilePathHelper.toFrontFilePath(path));
//        if (diff.getNewXmlFragment() != null) {
//            jsonObject.put("newXml", diff.getNewXmlFragment());
//        } else {
//            jsonObject.put("newXml", xmlTree.xmlTree.getOrgXml());
//        }
    }

    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
        // 修改Setting直接保存到xml文件中不再生成临时文件
        String xml = genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument(xml);
        MetaCommonDefLoad metaCommonDefLoad = new MetaCommonDefLoad(AppRunType.App);
        metaCommonDefLoad.load(document);
        MetaCommonDef metaCommonDef = (MetaCommonDef) metaCommonDefLoad.getRootMetaObject();
        dealMetaCommonDef(metaCommonDef);
        DesignCommonDefMetaResolver designCommonDefMetaResolver = new DesignCommonDefMetaResolver();
        (new MetaCommonDefSave(metaCommonDef)).save(designCommonDefMetaResolver, filePath);
        if (diff.getNewXmlFragment()!=null){
            jsonObject.put("newXml",  diff.getNewXmlFragment());
        }else {
            jsonObject.put("newXml", xmlTree.xmlTree.getOrgXml());
        }
        jsonObject.put("xmlPath", StringUtil.isBlankOrNull(filePath) ? filePath : FilePathHelper.toFrontFilePath(filePath));
    }

    private void dealMetaCommonDef(MetaCommonDef metaCommonDef){
        if (metaCommonDef.getScriptCollection() == null){
            return;
        }
        for (MetaScript metaScript : metaCommonDef.getScriptCollection()) {
            if (metaScript.getVerb() == -1){
                // FormVerb的parse方法转换Other错误，此处修正
                metaScript.setVerb(FormVerb.Other);
            }
        }
    }

    public void dealStatusList(DataTable statusCollection, TagNode tagNode) {
//		List<AbstractNode> childs = tagNode.getChildren();
        for (int j = 0; j < statusCollection.size(); j++) {
            String keyDetail = statusCollection.getString(j, "Key");
            String statusCaption = statusCollection.getString(j, "Caption");
            Integer statusValue = statusCollection.getInt(j, "StatusValue");
            boolean standalone = statusCollection.getBoolean(j, "IsStandalone");
            int state = statusCollection.getState(j);
            if (state == RowState.NEW || state == RowState.MODIFIED || state == RowState.NORMAL) {
                TagNode script = new TagNode(ConstantUtil.STATUS, null);
                script.setAttribute(ConstantUtil.KEY, keyDetail);
                if (StringUtils.isNotEmpty(statusCaption)) {
                    script.setAttribute(ConstantUtil.CAPTION, statusCaption);
                }
                if (statusValue != -1){
                    script.setAttribute(ConstantUtil.VALUE, String.valueOf(statusValue) );
                }


                script.setAttribute(MetaConstants.STATUS_STANDALONE, String.valueOf(standalone));

                tagNode.addNode(script);
            } else if (state == RowState.DELETED) {
                List<AbstractNode> childrenDelete = tagNode.getChildren();
                for (Iterator<AbstractNode> iterator = childrenDelete.iterator(); iterator.hasNext(); ) {
                    AbstractNode dren = iterator.next();
                    if (dren instanceof TagNode) {
                        String chridrenName = ((TagNode) dren).getTagName();
                        if (ConstantUtil.STATUS.equalsIgnoreCase(chridrenName)
                                && ((TagNode) dren).getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(keyDetail)) {
                            iterator.remove();
                        }
                    }
                }
            }
        }
    }
    public static void dealOperationToobar(XmlTreeWithPath xmlTree, DataTable collecTable, DataTable fieldTable, DataTable marcoTable, DataTable scriptList, DataTable queryStatement, DataTable parameterCollection, DataTable queryCollection, Diff diff) throws Throwable {
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        FormToolOperUtil.dealOperationCollection(collecTable, fieldTable, rootNode, false, false, null,null);
        FormToolOperUtil.dealMacroCollection(marcoTable, rootNode,  false,null);
        FormToolOperUtil.dealScriptNode(scriptList, rootNode,false,null);
        FormToolOperUtil.dealParameterCollection(queryCollection,rootNode,queryStatement, parameterCollection,false,null);
    }
}
