package com.bokesoft.yes.design.mergesingle.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.mergesingle.common.MergeSingleDiffUtil;
import com.bokesoft.yes.design.mergesingle.impl.SingleSettingImpl;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LayoutOperUtil extends SingleSettingImpl {
    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        String ownerFormKey = diff.formKey;
        MetaForm ownerMetaForm = StringUtils.isBlank(ownerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey);
        String key = diff.getKey();
        MetaComponent comp = IOMetaObject.getComponentByKey(ownerMetaForm, key);
        TagNode curNode;
        if (comp != null && comp.getControlType() == ControlType.EDITVIEW) {
            String xmlTreeKey = "GridLayout@" + diff.getReserveOne();
            curNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        } else {
            MetaGridLayoutPanel metaGridLayoutPanel = (MetaGridLayoutPanel) IOMetaObject.getComponentByKey(ownerMetaForm, key);
            if (Objects.isNull(metaGridLayoutPanel) && diff.getContainerKey() != null) {
                ownerMetaForm = StringUtils.isBlank(ownerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(diff.getContainerKey());
                metaGridLayoutPanel = (MetaGridLayoutPanel) IOMetaObject.getComponentByKey(ownerMetaForm, key);
            }
            String tagName = metaGridLayoutPanel.getTagName();
            String xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, tagName, key);// 字段抓取node
            curNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        }
        dealLayoutRow(document, diff,curNode);
        dealLayoutColumn(document, diff,curNode);
        setTagNode(curNode);
    }
    //布局方式行修改（行数，行间距，行高）
    private  void dealLayoutRow(Document document, Diff diff,TagNode curNode) throws Throwable {

        DataTable RheadTable = document.get(ConstantUtil.ED_ROW_HEAD);
        DataTable RDetailTable = document.get(ConstantUtil.ED_ROW_DETAIL);
        if (RheadTable.isEmpty()) {
            int row = RheadTable.append();
            RheadTable.setObject(row, ConstantUtil.ROW_GAP, "1");
            RheadTable.setObject(row, "RowDefHeight", 0);
            RheadTable.setObject(row, "RowNum", 1);
            RheadTable.setState(RowState.MODIFIED);
        }
        if (RDetailTable.isEmpty()) {
            int row = RDetailTable.append();
            RheadTable.setObject(row, ConstantUtil.ROW_GAP, "1");
            RDetailTable.setObject(row, "Type", 0);
            RDetailTable.setObject(row, "RowDefHeight", 30);
            RDetailTable.setObject(row, "RowNum", 1);
            RDetailTable.setState(RowState.MODIFIED);
        }
        int rowNum = RheadTable.getInt(0, "RowNum");
        TagNode rowNode = curNode.getOrCreateChildByKey(ConstantUtil.ROW_DEF_COLLECTION,"");
        rowNode.setAttribute(ConstantUtil.ROW_GAP, String.valueOf(RheadTable.getInt(0, ConstantUtil.ROW_GAP)));
        String rowDefHeight = String.valueOf(RheadTable.getInt(0, "RowDefHeight"));
        if (!"0".equals(rowDefHeight)) {
            rowNode.setAttribute(ConstantUtil.ROW_HEIGHT, rowDefHeight);
        }
        dealGridLayoutRowDetail(rowNode, RDetailTable, diff, rowNum,curNode);
    }

    private  void dealGridLayoutRowDetail(TagNode rowNode, DataTable RDetailTable, Diff diff, int rowNum,TagNode gridNode) throws Throwable {
        List<AbstractNode> childrenNode = rowNode.getChildren();
        int RDsize = RDetailTable.size();
        childrenNode.clear();
        RDetailTable.setShowDeleted(false);
        for (int i = 0; i < rowNum; i++) {
            if (i >= RDsize) {
                TagNode node = new TagNode(ConstantUtil.ROW_DEF, null);
                DefSize defSize = new DefSize(0, 32);//当新增空白行并不做修改时默认值为type=0，height=30
                String height = defSize.toString();
                node.setAttribute(ConstantUtil.HEIGHT, height);
                childrenNode.add( node);
            } else {
                TagNode node = new TagNode(ConstantUtil.ROW_DEF, null);
                DefSize defSize = new DefSize(Integer.parseInt(RDetailTable.getString(i, "Type")), RDetailTable.getInt(i, "RowDefHeight"));
                String height = defSize.toString();
                node.setAttribute(ConstantUtil.HEIGHT, height);
                childrenNode.add( node);
            }
        }
    }

    //面板布局设置列头表属性修改（列间距）
    private  void dealLayoutColumn(Document document, Diff diff,TagNode curNode) throws Throwable {
        DataTable CheadTable = document.get(ConstantUtil.ED_COLUMN_HEAD);
        DataTable CDetailTable = document.get(ConstantUtil.ED_COLUMN_DETAIL);
        if (CheadTable.isEmpty()) {
            int row = CheadTable.append();
            CheadTable.setObject(row, ConstantUtil.COLUMN_GAP, "1");
            CheadTable.setObject(row, "ColumnNum", 1);
            CheadTable.setState(RowState.MODIFIED);
        }
        if (CDetailTable.isEmpty()) {
            int row = CDetailTable.append();
            CheadTable.setObject(row, ConstantUtil.COLUMN_GAP, "1");
            CDetailTable.setObject(row, ConstantUtil.WIDTH, 100);
            CDetailTable.setObject(row, "Type", 0);
            CDetailTable.setObject(row, "RowNum", 1);
            CDetailTable.setState(RowState.MODIFIED);
        }
        int columnNum = CheadTable.getInt(0, "ColumnNum");
        TagNode columnNode = curNode.getOrCreateChildByKey(ConstantUtil.COLUMN_DEF_COLLECTION,"");
        columnNode.setAttribute(ConstantUtil.COLUMN_GAP, String.valueOf(CheadTable.getInt(0, ConstantUtil.COLUMN_GAP)));

        dealGridLayoutColumnDetail(columnNode, CDetailTable, diff, columnNum,curNode);
    }

    private  void dealGridLayoutColumnDetail(TagNode ColumnNode, DataTable CDetailTable, Diff diff, int columnNum,TagNode gridNode) throws Throwable {
        List<AbstractNode> childrenNode = ColumnNode.getChildren();
        childrenNode.clear();
        int CDsize = CDetailTable.size();
        for (int i = 0; i < columnNum; i++) {
            if (i >= CDsize) {
                TagNode node = new TagNode(ConstantUtil.COLUMN_DEF, null);
                childrenNode.add(node);
            } else {
                TagNode node = new TagNode(ConstantUtil.COLUMN_DEF, null);
                DefSize defSize = new DefSize(Integer.parseInt(CDetailTable.getString(i, "Type")), CDetailTable.getInt(i, ConstantUtil.WIDTH));
                if (CDetailTable.getString(i, "MinType") != null && CDetailTable.getString(i, "MinWidth") != null) {
                    if (!"".equals(CDetailTable.getString(i, "MinType")) && !"".equals(CDetailTable.getString(i, "MinWidth"))) {
                        DefSize mindefSize = new DefSize(Integer.parseInt(CDetailTable.getString(i, "MinType")), Integer.parseInt(CDetailTable.getString(i, "MinWidth")));
                        String MinWidth = mindefSize.toString();
                        node.setAttribute("MinWidth", MinWidth);
                    }
                }
                String height = defSize.toString();
                node.setAttribute(ConstantUtil.WIDTH, height);
                childrenNode.add( node);
            }
        }
    }

}
