//package com.bokesoft.yes.design.codemirror;
//
//import java.util.ArrayList;
//
//import com.sun.javadoc.ClassDoc;
//import com.sun.javadoc.MethodDoc;
//import com.sun.javadoc.ParamTag;
//import com.sun.javadoc.Parameter;
//import com.sun.javadoc.RootDoc;
//import com.sun.javadoc.ThrowsTag;
//
///**
// * 类说明：打印类及其字段、方法的注释<br>
// * 使用javadoc实现<br>
// * 需要在工程中加载jdk中的包$JAVA_HOME/lib/tools.jar
// */
//public class JavaMethodCommentParser {
//
//	/** 文档根节点 */
//	private static RootDoc root;
//
//	/**
//	 * 打印类及其字段、方法的注释
//	 *
//	 * @param sources java源文件路径
//	 */
//	public static void println(ArrayList<String> sources) {
//		ArrayList<String> list = new ArrayList<>();
//		list.add("-doclet");
//		list.add(JavaMethodCommentParser.class.getName());
//		list.addAll(sources);
//		com.sun.tools.javadoc.Main.execute(list.toArray(new String[list.size()]));
//
//		StringBuilder buffer = new StringBuilder();
//		ClassDoc[] classes = JavaMethodCommentParser.root.classes();
//		buffer.append('\n');
//		for (ClassDoc classDoc : classes) {
//			buffer.append("类名:" + classDoc.containingPackage().name() + "." + classDoc.name() + ".java").append('\n');
//			buffer.append("类名描述:" + classDoc.commentText()).append('\n');
//			buffer.append('\n');
//			MethodDoc[] methods = classDoc.methods();
//			for (MethodDoc method : methods) {
//				buffer.append("方法名:" + method.name()).append('\n');
//				buffer.append("方法描述:" + method.commentText()).append('\n');
//				ParamTag [] paramTags = method.paramTags();
//				Parameter[] parameters = method.parameters();
//				for (int i=0;i<paramTags.length;i++) {
//					buffer.append("参数名:" + paramTags[i].parameterName()).append(',');
//					buffer.append("参数类型:" + parameters[i].type().qualifiedTypeName()).append(',');
//					buffer.append("参数描述:" + paramTags[i].parameterComment()).append('\n');
//				}
//				buffer.append("返回类型:" + method.returnType()).append('\n');
//				ThrowsTag[] throwsTags = method.throwsTags();
//				for (ThrowsTag throwsTag : throwsTags) {
//					buffer.append("异常:" + throwsTag.exceptionName()).append('\n');
//				}
////				AnnotationDesc[] annotationDescs = method.annotations();
////				for(AnnotationDesc annotationDesc : annotationDescs) {
////					buffer.append("注解为:" + annotationDesc.annotationType()).append('\n');
////				}
//				buffer.append('\n');
//			}
//		}
//		System.out.println(buffer);
//	}
//
//	/**
//	 * 测试
//	 */
//	public static void main(String[] args) {
//		// java源文件的路径
//		ArrayList<String> sources = new ArrayList<>();
//		sources.add("D:\\source2\\bokeerp\\yes-webdesigner\\src\\main\\java\\com\\bokesoft\\yes\\design\\cmd\\ExpAutoCompleteCmd.java");
//		// 打印
//		println(sources);
//	}
//
//	/**
//	 * javadoc调用入口
//	 *
//	 * @param root
//	 * @return
//	 */
//	public static boolean start(RootDoc root) {
//		JavaMethodCommentParser.root = root;
//		return true;
//	}
//}
