package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.vo.RecycleForm;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.*;

/**
 * 差异的XML文件处理
 */
public class XmlFileProcessor {
	public static final XmlFileProcessor instance = new XmlFileProcessor();
	/**
	 * 记录文件和临时文件的关系，这样源代码能取到最新的代码
	 */
	public static Map<String, Stack<String>> filePathToTmpFileMap = new HashMap<>();//临时文件和撤销
	public static Map<String, Stack<String>> reFilePathToTmpFileMap = new HashMap<>();//前进
	public static Map<String, RecycleForm> recycleToTmpFormAndFileMap = new HashMap<>();//记录着删除表单后的对象
	public static Map<String, Stack<String>> filePathToSnapshotMap = new HashMap<>();//文件快照
//	/** 记录文件和临时文件的关系，这样源代码能取到最新的代码 */
//	public Map<String, String> DatafilePathToTmpFileMap = new HashMap<String, String>();
	/**
	 * 配置目录中临时目录的名称
	 */
	public static final String STR_TmpPath = "tmp";

	/**
	 * 将配置对象差异保存到临时xml文件
	 *
	 * @param diffs
	 * @param
	 * @param
	 * @param
	 * @param
	 * @return 返回修改的临时文件及文件内容
	 * @throws Throwable
	 */
	public Map<String, String> processDiff(List<Diff> diffs, boolean isCompositeComponent) throws Throwable {
		if ("DataObjectCheckRule".equals(diffs.get(0).getKey())) {
			return null;
		}
		Map<String, String> result = new LinkedHashMap<>();
		if(isCompositeComponent){
			// 复合组件 之前调用了mergePreDiff ，这里只保存最后一个diff的orgXml
			processDiff(diffs.get(diffs.size()-1), result);
		}else{
			for (Diff diff : diffs) {
				processDiff(diff, result);
			}
		}
		return result;
	}

	public Map<String, String> processDiff(Diff diff, Map<String, String> result) throws Throwable {
		Map<String, String> orgXmls = new LinkedHashMap<>();
		XmlTreeWithPath xmlTree2 = diff.getXmlTree2();
		if (xmlTree2 != null) {
			String xmlFilePath2 = xmlTree2.orgFilePath;
			if (!orgXmls.containsKey(xmlFilePath2)) {
				orgXmls.put(xmlFilePath2, xmlTree2.xmlTree.getOrgXml());
			}
		}
		XmlTreeWithPath xmlTree = diff.getXmlTree();
		if (xmlTree != null) {
			String xmlFilePath = xmlTree.orgFilePath;
			if (xmlFilePath != null && !orgXmls.containsKey(xmlFilePath)) {
				orgXmls.put(xmlFilePath, xmlTree.xmlTree.getOrgXml());
			}
		}
		genXML(orgXmls, diff);
		for (Map.Entry<String, String> entry : orgXmls.entrySet()) {
			String filePath = entry.getKey();
			String newContent = entry.getValue();
			boolean isPropertyDiff = true;
			String key, tmpFilePath;
			if (StringUtils.isNotBlank(filePath)) {
				key = LoadFileTree.getProjectKey(filePath);
			} else {
				key = MetaFactory.getGlobalInstance().getMetaFormList().get(diff.formKey).getProject().getKey();
			}
			if (!isPropertyDiff) {
				tmpFilePath = saveTempFile(filePath, newContent,key);
			} else {
				tmpFilePath = saveSortedTempFile(diff, filePath, newContent, key);
			}
			result.put(tmpFilePath, newContent);
		}
		return result;
	}

	/**
	 * 保存临时文件，并记录临时文件
	 *
	 * @param filePath
	 * @param fileContent
	 * @return
	 * @throws Throwable
	 */
	public String saveTempFile(String filePath, String fileContent,String projectKey) throws Throwable {
		return this.saveTempFile(filePath, fileContent, false,projectKey);
	}

	/**
	 * 保存临时文件，并记录临时文件
	 *
	 * @param filePath
	 * @param fileContent
	 * @return
	 * @throws Throwable
	 */
	public String saveTempFile(String filePath, String fileContent, boolean isPropertyDiff,String projectKey) throws Throwable {
		try {
			//String xmlFile = XmlFormat.formatXML_file(filePath);
			//判断节点关系是否正确;如果不正确就不保存临时文件
			String xmlFile1 = XmlFormat.formatXML_str(fileContent);
			XmlParser.parse(xmlFile1);
		} catch (Exception e) {
			throw new RuntimeException("xml结构错误修改失败!", e);
		}
		String newFilePath = FilePathHelper.toBackFilePath(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(projectKey)+ File.separator + new File(filePath).getName() + "." + System.currentTimeMillis());
		File file = new File(newFilePath);
		if (isPropertyDiff) {
			FileUtils.writeStringToFile(file, getFormatXml(filePath, fileContent), "UTF-8");
		} else {
			FileUtils.writeStringToFile(file, fileContent, "UTF-8");
		}
		stackput(filePath, newFilePath);
		return newFilePath;
	}

	public String saveSortedTempFile(Diff diff, String filePath, String fileContent, String projectKey) throws Throwable{
		try {
			String xmlFile1 = XmlFormat.formatXML_str(fileContent);
			XmlParser.parse(xmlFile1);
		} catch (Exception e) {
			throw new RuntimeException("xml结构错误修改失败!", e);
		}
		String newFilePath = FilePathHelper.toBackFilePath(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(projectKey)+ File.separator + new File(filePath).getName() + "." + System.currentTimeMillis());
		File file = new File(newFilePath);
		String oldXml = getFormatXml(filePath, fileContent);
		FileUtils.writeStringToFile(file, oldXml, "UTF-8");
		// 这里通过平台的方式生成有序的xml，将有序的xml替换到临时文件
		CheckXMLChanged.mergerSortedXml(diff, newFilePath, projectKey, oldXml);
		stackput(filePath, newFilePath);
		return newFilePath;

	}

	private String getFormatXml(String filePath, String fileContent) throws Exception {
		String tmpFile = XmlFileProcessor.instance.getTmpFile(filePath);
		if (StringUtils.isBlank(tmpFile)) {
			tmpFile = filePath;
		}
		String orgxml = FileUtil.File2String(new File(tmpFile), "UTF-8");
		com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree orgXmlTree = com.bokesoft.yes.meta.persist.dom.xml.XmlParser.parse(orgxml);
		byte[] bytes = fileContent.getBytes(StandardCharsets.UTF_8);
		ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
		XmlCreator creator = new XmlCreator(DomHelper.createDocument(byteArrayInputStream), orgXmlTree);
		String xml = creator.createXml();
		return xml;
	}

	public void saveTempRecycleFile(String key, RecycleForm recycleForm) throws Throwable {
		recycleToTmpFormAndFileMap.put(key, recycleForm);
	}

	public RecycleForm getTempRecycleFile(String key) throws Throwable {
		return recycleToTmpFormAndFileMap.get(key);
	}

	public static void stackput(String filePath, String newFilePath) {
		Stack<String> tmpFileMapStack = filePathToTmpFileMap.get(filePath);
		if (Objects.isNull(tmpFileMapStack)) {
			Stack<String> tmpStack = new Stack<>();
			tmpStack.push(newFilePath);
			filePathToTmpFileMap.put(filePath, tmpStack);
		} else {
			tmpFileMapStack.push(newFilePath);
		}

		//filePathToTmpFileMap 的数据会根据保存/撤销/回退等操作发生变化，此处新增filePathToSnapshotMap保存临时文件用于快照功能
		Stack<String> SnapshotMapStack = filePathToSnapshotMap.get(filePath);
		if (Objects.isNull(SnapshotMapStack)) {
			Stack<String> tmpStack = new Stack<>();
			tmpStack.push(newFilePath);
			filePathToSnapshotMap.put(filePath, tmpStack);
		} else {
			SnapshotMapStack.push(newFilePath);
		}
	}


	private static void genXML(Map<String, String> orgXmls, Diff diff) throws Throwable {


		XmlTreeWithPath xmlTree1 = diff.getXmlTree();
		if (Objects.isNull(xmlTree1)) {
			return;
		}
		String filePath = diff.getXmlTree().orgFilePath;
		String result = diff.getXmlTree().xmlTree.getOrgXml();
		if (StringUtils.isNotEmpty(diff.getNewXml())) {//预览功能
			result = diff.getNewXml();xmlTree1.xmlTree.getOrgXml();
			XmlTreeWithPath orgTree = XmlTreeWithPath.parseFilePath(filePath);
			if(orgTree.xmlTree.getOrgXml().equals(result)){
				throw new RuntimeException("预览失败,XML未产生变化!");
			}
		} else {
			result = mergeDiff(result, diff, orgXmls);
		}
		XmlTreeWithPath xmlTree2 = diff.getXmlTree2();
		String filePath2 = Objects.isNull(xmlTree2) ? null : xmlTree2.orgFilePath;
		if (filePath2 != null && !filePath2.equals(filePath)) {
			String[] fenges = result.split("fenge");
			orgXmls.put(filePath, fenges[0]);
			orgXmls.put(filePath2, fenges[1]);
		} else {
			orgXmls.put(filePath, result);
		}

	}
	public static String mergeDiff(String xml, Diff diff, Map<String, String> orgXmls) throws Throwable {
		String result = xml;
		ReplaceStringEntry entry = diff.isPropertyDiff() ? new ReplaceStringEntry() : null;
		int startLine = diff.getStartLine();
		String orgXmlFragment = diff.getOrgXmlFragment();
		String newXmlFragment = diff.getNewXmlFragment();
		boolean insertIndent = diff.isPropertyDiff() && !diff.isGridColumnDrag(); // 如果是根据属性差异生成的xml需要插入缩进
		result = CheckXMLChanged.mergeXML(result, startLine, orgXmlFragment, newXmlFragment, entry, insertIndent);
		int startLine2 = diff.getStartLine2();
		if (startLine2 != Diff.INT_InvalidLine) {
			ReplaceStringEntry entry2 = diff.isPropertyDiff() ? new ReplaceStringEntry() : null;
			String xmlFilePath2 = diff.getXmlTree2().orgFilePath;
			if (!xmlFilePath2.equals(diff.getXmlTree().orgFilePath)) {
				result = result + "fenge" + CheckXMLChanged.mergeXML(orgXmls.get(xmlFilePath2), startLine2, diff.getOrgXmlFragment2(),
						diff.getNewXmlFragment2(), entry2, insertIndent);
			} else {
				result = CheckXMLChanged.mergeXML(result, startLine2, diff.getOrgXmlFragment2(),
						diff.getNewXmlFragment2(), entry2, insertIndent);
			}
		}
		return result;
	}

	/**
	 * 多个diff的情况下    把前面diff的修改之后的xml作为第二个diff的xmltree
	 * @return
	 * @throws Throwable
	 */
	public static String mergePreDiff (Diff preDiff,Diff diff) throws Throwable{
		String content = preDiff.getXmlTree().xmlTree.getOrgXml();
		String newXmlFragment = preDiff.getNewXmlFragment();
		String orgXmlFragment = preDiff.getOrgXmlFragment();
		int startLine = preDiff.getStartLine();
		boolean insertIndent = preDiff.isPropertyDiff() && !preDiff.isGridColumnDrag();
		ReplaceStringEntry replaceStringEntry = new ReplaceStringEntry();
		content= CheckXMLChanged.mergeXML(content,startLine,orgXmlFragment,newXmlFragment,replaceStringEntry,insertIndent);
		int startLine2 = preDiff.getStartLine2();
		if (startLine2 != Diff.INT_InvalidLine) {
			ReplaceStringEntry entry2 = diff.isPropertyDiff() ? new ReplaceStringEntry() : null;
			content = CheckXMLChanged.mergeXML(content, startLine2, preDiff.getOrgXmlFragment2(), preDiff.getNewXmlFragment2(), entry2, insertIndent);
		}
		String key = MetaFactory.getGlobalInstance().getMetaFormList().get(preDiff.formKey).getProject().getKey();
		String filepath = Paths.get(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(key),"tmp",diff.formKey + "_midfile.xml").toString();
		File file =new File(filepath);
		FileUtils.writeStringToFile(file, content, "UTF-8");
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		ReloadForm.reloadFormKey(metaFactory,diff.formKey,LoadFileTree.getResource(filepath,metaFactory.getMetaFormList().get(diff.formKey).getProject().getKey()));
		return filepath;
	}

	/**
	 * 取表单对应的临时文件
	 *
	 * @param filePath
	 * @return
	 */
	public String getTmpFile(String filePath) {
		if (filePathToTmpFileMap.containsKey(filePath)) {
			try {
				String result = filePathToTmpFileMap.get(filePath).peek();
				if (new File(result).exists()) { // 用户可以直接删除临时文件，取消所有修改
					return result;
				} else {
					LogSvr.getInstance().info("临时文件即将被清除！filePath: " + filePath);
					filePathToTmpFileMap.remove(filePath);
				}
			} catch (Exception e) {
				return null;
			}
		}
		return null;
	}

	/**
	 * 取当前表单对应的临时文件
	 *
	 * @param filePath
	 * @return
	 */
	public String getUndoContent(List<UICommand> result, String type, String filePath, String formKey) {
		if (filePathToTmpFileMap.containsKey(filePath)) {
			try {
				String pop = filePathToTmpFileMap.get(filePath).pop();
				//撤销时存入前进栈
				Stack<String> tmpFileMapStack = reFilePathToTmpFileMap.get(filePath);
				if (Objects.isNull(tmpFileMapStack)) {
					Stack<String> tmpStack = new Stack<>();
					tmpStack.push(pop);
					reFilePathToTmpFileMap.put(filePath, tmpStack);
				} else {
					tmpFileMapStack.push(pop);
				}
				dealWithObject(result, type, filePath, formKey, pop);
				return pop;
			} catch (Throwable e) {
				return null;
			}
		} else {
			return null;
		}
	}

	public static void dealWithObject(List<UICommand> result, String type, String filePath, String formKey, String pop) throws Throwable {
		result.add(UICommand.reloadXmlSource(filePath));
		if ("Form".equalsIgnoreCase(type)) {
			DesignReloadMetaObject.reloadMetaFormRollbackError(null,formKey);
			result.add(UICommand.reloadFormKey(formKey));
			result.add(UICommand.refreshMenuTree(formKey));
		} else if (ConstantUtil.DATA_OBJECT.equalsIgnoreCase(type)) {
			DataObjectHelper.reload(null,formKey, pop, null);
		} else if (ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(type)) {
			IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
			ReloadForm.reloadDataMigrationKey(iMetaFactory, formKey, pop);
			JSONObject jsonFileContent = WebDataMigration.getJsonFileContent(filePath);
			result.add(UICommand.uadataWebJson(JSONObject.toJSONString(jsonFileContent,
					SerializerFeature.WriteMapNullValue,
					SerializerFeature.WriteNullStringAsEmpty,
					SerializerFeature.DisableCircularReferenceDetect)));
		} else if ("DataMap".equalsIgnoreCase(type)) {
			//重新加载数据映射
			String projectKey = LoadFileTree.getProjectKey(filePath);
			ReloadForm.reloadCustom(projectKey, formKey);
			JSONObject jsonFileContent = WebDataMapDesign.getJsonFileContent(filePath);
			result.add(UICommand.uadataWebJson(JSONObject.toJSONString(jsonFileContent,
					SerializerFeature.WriteMapNullValue,
					SerializerFeature.WriteNullStringAsEmpty,
					SerializerFeature.DisableCircularReferenceDetect)));
		} else if ("BPM".equalsIgnoreCase(type)) {
			String newContent = FileUtils.readFileToString(new File(pop), "UTF-8");
			String newSecondLine = DesignIOMetaUtil.getSecondLine(newContent);
			String version;
			try {
				version = DesignIOMetaUtil.getSubString(newSecondLine, "Version=\"([A-Za-z_]\\w*)\"");
			} catch (Exception e) {
				version = "1";
			}
			IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
			iMetaFactory.updateProcessDefination(formKey, Integer.parseInt(version));
			iMetaFactory.updateProcessDefinationByDeployKey(formKey);
			JSONObject jsonFileContent = WebBpmDesignCmd.getJsonFileContent(filePath);
			result.add(UICommand.uadataWebJson(jsonFileContent));

		}
	}

	/**
	 * 取前进对应的临时文件
	 *
	 * @param filePath
	 * @return
	 */
	public String getRedoContent(List<UICommand> result, String type, String filePath, String formKey) {
		if (reFilePathToTmpFileMap.containsKey(filePath)) {
			try {
				String pop = reFilePathToTmpFileMap.get(filePath).pop();
				//撤销时存入前进栈
				Stack<String> tmpFileMapStack = filePathToTmpFileMap.get(filePath);
				if (Objects.isNull(tmpFileMapStack)) {
					Stack<String> tmpStack = new Stack<>();
					tmpStack.push(pop);
					filePathToTmpFileMap.put(filePath, tmpStack);
				} else {
					tmpFileMapStack.push(pop);
				}
				dealWithObject(result, type, filePath, formKey, pop);
				return pop;
			} catch (Throwable e) {
				return null;
			}
		} else {
			return null;
		}
	}


	/**
	 * 清除临时文件
	 *
	 * @param filePath
	 */
	public void clearTmpFile(String filePath) {
		filePathToTmpFileMap.remove(filePath);
		reFilePathToTmpFileMap.remove(filePath);
	}
}
