package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.automap.print.template.ReportDomUtil;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.report.MetaReportLoad;
import com.bokesoft.yes.meta.persist.dom.report.MetaReportSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportDataField;
import com.bokesoft.yigo.meta.report.MetaReportDataSource;
import com.bokesoft.yigo.meta.report.MetaReportDataTable;
import com.bokesoft.yigo.meta.report.MetaReportList;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.*;

/*
 *文件名: WebPrintDesign
 *创建者: zhangk
 *创建时间:2022/11/12 13:07
 */
public class WebPrintDesign extends DesignerServiceCmd {
	public static final String CMD = "WebPrintDesign";
	private static final String XML_EXTENSION = ".xml";
	/***projectKey*/
	private String projectKey;
	/***formKey*/
	private String formKey;
	/***formCaption*/
	private String formCaption;
	private String associationForm;
	private boolean createDefaultTemplate = true;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) {
		projectKey = (String) arguments.get("projectKey");
		formKey = (String) arguments.get("newFormKey");
		formCaption = (String) arguments.get("formCaption");
		associationForm = (String) arguments.get("associationForm");
		createDefaultTemplate = Integer.valueOf((String) arguments.get("createDefaultTemplate")) == 1;

	}

	/**
	 * 创建数据对象
	 *
	 * @param projectKey 选择的工程名
	 * @param key        标识
	 * @param caption    名称
	 * @return
	 */
	public Map<String, String> createXml(String projectKey, String key, String caption) throws Throwable {
		Map<String, String> result = new HashMap<>(10);
		String filePath = "";

		String newFileName = key + XML_EXTENSION;
		//创建一个新的路径
		filePath = LoadFileTree.NewPrintfilePath(result, projectKey, newFileName, key, caption, associationForm);
		//创建一个初始的XMl Content
		String fileContent = setMetaPrint(key, caption, newFileName, projectKey);

		//创建的时候直接生成文件夹
		FileUtils.writeStringToFile(new File(filePath), fileContent, "UTF-8");
		result.put("result", "true");
		result.put("filePath", filePath);
		result.put("fileName", newFileName.replaceAll(".xml", ""));
		return result;
	}

	public MetaStatusCollection getStatusCollection(String projectKey, MetaDataObject dataObject) throws Throwable {
		if (Objects.isNull(dataObject)) {
			return null;
		}
		MetaStatusCollection statusCollection = dataObject.getStatusCollection();
		if (Objects.isNull(statusCollection)) {
			IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
			MetaStatusCollection statuses = globalInstance.getCommonDef(projectKey).getStatusCollection();
			if (Objects.isNull(statuses)) {
				return globalInstance.getCommonDef(null).getStatusCollection();
			}
			return statuses;

		} else {
			return statusCollection;
		}

	}

	private MetaReport createDefault(String key, String caption, String formKey) throws Throwable {
		MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
		MetaDataSource dataSource = metaForm.getDataSource();
		MetaDataObject metaDataObject = null;
		if (dataSource != null) {
			metaDataObject = dataSource.getDataObject();
		}
		return ReportDomUtil.createDefaultReport(key, caption, metaForm, metaDataObject, getStatusCollection(projectKey, metaDataObject));

	}

	/**
	 * @param key
	 * @param caption
	 * @throws Throwable 在MetaDataObjectList中创建文件
	 */
	private String setMetaPrint(String key, String caption, String newFileName, String projectKey) throws Throwable {
		//获取模板内容
		MetaReportList metaReportList = MetaFactory.getGlobalInstance().getMetaReportList();
		MetaReportSubList d_billModuleTem = metaReportList.get("D_BillModuleTem");
		MetaReportProfile d_printTem = d_billModuleTem.get("D_PrintTem");
		MetaReportProfile metaReportProfileClone = MetaObjectHelper.deptClone(d_printTem);
		if (createDefaultTemplate) {
			metaReportProfileClone.setReport(createDefault(key, caption, associationForm));
		}
		metaReportProfileClone.setCaption(caption);
		metaReportProfileClone.setKey(key);
		metaReportProfileClone.setFormKey(associationForm);
		if (Objects.isNull(metaReportProfileClone.getReport())) {
			MetaProject metaProject = (MetaProject) metaReportProfileClone.getProject();
			IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
			IMetaResolver projectResourceResolver = globalInstance.getProjectResolverMap().get(metaProject.getKey());
			MetaReportLoad load = new MetaReportLoad(AppRunType.App);
			load.load(projectResourceResolver, metaReportProfileClone.getResource());
			MetaReport metaReport = (MetaReport) load.getRootMetaObject();
			metaReportProfileClone.setReport(metaReport);
		}
		metaReportProfileClone.getReport().setCaption(caption);
		metaReportProfileClone.getReport().setFormKey(associationForm);
		metaReportProfileClone.getReport().setKey(key);
		if (!createDefaultTemplate) {
			MetaReportDataSource metaReportDataTables = new MetaReportDataSource();
			MetaForm metaForm = NewFormCmd.loadMetaForm(associationForm);
			MetaDataSource dataSource = metaForm.getDataSource();
			if (dataSource == null && StringUtils.isNotEmpty(metaForm.getExtend())) {
				MetaForm extendMetaForm = NewFormCmd.loadMetaForm(metaForm.getExtend());
				dataSource = extendMetaForm.getDataSource();
			}
			if (dataSource != null) {
				MetaDataObject metaDataObject = null;
				if (StringUtils.isNotEmpty(dataSource.getRefObjectKey())) {
					metaDataObject = DataObjectHelper.loadByKey(dataSource.getRefObjectKey());
				}
				MetaTableCollection tableCollection = null;
				if (metaDataObject != null) {
					tableCollection = metaDataObject.getTableCollection();
				} else {
					tableCollection = dataSource.getDataObject().getTableCollection();
				}

				for (MetaTable metaTable : tableCollection) {
					MetaReportDataTable metaReportDataFields = new MetaReportDataTable();
					metaReportDataFields.setKey(metaTable.getKey());
					metaReportDataFields.setCaption(metaTable.getCaption());
					metaReportDataFields.setSourceType(metaTable.getSourceType());
					metaReportDataTables.add(metaReportDataFields);
					for (MetaColumn metaColumn : metaTable) {
						MetaReportDataField metaReportDataField = new MetaReportDataField();
						metaReportDataField.setCaption(metaColumn.getCaption());
						metaReportDataField.setKey(metaColumn.getKey());
						metaReportDataField.setDescription(metaColumn.getDescription());
						metaReportDataField.setDBFieldKey(metaColumn.getDBColumnName());
						metaReportDataFields.add(metaReportDataField);

					}
				}
			}

			metaReportProfileClone.getReport().setDataSource(metaReportDataTables);
		}

		//更改模板内容
		MetaReportProfile metaReport = setKeyAndCaption(metaReportProfileClone, key, caption,
				metaReportList, newFileName, projectKey);

		MetaReportSave metaReportSave = new MetaReportSave(metaReport.getReport());
		org.w3c.dom.Document document = metaReportSave.getDocument();
		XmlCreator creator11 = new XmlCreator(document, null);
		return creator11.createXml();

	}

	public static ResponseResult<JSONArray> SavePrintXML(String filePaths, IMetaFactory metaFactory) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			File file = new File(filePaths);
			String tmpFile = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tmpFile)) {
				tmpFile = filePaths;
			}
			String newContent = FileUtils.readFileToString(new File(tmpFile), "UTF-8");
			//重新写入文件夹
			FileUtils.writeStringToFile(file, newContent, "UTF-8");
			XmlFileProcessor.instance.clearTmpFile(filePaths);
			result.setCode(0);
			result.setMsg("保存打印模板成功");
			//处理Print实体//Group
			String group = XmlTreeWithPath.parseFilePath(filePaths).xmlTree.getRoot().getAttributes().get("Group");
			String key = XmlTreeWithPath.parseFilePath(filePaths).xmlTree.getRoot().getAttributes().get("Key");
			String formKey1 = XmlTreeWithPath.parseFilePath(filePaths).xmlTree.getRoot().getAttributes().get("FormKey");
			MetaReportSubList reportSubList = metaFactory.getReportSubList(formKey1);
			reportSubList.get(key).setReport(null);
			metaFactory.getReport(group, key, formKey1);

		} catch (Throwable e) {
			result.setCode(999);
			result.setMsg("保存出现异常，失败消息为:" + e.getMessage());
		}
		return result;
	}

	/**
	 * @param metaReportProfile
	 * @param Key
	 * @param Caption
	 * @return 替换内容
	 */
	public MetaReportProfile setKeyAndCaption(MetaReportProfile metaReportProfile, String Key, String Caption,
											  MetaReportList metaReportList, String newFileName, String projectKey) throws Exception {

		metaReportProfile.setKey(Key);
		metaReportProfile.setCaption(Caption);
		metaReportProfile.setResource("Report/" + newFileName);
		try {
			MetaProject project = MetaFactory.getGlobalInstance().getMetaProject(projectKey);
			metaReportProfile.setProject(project);
		} catch (Throwable throwable) {
			LogSvr.getInstance().error(throwable.getMessage(), throwable);
		}
		MetaReportSubList metaReportProfiles = metaReportList.get(associationForm);

		if (Objects.isNull(metaReportProfiles)) {
			MetaReportSubList metaReportSubList = new MetaReportSubList();
			metaReportSubList.setKey(associationForm);
			metaReportSubList.add(metaReportProfile);
			metaReportList.add(metaReportSubList);
		} else {
			metaReportProfiles.add(metaReportProfile);
		}
		metaReportProfile.doPostProcess(0, null);
		return metaReportProfile;
	}

	@Override
	public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
		JSONObject result = new JSONObject();
		Map<String, String> xml = createXml(projectKey, formKey, formCaption);

		// 成功
		result.put("code", 0);
		result.put("msg", "新增文件成功");
		result.put("filePath", xml.get("filePath"));
		//前端重新装载xml文件命令
		List<UICommand> uiCommands = new ArrayList<>();
		uiCommands.add(UICommand.reloadFileTree(xml.get("filePath")));
		uiCommands.add(UICommand.reloadMenuTree());
		result.put("uICommands", UICommand.toJson(uiCommands));
		return result;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new WebPrintDesign();
	}

	@Override
	public String getCmd() {
		return CMD;
	}
}
