package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.function.CompositeComponentUtil;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import org.dom4j.Element;
import org.json.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class SetComponentGridCmd extends DesignerServiceCmd {
    public static final String CMD = "SetComponentGrid";
    private String CompositeComponentType = null;
    private String formKey = null;
    private DocumentRecordDirty formDocument;
    private String type = null;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        CompositeComponentType = (String)arguments.get("compositeComponentType");
        formKey = (String)arguments.get("metaFormKey");
        type = (String)arguments.get("type");
        if (arguments.containsKey("formDocument")) {
            String docStr = (String) arguments.get("formDocument");
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
            formDocument = new DocumentRecordDirty(metaForm, false);
            try {
                formDocument.fromJSON(new JSONObject(docStr));
            } catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
        }
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        JSONObject dirtyJSON = new JSONObject();
        ArrayList<Integer> compositeComponentTypeList = new ArrayList<>();
        if(ConstantUtil.Field.equals(type)){
            compositeComponentTypeList = formDocument.get(ConstantUtil.ED_NewCompositeComponent).filter("CompositeComponentType == '" + CompositeComponentType + "'");
        }else{
            compositeComponentTypeList = formDocument.get(ConstantUtil.ED_NewCompositeComToGrid).filter("Key == '" + CompositeComponentType + "'");
        }
        if (compositeComponentTypeList.size() > 1) {
            throw new Exception("重复设置");
        }

        MetaFormProfile metaFormProfile = MetaFactory.getGlobalInstance().getMetaFormList().get(formKey);
        DataTable dataTable = DataTableUtil.newEmptyDataTable(metaFormProfile.getForm().getMetaTable(ConstantUtil.ComponentDtl));
        Element node = CompositeComponentUtil.getCompositeComponentRoot();
        Element compositeComponentElement =
                (Element)node.selectSingleNode("/CompositeComponents/CompositeComponent[@Key='" + CompositeComponentType + "']");
        if(compositeComponentElement == null){
            return dirtyJSON;
        }
        List<Element> components = compositeComponentElement.elements("Component");
        for (int i = 0; i < components.size(); i++) {
            dataTable.append();
            String key = components.get(i).attributeValue(ConstantUtil.KEY);
            String caption = components.get(i).attributeValue(ConstantUtil.CAPTION);
            String controlType = components.get(i).attributeValue(ConstantUtil.CONTROLTYPE);
            String itemKey = components.get(i).attributeValue(ConstantUtil.ITEM_KEY);
            dataTable.setString(ConstantUtil.ComponentKey, key);
            dataTable.setString(ConstantUtil.COLUMN_KEY, key);
            dataTable.setString(ConstantUtil.ComponentCaption, caption);
            dataTable.setString(ConstantUtil.CONTROLTYPE, controlType);
            dataTable.setString(ConstantUtil.ITEM_KEY, itemKey);
            dataTable.setState(RowState.NORMAL);
        }
        formDocument.remove(ConstantUtil.ComponentDtl);
        formDocument.add(ConstantUtil.ComponentDtl, dataTable);
        formDocument.addDirtyTableFlag(ConstantUtil.ComponentDtl);
        RichDocumentContext richDocumentContext = publicMethodUtil.processParentContext(context, formDocument);
        formDocument.setContext(richDocumentContext);
        formDocument.setMetaForm(metaFormProfile.getForm());
        dirtyJSON = richDocumentContext.getDirtyJSON();
        return dirtyJSON;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new SetComponentGridCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }


}
