package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.all.initiator.InitializingDesigner;
import com.bokesoft.erp.register.ErpConfig;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.mid.base.DefaultContext;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 *
 */
public class ReviseProjectCmd extends DesignerServiceCmd {

	public static final String CMD = "ReviseProject";

	/**
	 * 新增的项目Key
	 */
	private String ProjectKey;
	/**
	 * 新增的项目名称
	 */
	private String ProjectCaption;
	private String SolutionKey;
	private String Type;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		ProjectKey = TypeConvertor.toString(arguments.get("newProject")).trim(); // formKey有特殊的含义
		ProjectCaption = TypeConvertor.toString(arguments.get("ProjectCaption")).trim();
		SolutionKey = TypeConvertor.toString(arguments.get("SolutionKey")).trim();
		Type = TypeConvertor.toString(arguments.get("Type")).trim();
	}

	/**
	 * 新增表单文件
	 */
	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		List<UICommand> result = new ArrayList<UICommand>();
		if ("New".equalsIgnoreCase(Type)) {
			String filePath = LoadFileTree.newProjectFile(ProjectKey, ProjectCaption, SolutionKey);
			if (filePath != null) {
				//	EntryProcessor.instance.NewProject(ProjectKey, ProjectCaption,SolutionKey);

				result.add(UICommand.reloadFileTree(filePath));
				result.add(UICommand.reloadMenuTree());
				result.add(UICommand.showTip("工程创建成功"));
				return UICommand.toJson(result);
			}
			result.add(UICommand.showTip("工程名存在,创建失败"));
		} else if ("Delete".equalsIgnoreCase(Type)) {

			//项目中添加新建的工程
			IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
			MetaProjectCollection projectCollection = globalInstance.getSolution().getProjectCollection();
			projectCollection.remove(ProjectKey);
			Map<String, IMetaResolver> projectResolverMap = globalInstance.getProjectResolverMap();
			projectResolverMap.remove(ProjectKey);
			//解除Solution.xml依赖
			EntryProcessor.deleteSolutionByProjectKey(ProjectKey, SolutionKey);
//			LoadFileTree.metaDesignerFactoryMap.remove(SolutionKey);
			//String parent = new File(FilePathHelper.toBackFilePath(CoreSetting.getInstance().getSolutionPath())).getParent();
			//删除Tree节点
			LoadFileTree.deleteProjectNodeByProjectKey(ProjectKey);
			//LoadFileTree.getTreeNode(parent, SolutionKey, false);
			ErpConfig.initExtendConfig();
			File file = new File(SolutionKey + File.separator + ProjectKey);
			String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", ProjectKey).toString();
			//将删除的工程文件夹移至tmp
			copy(file,newFilePath);
			//删除工程文件夹
			InitializingDesigner.delFolder(file.getPath());
			result.add(UICommand.reloadFileTree(SolutionKey));
			result.add(UICommand.reloadMenuTree());
			result.add(UICommand.freshFileTree());
			result.add(UICommand.showTip("工程删除成功"));
			return UICommand.toJson(result);
		}
		return  UICommand.toJson(result);
	}
	public static void copy(File file, String b) throws IOException {
		copy(file, new File(b));
	}
	public static void copy(File file, File file1) throws IOException {
		if (!file1.exists()) {
			file1.mkdirs();
		}
		if (file.isDirectory()) {
			File[] files = file.listFiles();
			for (File file2 : files) {
				if (file2.isDirectory()) {
					copy(file2, new File(file1.getPath(), file2.getName()));
				} else {
					Files.copy(file2.toPath(), Paths.get(file1.getPath() + File.separatorChar + file2.getName()), StandardCopyOption.REPLACE_EXISTING);
				}

			}

		}
	}


	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ReviseProjectCmd();
	}

}
