package com.bokesoft.yes.design.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

import com.bokesoft.yes.design.io.TreeNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.bpm.util.GetDataUtil;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.search.replace.FileContentReplacer;
import com.bokesoft.yes.design.search.replace.MatchReplace;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.RebuildTableUtil;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.xml.XmlCreator;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.xml.node.Xml4jUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class ReplaceFileSearchResultCmd extends DesignerServiceCmd {

	public static final String CMD = "ReplaceFileSearchResult";

	/** 工具类 */
	public static DataMapOperXmlUtil dataMapOperJsonUtil = new DataMapOperXmlUtil();

	/** 获取数据操作类 */
	private final GetDataUtil getDataUtil = new GetDataUtil();

	/** 文件路径 */
	private String filePath = "";

	private String replaceText = "";

	private List<MatchReplace> matchs = new ArrayList<MatchReplace>();

	@Override
	public void dealArguments(DefaultContext arg0, StringHashMap<Object> arguments) throws Throwable {
		filePath = (String) arguments.get("filePath");
		replaceText = (String) arguments.get("replaceStr");
		String matchsString = (String) arguments.get("matchArr");
		org.json.JSONArray array = new org.json.JSONArray(matchsString);
		for (int i = 0; i < array.length(); i++) {
			matchs.add(MatchReplace.fromJson(array.getJSONObject(i)));
		}
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		File file = new File(this.filePath);

		if (file.exists() && file.isFile()) {
			if (this.matchs.size() > 0) {
				// FileContentReplacer.replaceContentInFile(file, replaceText, matchs);

				// 获取替换后的内容
				String content = null;
				List<UICommand> result = new ArrayList<>();
				// 检验语法错误
				try {
					content = FileContentReplacer.getReplaceFileContent(file, replaceText, matchs);

					String xmlFile1 = XmlFormat.formatXML_str(content);
					XmlParser.parse(xmlFile1);
				} catch (Exception e) {
					throw new RuntimeException("xml结构错误保存失败!", e);
				}

				Object[] actions = { "SaveFileContent: ", filePath };
				Performance.endActive(Performance.startAction(actions), actions);
				IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
				String newContent = content;
				boolean isEntry = "Entry.xml".equals(FilenameUtils.getName(filePath));
				boolean isCommonDef = "CommonDef.xml".equals(FilenameUtils.getName(filePath));
				String secondLine = DesignIOMetaUtil.getSecondLine(newContent);
				String newSecondLine = DesignIOMetaUtil.getSecondLine(newContent);
				boolean hasNoAttribute = newSecondLine.matches("<[A-Za-z_]*>");
				String objectType = "";
				if (!isCommonDef && !hasNoAttribute) {
					objectType = DesignIOMetaUtil.getSubString(newSecondLine, "<([A-Za-z_]\\w*)\\s");
				}

				// 不包含Version属性代码时马甲 略过
				if (!isEntry && !isCommonDef && secondLine.contains(ConstantUtil.VERSION)) {
					if (!MetaProcess.TAG_NAME.equals(objectType)) {
						int version = checkFileVersion(content);
						newContent = versionAddOne(content, version);
					}
				}
				newContent = newContent.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
				List<MetaFormProfile> reloadMetaFormProfiles = null;
				if (!newSecondLine.contains("Key")) {
					if (isCommonDef) {
						int endi = filePath.indexOf(File.separatorChar + "CommonDef.xml");
						int iStart = filePath.indexOf(File.separatorChar + "solution" + File.separatorChar);
						String key = null;
						if (iStart + 10 < endi) {
							key = filePath.substring(iStart + 10, endi);
						}
						FileUtils.writeStringToFile(new File(filePath), content, "UTF-8");
						XmlFileProcessor.instance.clearTmpFile(filePath);
						TreeNode treeNode = LoadFileTree.getTreeNode(filePath);
						String solutionKey = treeNode.solutionKey;
						CommonDefProcessor.getInstance().reloadCommonDef(key,solutionKey);
						result.add(UICommand.reloadMenuTree());
					} else {
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					}
				} else {
					String key = DesignIOMetaUtil.getSubString(newSecondLine, "Key=\"([A-Za-z_]\\w*)\"");
					String projectKey = LoadFileTree.getProjectKey(filePath);

					if (MetaForm.TAG_NAME.equals(objectType)) {// form处理
						XmlFileProcessor.instance.saveTempFile(filePath, newContent, projectKey);
						MetaForm metaForm = metaFactory.getMetaForm(key);
						if (StringUtils.isBlank(metaForm.getProject().getKey())
								|| filePath.indexOf(metaForm.getProject().getKey()) == -1) {
							// 新增表单所选的项目名 并不等于metaForm的项目名
							setProjectKeyAndCaption(metaForm);
						}
						String extend = metaFactory.getMetaForm(key).getExtend();
						String refKey = "";
						if (metaFactory.getMetaForm(key).getDataSource() != null) {
							refKey = metaFactory.getMetaForm(key).getDataSource().getRefObjectKey();
						}
						if (!StringUtils.isNotEmpty(extend)) {// 不是马甲
							if (StringUtils.isNotEmpty(refKey)) {// 是数据对象表单
								MetaForm metaForm1 = metaFactory.getMetaForm(key);
								String refObjectKey = metaForm1.getDataSource().getRefObjectKey();
								String s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
								reloadMetaFormProfiles = DataObjectHelper.reload(null,refObjectKey, s, null);
							} else {// 不是数据对象表单
								reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(null,key);
							}
						} else {// 马甲
							Boolean mergeToSource = metaFactory.getMetaFormList().get(key).getMergeToSource();
							if (mergeToSource) {// 功能马甲
								reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(null,key);
							} else {// 界面马甲
								if (StringUtils.isNotEmpty(refKey)) {// 是数据对象表单
									MetaForm metaForm1 = metaFactory.getMetaForm(key);
									String refObjectKey = metaForm1.getDataSource().getRefObjectKey();
									String s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
									reloadMetaFormProfiles = DataObjectHelper.reload(null,refObjectKey, s, null);
								} else {// 不是数据对象表单
									reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(null,key);
								}
							}

						}
						if (reloadMetaFormProfiles != null) {
							for (MetaFormProfile metaFormProfile : reloadMetaFormProfiles) {
								result.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
							}
						}
						result.add(UICommand.reloadXmlSource(filePath));
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
						if (metaForm.getDataSource() != null) {
							RebuildTableUtil.rebuildTable(context, filePath);
						}
						XmlFileProcessor.recycleToTmpFormAndFileMap.remove("Entry@Entry" + key);
						XmlFileProcessor.instance.clearTmpFile(filePath);
						reloadDataObjects(result, metaFactory, filePath);
						SaveFilesByFormKeyCmd.removeScopeCache(metaForm, metaFactory, result);
						SaveFileContentCmd.formatXml(filePath, key);
					} else if (isEntry) {// 菜单处理
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
						XmlFileProcessor.instance.clearTmpFile(filePath);
						// String projectKey = LoadFileTree.getProjectKey(filePath);
						EntryProcessor.instance.reloadEntry(projectKey);
						result.add(UICommand.reloadMenuTree());
					} else if (MetaObjectType.DataObject.name.equals(objectType)) {
						// 数据对象处理
						XmlFileProcessor.instance.saveTempFile(filePath, newContent, projectKey);
						String s = LoadFileTree.loadFilePathByDataObjectFieldKey(key);
						reloadMetaFormProfiles = DataObjectHelper.reload(null,key, s, null);
						RebuildTableUtil.rebuildTable(context, filePath);
						if (reloadMetaFormProfiles != null) {
							for (MetaFormProfile metaFormProfile : reloadMetaFormProfiles) {
								result.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
							}
						}
						reloadDataObjects(result, metaFactory, filePath);
						SaveFilesByFormKeyCmd.removeScopeCache(null, metaFactory, result);
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
						XmlFileProcessor.instance.clearTmpFile(filePath);
					} else if (MetaDataMigration.TAG_NAME.equals(objectType)) {// 数据迁移
						XmlFileProcessor.instance.saveTempFile(filePath, newContent, projectKey);
						ResponseResult<JSONArray> haveMainTable = isHaveMainTable(filePath);
						ResponseResult<List<JSONObject>> responseResult = dataMapOperJsonUtil.SaveHtml(filePath);
						List<JSONObject> data = responseResult.getData();
						if (data != null && data.size() > 0) {
							result.add(UICommand.rebuildTable(data));
						}
						String msg = haveMainTable.getMsg();
						if (StringUtils.isNotEmpty(msg)) {
							result.add(UICommand.showError("保存成功：" + msg));
						} else {
							result.add(UICommand.showTip("保存成功"));
						}
					} else if (MetaMap.TAG_NAME.equals(objectType)) {// 数据映射
						XmlFileProcessor.instance.saveTempFile(filePath, newContent, projectKey);
						ResponseResult<JSONArray> haveMainTable = isHaveMainTable(filePath);
						ResponseResult<List<JSONObject>> responseResult = dataMapOperJsonUtil.SaveHtml(filePath);
						List<JSONObject> data = responseResult.getData();
						if (data != null && data.size() > 0) {
							result.add(UICommand.rebuildTable(data));
							if (data.size() > 1) {
								result.add(UICommand.reloadFormKey(data.get(1).getString("key")));// reload目标表
							}
						}
						String msg = haveMainTable.getMsg();
						if (StringUtils.isNotEmpty(msg)) {
							result.add(UICommand.showError(msg));
						} else {
							result.add(UICommand.showTip("保存成功"));
						}
					} else if (MetaProcess.TAG_NAME.equals(objectType)) {// 工作流
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
						getDataUtil.SaveBPMXML(filePath);
						result.add(UICommand.showTip("保存成功"));
					} else if (MetaReport.TAG_NAME.equals(objectType)) {// 打印模板
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
						WebPrintDesign.SavePrintXML(filePath, metaFactory);
						result.add(UICommand.showTip("保存成功"));
					} else if (MetaExcelWorkbook.TAG_NAME.equals(objectType)) {// Excel模板
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
						WebExcelDesign.SaveExcelXML(filePath, metaFactory);
						result.add(UICommand.showTip("保存成功"));
					} else {
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					}

				}
				result.add(UICommand.reloadXmlSource(filePath));
				List<UICommand> resultList = result.stream().distinct().collect(Collectors.toList());
				return UICommand.toJson(resultList);
			}
		}

		return true;
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ReplaceFileSearchResultCmd();
	}

	/**
	 * 检查文件版本是否一致
	 *
	 * @return
	 * @throws Throwable
	 */
	private int checkFileVersion(String content) throws Throwable {
		Stack<String> stack = XmlFileProcessor.filePathToTmpFileMap.get(filePath);
		if (stack != null && stack.size() > 0) {
			String peek = stack.peek();
			return checkFileVersion(peek, content);
		}
		return checkFileVersion(filePath, content);
	}

	/**
	 * 检查文件版本是否一致
	 *
	 * @param oldFilePath
	 * @param newContent
	 * @return
	 * @throws Throwable
	 */
	public static int checkFileVersion(String oldFilePath, String newContent) throws Throwable {
		File file = new File(oldFilePath);
		String oldContent = FileUtils.readFileToString(file, "UTF-8");
		int oldVersion = getVersion(oldContent);
		int newVersion = getVersion(newContent);
		if (oldVersion != newVersion) {
			throw new RuntimeException(
					"文件" + oldFilePath + "中版本为" + oldVersion + "，而新文件中版本为" + newVersion + "，不一致导致保存失败。");
		}
		return newVersion;
	}

	private static int getVersion(String content) {
		String secondLine = DesignIOMetaUtil.getSecondLine(content);
		String version = DesignIOMetaUtil.getSubString(secondLine, "Version=\"(\\d+)\"");
		return Integer.parseInt(version);
	}

	/**
	 * 版本加1
	 *
	 * @param content
	 * @param version
	 * @return
	 */
	public static String versionAddOne(String content, int version) {
		return content.replace("Version=\"" + version + "\"", "Version=\"" + (version + 1) + "\"");
	}

	/**
	 * 验证是否存在主表
	 */
	public static ResponseResult<JSONArray> isHaveMainTable(String filePath) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.isHaveMainTable(filePath);
		} catch (Exception e) {
			response.setCode(999);
			response.setMsg("保存失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			LogSvr.getInstance().error(throwable.getMessage(), throwable);
		}
		return response;
	}

	public static void formatXml(String filePath, String key) throws Throwable {
		MetaForm metaForm1 = NewFormCmd.loadMetaForm(key);
		MetaFormSave metaFormSave = new MetaFormSave(metaForm1);
		Document document = metaFormSave.getDocument();
		XmlTree oldXmlTree = Xml4jUtil.parseTree(filePath);
		String xml = new XmlCreator(document, oldXmlTree).createXml();
		FileUtils.writeStringToFile(new File(filePath), xml, "UTF-8");
	}

	public static void reloadDataObjects(List<UICommand> result, IMetaFactory metaFactory, String filePath)
			throws Throwable {
		//Class<?> instance = Class.forName("com.bokesoft.yes.mid.mysqls.group.meta.DataObjects");
		//Method init = instance.getDeclaredMethod("init", IMetaFactory.class);
		// 实例化对象的方法
		DataObjects.getInstance().init(metaFactory, true);
		//init.setAccessible(true);
		//init.invoke(instance1, metaFactory);
		result.add(UICommand.reloadXmlSource(filePath));
	}

	public static void setProjectKeyAndCaption(MetaForm metaForm) throws Throwable {
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		String projectKey;
		if (StringUtils.isNotEmpty(metaForm.getExtend())) {// 马甲
			projectKey = NewExpandFormCmd.projectKey;
		} else {
			projectKey = NewFormCmd.projectKey;
		}
		if (StringUtils.isBlank(projectKey)) {
			return;
		}
		MetaProject metaProject = metaFactory.getMetaProject(projectKey);
		metaForm.setProject(metaProject);
	}
}
