package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.vo.RecycleForm;
import com.bokesoft.yes.erp.scope.MetaFormAllFormulScopeCache;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSubList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * create time: 2020/12/15 10:00
 * Affect :删除表单后处理还原操作
 *
 * @Param: null
 * @return
 */
public class ReductionXmlCmd extends DesignerServiceCmd {
	public static final String CMD = "ReductionXml";
	/**
	 * 文件路径
	 */
	private String reduKey;


	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) {
		reduKey = (String) arguments.get("reduKey");
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		RecycleForm tempRecycleFile = XmlFileProcessor.instance.getTempRecycleFile(reduKey);
		String content = tempRecycleFile.getContent();
		String type = tempRecycleFile.getType();
		String filePath = tempRecycleFile.getFilePath();
		List<UICommand> result = new ArrayList<UICommand>();
		Object form = tempRecycleFile.getForm();
		if (Objects.isNull(form)) {
			result.add(UICommand.showError("数据丢失无法恢复当前表单"));
			XmlFileProcessor.recycleToTmpFormAndFileMap.remove(reduKey);
			result = result.stream().distinct().collect(Collectors.toList());
			return UICommand.toJson(result);
		}
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		MetaFormList metaFormList = metaFactory.getMetaFormList();
		if (MetaForm.TAG_NAME.equals(type)) {
			MetaFormProfile metaFormProfile = (MetaFormProfile) tempRecycleFile.getForm();
			if (metaFormProfile.getMergeToSource()) {
				//如果存在功能马甲不给还原
				String extend = metaFormProfile.getExtend();
				for (MetaFormProfile metaFormProfile1 : metaFormList) {
					if (metaFormProfile1.getMergeToSource()) {
						if (extend.equalsIgnoreCase(metaFormProfile1.getExtend())) {
							result.add(UICommand.showError("当前项目存在了一个功能马甲无法还原"));
							result = result.stream().distinct().collect(Collectors.toList());
							return UICommand.toJson(result);
						}
					}
				}
			}
			String key = metaFormProfile.getKey();
			MetaFormProfile metaFormProfile1 = metaFormList.get(key);
			if (metaFormProfile1 != null) {
				result.add(UICommand.showError("当前项目存在了相同Key的表单无法还原"));
				result = result.stream().distinct().collect(Collectors.toList());
				return UICommand.toJson(result);
			}
			MetaForm cloneForm = metaFormProfile.getForm();
			//还原MetaForm
			metaFormList.add(metaFormProfile);
			//还原数据对象
			if (metaFormProfile.getFormType() == FormType.Entity ||
					metaFormProfile.getFormType() == FormType.Dict ||
					metaFormProfile.getFormType() == FormType.ChainDict) {
				addInlineDataObject(metaFormProfile, cloneForm, true,metaFactory.getDataObjectList());
			}
			//清除Scope重新计算
			MetaFormAllFormulScopeCache.instance.clear(metaFormProfile.getKey());
			//重新处理entry.xml
			EntryProcessor.instance.newForm("", cloneForm.getFormType(), cloneForm.getKey(), cloneForm.getCaption(), null, false);
			result.add(UICommand.runFormKey(cloneForm.getKey()));
			result.add(UICommand.reloadMenuTree());
			if (metaFormProfile.getMergeToSource()) {//功能马甲的删除后处理
				// result.add(UICommand.reloadFileTree(filePath));
				//将路径从新添加到LoadTree
				LoadFileTree.addFilePath(filePath, tempRecycleFile.getTreeNode(), type);
				//将xml重新写入文件夹
				FileUtils.writeStringToFile(new File(filePath), content, "UTF-8");
				XmlFileProcessor.recycleToTmpFormAndFileMap.remove(reduKey);
				result.add(UICommand.showTip("操作成功"));
				DesignReloadMetaObject.reloadMetaFormRollbackError(metaFormProfile.getKey());
				result = result.stream().distinct().collect(Collectors.toList());
				result.add(UICommand.refreshFileTreeChildren(filePath));
				return UICommand.toJson(result);
			}
		} else if (MetaDataObject.TAG_NAME.equals(type)) {
			MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile) tempRecycleFile.getForm();
			String key = metaDataObjectProfile.getKey();
			MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
			MetaDataObjectProfile metaDataObjectProfile1 = dataObjectList.get(key);
			if (metaDataObjectProfile1 != null) {
				result.add(UICommand.showError("当前项目存在了相同Key的数据对象无法还原"));
				result = result.stream().distinct().collect(Collectors.toList());
				return UICommand.toJson(result);
			}
			//数据对象
			dataObjectList.add(metaDataObjectProfile);
		} else if (MetaDataMigration.TAG_NAME.equals(type)) {//数据迁移
			MetaDataMigrationProfile metaDataMigrationProfile = (MetaDataMigrationProfile) tempRecycleFile.getForm();
			String key = metaDataMigrationProfile.getKey();
			MetaDataMigrationList dataMigrationList = metaFactory.getDataMigrationList();
			MetaDataMigrationProfile metaDataMigrationProfile1 = dataMigrationList.get(key);
			if (metaDataMigrationProfile1 != null) {
				result.add(UICommand.showError("当前项目存在了相同Key的数据迁移无法还原"));
				result = result.stream().distinct().collect(Collectors.toList());
				return UICommand.toJson(result);
			}
			dataMigrationList.add(metaDataMigrationProfile);
		} else if (MetaMap.TAG_NAME.equals(type)) {//数据映射
			KeyPairMetaObject metaMap = (KeyPairMetaObject) tempRecycleFile.getForm();
			String key = metaMap.getKey();
			ERPMetaMap metaMap1 = metaFactory.getMetaCustomObject(ERPMetaMap.class, key);
			if (metaMap1 != null) {
				result.add(UICommand.showError("当前项目存在了相同Key的数据映射无法还原"));
				result = result.stream().distinct().collect(Collectors.toList());
				return UICommand.toJson(result);
			}
			List<KeyPairMetaObject> customList = metaFactory.getCustomList();
			customList.add(metaMap);
		} else if (MetaProcess.TAG_NAME.equals(type)) {//工作流
			//将xml重新写入文件夹
			//将路径从新添加到LoadTree
			LoadFileTree.addFilePath(filePath, tempRecycleFile.getTreeNode(), type);
			FileUtils.writeStringToFile(new File(filePath), content, "UTF-8");
			metaFactory.reloadMetaBPM();
			XmlFileProcessor.recycleToTmpFormAndFileMap.remove(reduKey);
			result.add(UICommand.reloadFileTree(filePath));
			result = result.stream().distinct().collect(Collectors.toList());
			return UICommand.toJson(result);
		} else if (MetaReport.TAG_NAME.equals(type)) {//Print
			//将xml重新写入文件夹
			//将路径从新添加到LoadTree
			MetaReportProfile reportProfile = (MetaReportProfile) tempRecycleFile.getForm();
			String formKey = reportProfile.getFormKey();
			LoadFileTree.addFilePath(filePath, tempRecycleFile.getTreeNode(), tempRecycleFile.getProjectKey(),formKey, type);
			FileUtils.writeStringToFile(new File(filePath), content, "UTF-8");

			MetaReportSubList metaReportSubList =  metaFactory.getMetaReportList().get(formKey);
			metaReportSubList.add(reportProfile);
			XmlFileProcessor.recycleToTmpFormAndFileMap.remove(reduKey);
			result.add(UICommand.reloadFileTree(filePath));
			result = result.stream().distinct().collect(Collectors.toList());
			return UICommand.toJson(result);
		} else if (MetaExcelWorkbook.TAG_NAME.equals(type)) {//Excel
			//将xml重新写入文件夹
			//将路径从新添加到LoadTree
			LoadFileTree.addFilePath(filePath, tempRecycleFile.getTreeNode(), tempRecycleFile.getProjectKey(),"", type);
			FileUtils.writeStringToFile(new File(filePath), content, "UTF-8");
			MetaExcelTemplateSubList metaExcelTemplateSubList = metaFactory.getMetaExcelTemplateList().get(tempRecycleFile.getProjectKey());
			metaExcelTemplateSubList.add((MetaExcelTemplateProfile) tempRecycleFile.getForm());

			XmlFileProcessor.recycleToTmpFormAndFileMap.remove(reduKey);
			result.add(UICommand.reloadFileTree(filePath));
			result = result.stream().distinct().collect(Collectors.toList());
			return UICommand.toJson(result);
		} else {
			result.add(UICommand.showTip("不应该出现的错误"));
			result = result.stream().distinct().collect(Collectors.toList());
			return UICommand.toJson(result);
		}
		if (!MetaForm.TAG_NAME.equals(type)) {
			result.add(UICommand.reloadFileTree(filePath));
		} else {
			result.add(UICommand.refreshFileTreeChildren(filePath));
		}
		//将路径从新添加到LoadTree
		LoadFileTree.addFilePath(filePath, tempRecycleFile.getTreeNode(), type);
		//将xml重新写入文件夹
		FileUtils.writeStringToFile(new File(filePath), content, "UTF-8");
		XmlFileProcessor.recycleToTmpFormAndFileMap.remove(reduKey);
		if (MetaForm.TAG_NAME.equals(type)) {
			MetaFormProfile metaFormProfile = (MetaFormProfile) tempRecycleFile.getForm();
			MetaForm cloneForm = metaFormProfile.getForm();
			if (StringUtils.isBlank(cloneForm.getExtend()) && StringUtils.isNotBlank(cloneForm.getDataSource().getRefObjectKey())) {
				if (StringUtils.isNotBlank(cloneForm.getDataSource().getDataObject().getMergeToSourceMapKey())) {
					DesignReloadMetaObject.reloadMetaFormRollbackError(metaFormProfile.getKey());
				}
			}
		}
		result.add(UICommand.showTip("操作成功"));
		result = result.stream().distinct().collect(Collectors.toList());
		return UICommand.toJson(result);
	}

	private void addInlineDataObject(MetaFormProfile metaFormProfile, MetaForm metaForm, boolean errorFlag,
									 MetaDataObjectList dataObjectList) throws Throwable {
		if (metaFormProfile.getMergeToSource()) {
			// 合并至原单的马甲不需要处理
			return;
		}
		MetaDataSource metaDataSource = metaForm.getDataSource();
		if (metaDataSource != null) {
			String refDataObjectKey = metaDataSource.getRefObjectKey();
			// 只有独立引用的情况下才去读取数据源
			if (refDataObjectKey == null || refDataObjectKey.isEmpty()) {
				MetaDataObject metaDataObject = metaDataSource.getDataObject();
				if (metaDataObject != null) {
					IMetaProject project = metaFormProfile.getProject();
					metaDataObject.setProject(metaFormProfile.getProject());
					metaDataObject.setVersion(metaForm.getVersion());
					MetaDataObjectProfile metaDataObjectProfile = new MetaDataObjectProfile();
					metaDataObjectProfile.setProject(project);
					metaDataObjectProfile.setKey(metaDataObject.getKey());
					metaDataObjectProfile.setCaption(metaDataObject.getCaption());
					metaDataObjectProfile.setDataObject(metaDataObject);
					metaDataObjectProfile.setFormKey(metaFormProfile.getKey());
					metaDataObjectProfile.setPrimaryType(metaDataObject.getPrimaryType());
					metaDataObjectProfile.setSecondaryType(metaDataObject.getSecondaryType());

					if (dataObjectList.containsKey(metaDataObjectProfile.getKey())) {
						MetaDataObjectProfile tmpDataObjectProfile = dataObjectList.get(metaDataObjectProfile.getKey());
						IMetaProject tmpProject = tmpDataObjectProfile.getProject();
						if (errorFlag) {
							throw new MetaException(MetaException.REPEAT_DATAOBJECT_DEFINED,
									SimpleStringFormat.format(
											StringTable.getString(null, "", StringTable.RepeatDataObjectDefined),
											project.getKey(), metaFormProfile.getKey(), metaDataObjectProfile.getKey(),
											tmpProject.getKey(), tmpDataObjectProfile.getFormKey()));
						}
					} else {
						dataObjectList.add(metaDataObjectProfile);
					}
				}
			}
		}
	}
	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ReductionXmlCmd();
	}

	@Override
	public String getCmd() {
		return CMD;
	}
}
