package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.vest.DefaultVestCreator;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 *
 */
public class NewExpandFormCmd extends DesignerServiceCmd {

	public static final String CMD = "NewExpandForm";

	/**
	 * 项目的名
	 */
	public static String projectKey;
	/**
	 * 关联表单
	 */
	private String associationForm;
	/**
	 * 关联表单
	 */
	private int formType;
	/**
	 * 新增的扩展表单Key
	 */
	private String formKey;
	/**
	 * 新增的扩展表单名称
	 */
	private String formCaption;
	/**
	 * 指定的目录
	 */
	private String directory;
	/**
	 * 是否指定的目录
	 */
	private String isdirectory;
	/**
	 * Entry目录
	 */
	private String Source;
	/**
	 * 是否合并数据源
	 */
	private String MergeToSource;
	private String mergeToSourceMapKey;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		projectKey = TypeConvertor.toString(arguments.get("projectKey")).trim();
		associationForm = TypeConvertor.toString(arguments.get("associationForm")).trim();
		formKey = TypeConvertor.toString(arguments.get("newFormKey")).trim(); // formKey有特殊的含义
		formCaption = TypeConvertor.toString(arguments.get("formCaption")).trim();
		formType = MetaFactory.getGlobalInstance().getMetaForm(associationForm).getFormType();
		directory = TypeConvertor.toString(arguments.get("directory")).trim();
		isdirectory = TypeConvertor.toString(arguments.get("IsDirectory")).trim();
		Source = TypeConvertor.toString(arguments.get("Source")).trim();
		MergeToSource = TypeConvertor.toString(arguments.get("MergeToSource")).trim();
	}

	/**
	 * 新增扩展表单文件
	 */
	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		MetaFormList metaFormList = metaFactory.getMetaFormList();
		if (metaFormList.containsKey(formKey)) {
			return null;
		}

		MetaForm metaForm = metaFactory.getMetaForm(associationForm);
		MetaDataSource dataSource = metaForm.getDataSource();
		String refObjectKey1 = "";
		if (dataSource != null){
			refObjectKey1 = dataSource.getRefObjectKey();
		}
		if (StringUtils.equals(MergeToSource, "1")){
			for (MetaFormProfile metaFormProfile : metaFormList) {
				if (metaFormProfile.getMergeToSource()) {
					if (associationForm.equalsIgnoreCase(metaFormProfile.getExtend())) {
						MergeToSource = "0";
					}
				}
			}
		}
		if (StringUtils.isNotBlank(refObjectKey1) && StringUtils.equals(MergeToSource, "1")) {
			MetaDataObject dataObject = metaFactory.getDataObject(refObjectKey1);
			mergeToSourceMapKey = dataObject.getMergeToSourceMapKey();
			if (StringUtils.isBlank(mergeToSourceMapKey)) {
				MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
				for (MetaDataObjectProfile metaDataObjectProfile : dataObjectList) {
					if (StringUtils.equals(metaDataObjectProfile.getExtend(), refObjectKey1)) {
						mergeToSourceMapKey = metaDataObjectProfile.getKey();
						break;
					}
				}
				if (StringUtils.isBlank(mergeToSourceMapKey)) {
					mergeToSourceMapKey = dataObject.getKey() + "_Vest";
					String caption = dataObject.getCaption() + "马甲";
					MetaDataObjectProfile profile = DataObjectHelper.createOutsideProfile(mergeToSourceMapKey, caption, projectKey, refObjectKey1);
					//创建一个新的路径
					String filePath = LoadFileTree.NewDataObjectFilePath(projectKey, mergeToSourceMapKey, caption);
					//创建一个初始的XMl Content
					String fileContent = DataObjectHelper.createXml(profile.getDataObject());
					//生成一个临时文件
					XmlFileProcessor.instance.saveTempFile(filePath, fileContent,projectKey);
					//创建的时候直接生成文件
					FileUtils.writeStringToFile(new File(filePath), fileContent, "UTF-8");
					dataObjectList.add(profile);
				}
			}
		}

		String fileName = formKey + ".xml";
		String content = getNewFormContent(formKey, formCaption, associationForm);
		String filePath = LoadFileTree.newFile(projectKey, formType, fileName, formKey, formCaption, directory, isdirectory);
		String tmpFilePath = XmlFileProcessor.instance.saveTempFile(filePath, content,projectKey);
		File file = new File(filePath);
		String reloadParentKey = "";
		if (!file.getParentFile().exists()){
			reloadParentKey = file.getParent();
		}
		FileUtils.writeStringToFile(file, content, "UTF-8");

		String resource = LoadFileTree.getResource(tmpFilePath,projectKey);
		metaFormList.get(formKey).setProject(metaFactory.getMetaProject(projectKey));
		metaFormList.get(formKey).setResource(resource);
		metaFormList.get(formKey).setExtend(associationForm);
		metaFormList.get(formKey).setMergeToSource("1".equals(MergeToSource));
		if (!"1".equals(MergeToSource)&& StringUtils.isNotEmpty(associationForm)){
			metaFormList.get(formKey).setFormType(-1);
		}
		metaFactory.reloadMetaForm(formKey);
		metaFactory.getMetaForm(formKey);
		EntryProcessor.instance.newForm(projectKey, formType, formKey, formCaption, Source, true);
		List<MetaFormProfile> reloadMetaFormProfiles = null;
		String refKey = "";
		if (metaFactory.getMetaForm(formKey).getDataSource() != null) {
			refKey = metaFactory.getMetaForm(formKey).getDataSource().getRefObjectKey();
		}
		if ("1".equals(MergeToSource)) {//功能马甲
			reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(formKey);
		} else {
			if (StringUtils.isNotEmpty(refKey)) {//是数据对象表单
				MetaForm metaForm1 = metaFactory.getMetaForm(formKey);
				String refObjectKey = metaForm1.getDataSource().getRefObjectKey();
				String s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
				reloadMetaFormProfiles = DataObjectHelper.reload(null,refObjectKey, s, null);
			} else {//不是数据对象表单
				reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(formKey);
			}
		}
		List<UICommand> result = new ArrayList<UICommand>();
		if (reloadMetaFormProfiles != null) {
			for (MetaFormProfile metaFormProfile : reloadMetaFormProfiles) {
				result.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
			}
		}
		UICommand command = UICommand.reloadFileTree(filePath);
		result.add(command);
		if (!reloadParentKey.isEmpty()){
			result.add(UICommand.reloadFileTree(reloadParentKey));
		}
		result.add(UICommand.runFormKey(formKey));
		result.add(UICommand.reloadMenuTree());

		return UICommand.toJson(result);
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new NewExpandFormCmd();
	}

	/**
	 * 生成新表单配置的源文件，并更新配置对象
	 *
	 * @param key
	 * @param caption
	 * @param oldFormKey
	 * @return
	 * @throws Throwable
	 */
	private String getNewFormContent(String key, String caption, String oldFormKey) throws Throwable {
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		MetaFormList metaFormList = metaFactory.getMetaFormList();
		MetaForm module = getModule(oldFormKey);
		MetaForm newMetaForm = setKeyAndCaption(module, key, caption);
		String xml = saveMetaForm(module);
		MetaFormProfile newFormProfile = (MetaFormProfile) metaFormList.get(module.getKey()).clone();
		newFormProfile.setKey(key);
		newFormProfile.setCaption(caption);
		newFormProfile.setResource("");
		newFormProfile.setForm(newMetaForm);
		newFormProfile.setExtend(oldFormKey);
		metaFormList.add(newFormProfile);
		MetaObjectChange.fireChangeDesignMetaForm(newMetaForm);
		MetaForm erpNewMetaForm = metaFactory.getMetaForm(key); // 这里进行ERPMetaFactory中的相关处理
		metaFactory.replaceMetaForm(key, erpNewMetaForm);
		return xml;
	}

	private synchronized MetaForm getModule(String oldFormKey) throws Throwable {
		MetaForm result;
		result = MetaFactory.getGlobalInstance().getMetaForm(oldFormKey);
		return (MetaForm) result.clone();
	}

	/**
	 * 设置新的Key和Caption，同时修改表名等Key
	 *
	 * @param module
	 * @param key
	 * @param caption
	 * @return
	 */
	private MetaForm setKeyAndCaption(MetaForm module, String key, String caption) {
		MetaForm newMetaForm = (MetaForm) module.clone();
		newMetaForm.setKey(key);
		newMetaForm.setCaption(caption);
		newMetaForm.setExtend(module.getKey());
		newMetaForm.doPostProcess(0, null);
		return newMetaForm;
	}

	private String saveMetaForm(MetaForm module) throws Throwable {
		String solutionPath = LoadFileTree.getPathByFormKey(associationForm);
		DefaultVestCreator defaultVestCreator = new DefaultVestCreator(formKey, formCaption, solutionPath);
		String vestXml = defaultVestCreator.createVestXml(associationForm,StringUtils.equals(MergeToSource, "1"));

		if (!StringUtils.equals(MergeToSource, "1")) {//界面马甲
			String refObjectKey = "";
			MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
			for (MetaFormProfile metaFormProfile : metaFormList) {
				if (metaFormProfile != null) {
					Boolean mergeToSource = metaFormProfile.getMergeToSource();
					if (mergeToSource && associationForm.equals(metaFormProfile.getExtend())) {
						MetaForm form = metaFormProfile.getForm();
						String filePath = LoadFileTree.getPathByFormKey(form.getKey());
						String tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
						if (tmpFilePath != null) {
							filePath = tmpFilePath;
						}
						DefaultVestCreator defaultVestCreator1 = new DefaultVestCreator(formKey, formCaption, filePath);
						vestXml = defaultVestCreator1.createVestXml(associationForm,StringUtils.equals(MergeToSource, "1"));
						refObjectKey = form.getDataSource().getDataObject().getKey();

						break;

					}
				}
			}
			String pathByDataObject = LoadFileTree.getPathByDataObject(refObjectKey);
			if (pathByDataObject != null && !pathByDataObject.isEmpty()) {
				XmlTree parse = XmlParser.parse(vestXml);
				TagNode dataSource = parse.getRoot().getOrCreateChildByTagName(ConstantUtil.DATA_SOURCE);
				TagNode parentTagNode = dataSource.getParent();
				int lineByIndex = parse.getLineByIndex(parentTagNode.getElement().getBgIndex());
				String xml = DesignIOMetaUtil.getXml(parentTagNode);
				parse.getRoot().deleteChildByTagName(ConstantUtil.DATA_SOURCE);
				String xml1 = DesignIOMetaUtil.getXml(parse.getRoot());
				ReplaceStringEntry replaceStringEntry = new ReplaceStringEntry();
				vestXml = CheckXMLChanged.mergeXML(vestXml, lineByIndex, xml, xml1, replaceStringEntry, false);
			}
			return vestXml;
		}else {//功能
			String refObjectKey = "";
			if (module.getDataSource()!=null){
				refObjectKey = module.getDataSource().getRefObjectKey();
			}
			if (StringUtils.isBlank(refObjectKey)) {//内敛数据对象
				return vestXml;
			} else {//外联数据对象

				XmlTree xmlTree = XmlParser.parse(vestXml);
				TagNode rootNode = xmlTree.getRoot();
				rootNode.setAttribute("MergeToSource", "true");

				TagNode dataSource1 = new TagNode(ConstantUtil.DATA_SOURCE, null);
				dataSource1.setAttribute("RefObjectKey", mergeToSourceMapKey);
				// TagNode dataObjectNode = new TagNode(ConstantUtil.DATA_OBJECT, null);
				// dataSource1.addNode(dataObjectNode);
				// dataObjectNode.setAttribute("RefObjectKey", mergeToSourceMapKey);

				List<AbstractNode> children1 = rootNode.getChildren();
				int index = 0;
				for (int i = 0; i < children1.size(); i++) {
					AbstractNode abstractNode = children1.get(i);
					if (abstractNode instanceof TagNode && ConstantUtil.DATA_SOURCE.equals(((TagNode) abstractNode).getTagName())) {
						index = i;
					}
				}
				rootNode.addNode(dataSource1, index);
				String xml1 = DesignIOMetaUtil.getXml(rootNode);
				return "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n" + xml1 + "\n";
			}

		}


	}
}
