package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.setting.util.DataElementDefOperJsonUtil;
import com.bokesoft.yes.design.setting.util.DomainDefOperJsonUtil;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDataElementDefLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDataElementDefSave;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDomainDefLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDomainDefSave;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.CaseType;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.common.MetaFieldLabel;
import com.bokesoft.yigo.meta.common.MetaFieldLabelCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.domain.MetaDomainCollection;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class NewDomainORDataElementCmd extends DesignerServiceCmd {

    public static final String CMD = "NewDomainORDataElement";

    /***操作类型 1：新增；2：修改；3：删除*/
    private String operType = "New";
    private String formKey = null;
    private DocumentRecordDirty formDocument;
    /***projectKey*/
    private String projectKey;
    private String fileType;
    /***key*/
    private String key;
    /***filePath*/
    private String filePath;

    private String pFormKey;

    /***常量CONST_ONE*/
    public static final String CONST_ONE = "New";

    private boolean flag = true;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        String path = (String) arguments.get("filePath");
        if(StringUtils.isEmpty(path)){
            flag = false;
            pFormKey = (String) arguments.get("pFormKey");
            if(StringUtils.isNotEmpty(pFormKey)){
                filePath = FilePathHelper.toBackFilePath(LoadFileTree.getPathByFormKey(pFormKey));
            }else{
                filePath = "";
            }
        }else{
            filePath = FilePathHelper.toBackFilePath(path);
        }
        projectKey = (String) arguments.get("projectKey");
        formKey = (String) arguments.get("formKey");
        key = (String) arguments.get("key");
        operType = (String) (arguments.get("operType"));
        fileType = (String) (arguments.get("fileType"));
        if (arguments.containsKey("formDocument")) {
            String docStr = (String) arguments.get("formDocument");
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
            formDocument = new DocumentRecordDirty(metaForm, false);
            try {
                formDocument.fromJSON(new org.json.JSONObject(docStr));
            } catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
        }
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        JSONObject result = new JSONObject();
        DataTable ed_newDomain = formDocument.get("ED_NewDomain");
        //前端重新装载xml文件命令
        List<UICommand> uiCommands = new ArrayList<>();
        if (fileType.equals("Domain")) {
            if (CONST_ONE.equalsIgnoreCase(operType)) {//新增Domain
                newDomain(ed_newDomain,"NewDomain",null);
            }
        } else {
            if (CONST_ONE.equalsIgnoreCase(operType)) {//新增DataElement
                String domainNewKey = newDomain(ed_newDomain,"",uiCommands);
                newDataElement(domainNewKey);

            }
        }
        // 成功
        result.put("code", 0);
        result.put("msg", "新增文件成功");
        result.put("filePath", this.filePath);

        if(flag){
            uiCommands.add(UICommand.reloadFileTree(this.filePath));
        }
        uiCommands.add(UICommand.reloadMenuTree());
        result.put("uICommands", UICommand.toJson(uiCommands));
        return result;
    }

    private void newDataElement(String domainNewKey) throws Throwable {
        DataTable ed_newDataElement = formDocument.get("ED_NewDataElement");
        String dataElementKey = ed_newDataElement.getString("DataElementKey");
        String dataElementCaption = ed_newDataElement.getString("DataElementCaption");
        String dataElementProjectKey = ed_newDataElement.getString("DataElementProjectKey");
        String dataElementPosition = ed_newDataElement.getString("DataElementPosition");
        String newDataElementFileKey = ed_newDataElement.getString("NewDataElementFileKey");
        String defaultCaption = ed_newDataElement.getString("DefaultCaption");
        String dataDiffLog = ed_newDataElement.getString("DataDiffLog");
        String noHistory = ed_newDataElement.getString("NoHistory");
        String paramID = ed_newDataElement.getString("ParamID");
        MetaDataElementDef metaDataElementDef;
        MetaDataElementCollection metaDataElements;
        MetaDataElement metaDataElement = new MetaDataElement();
        String resourceDataElement;
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        IMetaResolver resolver = globalInstance.getProjectResolver(dataElementProjectKey);
        AtomicReference<String> path = new AtomicReference<>(dataElementProjectKey);
        File file = new File(dataElementPosition);
        if (StringUtils.isEmpty(dataElementProjectKey)) {
            if(dataElementPosition.equalsIgnoreCase("NewDataElementFile")){
                LoadFileTree.metaDesignerSolutionPathMap.forEach((k, v) -> {
                    if (filePath.contains(v)) {
                        path.set(k);
                    }
                });
            }else{
                LoadFileTree.mapDataElementKeyToXmlPath.forEach((k, v) -> {
                    if(k.equalsIgnoreCase(file.getName().substring(0,file.getName().lastIndexOf(".")))){
                        path.set(v.solutionKey);
                    }
                });
            }
            String solutionPath = LoadFileTree.getSolutionPath(path.get());
            resolver = new DefaultMetaResolverFactory(solutionPath).newMetaResolver("");
        }
        String solutionPath = LoadFileTree.getSolutionPath(path.get());
        MetaDataElementDefLoad metaDataElementDefLoad = new MetaDataElementDefLoad(AppRunType.Dev);
        boolean newDataElementFile = false;
        metaDataElement.setKey(dataElementKey);
        metaDataElement.setCaption(dataElementCaption);
        metaDataElement.setDomainKey(domainNewKey);
        if (dataElementPosition.equals("NewDataElementFile")) {//新增数据元素文件写入数据
            // 验证文件名是否重复
            resourceDataElement = File.separator + "DataElement" + File.separator + newDataElementFileKey + ".xml";

            metaDataElementDefLoad.load(resolver, resourceDataElement);
            metaDataElementDef = (MetaDataElementDef) metaDataElementDefLoad.getRootMetaObject();

            if (metaDataElementDef == null){
                // 调用新增xml文件方法
                metaDataElementDef = new MetaDataElementDef();
                metaDataElements = new MetaDataElementCollection();
                metaDataElementDef.setDataElementCollection(metaDataElements);
                newDataElementFile = true;
            } else {
                metaDataElements = metaDataElementDef.getDataElementCollection();
            }
            metaDataElements.add(metaDataElement);
        } else {//选择数据元素文件写入数据
            resourceDataElement = File.separator + "DataElement" + File.separator + file.getName();
            metaDataElementDefLoad.load(resolver, resourceDataElement);
            metaDataElementDef = (MetaDataElementDef) metaDataElementDefLoad.getRootMetaObject();
            globalInstance.getDataElementDef().getDataElementCollection().add(metaDataElement);
            metaDataElementDef.getDataElementCollection().add(metaDataElement);
            MetaDomain domain = globalInstance.getDomainDef().getDomain(domainNewKey);
            metaDataElement.setDomain(domain);
            metaDataElement.setDataType(domain.getDataType());
            metaDataElement.setLength(domain.getLength());
            metaDataElement.setPrecision(domain.getPrecision());
            metaDataElement.setScale(domain.getScale());
        }

        if (!paramID.isEmpty()) {
            metaDataElement.setParamID(paramID);
        }
        if (!defaultCaption.isEmpty()) {
            metaDataElement.setDefaultCaption(defaultCaption);
        }
        if (!dataDiffLog.isEmpty()) {
            metaDataElement.setDataDiffLog(Boolean.parseBoolean(dataDiffLog));
        }
        if (!noHistory.isEmpty()) {
            metaDataElement.setNoHistory(Boolean.parseBoolean(noHistory));
        }
        DataTable ed_fieldLabelCollection = formDocument.get("ED_FieldLabelCollection");
        if (!ed_fieldLabelCollection.isEmpty()) {
            MetaFieldLabelCollection fieldLabelCollection = new MetaFieldLabelCollection();
            metaDataElement.setFieldLabelCollection(fieldLabelCollection);
            for (int i = 0; i < ed_fieldLabelCollection.size(); i++) {
                MetaFieldLabel metaFieldLabel = new MetaFieldLabel();
                fieldLabelCollection.add(metaFieldLabel);
                String key1 = ed_fieldLabelCollection.getString(i, "Key");
                int length1 = ed_fieldLabelCollection.getInt(i, "Length");
                String text = ed_fieldLabelCollection.getString(i, "Text");
                metaFieldLabel.setKey(key1);
                metaFieldLabel.setLength(length1);
                if (!text.isEmpty()) {
                    metaFieldLabel.setText(text);
                }
            }
        }

        // 新增
        // 调用新增xml文件方法
        MetaDataElementDefSave metaDataElementDefSave = new MetaDataElementDefSave(metaDataElementDef);
        // 保存xml文件到磁盘
        metaDataElementDefSave.save(resolver, resourceDataElement);
        if (dataElementPosition.equals("NewDataElementFile")  && newDataElementFile) {//新建数据元素文件写入数据
            dataElementPosition = LoadFileTree.newDataElementFile(dataElementProjectKey, newDataElementFileKey + ".xml", newDataElementFileKey, newDataElementFileKey, solutionPath);
            filePath = dataElementPosition;
            DataElementDefOperJsonUtil dataElementDefOperJsonUtil = new DataElementDefOperJsonUtil();
            dataElementDefOperJsonUtil.reload(filePath);
        }else{
//            LogSvr.getInstance().info("数据元素传入dataElementPosition：" + dataElementPosition);
//            //菜单树节点添加，与组件添加 dataElementPosition 值不一样
//            if (!dataElementPosition.contains("\\") && !dataElementPosition.contains("/")) {
//                String currentPath = ed_newDataElement.getString("CurrentPath");
//                dataElementPosition = FilePathHelper.toBackFilePath(currentPath +  File.separator + dataElementPosition);
//            }
//            if(dataElementPosition.startsWith("..")){
//                String fileName = dataElementPosition.substring(dataElementPosition.lastIndexOf(File.separator)+1, dataElementPosition.lastIndexOf("."));
//                dataElementPosition = LoadFileTree.mapDataElementKeyToXmlPath.get(fileName.toLowerCase()).key;
//            }
//            DataElementDefOperJsonUtil dataElementDefOperJsonUtil = new DataElementDefOperJsonUtil();
//            LogSvr.getInstance().info("数据元素最终dataElementPosition：" + dataElementPosition);
//            dataElementDefOperJsonUtil.reload(dataElementPosition);
        }
    }

    private String newDomain( DataTable ed_newDomain,String setDomain, List<UICommand> uiCommands ) throws Throwable {
        String dataType = ed_newDomain.getString("DataType");
        String domainFileKey = ed_newDomain.getString("DomainFileKey");
        String domainCaption = ed_newDomain.getString("DomainCaption");
        int precision = ed_newDomain.getInt("Precision");
        int scale = ed_newDomain.getInt("Scale");
        int length = ed_newDomain.getInt("Length");
//                String useGroupingSeparator = ed_newDomain.getString("UseGroupingSeparator");
        String domainPosition = ed_newDomain.getString("DomainPosition");
        String domainFilePosition = ed_newDomain.getString("DomainFilePosition");
        String controlType = ed_newDomain.getString("ControlType");
        String aCase = ed_newDomain.getString("Case");
        String sourceType = ed_newDomain.getString("SourceType");
        String groupKey = ed_newDomain.getString("GroupKey");
        String itemKey = ed_newDomain.getString("ItemKey");
        String allowMultiSelection = ed_newDomain.getString("AllowMultiSelection");
        String domainNewKey = ed_newDomain.getString("DomainNewKey");
        if (setDomain.equals("NewDomain") || (StringUtils.isEmpty(setDomain) && MetaUtil.getDomain(MetaFactory.getGlobalInstance(),domainNewKey) == null)) {
            MetaDomainCollection collection;
            MetaDomain element = new MetaDomain();
            MetaDomainDef rootMetaObject;
            IMetaResolver resolver = MetaFactory.getGlobalInstance().getProjectResolver(domainFilePosition);
            AtomicReference<String> path = new AtomicReference<>(domainFilePosition);
            File file = new File(domainPosition);
            if(StringUtils.isEmpty(domainFilePosition)) {
                if(domainPosition.equalsIgnoreCase("NewDomainFile")){
                    LoadFileTree.metaDesignerSolutionPathMap.forEach((k, v) -> {
                        if (filePath.contains(v)) {
                            path.set(k);
                        }
                    });
                }else{
                    LoadFileTree.mapDomainKeyToXmlPath.forEach((k, v) -> {
                        if(k.equalsIgnoreCase(file.getName().substring(0,file.getName().lastIndexOf(".")))){
                            path.set(v.solutionKey);
                        }
                    });
                }
                String solutionPath = LoadFileTree.getSolutionPath(path.get());
                resolver = new DefaultMetaResolverFactory(solutionPath).newMetaResolver("");
            }
            String solutionPath = LoadFileTree.getSolutionPath(path.get());
            String resourceDomain;
            MetaDomainDefLoad metaDomainDefLoad = new MetaDomainDefLoad(AppRunType.Dev);
            boolean newDomainFile = false;
            if (domainPosition.equals("NewDomainFile") ) {//新增域文件写入数据
                //这里检查是否已经存在同名文件
                resourceDomain = File.separator + "Domain" + File.separator + domainFileKey + ".xml";
                metaDomainDefLoad.load(resolver, resourceDomain);
                rootMetaObject = (MetaDomainDef) metaDomainDefLoad.getRootMetaObject();
                if (rootMetaObject == null){
                    // 新增
                    // 调用新增xml文件方法
                    rootMetaObject = new MetaDomainDef();
                    collection = new MetaDomainCollection();
                    rootMetaObject.setDomainCollection(collection);
                    newDomainFile = true;
                } else {
                    collection = rootMetaObject.getDomainCollection();
                }
            } else {
                resourceDomain = File.separator + "Domain" + File.separator + file.getName();
                metaDomainDefLoad.load(resolver, resourceDomain);
                rootMetaObject = (MetaDomainDef) metaDomainDefLoad.getRootMetaObject();
                collection = rootMetaObject.getDomainCollection();
            }

            if (controlType.equals(ControlType.STR_COMBOBOX) || controlType.equals(ControlType.STR_CHECKLISTBOX)) {
                element.setSourceType(ComboBoxSourceType.parse(sourceType));
                DataTable ed_defaultItem = formDocument.get("ED_DefaultItem");
                if (!ed_defaultItem.isEmpty() && StringUtils.isNotEmpty(sourceType) && sourceType.equals(ComboBoxSourceType.STR_ITEMS)) {
                    MetaListBoxItemCollection metaDefaultItems = new MetaListBoxItemCollection();
                    element.setItems(metaDefaultItems);
                    for (int i = 0; i < ed_defaultItem.size(); i++) {
                        MetaDefaultItem metaDefaultItem = new MetaDefaultItem();
                        String key1 = ed_defaultItem.getString(i, "Key");
                        String caption = ed_defaultItem.getString(i, "Caption");
                        String value = ed_defaultItem.getString(i, "Value");
                        String icon = ed_defaultItem.getString(i, "Icon");
                        metaDefaultItem.setKey(key1);
                        metaDefaultItem.setCaption(caption);
                        metaDefaultItem.setValue(value);
                        metaDefaultItem.setIcon(icon);
                        metaDefaultItems.add(metaDefaultItem);
                    }
                } else if (sourceType.equals(ComboBoxSourceType.STR_PARAGROUP)) {
                    if (!groupKey.isEmpty()){
                        element.setGroupKey(groupKey);

                    }
                }
                element.setAllowMultiSelection(Boolean.parseBoolean(allowMultiSelection));
            } else if (controlType.equals(ControlType.STR_DICT) || controlType.equals(ControlType.STR_DYNAMICDICT)) {
                element.setItemKey(itemKey);
            } else {
                if (!aCase.isEmpty()){
                    element.setCase(CaseType.parse(aCase));
                }
            }
            element.setLength(length);
            if (DataType.STR_STRING.equals(dataType) || length == 0){
                element.setLength(255);
            }
            element.setScale(scale);
            element.setPrecision(precision);

            element.setDataType(DataType.parse(dataType));
            element.setRefControlType(ControlType.parse(controlType));
            element.setKey(domainNewKey);
            element.setCaption(domainCaption);
            if ("".equals(groupKey)){
                // save方法中groupKey为null会将""写入xml,若为""则和默认值一致不写入xml
                element.setGroupKey(groupKey);
            }
            collection.add(element);
            MetaDomainDefSave metaDomainDefSave = new MetaDomainDefSave(rootMetaObject);
            // 保存xml文件到磁盘
            metaDomainDefSave.save(resolver, resourceDomain);
            if (domainPosition.equals("NewDomainFile") && newDomainFile) {
                domainPosition = LoadFileTree.newDomainFile(domainFilePosition, domainFileKey + ".xml", domainFileKey, domainFileKey, solutionPath);
                //重新加载域文件
                if (uiCommands != null){
                    uiCommands.add(UICommand.refreshFileTreeChildren(domainPosition));
                }
                DomainDefOperJsonUtil domainDefOperJsonUtil = new DomainDefOperJsonUtil();
                domainDefOperJsonUtil.reload(domainPosition);
                filePath = domainPosition;
            }else{
                DomainDefOperJsonUtil domainDefOperJsonUtil = new DomainDefOperJsonUtil();
                domainDefOperJsonUtil.reload(domainPosition);
            }

        } else {//引用域 不处理

        }


        return domainNewKey;
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new NewDomainORDataElementCmd();
    }

}
