package com.bokesoft.yes.design.cmd;

import java.io.File;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class LoadSearchFilesContentCmd extends DesignerServiceCmd {

	public static final String CMD = "LoadSearchFilesContent";

	@Override
	public void dealArguments(DefaultContext arg0, StringHashMap<Object> arg1) throws Throwable {

	}

	@Override
	public Object innerDoCmd(DefaultContext arg0) throws Throwable {
		List<String> solutionsPath = LoadFileTree.getAllSolutionsPath();
		JSONArray result = new JSONArray();
		for (String solutionPath : solutionsPath) {
			File solutionDir = new File(solutionPath);
			// 遍历文件内容
			processDir(solutionDir, result);
		}

		return result;
	}

	private void processDir(File dir, JSONArray result) throws Throwable {
		if (dir != null && dir.isDirectory()) {
			for (File child : dir.listFiles()) {
				if (child.isDirectory()) {
					processDir(child, result);
				} else {
					if (child.getName().endsWith(".xml")) {
						JSONObject r = new JSONObject();
						r.put("key", child.getAbsolutePath());
						r.put("value", FileUtils.readFileToString(child, "UTF-8"));

						result.put(r);
					}
				}
			}
		}
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new LoadSearchFilesContentCmd();
	}

}
