package com.bokesoft.yes.design.cmd;

import java.io.File;

import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 取文件内容
 */
public class LoadFileContentCmd extends DesignerServiceCmd {

	public static final String CMD = "LoadFileContent";

	private String filePath;
	private String temFilePath;
	private boolean needLoad;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		filePath = FilePathHelper.toBackFilePath((String) arguments.get("filePath"));
		temFilePath = FilePathHelper.toBackFilePath((String) arguments.get("temFilePath"));
		// arguments.get("needLoad") == null ? true : arguments.get("needLoad")  这里兼容一下前端的版本
		needLoad = TypeConvertor.toBoolean(arguments.get("needLoad") == null ? true : arguments.get("needLoad"));
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		String tmpFilePath;
		String currentVersion = "";
		String content = "";
		if(StringUtils.isNotEmpty(temFilePath)){
			tmpFilePath = temFilePath;
			if(needLoad) {
				File file = new File(filePath);
				content = FileUtils.readFileToString(file, "UTF-8");
				String newSecondLine = DesignIOMetaUtil.getSecondLine(content);
				try {
					currentVersion = DesignIOMetaUtil.getSubString(newSecondLine, "Version=\"(\\d*)\"");
				} catch (Exception e) {
					currentVersion = "1";
				}
			}
		}else{
			tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
		}
		if (StringUtils.isBlank(tmpFilePath)) {
			tmpFilePath = filePath;
		}
		if(needLoad){
			File file = new File(tmpFilePath);
			content = FileUtils.readFileToString(file, "UTF-8");
			if(StringUtils.isNotEmpty(currentVersion)){
				String oldVerison;
				try {
					oldVerison = DesignIOMetaUtil.getSubString(content, "Version=\"(\\d*)\"");
				} catch (Exception e) {
					oldVerison = "1";
				}
				content = content.replace("Version=\"" + oldVerison, "Version=\"" + currentVersion);
			}
		}
		JSONObject result = new JSONObject();
		result.put("isNew", !(new File(filePath).exists()));
		result.put("isEditBeforeLoad", (tmpFilePath != filePath));
		result.put("content", content);
		return result;
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new LoadFileContentCmd();
	}
}
