package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

import java.util.*;


/**
 * 表达式自动完成类
 *
 * @author zhsy
 * @date 2020-06-18
 */
public class GetmacroformulaCmd extends DesignerServiceCmd {

	public static final String CMD = "Getmacroformula";

	/***表单formKey*/
	private String formKey;

	/***编辑器中的内容*/
	private String content;

	/***编辑器中的内容*/
//	private String type;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = (String) arguments.get("formKey");
		content = TypeConvertor.toString(arguments.get("content"));//宏公式内容
//		type = TypeConvertor.toString(arguments.get("type"));//key
		if (StringUtils.isNotEmpty(content)) {
			//换行符变成空格
			content = content.replaceAll("@br@", " ")
					.replaceAll("；", ";")
					.replaceAll("（", "(")
					.replaceAll("）", ")");
		}

	}

	@Override
	public Object innerDoCmd(DefaultContext context) {
		String contenttext = content;
		Map<String, Map<String, String>> macroMap = new HashMap<>(150);
//		Map<String, Map<String, String>> defaultmacroMap = new HashMap<>(150);
		Map<String, String> stringStringMap = new HashMap<>();
		Map<String, String> optionstringStringMap = new HashMap<>();
		extracted(context, contenttext, macroMap, stringStringMap, optionstringStringMap);
		JSONObject jsonObject = new JSONObject();
		StringBuilder ssaa = new StringBuilder();
		for (Map.Entry<String, Map<String, String>> stringMapEntry : macroMap.entrySet()) {
			String key = stringMapEntry.getKey();
			ssaa.append(key).append("\n").append(" ");
			Map<String, String> value = stringMapEntry.getValue();
			for (Map.Entry<String, String> stringStringEntry : value.entrySet()) {
				String key1 = stringStringEntry.getKey();
				String value1 = stringStringEntry.getValue();
				ssaa.append(key1).append(":").append("\n\t\t").append(value1).append("\n");
				if (value1.contains(";")) {
					extracted(context, value1, macroMap, stringStringMap, optionstringStringMap);
				}
			}

		}
		jsonObject.append("mm1", ssaa);
		if (!content.equals("")) {
			return jsonObject.toString();
		}
		return new JSONObject().toString();
	}

	private void extracted(DefaultContext context, String contenttext, Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap, Map<String, String> optionstringStringMap) {
		List<String> strings = getStrings(contenttext);//处理内容
		extracted(context, strings, macroMap, stringStringMap);//公共的
		extractedprojiect(context, strings, macroMap, stringStringMap);//项目的
		extracteds(strings, macroMap, stringStringMap);//当前表单
		optionextracted(context, strings, macroMap, optionstringStringMap);//公共的操作
		optionextractedprojiect(context, strings, macroMap, optionstringStringMap);//项目的操作
		optionextracteds(strings, macroMap, optionstringStringMap);//当前表单操作
	}

	private void extracteds(List<String> strings, Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
		if (strings.size() > 0) {
			for (String string : strings) {
				MetaForm metaForm = null;
				try {
					metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
					MetaMacroCollection macroCollection = metaForm.getMacroCollection();
					String macro = string.substring(0, string.indexOf("("));
					if (macroCollection.get(macro) != null) {
						MetaMacro metaMacro = macroCollection.get(macro);
						String args = "";
						String key = "";
						String value = "";
						args = metaMacro.getArgs();
						if (StringUtils.isNotEmpty(args)) {
							key = metaMacro.getKey() + "(" + args + ")";
						} else {
							key = metaMacro.getKey() + "()";
						}
						value = metaMacro.getContent();
						stringStringMap.put(key, value);
					}
				} catch (Throwable throwable) {
					LogSvr.getInstance().error(throwable.getMessage(), throwable);
				}
			}
			if (stringStringMap.size() > 0) {
				macroMap.put("@" + formKey + "/CommonDef.xml", stringStringMap);
			}
		}
	}

	private void optionextracteds(List<String> strings, Map<String, Map<String, String>> macroMap,
								  Map<String, String> stringStringMap) {
		if (strings.size() > 0) {
			for (String string : strings) {
				MetaForm metaForm = null;
				try {
					metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
					MetaOperationCollection operationCollection = metaForm.getOperationCollection();
					String macro = string.substring(0, string.indexOf("("));
					if (operationCollection.get(macro) != null) {
						if (operationCollection.get(macro) != null) {
							MetaOperation metaOperation = (MetaOperation) operationCollection.get(macro);
							String value = metaOperation.getAction().getContent();
							stringStringMap.put(macro, value);
						}
					}
				} catch (Throwable throwable) {
					LogSvr.getInstance().error(throwable.getMessage(), throwable);
				}
			}
			if (stringStringMap.size() > 0) {
				macroMap.put("@" + formKey + "/CommonDef.xml", stringStringMap);
			}
		}
	}

	private void extractedprojiect(DefaultContext context, List<String> strings,
								   Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
		if (strings.size() > 0) {
			for (String string : strings) {
				try {
					MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
					IMetaFactory metaFactory = context.getVE().getMetaFactory();
					MetaProject metaProject = (MetaProject) metaForm.getProject();
					MetaCommonDef metaCommonDef = metaFactory.getCommonDef(metaProject.getKey());
					// 自己的commonDef
					if (null != metaCommonDef) {
						MetaMacroCollection macroCollection = metaCommonDef.getMacroCollection();
						String macro = string.substring(0, string.indexOf("("));
						if (macroCollection.get(macro) != null) {
							MetaMacro metaMacro = macroCollection.get(macro);
							String args = "";
							String key = "";
							String value = "";
							args = metaMacro.getArgs();
							if (StringUtils.isNotEmpty(args)) {
								key = metaMacro.getKey() + "(" + args + ")";
							} else {
								key = metaMacro.getKey() + "()";
							}
							value = metaMacro.getContent();
							stringStringMap.put(key, value);
						}
					}
				} catch (Throwable e) {
				}
			}
			if (stringStringMap.size() > 0) {
				try {
					macroMap.put("@" + MetaFactory.getGlobalInstance().getMetaForm(this.formKey).getProject().getKey() + "/CommonDef.xml",
							stringStringMap);
				} catch (Throwable throwable) {
					LogSvr.getInstance().error(throwable.getMessage(), throwable);
				}
			}
		}
	}

	private void optionextractedprojiect(DefaultContext context, List<String> strings,
										 Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
		if (strings.size() > 0) {
			for (String string : strings) {
				try {
					MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
					IMetaFactory metaFactory = context.getVE().getMetaFactory();
					MetaProject metaProject = (MetaProject) metaForm.getProject();
					MetaCommonDef metaCommonDef = metaFactory.getCommonDef(metaProject.getKey());
					MetaOperationCollection operationCollection = metaCommonDef.getOperationCollection();
					String macro = string.substring(0, string.indexOf("("));
					if (operationCollection.get(macro) != null) {
						if (operationCollection.get(macro) != null) {
							MetaOperation metaOperation = (MetaOperation) operationCollection.get(macro);
							String value = metaOperation.getAction().getContent();
							stringStringMap.put(macro, value);
						}
					}
				} catch (Throwable e) {
				}
			}
			if (stringStringMap.size() > 0) {
				try {
					macroMap.put("@" + MetaFactory.getGlobalInstance().getMetaForm(this.formKey).getProject().getKey() + "/CommonDef.xml",
							stringStringMap);
				} catch (Throwable throwable) {
					LogSvr.getInstance().error(throwable.getMessage(), throwable);
				}
			}
		}
	}

	private void extracted(DefaultContext context, List<String> strings, Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
		if (strings.size() > 0) {
			for (String string : strings) {
				try {
					IMetaFactory metaFactory = context.getVE().getMetaFactory();
					// 公共的commonDef
					MetaCommonDef metaCommonDef = metaFactory.getCommonDef("");
					if (null != metaCommonDef) {

						MetaMacroCollection macroCollection = metaCommonDef.getMacroCollection();
						String macro = string.substring(0, string.indexOf("("));
						if (macroCollection.get(macro) != null) {
							MetaMacro metaMacro = macroCollection.get(macro);
							String args = "";
							String key = "";
							String value = "";
							args = metaMacro.getArgs();
							if (StringUtils.isNotEmpty(args)) {
								key = metaMacro.getKey() + "(" + args + ")";
							} else {
								key = metaMacro.getKey() + "()";
							}
							value = metaMacro.getContent();
							stringStringMap.put(key, value);
						}
					}

				} catch (Throwable e) {
				}

			}
			if (stringStringMap.size() > 0) {
				macroMap.put("@solution/CommonDef.xml", stringStringMap);
			}
		}
	}

	private void optionextracted(DefaultContext context, List<String> strings,
								 Map<String, Map<String, String>> macroMap, Map<String, String> stringStringMap) {
		if (strings.size() > 0) {
			for (String string : strings) {
				try {
					IMetaFactory metaFactory = context.getVE().getMetaFactory();
					// 公共的commonDef
					MetaCommonDef metaCommonDef = metaFactory.getCommonDef("");
					if (null != metaCommonDef) {
						MetaOperationCollection operationCollection = metaCommonDef.getOperationCollection();
						String macro = string.substring(0, string.indexOf("("));
						if (operationCollection.get(macro) != null) {
							MetaOperation metaOperation = (MetaOperation) operationCollection.get(macro);
							String value = metaOperation.getAction().getContent();
							stringStringMap.put(macro, value);
						}
					}
				} catch (Throwable e) {
				}
			}
			if (stringStringMap.size() > 0) {
				macroMap.put("@solution/CommonDef.xml", stringStringMap);
			}
		}
	}

	private List<String> getStrings(String contenttext) {
		Stack<Character> stack = new Stack<Character>();
//		String contents = reverseRecursive(contenttext);
       /* for (int pos = 0, size = contents.length(); pos < size; pos++) {
            char c = contents.charAt(pos);
            if (c == '{') {
                if (stack.size() == 0 || (stack.peek() != '/' && stack.peek() != '*')) {
                    stack.push('{');
                }
            } else if (c == '}') {
                if (stack.size() == 0 || (stack.peek() != '/' && stack.peek() != '*')) {
                    if (stack.peek() == '{') {
                        stack.pop();
                    } else {
                        throw new RuntimeException("XXX");
                    }
                }
            } else if (c == '/') {
                if (stack.size() == 0 || (stack.peek() != '/' && stack.peek() != '*')) {
                    if (pos == size - 1) {
                        throw new RuntimeException("XXX");
                    }
                    char next = contents.charAt(++pos);
                    if (next == '/') {
                        stack.push('/');
                    } else if (next == '*') {
                        stack.push('*');
                    } else {
                        throw new RuntimeException("XXX");
                    }
                }
            } else if (c == '\n') {
                if (stack.size() > 0 && stack.peek() == '/') {
                    stack.pop();
                } else if (c == '*') {

                } else if (c == ';') {
                    if (stack.size() == 0) {
                        //表示要换行，还需要判断;号后是否就是/n
                    }
                }
            } else {
                stack.push(c);
            }
        }*/
		String a = "";
		List<String> strings = new ArrayList<>();
		int size = stack.size();
		for (int i = 0; i < size; i++) {
			if (stack.peek() != ';' && stack.size() != 0) {
				a = a + stack.pop();
			} else if (stack.size() != 0) {
				stack.pop();
				strings.add(a);
				a = "";
			}
			if (stack.size() == 0) {
				strings.add(a);
			}

		}
		return strings;
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetmacroformulaCmd();
	}

	public static String reverseRecursive(String s) {
		int length = s.length();
		if (length <= 1) {
			return s;
		}
		String left = s.substring(0, length / 2);
		String right = s.substring(length / 2, length);
		String afterReverse = reverseRecursive(right) + reverseRecursive(left);
		return afterReverse;
	}

}
