package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Document;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CopyFormCmd extends DesignerServiceCmd {
    public static final String CMD = "CopyForm";

    /**
     * 项目的名
     */
    public static String projectKey;
    /**
     * 新增的表单Key
     */
    private String formKey;
    /**
     * 新增的表单名称
     */
    private String formCaption;
    /**
     * 指定的目录
     */
    private String directory;
    /**
     * Entry目录
     */
    private String Source;
    /**
     * 原表单
     */
    private String AssociationForm;

    private int formType;

    private String isDirectory = "1";

    @Override
    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> arguments) throws Throwable {
        projectKey = TypeConvertor.toString(arguments.get("projectKey")).trim();
        formKey = TypeConvertor.toString(arguments.get("newFormKey")).trim(); // formKey有特殊的含义
        formCaption = TypeConvertor.toString(arguments.get("formCaption")).trim();
        directory = TypeConvertor.toString(arguments.get("directory")).trim();
        Source = TypeConvertor.toString(arguments.get("Source")).trim();
        AssociationForm = TypeConvertor.toString(arguments.get("AssociationForm")).trim();
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        // 普通表单的拷贝 带有模板表单的拷贝 有马甲表单的拷贝

        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();

        List<UICommand> result = new ArrayList<>();
        if (globalInstance.getMetaFormList().get(formKey) != null) {
            return UICommand.showError("表单名重复创建失败！").toJson();
        }
        // 下面的路径是AssociationForm在你本机所对应的目录
        String orgFilePath = LoadFileTree.getPathByFormKey(AssociationForm);
        if (StringUtils.isBlank(orgFilePath)) {
            return UICommand.showError("关联表" + AssociationForm + "不存在！").toJson();
        }
        String tempPath = XmlFileProcessor.instance.getTmpFile(orgFilePath);
        if (StringUtils.isBlank(tempPath)) {
            tempPath = orgFilePath;
        }
        // 创建SAX读取器
        SAXReader reader = new SAXReader();
        File file = new File(tempPath);
        // 加载文档对其进行修改
        org.dom4j.Document document = reader.read(file);
        Element root = document.getRootElement();

        String mergeToSource = root.attributeValue("MergeToSource");
        if (StringUtils.equalsAnyIgnoreCase(mergeToSource, "1", "true")) {
            return UICommand.showError("不可复制功能马甲！").toJson();
        }


        // 修改前和修改后的内容对应 主要用于DataBinding TableKey 和 DataTable key的对应
        HashMap<String, String> changedContent = new HashMap<>();

        //修改Form Key Caption
        //修改前的formKey
        String orgFormKey = root.attributeValue(ConstantUtil.KEY);
        root.addAttribute(ConstantUtil.KEY, formKey);
        root.addAttribute(ConstantUtil.CAPTION, formCaption);
        changedContent.put(orgFormKey, formKey);

        // 是否有数据对象
        List<Element> dataObjectKeys = (List<Element>) (List) root.selectNodes("//DataSource");
        boolean isnExtend = StringUtils.isEmpty(root.attributeValue(ConstantUtil.EXTEND));
        String extendedForm = root.attributeValue(ConstantUtil.EXTEND);
        String formType1 = root.attributeValue("FormType");
        this.formType = FormType.parse(StringUtils.isEmpty(formType1) ? "Normal" : formType1);
        this.formType = isnExtend ? this.formType : MetaFactory.getGlobalInstance().getMetaForm(extendedForm).getFormType();
        // 有数据对象
        if (dataObjectKeys != null && dataObjectKeys.size() > 0) {
            Element dataSource = dataObjectKeys.get(0);
            String refObjectKey = dataSource.attributeValue("RefObjectKey");

            // 判断是否是界面马甲 是马甲直接跳过数据源和body内容的修改
            if (isnExtend) {
                // 引用了数据对象 或者 视图类型 直接跳过
                if (dataSource != null && StringUtils.isEmpty(refObjectKey) && FormType.View != this.formType) {
                    // 修改DataObject Key Caption
                    Element dataObject = dataSource.element(ConstantUtil.DATA_OBJECT);
                    dataObject.addAttribute(ConstantUtil.KEY, formKey);
                    dataObject.addAttribute(ConstantUtil.CAPTION, formCaption);
                    String primaryTableKey = dataObject.attributeValue(ConstantUtil.PRIMARY_TABLE_KEY);

                    // 修改Table key caption
                    List<Element> tables = (List<Element>) (List) root.selectNodes("//TableCollection/Table");
                    for (Element table : tables) {
                        String orgTableKey = table.attributeValue(ConstantUtil.KEY);
                        String tmp = "Tmp";
                        // 复制表单数据源的表名在原表名后增加Tmp
                        String newTableKey = orgTableKey.replace(orgFormKey, formKey) + tmp;
                        String orgTableCaption = table.attributeValue(ConstantUtil.CAPTION);
                        table.addAttribute(ConstantUtil.KEY, newTableKey);
                        table.addAttribute(ConstantUtil.CAPTION, orgTableCaption.replace(orgFormKey, formKey));
                        table.addAttribute(ConstantUtil.INDEX_PREFIX, newTableKey);
                        String parentKey = table.attributeValue(ConstantUtil.PARENT_KEY);
                        if (!StringUtils.isEmpty(parentKey)) {
                            table.addAttribute(ConstantUtil.PARENT_KEY, changedContent.get(parentKey));
                        }
                        changedContent.put(orgTableKey, newTableKey);
                    }

                    // 修改DataObject的PrimaryTableKey
                    dataObject.addAttribute(ConstantUtil.PRIMARY_TABLE_KEY, changedContent.get(primaryTableKey));

                    // 修改所有绑定TableKey的属性
                    List<Element> hasTableKeys = (List<Element>) (List) root.selectNodes("Body//*[@TableKey]");
                    for (Element hasTableKey : hasTableKeys) {
                        String orgTableKeyValue = hasTableKey.attributeValue(ConstantUtil.TABLE_KEY);
                        hasTableKey.addAttribute(ConstantUtil.TABLE_KEY, changedContent.getOrDefault(orgTableKeyValue, orgTableKeyValue));
                    }
                    List<Element> defaultFormulaValues = (List<Element>) (List) root.selectNodes("Body//*[@DefaultFormulaValue]");
                    for (Element defaultFormulaValue : defaultFormulaValues) {
                        String oldDefaultFormulaValue = defaultFormulaValue.attributeValue(ConstantUtil.DEFAULT_FORMULA_VALUE);
                        if (StringUtils.isNotBlank(oldDefaultFormulaValue)) {
                            String newDefaultFormulaValue = StringUtils.replace(oldDefaultFormulaValue, primaryTableKey, changedContent.getOrDefault(primaryTableKey, primaryTableKey));
                            defaultFormulaValue.addAttribute(ConstantUtil.DEFAULT_FORMULA_VALUE, newDefaultFormulaValue);
                        }
                    }

                    // 修改嵌入组件绑定的table
                    List<Element> embedVars = (List<Element>) (List) root.selectNodes("Body//Embed/Var");
                    for (Element embedVar : embedVars) {
                        String orgValue = embedVar.attributeValue(ConstantUtil.VALUE);
                        String keyValue = embedVar.attributeValue(ConstantUtil.KEY);
                        if (!StringUtils.isEmpty(orgValue)) {
                            embedVar.addAttribute(ConstantUtil.VALUE, changedContent.get(orgValue));
                        }
                    }
                }
            }
        }


        // 注册
		/*String content = document.asXML();
		InputStream inputStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
		MetaFormLoad formLoad = new MetaFormLoad(AppRunType.App, null);
		formLoad.load(inputStream);
		MetaForm metaForm = (MetaForm) formLoad.getRootMetaObject();
		// 设置工程 数据源
		metaForm.setProject(metaProject);
		if(refObjectKey != null) {
			metaForm.getDataSource().setDataObject(globalInstance.getDataObject(refObjectKey));
		}*/

        //
        String fileName = formKey + ".xml";
        String fileTreePath = LoadFileTree.newFile(projectKey, this.formType, fileName, formKey, formCaption, directory, isDirectory);

        // 文件流操作
        OutputFormat format = DataMapOperXmlUtil.getOutputFormat();

        String newFilePath = FilePathHelper.toBackFilePath(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(projectKey)+ File.separator + fileName + "." + System.currentTimeMillis());

        // 修改文档存储地址 -> 复制
        document.setName(fileTreePath);

        String resource = LoadFileTree.getResource(newFilePath,projectKey);

        FileOutputStream fileOutputStream = new FileOutputStream(newFilePath);
        XMLWriter writer = new XMLWriter(fileOutputStream, format);
        writer.write(document);
        closeFileStream(fileOutputStream, writer);
        XmlFileProcessor.stackput(fileTreePath, newFilePath);
        EntryProcessor.instance.newForm(projectKey, this.formType, formKey, formCaption, Source, true);

        MetaProject metaProject = globalInstance.getMetaProject(projectKey);
        MetaFormList metaFormList = globalInstance.getMetaFormList();
        MetaFormProfile newFormProfile = MetaObjectHelper.deptClone(metaFormList.get(orgFormKey));
        newFormProfile.setProject(metaProject);
        newFormProfile.setKey(formKey);
        newFormProfile.setCaption(formCaption);
        newFormProfile.setForm(null);
        metaFormList.add(newFormProfile);
        if (!isnExtend) {
            newFormProfile.setExtend(extendedForm);
            newFormProfile.setFormType(-1);
        }
        newFormProfile.setResource(resource);

        ReloadForm.reloadFormKey(globalInstance, formKey, resource);
        globalInstance.getMetaForm(formKey);
        result.add(UICommand.reloadFileTree(fileTreePath));
        result.add(UICommand.runFormKey(formKey));
        result.add(UICommand.reloadMenuTree());

        return UICommand.toJson(result);
    }

    /***
     * 关闭文件流
     * @param fileOutputStream 文件输出流
     * @param writer 写对象
     */
    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (null != fileOutputStream) {
                fileOutputStream.close();
            }
            if (null != writer) {
                writer.close();
            }
        } catch (Exception e) {
        }
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new CopyFormCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    private MetaForm setKeyAndCaption(MetaForm orgMetaForm, MetaForm newMetaForm, String key, String caption) throws Exception {
        String orgKey = orgMetaForm.getKey();
        String orgCaption = orgMetaForm.getCaption();
        newMetaForm.setKey(formKey);
        newMetaForm.setCaption(formCaption);
        if (newMetaForm.getDataSource() != null && (formType != 3 || AssociationForm.isEmpty())) {
            // 设置数据源中的Key和Caption
            MetaDataObject metaDataObject = newMetaForm.getDataSource().getDataObject();
            metaDataObject.setKey(metaDataObject.getKey().replace(orgKey, key));
            metaDataObject.setCaption(metaDataObject.getCaption().replace(orgCaption, caption));
            Map<String, String> replacedTableKeys = new HashMap<>();
            MetaTableCollection metaTables = metaDataObject.getTableCollection();

            if (metaTables != null) {
                // 改表名
                List<MetaTable> metaTableArray = new ArrayList<>();
                for (MetaTable metaTable : metaTables) {
                    String tableOrgKey = metaTable.getKey();
                    String tableNewKey = tableOrgKey.replace(orgKey, key);
                    if (!tableOrgKey.equals(tableNewKey)) {
                        replacedTableKeys.put(tableOrgKey, tableNewKey);
                        metaTable.setKey(tableNewKey);
                    }
                    metaTable.setCaption(metaTable.getCaption().replace(orgCaption, caption));
                    metaTable.setIndexPrefix(metaTable.getIndexPrefix().replace(orgKey, key));
                    metaTableArray.add(metaTable);
                }
                metaTables.clear();
                for (MetaTable metaTable : metaTableArray) {
                    metaTables.add(metaTable);
                }
                String tableName = metaDataObject.getMainTableKey();
                metaDataObject.setMainTableKey(replacedTableKeys.getOrDefault(tableName, tableName));
                for (AbstractMetaObject metaObject : newMetaForm.getAllUIComponents().values()) {
                    if (metaObject instanceof MetaComponent) {
                        MetaComponent metaComponent = (MetaComponent) metaObject;
                        MetaDataBinding metaDataBinding = metaComponent.getDataBinding();
                        // 没有数据源的也会有对应表为XXX_NODB 对其进行处理
                        if (metaDataBinding != null && metaDataBinding.getTableKey().contains(MetaFormNODBProcess.STR_NODBTable_Profix)) {
                            metaComponent.setDataBinding(null);
                            metaDataBinding = null;
                        }
                        if (metaDataBinding != null) {
                            metaDataBinding.setTableKey(replacedTableKeys.getOrDefault(tableName, tableName));
                        }
                        if (metaComponent instanceof MetaGrid) {
                            MetaGrid metaGrid = (MetaGrid) metaComponent;
                            for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
                                metaGridRow.setTableKey(replacedTableKeys.getOrDefault(tableName, tableName));
                            }
                        }
                    }
                }
            }
        }
        return newMetaForm;
    }

    private String saveMetaForm(MetaForm metaForm) throws Throwable {
        MetaFormSave save = new MetaFormSave(metaForm);
        Document newDocument = save.getDocument();
        XmlCreator creator = new XmlCreator(newDocument, null);
        IMetaProject project = metaForm.getProject();
        MetaForm clone = MetaObjectHelper.deptClone(metaForm);
        MetaDataSource metaDataSource = new MetaDataSource();
        metaDataSource.setRefObjectKey(metaForm.getDataSource().getRefObjectKey());
        clone.setDataSource(metaDataSource);
        clone.setProject(project);
        String xml1 = creator.createXml();
        return xml1;
    }
}
